/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.admin;

import com.sun.web.console.admin.WebAdminException;
import com.sun.web.console.admin.WebAdminUtil;
import com.sun.web.console.config.ConsoleConfigFactory;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigRegistrationResolver;
import com.sun.web.console.config.ConsoleConfigRegnot;
import com.sun.web.console.config.ConsoleConfigService;
import java.io.File;
import java.util.Properties;

public class WebAdminDeploy {
    private static final String FS = File.separator;
    private Properties env = null;
    private WebAdminUtil util = null;
    private String prereg_dir = null;

    public WebAdminDeploy(Properties properties, WebAdminUtil webAdminUtil) throws WebAdminException {
        this.env = properties;
        this.util = webAdminUtil;
        this.prereg_dir = this.env.getProperty("console_conf") + FS + this.env.getProperty("console_instance") + FS + "prereg";
    }

    public void deployWebModule(String string, String string2, String string3, boolean bl) throws WebAdminException {
        String string4;
        Object object;
        Object object2;
        boolean bl2 = false;
        boolean bl3 = false;
        String string5 = null;
        try {
            object2 = new File(string3);
            if (!((File)object2).isAbsolute()) {
                throw new Exception("(not absolute path)");
            }
            string5 = ((File)object2).getCanonicalPath();
            if (string5.endsWith(".war") || string5.endsWith(".WAR")) {
                object2 = new File(string5);
                bl2 = ((File)object2).exists() && ((File)object2).isFile();
                bl3 = true;
            } else {
                if (string5.endsWith(FS) && string5.length() > 1) {
                    string5 = string5.substring(0, string5.length() - 1);
                }
                bl2 = ((File)(object2 = new File(string5))).exists() && ((File)object2).isDirectory();
            }
        }
        catch (Exception exception) {
            bl2 = false;
            string5 = exception.getMessage();
        }
        if (!bl2) {
            throw new WebAdminException("dep_err_02", string2, string5);
        }
        if (bl3) {
            throw new WebAdminException("dep_err_09");
        }
        object2 = string2;
        Properties properties = new Properties();
        properties.setProperty("type", "webapp");
        properties.setProperty("appname", string);
        properties.setProperty("id", (String)object2);
        properties.setProperty("context", string2);
        properties.setProperty("location", string5);
        properties.setProperty("debug", "0");
        properties.setProperty("system", "false");
        properties.setProperty("timestamp", Long.toString(System.currentTimeMillis()));
        properties.setProperty("notification", this.prereg_dir + FS + string + FS + (String)object2 + ".reg");
        if (!bl) {
            ConsoleConfigFactory consoleConfigFactory;
            if (!this.util.isInstanceConfigured(this.env)) {
                throw new WebAdminException("comm_err_12");
            }
            object = null;
            String string6 = null;
            try {
                string6 = this.env.getProperty("console_instance");
                consoleConfigFactory = new ConsoleConfigFactory();
                object = consoleConfigFactory.createConsoleConfigService(this.env, string6);
                object.initialize();
            }
            catch (Exception exception) {
                throw new WebAdminException("comm_err_02" + exception.getLocalizedMessage());
            }
            try {
                object.connectAdmin();
            }
            catch (Exception exception) {
                throw new WebAdminException("comm_err_07", exception.getLocalizedMessage());
            }
            try {
                consoleConfigFactory = new ConsoleConfigRegistrationResolver(this.env);
                consoleConfigFactory.deployWebModule((ConsoleConfigService)object, properties);
            }
            catch (Exception exception) {
                throw new WebAdminException("dep_err_03", string, exception.getLocalizedMessage());
            }
            try {
                object.disConnectAdmin();
            }
            catch (Exception exception) {
                // empty catch block
            }
            string4 = "dep_err_05";
        } else {
            string4 = "dep_err_06";
        }
        try {
            object = new ConsoleConfigRegnot(this.getRegnotDir());
            object.write(properties);
        }
        catch (Exception exception) {
            throw new WebAdminException("comm_err_08", exception.getLocalizedMessage());
        }
        object = new WebAdminException(string4, string2);
        this.util.printMessage(2, (WebAdminException)((Object)object));
        ConsoleConfigLog.log((int)3, (String)"log_adm_03", (String)string2, (String)string);
    }

    private String getRegnotDir() {
        String string = this.env.getProperty("console_conf") + FS + this.env.getProperty("console_instance") + FS + "prereg";
        return string;
    }
}

