/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.admin;

import com.sun.web.console.admin.WebAdminDeploy;
import com.sun.web.console.admin.WebAdminException;
import com.sun.web.console.admin.WebAdminSubcommand;
import com.sun.web.console.admin.WebAdminUtil;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.util.WebUtilLogger;
import java.io.File;
import java.util.Properties;

public class WebAdminDeploySubcommand
implements WebAdminSubcommand {
    public static final String SUBCMD_NAME = "deploy";
    private static final String INST_OPT_SHORT = "-i";
    private static final String INST_OPT_LONG = "--instance";
    private static final String CTX_OPT_SHORT = "-x";
    private static final String CTX_OPT_LONG = "--context";
    private static final String APP_OPT_SHORT = "-a";
    private static final String APP_OPT_LONG = "--application";
    private static final String DEFER_OPT_SHORT = "-D";
    private static final String DEFER_OPT_LONG = "--defer";
    private static final String HELP_OPT_SHORT = "-h";
    private static final String HELP_OPT_LONG = "--help";
    private static final String HELP_OPT_QUEST = "-?";
    private static final String DEBUG_OPT_LONG = "--debug";
    private static final String HELP_PREFIX = "dep_help_";
    private static final String FS = File.separator;
    private String console_conf;
    private WebUtilLogger logger = null;
    private WebAdminUtil util = null;
    private int log_level = 3;

    public WebAdminDeploySubcommand(String string) {
        this.console_conf = string;
        this.logger = new WebUtilLogger(SUBCMD_NAME);
        this.util = new WebAdminUtil(SUBCMD_NAME, this.logger);
    }

    public int execute(String[] stringArray) throws WebAdminException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        String string5 = null;
        int n = 0;
        if (stringArray.length > 2) {
            this.util.printError("cli_err_02", null);
            return 2;
        }
        if (stringArray.length == 1 || stringArray[1].trim().length() == 0) {
            this.util.showHelp(HELP_PREFIX, true);
            return 0;
        }
        String[] stringArray2 = stringArray[1].split("_WxS_");
        boolean bl2 = true;
        String string6 = null;
        int n2 = 0;
        while (n2 < stringArray2.length) {
            string5 = this.util.stripQuotes(stringArray2[n2]);
            if (bl2) {
                if (string5.equals(HELP_OPT_SHORT) || string5.equals(HELP_OPT_LONG) || string5.equals(HELP_OPT_QUEST)) {
                    this.util.showHelp(HELP_PREFIX, false);
                    return 0;
                }
                if (string5.equals(INST_OPT_SHORT) || string5.equals(INST_OPT_LONG)) {
                    string4 = this.util.getOptionValue(++n2, stringArray2, INST_OPT_LONG, string4);
                    ++n2;
                    continue;
                }
                if (string5.equals(APP_OPT_SHORT) || string5.equals(APP_OPT_LONG)) {
                    string = this.util.getOptionValue(++n2, stringArray2, APP_OPT_LONG, string);
                    ++n2;
                    continue;
                }
                if (string5.equals(CTX_OPT_SHORT) || string5.equals(CTX_OPT_LONG)) {
                    string2 = this.util.getOptionValue(++n2, stringArray2, CTX_OPT_LONG, string2);
                    ++n2;
                    continue;
                }
                if (string5.equals(DEFER_OPT_SHORT) || string5.equals(DEFER_OPT_LONG)) {
                    bl = true;
                    ++n2;
                    continue;
                }
                if (string5.equals(DEBUG_OPT_LONG)) {
                    this.log_level = 4;
                    ++n2;
                    continue;
                }
            }
            if (string5.startsWith("-")) {
                string6 = "cli_err_15";
                break;
            }
            bl2 = false;
            if (string3 != null) {
                string6 = "cli_err_08";
                break;
            }
            string3 = string5;
            ++n2;
        }
        if (string6 != null) {
            this.util.printError(string6, string5);
            return 2;
        }
        if (string == null || string.length() == 0) {
            this.util.printError("comm_err_11", null);
            return 2;
        }
        if (string2 == null || string2.length() == 0) {
            this.util.printError("comm_err_01", null);
            return 2;
        }
        if (string3 == null || string3.length() == 0) {
            this.util.printError("dep_err_01", null);
            return 2;
        }
        if (string3.endsWith(".war") || string3.endsWith(".WAR")) {
            this.util.printError("dep_err_09", null);
            return 2;
        }
        Properties properties = this.util.getConfigProperties(this.console_conf, string4);
        if (properties == null) {
            return 2;
        }
        this.util.openLog(properties, this.log_level);
        if (!this.util.isUserAdmin()) {
            ConsoleConfigLog.close();
            return 2;
        }
        n = 0;
        try {
            WebAdminDeploy webAdminDeploy = new WebAdminDeploy(properties, this.util);
            webAdminDeploy.deployWebModule(string, string2, string3, bl);
        }
        catch (WebAdminException webAdminException) {
            String string7 = this.util.printMessage(0, webAdminException);
            ConsoleConfigLog.log((int)1, (String)"log_adm_02", (String)string7);
            n = 2;
        }
        catch (Exception exception) {
            WebAdminException webAdminException = new WebAdminException("comm_err_03", exception.getLocalizedMessage());
            String string8 = this.util.printMessage(0, webAdminException);
            ConsoleConfigLog.log((int)1, (String)"log_adm_02", (String)string8);
            n = 2;
        }
        ConsoleConfigLog.close();
        return n;
    }

    public String getDescription() {
        WebAdminException webAdminException = new WebAdminException("usage_101");
        return webAdminException.getLocalizedMessage();
    }
}

