/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.admin;

import com.sun.management.services.common.ConsoleInfo;
import com.sun.web.console.admin.WebAdminException;
import com.sun.web.console.admin.WebAdminSubcommand;
import java.lang.reflect.Constructor;

public class WebAdminDriver {
    public static final String ADMIN_LOG_FILENAME = "console_admin_log";
    private static final String OPT_HELP_SHORT = "-h";
    private static final String OPT_HELP_LONG = "--help";
    private static final String OPT_VERS_SHORT = "-V";
    private static final String OPT_VERS_LONG = "--version";
    private static String[][] subcommands = new String[][]{{"add", "com.sun.web.console.admin.WebAdminAddSubcommand"}, {"deploy", "com.sun.web.console.admin.WebAdminDeploySubcommand"}, {"disable", "com.sun.web.console.admin.WebAdminDisableSubcommand"}, {"enable", "com.sun.web.console.admin.WebAdminEnableSubcommand"}, {"list", "com.sun.web.console.admin.WebAdminListSubcommand"}, {"password", "com.sun.web.console.admin.WebAdminPasswordSubcommand"}, {"reload", "com.sun.web.console.admin.WebAdminReloadSubcommand"}, {"remove", "com.sun.web.console.admin.WebAdminRemoveSubcommand"}, {"undeploy", "com.sun.web.console.admin.WebAdminUndeploySubcommand"}};

    public static void main(String[] stringArray) {
        WebAdminException webAdminException;
        String string = null;
        int n = 0;
        String string2 = System.getProperty("com.sun.web.console.conf");
        if (string2 == null) {
            webAdminException = new WebAdminException("cli_err_01");
            System.err.println(webAdminException.getLocalizedMessage());
            System.exit(2);
        }
        if (stringArray.length < 1) {
            webAdminException = new WebAdminException("cli_err_02");
            System.err.println(webAdminException.getLocalizedMessage());
            System.exit(2);
        }
        if ((string = stringArray[0]).trim().length() == 0) {
            WebAdminDriver.showUsage(string2);
        } else if (string.equals(OPT_HELP_SHORT) || string.equals(OPT_HELP_LONG)) {
            WebAdminDriver.showHelp(string2);
        } else if (string.equals(OPT_VERS_SHORT) || string.equals(OPT_VERS_LONG)) {
            WebAdminDriver.showVersion(string2);
        } else {
            boolean bl = false;
            for (int i = 0; i < subcommands.length; ++i) {
                String string3 = subcommands[i][0];
                if (!string.equals(string3)) continue;
                String string4 = subcommands[i][1];
                n = WebAdminDriver.executeSubcommand(string2, string3, string4, stringArray);
                bl = true;
                break;
            }
            if (!bl) {
                WebAdminException webAdminException2 = new WebAdminException("cli_err_03", string);
                System.err.println(webAdminException2.getLocalizedMessage());
                n = 2;
            }
        }
        System.exit(n);
    }

    protected WebAdminDriver() {
    }

    private static int executeSubcommand(String string, String string2, String string3, String[] stringArray) {
        WebAdminException webAdminException = null;
        int n = 0;
        try {
            WebAdminSubcommand webAdminSubcommand = WebAdminDriver.getSubcommandInstance(string, string2, string3);
            n = webAdminSubcommand.execute(stringArray);
        }
        catch (WebAdminException webAdminException2) {
            webAdminException = webAdminException2;
            n = 2;
        }
        catch (Exception exception) {
            webAdminException = new WebAdminException("cli_err_04", string2, exception.getLocalizedMessage());
            n = 2;
        }
        if (webAdminException != null) {
            System.err.println(webAdminException.getLocalizedMessage());
        }
        return n;
    }

    private static void showUsage(String string) {
        WebAdminDriver.printMessage(" ");
        WebAdminDriver.printMessage(new WebAdminException("usage_01"));
        WebAdminDriver.printMessage(new WebAdminException("usage_02"));
        WebAdminDriver.printMessage(new WebAdminException("usage_03"));
        WebAdminDriver.printMessage(" ");
    }

    private static void showHelp(String string) {
        WebAdminDriver.showUsage(string);
        WebAdminDriver.printMessage(new WebAdminException("usage_04"));
        WebAdminDriver.printMessage(new WebAdminException("usage_05"));
        WebAdminDriver.printMessage(" ");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < subcommands.length; ++i) {
            Object object;
            string2 = subcommands[i][0];
            string3 = subcommands[i][1];
            try {
                object = WebAdminDriver.getSubcommandInstance(string, string2, string3);
                string4 = object.getDescription();
            }
            catch (Exception exception) {
                WebAdminException webAdminException = new WebAdminException("cli_err_05", exception.getLocalizedMessage());
                string4 = webAdminException.getLocalizedMessage();
            }
            object = string2 + "       ";
            object = ((String)object).substring(0, 8);
            WebAdminDriver.printMessage("    " + (String)object + "  " + string4);
            WebAdminDriver.printMessage(" ");
        }
        WebAdminDriver.printMessage(new WebAdminException("usage_06"));
        WebAdminDriver.printMessage(new WebAdminException("usage_07"));
        WebAdminDriver.printMessage(" ");
        WebAdminDriver.printMessage(new WebAdminException("usage_08"));
        WebAdminDriver.printMessage(new WebAdminException("usage_09"));
        WebAdminDriver.printMessage(" ");
        WebAdminDriver.printMessage(new WebAdminException("usage_10"));
        WebAdminDriver.printMessage(" ");
    }

    private static void showVersion(String string) {
        String string2 = ConsoleInfo.getProductName() + " " + ConsoleInfo.getDisplayVersion();
        System.out.println(string2);
    }

    private static WebAdminSubcommand getSubcommandInstance(String string, String string2, String string3) throws WebAdminException {
        WebAdminSubcommand webAdminSubcommand = null;
        try {
            Class<?> clazz = Class.forName(string3);
            Class[] classArray = new Class[]{String.class};
            Object[] objectArray = new Object[]{string};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            webAdminSubcommand = (WebAdminSubcommand)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WebAdminException("cli_err_06", string2, string3);
        }
        catch (Exception exception) {
            throw new WebAdminException("cli_err_07", string2, exception.getLocalizedMessage());
        }
        return webAdminSubcommand;
    }

    private static void printMessage(WebAdminException webAdminException) {
        WebAdminDriver.printMessage(webAdminException.getLocalizedMessage());
    }

    private static void printMessage(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(2, string.length() - 1);
        }
        System.out.println(string);
    }
}

