/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.admin;

import com.sun.web.console.admin.WebAdminAble;
import com.sun.web.console.admin.WebAdminException;
import com.sun.web.console.admin.WebAdminSubcommand;
import com.sun.web.console.admin.WebAdminUtil;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.util.WebUtilLogger;
import java.io.File;
import java.util.Properties;

public class WebAdminEnableSubcommand
implements WebAdminSubcommand {
    public static final String SUBCMD_NAME = "enable";
    public static final String SUBCMD_FILL = "      ";
    private static final String INST_OPT_SHORT = "-i";
    private static final String INST_OPT_LONG = "--instance";
    private static final String NAME_OPT_SHORT = "-x";
    private static final String NAME_OPT_LONG = "--context";
    private static final String HELP_OPT_SHORT = "-h";
    private static final String HELP_OPT_LONG = "--help";
    private static final String HELP_OPT_QUEST = "-?";
    private static final String DEBUG_OPT_LONG = "--debug";
    private static final String HELP_PREFIX = "enable_help_";
    private static final String FS = File.separator;
    private String console_conf;
    private WebUtilLogger logger = null;
    private WebAdminUtil util = null;
    private int log_level = 3;

    public WebAdminEnableSubcommand(String string) {
        this.console_conf = string;
        this.logger = new WebUtilLogger(SUBCMD_NAME);
        this.util = new WebAdminUtil(SUBCMD_NAME, this.logger);
    }

    public int execute(String[] stringArray) throws WebAdminException {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        if (stringArray.length > 2) {
            this.util.printError("cli_err_02", null);
            return 2;
        }
        if (stringArray.length == 1 || stringArray[1].trim().length() == 0) {
            this.util.showHelp(HELP_PREFIX, true);
            return 0;
        }
        String[] stringArray2 = stringArray[1].split("_WxS_");
        boolean bl = true;
        String string4 = null;
        int n2 = 0;
        while (n2 < stringArray2.length) {
            string3 = this.util.stripQuotes(stringArray2[n2]);
            if (bl) {
                if (string3.equals(HELP_OPT_SHORT) || string3.equals(HELP_OPT_LONG) || string3.equals(HELP_OPT_QUEST)) {
                    this.util.showHelp(HELP_PREFIX, false);
                    return 0;
                }
                if (string3.equals(INST_OPT_SHORT) || string3.equals(INST_OPT_LONG)) {
                    string2 = this.util.getOptionValue(++n2, stringArray2, INST_OPT_LONG, string2);
                    ++n2;
                    continue;
                }
                if (string3.equals(NAME_OPT_SHORT) || string3.equals(NAME_OPT_LONG)) {
                    string = this.util.getOptionValue(++n2, stringArray2, NAME_OPT_LONG, string);
                    ++n2;
                    continue;
                }
                if (string3.equals(DEBUG_OPT_LONG)) {
                    this.log_level = 4;
                    ++n2;
                    continue;
                }
            }
            if (string3.startsWith("-")) {
                string4 = "cli_err_15";
                break;
            }
            bl = false;
            string4 = "cli_err_08";
            break;
        }
        if (string4 != null) {
            this.util.printError(string4, string3);
            return 2;
        }
        if (string == null || string.length() == 0) {
            this.util.printError("comm_err_01", null);
            return 2;
        }
        Properties properties = this.util.getConfigProperties(this.console_conf, string2);
        if (properties == null) {
            return 2;
        }
        this.util.openLog(properties, this.log_level);
        if (!this.util.isUserAdmin()) {
            ConsoleConfigLog.close();
            return 2;
        }
        n = 0;
        try {
            WebAdminAble webAdminAble = new WebAdminAble(properties, this.util);
            webAdminAble.processWebModule(SUBCMD_NAME, string);
        }
        catch (WebAdminException webAdminException) {
            String string5 = this.util.printMessage(0, webAdminException);
            ConsoleConfigLog.log((int)1, (String)"log_adm_02", (String)string5);
            n = 2;
        }
        catch (Exception exception) {
            WebAdminException webAdminException = new WebAdminException("comm_err_03", exception.getLocalizedMessage());
            String string6 = this.util.printMessage(0, webAdminException);
            ConsoleConfigLog.log((int)1, (String)"log_adm_02", (String)string6);
            n = 2;
        }
        ConsoleConfigLog.close();
        return n;
    }

    public String getDescription() {
        WebAdminException webAdminException = new WebAdminException("usage_103");
        return webAdminException.getLocalizedMessage();
    }
}

