/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.admin;

import com.sun.management.services.common.CCServiceLibrary;
import com.sun.web.console.admin.WebAdminException;
import com.sun.web.console.admin.WebAdminUtil;
import com.sun.web.console.config.ConsoleConfigFactory;
import com.sun.web.console.config.ConsoleConfigRegistrationResolver;
import com.sun.web.console.config.ConsoleConfigRegnot;
import com.sun.web.console.config.ConsoleConfigService;
import com.sun.web.console.config.SectionedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class WebAdminList {
    private static final String FS = File.separator;
    private static final int REG_PROP_OPTION_PREFIX_LEN = "option_".length();
    private static final String STATE_RUNNING = "[running]";
    private static final String STATE_STOPPED = "[stopped]";
    private static final String STATE_REGNOT = "[regnot ]";
    private Properties env = null;
    private SimpleDateFormat sdf = null;
    private String conf_dir = null;
    private String inst_name = null;
    private String prereg_dir = null;
    private WebAdminUtil util = null;

    public WebAdminList(Properties properties, WebAdminUtil webAdminUtil) throws WebAdminException {
        this.env = properties;
        this.util = webAdminUtil;
        this.sdf = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        this.conf_dir = this.env.getProperty("console_conf");
        this.inst_name = this.env.getProperty("console_instance");
        this.prereg_dir = this.conf_dir + FS + this.inst_name + FS + "prereg";
    }

    public void list(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws WebAdminException {
        Properties[] propertiesArray;
        SectionedProperties sectionedProperties;
        ConsoleConfigRegnot consoleConfigRegnot = new ConsoleConfigRegnot(this.prereg_dir);
        ConsoleConfigRegistrationResolver consoleConfigRegistrationResolver = new ConsoleConfigRegistrationResolver(this.env);
        SectionedProperties sectionedProperties2 = null;
        if (bl6) {
            try {
                sectionedProperties2 = consoleConfigRegnot.loadAll();
            }
            catch (Exception exception) {
                throw new WebAdminException("list_err_03", exception.getLocalizedMessage());
            }
        }
        if (!this.util.isInstanceConfigured(this.env)) {
            throw new WebAdminException("comm_err_12");
        }
        if (bl2 || bl3 || bl4) {
            try {
                sectionedProperties2 = consoleConfigRegistrationResolver.loadCache();
            }
            catch (Exception exception) {
                throw new WebAdminException("list_err_03", exception.getLocalizedMessage());
            }
        }
        if (bl) {
            sectionedProperties = null;
            propertiesArray = null;
            boolean bl7 = true;
            if (bl6) {
                sectionedProperties = sectionedProperties2.select("webapp-");
            } else {
                boolean bl8 = bl7 = CCServiceLibrary.isUserAdmin() == 0;
                if (bl7) {
                    sectionedProperties = this.loadWebappCache(consoleConfigRegistrationResolver);
                }
            }
            if (sectionedProperties != null) {
                propertiesArray = this.getPropertiesList(sectionedProperties);
            }
            this.printWebModules(propertiesArray, bl5, bl6, bl7);
        }
        if (bl2) {
            sectionedProperties = sectionedProperties2.select("jar-");
            propertiesArray = this.getPropertiesList(sectionedProperties);
            this.printLibraries(propertiesArray, bl5, bl6);
        }
        if (bl3) {
            sectionedProperties = sectionedProperties2.select("loginmodule-");
            propertiesArray = this.getPropertiesList(sectionedProperties);
            this.sortLoginModules(propertiesArray);
            this.printLoginModules(propertiesArray, bl5, bl6);
        }
        if (bl4 && !bl6) {
            sectionedProperties = sectionedProperties2.select("jvmoptions-");
            propertiesArray = this.getPropertiesList(sectionedProperties);
            if (propertiesArray != null && propertiesArray.length > 0) {
                this.printJvmProperties(propertiesArray[0]);
            }
            String string = this.conf_dir + FS + this.inst_name + FS + "service.properties";
            FileInputStream fileInputStream = null;
            WebAdminException webAdminException = null;
            Properties properties = new Properties();
            try {
                File file = new File(string);
                if (file.exists()) {
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                }
            }
            catch (Exception exception) {
                webAdminException = new WebAdminException("add_err_13", exception.getLocalizedMessage());
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.printServiceProperties(properties);
        }
    }

    private void printWebModules(Properties[] propertiesArray, boolean bl, boolean bl2, boolean bl3) {
        if (propertiesArray == null || propertiesArray.length == 0) {
            this.skipLine();
            if (bl3) {
                this.printLine("list_err_04");
            } else {
                this.printLine("list_err_07");
            }
            return;
        }
        int[] nArray = this.getColumnWidths(propertiesArray, "id");
        this.skipLine();
        if (bl2) {
            this.printLine("list_err_21");
        } else {
            this.printLine("list_err_22");
        }
        this.skipLine();
        for (int i = 0; i < propertiesArray.length; ++i) {
            String string;
            String string2;
            Properties properties = propertiesArray[i];
            String string3 = properties.getProperty("context");
            if (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            if ((string2 = properties.getProperty("appname")) == null || string2.length() == 0) {
                string2 = string3;
            }
            String string4 = STATE_REGNOT;
            String string5 = properties.getProperty("enabled");
            if (string5 != null) {
                string4 = string5.equalsIgnoreCase("true") ? STATE_RUNNING : STATE_STOPPED;
            }
            if (string2.length() < nArray[0]) {
                string2 = string2 + "                ";
                string2 = string2.substring(0, nArray[0]);
            }
            if (string3.length() < nArray[1]) {
                string3 = string3 + "                ";
                string3 = string3.substring(0, nArray[1]);
            }
            this.printEntityLine(string2, string3, string4);
            if (!bl) continue;
            this.printTimeStamp(properties, bl2);
            String string6 = properties.getProperty("location");
            this.printDetailLine("list_err_18", string6);
            String string7 = properties.getProperty("debug");
            if (string7 != null && string7.length() > 0) {
                this.printDetailLine("list_err_13", string7);
            }
            if ((string = properties.getProperty("system")) == null || string.length() == 0) {
                string = "false";
            }
            this.printDetailLine("list_err_11", string);
            this.skipLine();
        }
    }

    private void printLibraries(Properties[] propertiesArray, boolean bl, boolean bl2) {
        if (propertiesArray == null || propertiesArray.length == 0) {
            this.skipLine();
            this.printLine("list_err_05");
            return;
        }
        int[] nArray = this.getColumnWidths(propertiesArray, "id");
        this.skipLine();
        this.printLine("list_err_23");
        this.skipLine();
        for (int i = 0; i < propertiesArray.length; ++i) {
            Properties properties = propertiesArray[i];
            String string = properties.getProperty("id");
            String string2 = properties.getProperty("appname");
            String string3 = properties.getProperty("location");
            if (string2.length() < nArray[0]) {
                string2 = string2 + "                ";
                string2 = string2.substring(0, nArray[0]);
            }
            if (string.length() < nArray[1]) {
                string = string + "                ";
                string = string.substring(0, nArray[1]);
            }
            this.printEntityLine(string2, string, string3);
            if (!bl) continue;
            this.printTimeStamp(properties, bl2);
            String string4 = properties.getProperty("system");
            if (string4 != null && string4.length() > 0) {
                this.printDetailLine("list_err_11", string4);
            }
            this.skipLine();
        }
    }

    private void printLoginModules(Properties[] propertiesArray, boolean bl, boolean bl2) {
        if (propertiesArray == null || propertiesArray.length == 0) {
            this.skipLine();
            this.printLine("list_err_06");
            return;
        }
        int[] nArray = this.getColumnWidths(propertiesArray, "service");
        this.skipLine();
        this.printLine("list_err_24");
        String string = "";
        for (int i = 0; i < propertiesArray.length; ++i) {
            Properties properties = propertiesArray[i];
            String string2 = properties.getProperty("id");
            String string3 = properties.getProperty("service");
            String string4 = properties.getProperty("appname");
            if (string4.length() < nArray[0]) {
                string4 = string4 + "                ";
                string4 = string4.substring(0, nArray[0]);
            }
            if (string3.length() < nArray[1]) {
                string3 = string3 + "                ";
                string3 = string3.substring(0, nArray[1]);
            }
            if (!string3.equalsIgnoreCase(string)) {
                this.skipLine();
                string = string3;
            }
            this.printEntityLine(string4, string3, string2);
            if (!bl) continue;
            this.printTimeStamp(properties, bl2);
            String string5 = properties.getProperty("class");
            this.printDetailLine("list_err_14", string5);
            String string6 = properties.getProperty("behavior");
            this.printDetailLine("list_err_15", string6);
            String string7 = properties.getProperty("order");
            if (string7 == null || string7.length() == 0) {
                string7 = "0";
            }
            this.printDetailLine("list_err_17", string7);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string8 = (String)enumeration.nextElement();
                if (!string8.startsWith("option_")) continue;
                String string9 = properties.getProperty(string8);
                string8 = string8.substring(REG_PROP_OPTION_PREFIX_LEN);
                this.printDetailLine("list_err_16", string8, string9);
            }
            this.skipLine();
        }
    }

    private void printJvmProperties(Properties properties) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.skipLine();
        this.printLine("Persistent Jvm options:");
        this.skipLine();
        int n = 1;
        boolean bl = true;
        while (bl) {
            try {
                String string = properties.getProperty("value_" + n);
                if (string != null && string.length() > 0) {
                    this.printEntityLine(string);
                } else {
                    bl = false;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            ++n;
        }
    }

    private void printServiceProperties(Properties properties) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.skipLine();
        this.printLine("list_err_25");
        this.skipLine();
        Set<Object> set = properties.keySet();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = properties.getProperty(string);
            if (string.length() < 16) {
                string = string + "                ";
                string = string.substring(0, 16);
            }
            if (string2 == null) {
                string2 = "(null)";
            }
            this.printEntityLine(string, string2);
        }
        this.skipLine();
    }

    private SectionedProperties loadWebappCache(ConsoleConfigRegistrationResolver consoleConfigRegistrationResolver) throws WebAdminException {
        ConsoleConfigFactory consoleConfigFactory;
        ConsoleConfigService consoleConfigService = null;
        try {
            consoleConfigFactory = new ConsoleConfigFactory();
            consoleConfigService = consoleConfigFactory.createConsoleConfigService(this.env, this.inst_name);
            consoleConfigService.initialize();
        }
        catch (Exception exception) {
            throw new WebAdminException("comm_err_02", exception.getLocalizedMessage());
        }
        try {
            consoleConfigService.connectAdmin();
        }
        catch (Exception exception) {
            throw new WebAdminException("comm_err_07", exception.getLocalizedMessage());
        }
        consoleConfigFactory = null;
        try {
            consoleConfigFactory = consoleConfigRegistrationResolver.loadWebappCache(consoleConfigService);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new WebAdminException("list_err_02", exception.getLocalizedMessage());
        }
        try {
            consoleConfigService.disConnectAdmin();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return consoleConfigFactory;
    }

    private Properties[] getPropertiesList(SectionedProperties sectionedProperties) {
        Properties[] propertiesArray = new Properties[sectionedProperties.size()];
        Iterator iterator = sectionedProperties.blockNames();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            propertiesArray[n] = sectionedProperties.getBlock(string);
            ++n;
        }
        return propertiesArray;
    }

    private void sortLoginModules(Properties[] propertiesArray) {
        if (propertiesArray.length > 1) {
            Properties properties = null;
            int n = propertiesArray.length;
            for (int i = 0; i < n; ++i) {
                for (int j = i; j < n - 1; ++j) {
                    String string;
                    String string2 = this.getLoginModuleSortKey(propertiesArray[j]);
                    if (string2.compareToIgnoreCase(string = this.getLoginModuleSortKey(propertiesArray[j + 1])) <= 0) continue;
                    properties = propertiesArray[j];
                    propertiesArray[j] = propertiesArray[j + 1];
                    propertiesArray[j + 1] = properties;
                }
            }
        }
    }

    private String getLoginModuleSortKey(Properties properties) {
        String string = properties.getProperty("service");
        String string2 = properties.getProperty("order");
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n <= 0) {
            n = 9999;
        }
        String string3 = Integer.toString(n += 10000).substring(1);
        return string + "-" + string3;
    }

    private void printTimeStamp(Properties properties, boolean bl) {
        String string = null;
        String string2 = properties.getProperty("timestamp");
        if (string2 != null && string2.length() > 0) {
            try {
                long l = Long.parseLong(string2);
                if (l > 0L) {
                    string = this.sdf.format(new Date(l));
                    this.printDetailLine("list_err_10", string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int[] getColumnWidths(Properties[] propertiesArray, String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < propertiesArray.length; ++i) {
            String string2;
            String string3 = propertiesArray[i].getProperty("appname");
            if (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            if (string3.length() > n) {
                n = string3.length();
            }
            if ((string2 = propertiesArray[i].getProperty(string)) == null || string2.length() <= n2) continue;
            n2 = string2.length();
        }
        if (n > 16) {
            n = 16;
        }
        if (n2 > 16) {
            n2 = 16;
        }
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    private void skipLine() {
        System.out.println(" ");
    }

    private void printLine(String string) {
        WebAdminException webAdminException = new WebAdminException(string);
        System.out.println(webAdminException.getLocalizedMessage());
    }

    private void printDetailLine(String string, String string2) {
        WebAdminException webAdminException = new WebAdminException(string, string2);
        System.out.println("        " + webAdminException.getLocalizedMessage());
    }

    private void printDetailLine(String string, String string2, String string3) {
        WebAdminException webAdminException = new WebAdminException(string, string2, string3);
        System.out.println("        " + webAdminException.getLocalizedMessage());
    }

    private void printEntityLine(String string) {
        System.out.println("    " + string);
    }

    private void printEntityLine(String string, String string2) {
        System.out.println("    " + string + "  " + string2);
    }

    private void printEntityLine(String string, String string2, String string3) {
        System.out.println("    " + string + "  " + string2 + "  " + string3);
    }
}

