/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.admin;

import com.sun.management.services.common.CCServiceLibrary;
import com.sun.web.console.admin.WebAdminException;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigStatus;
import com.sun.web.console.config.ConsoleConfigUtil;
import com.sun.web.util.WebUtilLogger;
import java.io.File;
import java.util.Properties;

public class WebAdminUtil {
    private static final String HELP_EOM = "EOM";
    private static final String FS = File.separator;
    private String subcmd;
    private WebUtilLogger logger;

    public WebAdminUtil(String string, WebUtilLogger webUtilLogger) {
        this.subcmd = string;
        this.logger = webUtilLogger;
    }

    public Properties getConfigProperties(String string, String string2) {
        Properties properties = null;
        if (string2 == null) {
            string2 = "console";
        }
        try {
            String string3;
            properties = ConsoleConfigUtil.getEnvProperties((String)string, (String)string2);
            ConsoleConfigStatus consoleConfigStatus = new ConsoleConfigStatus(properties);
            if (consoleConfigStatus != null && (string3 = consoleConfigStatus.getUserName()) != null && !string3.equals("undefined")) {
                properties.setProperty("console_user", string3);
            }
        }
        catch (Exception exception) {
            this.printMessage(0, exception.getLocalizedMessage());
        }
        return properties;
    }

    public boolean isInstanceConfigured(Properties properties) {
        boolean bl = false;
        try {
            ConsoleConfigStatus consoleConfigStatus = new ConsoleConfigStatus(properties);
            if (consoleConfigStatus != null) {
                bl = consoleConfigStatus.isDomainComplete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isUserAdmin() {
        boolean bl;
        boolean bl2 = bl = CCServiceLibrary.isUserAdmin() == 0;
        if (!bl) {
            String string = System.getProperty("user.name");
            this.printError("cli_err_14", string);
            ConsoleConfigLog.log((int)1, (String)"log_adm_01", (String)this.subcmd, (String)string);
        }
        return bl;
    }

    public void openLog(Properties properties, int n) {
        String string = properties.getProperty("console_log") + FS + properties.getProperty("console_instance") + FS + "console_admin_log";
        ConsoleConfigLog.open((int)n, (String)string);
    }

    public void showHelp(String string, boolean bl) {
        boolean bl2 = true;
        int n = 0;
        System.out.println("");
        while (bl2) {
            String string2 = string + ++n;
            String string3 = new WebAdminException(string2).getLocalizedMessage();
            if (string3.startsWith("\"") && string3.endsWith("\"")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if (bl && string3.trim().length() == 0 || string3.equals(HELP_EOM) || string3.equals(string2)) break;
            System.out.println(string3);
        }
        System.out.println("");
    }

    public String getOptionValue(int n, String[] stringArray, String string, String string2) throws WebAdminException {
        if (n >= stringArray.length) {
            throw new WebAdminException("cli_err_09", string.substring(2));
        }
        if (stringArray[n].startsWith("-")) {
            throw new WebAdminException("cli_err_09", string.substring(2));
        }
        if (string2 != null) {
            throw new WebAdminException("cli_err_10", string.substring(2));
        }
        return stringArray[n];
    }

    public String stripQuotes(String string) {
        if (string.startsWith("\"") && (string = string.substring(1)).endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public WebUtilLogger getLogger() {
        return this.logger;
    }

    public void printInfo(String string, String string2) {
        this.printMessage(2, string, string2, null, null);
    }

    public void printWarning(String string, String string2) {
        this.printMessage(1, string, string2, null, null);
    }

    public void printError(String string, String string2) {
        this.printMessage(0, string, string2, null, null);
    }

    public String printMessage(int n, String string, String string2, String string3, String string4) {
        WebAdminException webAdminException = new WebAdminException(string, string2 == null ? "(null)" : string2, string3 == null ? "(null)" : string3, string4 == null ? "(null)" : string4);
        return this.printMessage(n, webAdminException);
    }

    public String printMessage(int n, WebAdminException webAdminException) {
        String string = webAdminException.getLocalizedMessage();
        this.printMessage(n, string);
        return string;
    }

    public void printMessage(int n, String string) {
        if (this.logger != null) {
            this.logger.log(string, n);
        } else if (n == 0) {
            System.err.println(string);
        } else {
            System.out.println(string);
        }
    }
}

