/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.admindomain;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.utility.directorytable.DirectoryTableSetup;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.InstanceProvider;

public class Solaris_AdminDomain
implements InstanceProvider {
    private static final String CAPTION = "Caption";
    private static final String DESCRIPTION = "Description";
    private static final String INSTALL_DATE = "InstallDate";
    private static final String DOMAIN_NAME = "Name";
    private static final String NAME_FORMAT = "NameFormat";
    private static final String STATUS = "Status";
    private static final String CREATION_CLASS_NAME = "CreationClassName";
    private static final String PRIMARY_OWNER_CONTACT = "PrimaryOwnerContact";
    private static final String PRIMARY_OWNER_NAME = "PrimaryOwnerName";
    private static final String ROLES = "Roles";
    private static final String CIM_ALL_CLASS = "CIM_AdminDomain";
    private static final String SOL_ALL_CLASS = "Solaris_AdminDomain";
    private static final String ALL_SCOPES = "all";
    private static final String FORMAT_OTHER = "Other";
    private static final String SOLARIS_CAPTION = "Solaris Admin Domain";
    private static final String LOCAL_SYSTEM_DESC = "Solaris local system domain";
    private static final String NAME_SERVICE_DESC = " name service domain master server";
    protected ProviderCIMOMHandle cimomhandle = null;
    protected ProviderUtility provUtil = null;
    protected String providerName = "AdminDomainProvider";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)cimomhandle;
        this.provUtil = new ProviderUtility(cimomhandle, this.providerName);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> allRecs = new Vector<CIMObjectPath>();
        String cn = op.getObjectName();
        String type = this.getScopeType(cn);
        if (type.equals(ALL_SCOPES)) {
            CIMObjectPath[] copArray = new CIMObjectPath[allRecs.size()];
            allRecs.toArray(copArray);
            return copArray;
        }
        Vector vScopes = this.getScopes(type);
        String ns = op.getNameSpace();
        for (int i = 0; vScopes != null && i < vScopes.size(); ++i) {
            String scope = (String)vScopes.elementAt(i);
            type = this.getTypeFromScope(scope);
            cn = this.provUtil.getScopeClassFromType(type);
            String dn = this.getDomainFromScope(scope);
            CIMObjectPath cop = new CIMObjectPath(cn, ns);
            cop.addKey(CREATION_CLASS_NAME, new CIMValue((Object)cn));
            cop.addKey(DOMAIN_NAME, new CIMValue((Object)dn));
            allRecs.addElement(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[allRecs.size()];
        allRecs.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        CIMInstance ci = null;
        Vector<CIMInstance> allInstances = new Vector<CIMInstance>();
        String cn = op.getObjectName();
        String type = this.getScopeType(cn);
        if (type.equals(ALL_SCOPES)) {
            CIMInstance[] ciArray = new CIMInstance[allInstances.size()];
            allInstances.toArray(ciArray);
            return ciArray;
        }
        Vector vScopes = this.getScopes(type);
        for (int i = 0; vScopes != null && i < vScopes.size(); ++i) {
            String scope = (String)vScopes.elementAt(i);
            type = this.getTypeFromScope(scope);
            cn = this.provUtil.getScopeClassFromType(type);
            String dn = this.getDomainFromScope(scope);
            ci = cc.newInstance();
            ci.setClassName(cn);
            ci.setProperty(CREATION_CLASS_NAME, new CIMValue((Object)cn));
            ci.setProperty(DOMAIN_NAME, new CIMValue((Object)dn));
            ci.setProperty(NAME_FORMAT, new CIMValue((Object)FORMAT_OTHER));
            if (!localOnly) {
                ci.setProperty(CAPTION, new CIMValue((Object)SOLARIS_CAPTION));
                ci.setProperty(DESCRIPTION, new CIMValue((Object)this.getDescription(type)));
            } else {
                ci = ci.localElements();
            }
            allInstances.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
        }
        CIMInstance[] ciArray = new CIMInstance[allInstances.size()];
        allInstances.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        CIMInstance ci = null;
        String cn = null;
        String dn = null;
        Vector keys = op.getKeys();
        if (keys != null) {
            for (int i = 0; i < keys.size(); ++i) {
                CIMValue cv;
                CIMProperty cp = (CIMProperty)keys.elementAt(i);
                if (cp.getName().equalsIgnoreCase(DOMAIN_NAME) && (cv = cp.getValue()) != null) {
                    dn = (String)cv.getValue();
                }
                if (!cp.getName().equalsIgnoreCase(CREATION_CLASS_NAME) || (cv = cp.getValue()) == null) continue;
                cn = (String)cv.getValue();
            }
        }
        String scope = this.provUtil.getMgmtScope(cn, dn);
        String type = this.getTypeFromScope(scope);
        ci = cc.newInstance();
        ci.setClassName(cn);
        ci.setProperty(CREATION_CLASS_NAME, new CIMValue(cn));
        ci.setProperty(DOMAIN_NAME, new CIMValue((Object)dn));
        ci.setProperty(NAME_FORMAT, new CIMValue((Object)FORMAT_OTHER));
        if (localOnly) {
            ci = ci.localElements();
        } else {
            ci.setProperty(CAPTION, new CIMValue((Object)SOLARIS_CAPTION));
            ci.setProperty(DESCRIPTION, new CIMValue((Object)this.getDescription(type)));
        }
        return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        return null;
    }

    private String getScopeType(String cn) throws CIMException {
        String scope_type = null;
        if (cn != null && (scope_type = this.provUtil.getScopeTypeFromClass(cn)) == null) {
            if (cn.equals(SOL_ALL_CLASS)) {
                scope_type = ALL_SCOPES;
            } else if (cn.equals(CIM_ALL_CLASS)) {
                scope_type = null;
            }
        }
        if (scope_type == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cn);
        }
        return scope_type;
    }

    private Vector getScopes(String type) throws CIMException {
        Vector v = null;
        DirectoryTableSetup dirtab = new DirectoryTableSetup();
        try {
            v = type.equals(ALL_SCOPES) ? dirtab.getScopes(2) : dirtab.getScopes(type, 2);
        }
        catch (Exception ex) {
            v = null;
        }
        if (v == null || v.size() == 0) {
            if (type.equals(ALL_SCOPES) || type.equals("file")) {
                this.provUtil.writeLog(2, "LM_2410", "LM_2412", this.provUtil.getServerHostName(), null, null, null);
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)type);
            }
            v = new Vector(0);
        }
        return v;
    }

    private String getDescription(String type) {
        String desc = "";
        desc = type.equals("file") ? LOCAL_SYSTEM_DESC : "Solaris " + type + NAME_SERVICE_DESC;
        return desc;
    }

    private String getTypeFromScope(String scope) {
        int i = scope.indexOf(58);
        String type = i > 0 ? scope.substring(0, i) : "";
        return type;
    }

    private String getDomainFromScope(String scope) {
        int i = scope.lastIndexOf(47);
        String dn = i > 0 && i < scope.length() ? scope.substring(i + 1) : "";
        return dn;
    }
}

