/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.ether;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class NetInfo {
    int c;
    int num = 0;
    private static boolean library_loaded = false;
    public static String statTmp = "/var/sadm/wbem/stat.out";
    public static String configTmp = "/var/sadm/wbem/config.out";
    public static String netstat = "/usr/bin/netstat -p";
    public static String ifconfig = "/usr/sbin/ifconfig -au4";

    public static void createTmpFiles() {
        int c = 0;
        int processExitValue = -1;
        Runtime rt = null;
        NetInfo.deleteTmpFiles();
        try {
            Process p_netstat = null;
            rt = Runtime.getRuntime();
            if (rt == null) {
                return;
            }
            p_netstat = rt.exec(netstat);
            try {
                p_netstat.waitFor();
            }
            catch (Exception e) {
                System.err.println(e);
            }
            processExitValue = p_netstat.exitValue();
            if (processExitValue != 0) {
                return;
            }
            Process p_config = null;
            rt = Runtime.getRuntime();
            if (rt == null) {
                return;
            }
            p_config = rt.exec(ifconfig);
            try {
                p_config.waitFor();
            }
            catch (Exception e) {
                System.err.println(e);
            }
            processExitValue = p_config.exitValue();
            if (processExitValue != 0) {
                return;
            }
            BufferedInputStream in_stat = (BufferedInputStream)p_netstat.getInputStream();
            BufferedWriter statFile = new BufferedWriter(new FileWriter(statTmp, false));
            BufferedInputStream in_config = (BufferedInputStream)p_config.getInputStream();
            BufferedWriter configFile = new BufferedWriter(new FileWriter(configTmp, false));
            while ((c = in_stat.read()) != -1) {
                statFile.write((char)c);
            }
            statFile.flush();
            statFile.close();
            in_stat.close();
            while ((c = in_config.read()) != -1) {
                configFile.write((char)c);
            }
            configFile.flush();
            configFile.close();
            in_config.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void deleteTmpFiles() {
        File config = new File(configTmp);
        File stat = new File(statTmp);
        if (config.exists()) {
            config.delete();
        }
        if (stat.exists()) {
            stat.delete();
        }
    }

    public static String getMacAddr(String mac) {
        String buff = " ";
        String MAC = "";
        String Lhost = null;
        try {
            boolean num = false;
            BufferedReader tmpIn = new BufferedReader(new FileReader(statTmp));
            InetAddress host = InetAddress.getLocalHost();
            Lhost = host.getHostName().concat(" ");
            while ((buff = tmpIn.readLine()) != null) {
                if (buff.indexOf(Lhost, 0) <= 0) continue;
                StringBuffer contents = new StringBuffer(buff);
                int idx1 = buff.indexOf(58, 0);
                contents.delete(0, idx1 - 2);
                MAC = contents.substring(0);
                break;
            }
            tmpIn.close();
        }
        catch (IOException e) {
            System.err.println("getMacAddr: " + e);
        }
        return MAC;
    }

    public static int getNumInterfaces() {
        String buff = " ";
        int num = 0;
        try {
            BufferedReader tmpIn = new BufferedReader(new FileReader(configTmp));
            while ((buff = tmpIn.readLine()) != null) {
                if (buff.indexOf(58, 0) <= 0 || buff.indexOf("ether", 0) > 0) continue;
                ++num;
            }
        }
        catch (IOException e) {
            System.err.println("getNUMInterfaces: " + e);
        }
        return num;
    }

    public static String getDevID(int lines) {
        String buff = " ";
        String device = " ";
        String token = " ";
        try {
            StringTokenizer dev;
            int num = 0;
            BufferedReader tmpIn = new BufferedReader(new FileReader(configTmp));
            InetAddress host = InetAddress.getLocalHost();
            for (num = 0; num <= lines; ++num) {
                buff = tmpIn.readLine();
                if (num <= 0 && buff.indexOf("ether", 0) <= 0) continue;
                buff = tmpIn.readLine();
            }
            if (buff.indexOf(58, 0) > 0 && (dev = new StringTokenizer(buff, ":")).hasMoreTokens()) {
                token = dev.nextToken();
                token = token.trim();
            }
            tmpIn.close();
        }
        catch (IOException e) {
            System.err.println("getDevID: " + e);
        }
        return token.trim();
    }

    public static String getDevInfo(String dev, String option) {
        String buff = "";
        String value = "";
        int mtu_index = 0;
        int index = 0;
        try {
            BufferedReader tmpIn = new BufferedReader(new FileReader(configTmp));
            while ((buff = tmpIn.readLine()) != null) {
                if (!buff.startsWith(dev)) continue;
                if (option.equals("mtu")) {
                    mtu_index = buff.indexOf("mtu", 0);
                    index = buff.indexOf("index", 0);
                    value = buff.substring(mtu_index + 3, index);
                    break;
                }
                if (option.equalsIgnoreCase("Available")) {
                    if (buff.indexOf("RUNNING", 0) > 0) {
                        value = "3";
                        break;
                    }
                    value = "4";
                    break;
                }
                value = option.equalsIgnoreCase("status") ? buff : "Unknown";
                break;
            }
            tmpIn.close();
        }
        catch (IOException e) {
            System.err.println("getDevInfo: " + e);
        }
        return value.trim();
    }

    public static long getKstat(String dev, String arg) {
        long value = 0L;
        if (library_loaded) {
            value = NetInfo.getKstatInfo(dev, arg);
            return value;
        }
        return 0L;
    }

    private static native long getKstatInfo(String var0, String var1);

    static {
        try {
            System.loadLibrary("solprov");
            library_loaded = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

