/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.network;

import com.sun.wbem.solarisprovider.network.IPSubnetData;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import java.util.Hashtable;

public class IPSubnetInfo {
    private static final int subnetNumberColumn = 1;
    private static final int subnetMaskColumn = 2;
    private static final String emptyString = new String("");
    private static final String space = new String(" ");
    private static final String fileType = new String("File");
    Hashtable netmasksHashTable = new Hashtable();

    public Hashtable getNetmasksData() throws DirectoryTableException {
        DirectoryTable netmasksTable = null;
        try {
            netmasksTable = this.openNetmasksTable();
            this.parseNetmasksTable(netmasksTable);
            netmasksTable.close();
        }
        catch (DirectoryTableDoesNotExistException e) {
        }
        catch (DirectoryTableException e) {
            if (netmasksTable != null) {
                netmasksTable.close();
            }
            throw e;
        }
        return this.netmasksHashTable;
    }

    private DirectoryTable openNetmasksTable() throws DirectoryTableException {
        DirectoryTable netmasksTable = DirectoryTableFactory.getDirectoryTableInstance((String)fileType, (String)emptyString, (String)emptyString);
        netmasksTable.open("netmasks");
        return netmasksTable;
    }

    private void parseNetmasksTable(DirectoryTable netmasksTable) throws DirectoryTableException {
        String subnetNumber = null;
        String subnetMask = null;
        DirectoryRow netmasksEntry = null;
        netmasksEntry = netmasksTable.getFirstRow();
        while (netmasksEntry != null) {
            subnetNumber = netmasksEntry.getColumn(1);
            subnetMask = netmasksEntry.getColumn(2);
            IPSubnetData subnetData = new IPSubnetData(subnetNumber, subnetMask);
            this.netmasksHashTable.put(subnetNumber, subnetData);
            netmasksEntry = netmasksTable.getNextRow();
        }
    }
}

