/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.cli.PatchServices;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchList;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PPro;
import com.sun.wbem.solarisprovider.patch.PatchException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AssessNeededPatches
extends PPro {
    public static int IGNORE_CACHE = 0;
    public static int READ_CACHE = 1;
    public static int WRITE_CACHE = 2;
    private String cacheFile;
    Vector params;
    private static final String[] header = new String[]{"# DO NOT EDIT THIS FILE BY HAND. This file is not a public interface.", "# The format and contents of this file are subject to change.", "# Any user modification of this file may result in the incorrect", "# operation of Patch Manager."};
    boolean done = false;
    Vector props;

    public AssessNeededPatches(ProviderUtility provUtil) {
        this(provUtil, null);
    }

    public AssessNeededPatches(ProviderUtility provUtil, Vector params) {
        AssessNeededPatches.provUtil = provUtil;
        this.params = params;
        PatchProProperties props = PatchProProperties.getInstance();
        for (int i = 0; params != null && i < params.size(); ++i) {
            String param = (String)params.elementAt(i);
            int eq = 0;
            eq = param.indexOf(61);
            if (eq <= 0) continue;
            String key = param.substring(0, eq);
            String val = param.substring(eq + 1);
            if (val == null) continue;
            props.setProperty(key, val);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(props.getProperty("patchpro.cache.directory")).append(File.separator).append(props.getProperty("patchpro.cache.analysis"));
        this.cacheFile = buffer.toString();
    }

    public void initialize() throws PatchException {
        this.init();
    }

    public void getAssessedPatchesNeeded(int cacheMode) throws PatchException {
        try {
            if ((cacheMode & READ_CACHE) == READ_CACHE) {
                this.readFile(this.cacheFile);
            } else {
                this.analyzeHost();
                PatchList pl = this.getNeededPatches();
                this.props = PatchServices.convertPatchList((PatchList)pl);
                if ((cacheMode & WRITE_CACHE) == WRITE_CACHE) {
                    this.writeFile(this.cacheFile);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            throw new PatchException(ioe.getLocalizedMessage());
        }
        catch (PatchProException ppe) {
            throw new PatchException(ppe.getLocalizedMessage());
        }
    }

    public long getCacheLastModified() {
        File of = new File(this.cacheFile);
        return of.lastModified();
    }

    public Vector getPatchIds() {
        return PatchServices.getAllPropsWithTag((Vector)this.props, (String)"id");
    }

    public Vector getSynopsis() {
        return PatchServices.getAllPropsWithTag((Vector)this.props, (String)"syn");
    }

    public Vector getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String file) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        try {
            for (int i = 0; i < header.length; ++i) {
                out.write(header[i]);
                out.newLine();
            }
            Enumeration e = this.props.elements();
            while (e.hasMoreElements()) {
                out.write((String)e.nextElement());
                out.newLine();
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(String file) throws FileNotFoundException, IOException {
        this.props = new Vector();
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String prop;
            while ((prop = in.readLine()) != null) {
                if (prop.startsWith("#")) continue;
                this.props.add(prop);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void testGetAssessedPatchesNeeded() throws PatchException {
        this.getAssessedPatchesNeeded(WRITE_CACHE);
        Vector testPatchIds = this.getPatchIds();
        Vector testSynopsis = this.getSynopsis();
        for (int i = 0; testPatchIds != null && i < testPatchIds.size(); ++i) {
            System.out.print("Patch ID: " + (String)testPatchIds.elementAt(i) + "\tSynopsis: " + (String)testSynopsis.elementAt(i));
        }
    }

    public void test() {
        boolean done = false;
        while (!done) {
            System.out.println("1 - Get the needed patches:");
            System.out.println("q - To quit");
            System.out.println("");
            System.out.print("Enter option: ");
            try {
                byte[] buffer = new byte[100];
                char bytes = (char)System.in.read(buffer);
                System.out.println("");
                if (bytes != '\u0002') continue;
                char option = (char)buffer[0];
                switch (option) {
                    case '1': {
                        this.testGetAssessedPatchesNeeded();
                        break;
                    }
                    case 'q': {
                        if (this.model != null) {
                            this.model.removeListener((PatchProListener)this);
                        }
                        done = true;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Exception: " + e);
                e.printStackTrace();
            }
            System.out.println("");
        }
    }

    public static void main(String[] args) {
        AssessNeededPatches anp = new AssessNeededPatches(null);
        try {
            anp.initialize();
        }
        catch (PatchException pe) {
            pe.printStackTrace();
        }
        anp.test();
    }
}

