/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.PatchAccumulator;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchList;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PPro;
import com.sun.wbem.solarisprovider.patch.PProUtil;
import com.sun.wbem.solarisprovider.patch.PatchException;
import java.io.File;
import java.util.Vector;
import javax.wbem.client.Debug;

public class DownloadPatches
extends PPro {
    private File downloadDir;
    private PatchList assessedPatchList = null;
    private PatchList accumPatchList = null;
    private PatchList patchesNotDownloaded = null;
    private static final String DWNL_AUTH_STR = "patchpro.patch.download.authenticate";
    private PatchProProperties ppp;

    public DownloadPatches(ProviderUtility provUtil) {
        DownloadPatches.provUtil = provUtil;
        this.ppp = PatchProProperties.getInstance();
    }

    protected void initialize(Vector patchList, String targetDir) throws PatchException {
        this.patchListVec = patchList;
        this.targetDir = targetDir;
        if (targetDir != null) {
            this.ppp.setProperty("patchpro.download.directory", targetDir);
        }
        if (this.targetDir != null && this.targetDir.length() > 0) {
            PProUtil.dirAvailable(this.targetDir);
        }
        this.init();
        if (this.model == null) {
            throw new PatchException("EXM_DL_UNEXP_ERR");
        }
        this.analyzeHost();
    }

    protected void patchDownloader(boolean extract) throws PatchException {
        int vecSize = 0;
        Debug.trace3((String)("targetDir: " + this.targetDir));
        Debug.trace3((String)"Before downloadPatches(): ");
        this.downloadDir = new File(this.targetDir);
        if (this.patchListVec != null) {
            vecSize = this.patchListVec.size();
        }
        if (vecSize > 0) {
            this.downloadPatchList(extract);
        } else if (vecSize == 0) {
            this.downloadRecommended(extract);
        } else {
            throw new PatchException("EXM_DL_UNEXP_ERR");
        }
    }

    protected Vector getAssessedOrAccumPatchList() throws PatchException {
        if (this.accumPatchList != null) {
            return PProUtil.patchListToVector(this.accumPatchList);
        }
        if (this.assessedPatchList != null) {
            return PProUtil.patchListToVector(this.assessedPatchList);
        }
        return null;
    }

    protected Vector getPatchesNotDownloaded() throws PatchException {
        if (this.patchesNotDownloaded != null) {
            return PProUtil.patchListToVector(this.patchesNotDownloaded);
        }
        return null;
    }

    Vector getPatchesNotDownloadedWithError() throws PatchException {
        if (this.patchesNotDownloaded != null) {
            String patchErrorString = null;
            Vector<String> outVec = new Vector<String>();
            int plSize = this.patchesNotDownloaded.size();
            for (int index = 0; index < plSize; ++index) {
                IPatch patch;
                try {
                    patch = (IPatch)this.patchesNotDownloaded.getPatchAt(index);
                }
                catch (NoSuchPatchException nspe) {
                    throw new PatchException(nspe.getLocalizedMessage());
                }
                if (patch == null || (patchErrorString = patch.getError()) == null && patchErrorString.length() <= 0) continue;
                outVec.addElement(patchErrorString);
            }
            return outVec;
        }
        return null;
    }

    private void downloadRecommended(boolean extract) throws PatchException {
        this.assessedPatchList = this.getNeededPatches();
        Debug.trace3((String)"In downloadRecommended: ");
        PProUtil.printPatchList(this.assessedPatchList);
        try {
            this.download(this.assessedPatchList, extract);
        }
        catch (Exception ex) {
            this.cleanup();
            if (provUtil != null) {
                provUtil.writeLog(2, ex);
            }
            throw new PatchException(ex.getLocalizedMessage());
        }
    }

    private void downloadPatchList(boolean extract) throws PatchException {
        try {
            Debug.trace3((String)"Started getPatchAccumulator().");
            PatchAccumulator pa = null;
            if (this.model == null) {
                throw new PatchException("EXM_DL_UNEXP_ERR");
            }
            this.prepForThread();
            this.model.assessNeededPatches();
            this.waitForThread();
            pa = this.model.getPatchAccumulator();
            int size = this.patchListVec.size();
            String pidStr = "";
            for (int i = 0; i < size; ++i) {
                pidStr = (String)this.patchListVec.elementAt(i);
                Debug.trace3((String)("pidStr: " + pidStr));
                PatchID pid = new PatchID((String)this.patchListVec.elementAt(i));
                this.accumPatchList = pa.getPatchClosure(pid);
            }
            PProUtil.printPatchList(this.accumPatchList);
            for (int ii = 0; ii < this.accumPatchList.size(); ++ii) {
                Debug.trace3((String)("select status is: " + this.accumPatchList.getSelectionStatus(ii)));
                this.accumPatchList.setSelectionStatus(ii, true);
                Debug.trace3((String)("select status is: " + this.accumPatchList.getSelectionStatus(ii)));
            }
            this.download(this.accumPatchList, extract);
        }
        catch (Exception ex) {
            Debug.trace3((String)"---- download failed: ", (Throwable)ex);
            if (provUtil != null) {
                provUtil.writeLog(2, ex);
            }
            throw new PatchException(ex.getLocalizedMessage());
        }
        finally {
            this.cleanup();
        }
    }

    private void download(PatchList pList, boolean extract) throws Exception {
        this.prepForThread();
        Debug.trace3((String)"Started download(PatchList).");
        this.model.downloadPatches(pList, this.downloadDir);
        this.waitForThread();
        this.setupDownload(pList, this.targetDir, extract);
        this.patchesNotDownloaded = this.model.getUnavailablePatches();
        PProUtil.printPatchList(this.patchesNotDownloaded);
        this.logIt(pList, this.patchesNotDownloaded);
    }

    private void logIt(PatchList theList, PatchList notDwnlList) throws Exception {
        int theListSize;
        int notDownSize = notDwnlList != null ? notDwnlList.size() : 0;
        int n = theListSize = theList != null ? theList.size() : 0;
        if (notDownSize == 0 && theListSize > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < theListSize; ++i) {
                String tmp = theList.getPatchAt(i).getPatchID().getPatchID();
                sb.append(tmp);
                sb.append(" ");
            }
            provUtil.writeLog(0, "LM_8900", "LM_8901", sb.toString(), this.targetDir, null, null, null);
        }
    }

    private void setupDownload(PatchList pl, String targetDir, boolean extract) throws PatchException {
        String authStr = this.ppp.getProperty(DWNL_AUTH_STR);
        Debug.trace3((String)("authStr: " + authStr));
        if (authStr.equals("true")) {
            Debug.trace3((String)"extracting signed patches");
            if (extract) {
                PProUtil.extractSignedPatches(pl, targetDir);
            }
        } else {
            this.cleanup();
            throw new PatchException("EXM_PP_DOWNLOAD_AUTH");
        }
    }

    private void testDownloadRecommended() throws PatchException {
        System.out.println("------ Download Recommended Patches -------\n");
        this.patchDownloader(true);
        System.out.println("\n------  Download Recommended Patches ------\n");
    }

    private void testDownloadPatchList() throws PatchException {
        System.out.println("------ Download Recommended Patches -------\n");
        Vector<String> vec = new Vector<String>();
        String patchID = "";
        int x = 0;
        while (true) {
            if ((patchID = PProUtil.getKeyBoard(++x + ") " + "Patch IDs list(type 'b' to break): ")).length() == 0) {
                --x;
                continue;
            }
            if (patchID.equals("b")) break;
            vec.addElement(patchID);
        }
        this.patchListVec = vec;
        System.out.println("size: " + this.patchListVec.size());
        this.patchDownloader(true);
        System.out.println("\n------  Download Recommended Patches ------\n");
    }

    protected void test() {
        this.done = false;
        while (!this.done) {
            System.out.println("1 - Download Recomended Patches: ");
            System.out.println("2 - Enter known patches to download: ");
            System.out.println("q - To quit");
            System.out.println("");
            System.out.print("Enter option: ");
            try {
                byte[] buffer = new byte[100];
                char bytes = (char)System.in.read(buffer);
                System.out.println("");
                if (bytes != '\u0002') continue;
                char option = (char)buffer[0];
                switch (option) {
                    case '1': {
                        this.testDownloadRecommended();
                        break;
                    }
                    case '2': {
                        this.testDownloadPatchList();
                        break;
                    }
                    case 'q': {
                        if (this.model != null) {
                            this.model.removeListener((PatchProListener)this);
                        }
                        this.done = true;
                    }
                }
            }
            catch (Exception e) {
                this.cleanup();
                System.out.println("Exception: " + e);
                e.printStackTrace();
            }
            System.out.println("");
        }
    }

    public static void main(String[] args) {
        DownloadPatches ppc = new DownloadPatches(null);
        try {
            ppc.initialize(null, null);
        }
        catch (PatchException pe) {
            System.out.println((Object)pe);
        }
        ppc.test();
    }
}

