/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.StreamReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Vector;

public class OrderPatches {
    static final String PATCH_MANAGER_INVOCATION = "/usr/sbin/smpatch";
    Vector patchIDs = new Vector();
    ProviderUtility provUtil;

    public OrderPatches(ProviderUtility provUtil) {
        this.provUtil = provUtil;
    }

    public void initialize() {
    }

    public int orderPatches(Vector inputList, String spoolDir) throws PatchException {
        Process p;
        Vector<String> v = new Vector<String>();
        v.add(PATCH_MANAGER_INVOCATION);
        v.add("order");
        v.add("-L");
        if (spoolDir != null && spoolDir.length() != 0) {
            v.add("-d");
            v.add(spoolDir);
        }
        for (int i = 0; i < inputList.size(); ++i) {
            v.add("-i");
            v.add((String)inputList.elementAt(i));
        }
        String[] cmd = v.toArray(new String[0]);
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException iox) {
            throw new PatchException("EXM_IO_ERROR", cmd[0]);
        }
        InputStream is = p.getInputStream();
        StringBuffer ib = new StringBuffer("");
        StreamReader stdout = new StreamReader(is, ib);
        stdout.start();
        InputStream es = p.getErrorStream();
        StringBuffer eb = new StringBuffer("");
        StreamReader stderr = new StreamReader(es, eb);
        stderr.start();
        int rv = 1;
        try {
            rv = p.waitFor();
            stderr.join();
            stdout.join();
        }
        catch (InterruptedException iex) {
            throw new PatchException("EXM_ORDER_PATCHES_INTR");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (es != null) {
                    es.close();
                }
            }
            catch (IOException iox) {}
        }
        if (rv != 0) {
            throw new PatchException("EXM_ORDER_PATCHES_EXEC", cmd[0], Integer.toString(rv), eb.toString());
        }
        BufferedReader br = new BufferedReader(new StringReader(ib.toString()));
        try {
            String l;
            while ((l = br.readLine()) != null) {
                this.patchIDs.add(l);
            }
        }
        catch (IOException iox) {
            throw new PatchException("EXM_ORDER_READ");
        }
        return 0;
    }

    public Vector getPatchIDs() {
        return this.patchIDs;
    }
}

