/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.patch.PatchPropertiesConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class PatchPkgInfo {
    private static final String SUNW_PATCH_PROPERTIES = "SUNW_PATCH_PROPERTIES";
    private static final String SUM_REC = "singleuser_recommended";
    private static final String SUM_REQ = "singleuser_required";
    private static final String REB_AFT = "rebootafter";
    private static final String REB_IMM = "rebootimmediate";
    private static final String REC_AFT = "reconfigafter";
    private static final String REC_IMM = "reconfigimmediate";

    public static PatchPropertiesConfig getPatchPropConfig(Vector pkgs, String resource) {
        boolean sumRecommended = false;
        boolean sumRequired = false;
        boolean rebootAfter = false;
        boolean rebootImmediate = false;
        boolean reconfigAfter = false;
        boolean reconfigImmediate = false;
        boolean unrecognizable = false;
        int numPkgs = 0;
        if (pkgs != null) {
            numPkgs = pkgs.size();
        }
        StringBuffer pkgInfo = new StringBuffer(50);
        Vector pkgInfoVec = null;
        for (int i = 0; i < numPkgs; ++i) {
            String patchProp;
            pkgInfo.setLength(0);
            pkgInfo.append(resource);
            pkgInfo.append(File.separatorChar);
            pkgInfo.append((String)pkgs.elementAt(i));
            pkgInfo.append(File.separatorChar);
            pkgInfo.append("pkginfo");
            pkgInfoVec = PatchPkgInfo.contentsOfPkginfoFile(pkgInfo.toString());
            if (pkgInfoVec == null || pkgInfoVec.size() <= 0 || (patchProp = PatchPkgInfo.getInfoValue(pkgInfoVec, SUNW_PATCH_PROPERTIES)) == null || patchProp.length() == 0) continue;
            StringTokenizer parser = new StringTokenizer(patchProp, " ");
            while (parser.hasMoreTokens()) {
                String token = parser.nextToken();
                if (token.equals(SUM_REC)) {
                    sumRecommended = true;
                    continue;
                }
                if (token.equals(SUM_REQ)) {
                    sumRequired = true;
                    continue;
                }
                if (token.equals(REB_AFT)) {
                    rebootAfter = true;
                    continue;
                }
                if (token.equals(REB_IMM)) {
                    rebootImmediate = true;
                    continue;
                }
                if (token.equals(REC_AFT)) {
                    reconfigAfter = true;
                    continue;
                }
                if (token.equals(REC_IMM)) {
                    reconfigImmediate = true;
                    continue;
                }
                unrecognizable = true;
            }
        }
        return new PatchPropertiesConfig(sumRecommended, sumRequired, rebootAfter, rebootImmediate, reconfigAfter, reconfigImmediate, unrecognizable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector contentsOfPkginfoFile(String pkginfoFile) {
        File pkginfoFILE = new File(pkginfoFile);
        Vector<String> returnData = new Vector<String>();
        BufferedReader in = null;
        InputStreamReader fr = null;
        try {
            if (pkginfoFILE.exists() && pkginfoFILE.isFile() && pkginfoFILE.canRead()) {
                fr = new FileReader(pkginfoFILE);
                in = new BufferedReader(fr);
                String line = in.readLine();
                int index = 0;
                while (line != null) {
                    index = line.indexOf("=");
                    if (index != -1) {
                        String attrib = line.substring(0, index);
                        String value = line.substring(index + 1, line.length());
                        attrib = attrib.trim();
                        value = value.trim();
                        returnData.addElement(attrib);
                        returnData.addElement(value);
                    }
                    line = in.readLine();
                }
                in.close();
                fr.close();
                Vector<String> vector = returnData;
                return vector;
            }
            Vector<String> line = returnData;
            return line;
        }
        catch (Exception e) {
            Vector<String> vector = returnData;
            return vector;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static String getInfoValue(Vector patchRemoteInfo, String attrib) {
        try {
            int index = patchRemoteInfo.indexOf(attrib);
            if (index != -1) {
                return (String)patchRemoteInfo.elementAt(index + 1);
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

