/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.PatchPkgInfo;
import com.sun.wbem.solarisprovider.patch.PatchPropertiesConfig;
import com.sun.wbem.solarisprovider.patch.SolarisPatchObj;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisPatchUtil {
    private static final String PKG_BASE_DIR = "/var/sadm/pkg";
    private static final String PKG_SAVE_DIR = "save";
    private static final String PKG_DEF_SAVE_FILE = "undo.Z";
    private static final String PATCH_OBSOLETE_SAVE_FILE = "obsolete.Z";
    private static final String PKG_SAVE_REMOTE = "remote";
    private static final String PATCH_DEF_BACKOUT_DIR = "Default";
    private static final String REMOTE_LOCATION = "FIND_AT";
    private static final String EQUALS = "=";
    public static final String PATH_SEP = "/";
    public static final String PATCH_BASE_DIR = "/var/sadm/patch";
    public static final String README_FILE = "README";
    public static final String DOT = ".";
    private final String[] index = new String[]{"Patch:", "Obsoletes:", "Requires:", "Incompatibles:", "Packages:"};
    private final String indexes = this.index[0] + " " + this.index[1] + " " + this.index[2] + " " + this.index[3] + " " + this.index[4] + " ";
    private ProviderUtility provUtil;

    public SolarisPatchUtil(ProviderUtility provUtil) {
        this.provUtil = provUtil;
    }

    public SolarisPatchObj parseLine(String line) throws PatchException {
        Vector<Object> values = new Vector<Object>();
        Vector<String> val = new Vector<String>();
        SolarisPatchObj patchObj = new SolarisPatchObj();
        try {
            line = line.replace('\n', ' ');
            line = line.replace(',', ' ');
            StringTokenizer parser = new StringTokenizer(line, " ");
            while (parser.hasMoreTokens()) {
                String tmp = parser.nextToken();
                if (tmp.equals("Patch:")) {
                    values.addElement(parser.nextToken());
                    tmp = parser.nextToken();
                }
                if (this.indexes.indexOf(tmp) > 0) {
                    if (!tmp.equals("Obsoletes:")) {
                        values.addElement(val);
                    }
                    val = new Vector();
                    continue;
                }
                val.addElement(tmp);
            }
            values.addElement(val);
            patchObj.setPatchName((String)values.elementAt(0));
            patchObj.setObsoletes((Vector)values.elementAt(1));
            patchObj.setRequires((Vector)values.elementAt(2));
            patchObj.setIncompatibles((Vector)values.elementAt(3));
            Vector pkgs = (Vector)values.elementAt(4);
            patchObj.setPackages(pkgs);
            PatchPropertiesConfig ppc = PatchPkgInfo.getPatchPropConfig(pkgs, PKG_BASE_DIR);
            patchObj.setPatchPropertiesConfig(ppc);
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, "LM_8850", "LM_8852", null, null, null, null, null);
            throw new PatchException("EXM_PATCHDATA_PARSING");
        }
        return patchObj;
    }

    public Vector contentsOfReadmeFile(String patchREADMEFile) throws PatchException {
        Vector<String> patchReadmeInfo = new Vector<String>();
        BufferedReader in = null;
        InputStreamReader fr = null;
        try {
            File readmeFILE = new File(patchREADMEFile);
            if (readmeFILE.exists() && readmeFILE.isFile() && readmeFILE.canRead()) {
                fr = new FileReader(readmeFILE);
                in = new BufferedReader(fr);
                String line = in.readLine();
                int index = 0;
                while (line != null) {
                    index = line.indexOf(":");
                    if (index != -1) {
                        String attrib = line.substring(0, index);
                        String value = line.substring(index + 1, line.length());
                        attrib = attrib.trim();
                        value = value.trim();
                        patchReadmeInfo.addElement(attrib);
                        patchReadmeInfo.addElement(value);
                    }
                    line = in.readLine();
                }
                in.close();
                fr.close();
                Vector<String> vector = patchReadmeInfo;
                return vector;
            }
            Vector vector = null;
            return vector;
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            throw new PatchException("EXM_README_FILE_ERR");
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public Calendar convertDate(String newDate) {
        Calendar cal = Calendar.getInstance();
        cal.set(2000, 1, 1);
        StringTokenizer st = new StringTokenizer(newDate, PATH_SEP);
        String[] date = new String[]{"01", "Jan", "2000"};
        int count = 0;
        try {
            while (st.hasMoreTokens()) {
                String token;
                date[count] = token = st.nextToken();
                ++count;
            }
            if (count == 3) {
                String tmp;
                if (this.convertMonth(date[1]) == -1) {
                    tmp = date[1];
                    date[1] = date[0];
                    date[0] = tmp;
                }
                if (date[2].length() == 2) {
                    date[2] = tmp = "20" + date[2];
                }
                cal.set(Integer.parseInt(date[2]), this.convertMonth(date[1]) + 1, Integer.parseInt(date[0]));
            }
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
        }
        return cal;
    }

    private int convertMonth(String month) {
        if ((month = month.trim()).equalsIgnoreCase("Jan")) {
            return 0;
        }
        if (month.equalsIgnoreCase("Feb")) {
            return 1;
        }
        if (month.equalsIgnoreCase("Mar")) {
            return 2;
        }
        if (month.equalsIgnoreCase("Apr")) {
            return 3;
        }
        if (month.equalsIgnoreCase("May")) {
            return 4;
        }
        if (month.equalsIgnoreCase("Jun")) {
            return 5;
        }
        if (month.equalsIgnoreCase("Jul")) {
            return 6;
        }
        if (month.equalsIgnoreCase("Aug")) {
            return 7;
        }
        if (month.equalsIgnoreCase("Sep")) {
            return 8;
        }
        if (month.equalsIgnoreCase("Oct")) {
            return 9;
        }
        if (month.equalsIgnoreCase("Nov")) {
            return 10;
        }
        if (month.equalsIgnoreCase("Dec")) {
            return 11;
        }
        return -1;
    }

    public Date getPatchInstallDate(String patchName) throws PatchException {
        if (patchName == null || patchName.length() <= 0) {
            return null;
        }
        String patchDir = "/var/sadm/patch/" + patchName;
        File patchDirFILE = new File(patchDir);
        if (!patchDirFILE.exists()) {
            return null;
        }
        long timeInMS = patchDirFILE.lastModified();
        Date newTime = new Date(timeInMS);
        return newTime;
    }

    public String getPatchBackoutDir(String patch, String pkgName) throws PatchException {
        String line;
        StringBuffer patchPkgBaseDir = new StringBuffer(50);
        if (pkgName == null || pkgName.length() <= 0 || patch == null || patch.length() <= 0) {
            return null;
        }
        patchPkgBaseDir.append(PKG_BASE_DIR);
        patchPkgBaseDir.append(PATH_SEP);
        patchPkgBaseDir.append(pkgName);
        patchPkgBaseDir.append(PATH_SEP);
        patchPkgBaseDir.append(PKG_SAVE_DIR);
        patchPkgBaseDir.append(PATH_SEP);
        patchPkgBaseDir.append(patch);
        String baseStr = patchPkgBaseDir.toString();
        File patchPkgBaseDirF = new File(baseStr);
        if (!patchPkgBaseDirF.exists()) {
            return null;
        }
        patchPkgBaseDir.setLength(0);
        patchPkgBaseDir.append(baseStr);
        patchPkgBaseDir.append(PATH_SEP);
        patchPkgBaseDir.append(PKG_DEF_SAVE_FILE);
        patchPkgBaseDirF = new File(patchPkgBaseDir.toString());
        if (patchPkgBaseDirF.exists()) {
            return PATCH_DEF_BACKOUT_DIR;
        }
        patchPkgBaseDir.setLength(0);
        patchPkgBaseDir.append(baseStr);
        patchPkgBaseDir.append(PATH_SEP);
        patchPkgBaseDir.append(PATCH_OBSOLETE_SAVE_FILE);
        patchPkgBaseDirF = new File(patchPkgBaseDir.toString());
        if (patchPkgBaseDirF.exists()) {
            return PATCH_DEF_BACKOUT_DIR;
        }
        patchPkgBaseDir.setLength(0);
        patchPkgBaseDir.append(baseStr);
        patchPkgBaseDir.append(PATH_SEP);
        patchPkgBaseDir.append(PKG_SAVE_REMOTE);
        patchPkgBaseDirF = new File(patchPkgBaseDir.toString());
        BufferedReader in = null;
        InputStreamReader fr = null;
        try {
            if (patchPkgBaseDirF.exists() && patchPkgBaseDirF.isFile() && patchPkgBaseDirF.canRead()) {
                fr = new FileReader(patchPkgBaseDirF);
                in = new BufferedReader(fr);
                line = in.readLine();
                int index = 0;
                while (line != null) {
                    index = line.indexOf(EQUALS);
                    if (index != -1) {
                        String attrib = line.substring(0, index);
                        String value = line.substring(index + 1, line.length());
                        attrib = attrib.trim();
                        value = value.trim();
                        if (attrib != null && attrib.equals(REMOTE_LOCATION)) {
                            String string = this.filterBackOutDir(value, patch);
                            return string;
                        }
                    }
                    line = in.readLine();
                }
                in.close();
                fr.close();
            }
            line = null;
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            throw new PatchException("EXM_BACKOUT_DIR", patch);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception e) {}
            }
        }
        return line;
    }

    public String filterBackOutDir(String backOutDir, String patchName) {
        int index = backOutDir.lastIndexOf(patchName);
        String newString = null;
        newString = index > 0 ? backOutDir.substring(0, index - 1) : backOutDir;
        return newString;
    }

    public Vector execScript(String[] commandArray) throws PatchException {
        ExecProcess process = new ExecProcess(commandArray);
        return process.exec();
    }

    class ExecProcess
    implements Runnable {
        public int returnValue = -1;
        private String[] command = null;
        private Process currentProcess = null;
        private boolean finished = false;

        public ExecProcess(String[] command) {
            this.command = command;
        }

        public void run() {
            if (this.currentProcess != null) {
                try {
                    this.returnValue = this.currentProcess.waitFor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.finished = true;
        }

        /*
         * Loose catch block
         */
        public synchronized Vector exec() throws PatchException {
            Vector<String> stdErr;
            Vector<String> stdOut;
            block50: {
                Exception ie2222;
                BufferedReader ebr;
                BufferedReader ibr;
                InputStreamReader er;
                InputStreamReader ir;
                InputStream es;
                InputStream is;
                block45: {
                    Runtime runtime = null;
                    Process process = null;
                    is = null;
                    es = null;
                    ir = null;
                    er = null;
                    ibr = null;
                    ebr = null;
                    stdOut = null;
                    stdErr = null;
                    runtime = Runtime.getRuntime();
                    process = runtime.exec(this.command);
                    is = process.getInputStream();
                    es = process.getErrorStream();
                    ir = new InputStreamReader(is);
                    er = new InputStreamReader(es);
                    ibr = new BufferedReader(ir);
                    ebr = new BufferedReader(er);
                    StringBuffer stdOutLine = new StringBuffer("");
                    StringBuffer stdErrLine = new StringBuffer("");
                    this.finished = false;
                    this.currentProcess = process;
                    Thread t = new Thread(this);
                    t.start();
                    stdOut = new Vector<String>();
                    stdErr = new Vector<String>();
                    boolean continueFlag = true;
                    int count = 0;
                    do {
                        try {
                            char c;
                            if (ibr.ready()) {
                                while (ibr.ready()) {
                                    c = (char)ibr.read();
                                    if (c == '\n') {
                                        stdOutLine.append(c);
                                        stdOut.addElement(stdOutLine.toString());
                                        stdOutLine.setLength(0);
                                        continue;
                                    }
                                    stdOutLine.append(c);
                                }
                            }
                            if (ebr.ready()) {
                                while (ebr.ready()) {
                                    c = (char)ebr.read();
                                    if (c == '\n') {
                                        stdErrLine.append(c);
                                        stdErr.addElement(stdOutLine.toString());
                                        stdErrLine.setLength(0);
                                        continue;
                                    }
                                    stdErrLine.append(c);
                                }
                            }
                            Thread.currentThread();
                            Thread.sleep(100L);
                            this.returnValue = process.exitValue();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (!this.finished) continue;
                        if (count >= 4) {
                            continueFlag = false;
                            continue;
                        }
                        ++count;
                    } while (continueFlag);
                    Object var20_19 = null;
                    if (is == null) break block45;
                    try {
                        is.close();
                    }
                    catch (Exception ie2222) {
                        // empty catch block
                    }
                }
                if (es != null) {
                    try {
                        es.close();
                    }
                    catch (Exception ie2222) {
                        // empty catch block
                    }
                }
                if (ir != null) {
                    try {
                        ir.close();
                    }
                    catch (Exception ie2222) {
                        // empty catch block
                    }
                }
                if (er != null) {
                    try {
                        er.close();
                    }
                    catch (Exception ie2222) {
                        // empty catch block
                    }
                }
                if (ibr != null) {
                    try {
                        ibr.close();
                    }
                    catch (Exception ie2222) {
                        // empty catch block
                    }
                }
                if (ebr != null) {
                    try {
                        ebr.close();
                    }
                    catch (Exception ie2222) {}
                }
                break block50;
                {
                    catch (Exception e) {
                        throw new PatchException("EXM_PATCHADD_CMD_ERR", this.command.toString());
                    }
                }
                catch (Throwable throwable) {
                    Exception ie2222;
                    Object var20_20 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception ie2222) {
                            // empty catch block
                        }
                    }
                    if (es != null) {
                        try {
                            es.close();
                        }
                        catch (Exception ie2222) {
                            // empty catch block
                        }
                    }
                    if (ir != null) {
                        try {
                            ir.close();
                        }
                        catch (Exception ie2222) {
                            // empty catch block
                        }
                    }
                    if (er != null) {
                        try {
                            er.close();
                        }
                        catch (Exception ie2222) {
                            // empty catch block
                        }
                    }
                    if (ibr != null) {
                        try {
                            ibr.close();
                        }
                        catch (Exception ie2222) {
                            // empty catch block
                        }
                    }
                    if (ebr != null) {
                        try {
                            ebr.close();
                        }
                        catch (Exception ie2222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            Vector<Object> results = new Vector<Object>();
            Object[] array = new String[stdOut.size()];
            if (stdOut.size() != 0) {
                stdOut.copyInto(array);
            }
            results.addElement(array);
            array = new String[stdErr.size()];
            if (stdErr.size() != 0) {
                stdErr.copyInto(array);
            }
            results.addElement(array);
            Integer iExit = new Integer(this.returnValue);
            results.addElement(iExit);
            return results;
        }
    }
}

