/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.AssessNeededPatches;
import com.sun.wbem.solarisprovider.patch.DownloadPatches;
import com.sun.wbem.solarisprovider.patch.InstallPatchesByPolicy;
import com.sun.wbem.solarisprovider.patch.OrderPatches;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.PatchPropertiesConfig;
import com.sun.wbem.solarisprovider.patch.ResolvePatchList;
import com.sun.wbem.solarisprovider.patch.SolarisPatchInfo;
import com.sun.wbem.solarisprovider.patch.SolarisPatchObj;
import com.sun.wbem.solarisprovider.patch.SpooledPatchInfo;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.ParseException;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_Patch
implements InstanceProvider,
MethodProvider,
Authorizable,
EventProvider {
    private InstanceProvider ip;
    private int flag = 0;
    static final String INSTANCEADDITION = "cim_instcreation";
    private static final int INSTANCEADDITIONTYPE = 1;
    static final String INSTANCEDELETION = "cim_instdeletion";
    private static final int INSTANCEDELETIONTYPE = 2;
    static final String INSTANCEMODIFICATION = "cim_instmodification";
    private static final int INSTANCEMODIFICATIONTYPE = 4;
    private static final String NAME = "Name";
    private static final String OBSOLETES = "Obsoletes";
    private static final String REQUIRES = "Requires";
    private static final String INCOMPATIBLES = "Incompatibles";
    private static final String PACKAGES = "Packages";
    private static final String PATCH_DIR_NAME = "PatchDirectoryName";
    private static final String PATCH_BACKOUT_DIR = "BackoutDirectory";
    private static final String DESCRIPTION = "Description";
    private static final String TARGET_OS = "TargetOperatingSystem";
    private static final String INSTALL_DATE = "InstallDate";
    private static final String RELEASE_DATE = "ReleaseDate";
    private static final String ARCH = "Architecture";
    private static final String PATCH_SOLARIS_REL = "PatchSolarisRelease";
    private static final String PATCH_SUNOS_REL = "PatchSunOSRelease";
    private static final String BACK_UP_FILES = "BackUpFiles";
    private static final String SUM_REC = "SingleUserRecommended";
    private static final String SUM_REQ = "SingleUserRequired";
    private static final String REB_AFT = "RebootAfter";
    private static final String REB_IMM = "RebootImmediate";
    private static final String REC_AFT = "ReconfigAfter";
    private static final String REC_IMM = "ReconfigImmediate";
    private static final String NAME_SPACE = "/root/cimv2";
    private static final String ASSESS_NEEDED_PATCHES = "AssessNeededPatches";
    private static final String DOWNLOAD_PATCHES = "DownloadPatches";
    private static final String DOWNLOAD_PATCHES_IN_JAR_FORMAT = "DownloadPatchesInJarFormat";
    private static final String INSTALL_PATCHES = "InstallPatchesByPolicy";
    private static final String SPOOLED_PATCH_INFO = "GetSpooledPatchInfo";
    private static final String SPOOLED_PATCH_README = "GetSpooledPatchReadme";
    private static final String ORDER_PATCHES = "OrderPatches";
    private static final String ANALYZE = "Analyze";
    private static final String RESOLVE = "Resolve";
    private static final String ANALYZE_AND_WRITE_CACHE = "AnalyzeAndWriteCache";
    private static final String READ_CACHE = "ReadCache";
    private static final String PATCHMGR_WRITE_RIGHT = "solaris.admin.patchmgr.write";
    private static final String PATCHMGR_READ_RIGHT = "solaris.admin.patchmgr.read";
    private ProviderCIMOMHandle cimomhandle = null;
    private LogUtil logUtil = null;
    private ProviderUtility provUtil;
    private static final String providerName = "Solaris_Patch";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        try {
            this.cimomhandle = (ProviderCIMOMHandle)cimomhandle;
            this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
            this.provUtil = new ProviderUtility(cimomhandle, providerName);
        }
        catch (CIMException cex) {
            this.provUtil.writeLog(2, (Exception)((Object)cex));
            throw new CIMProviderException("CIM_ERR_FAILED", (Object)cex.getLocalizedMessage());
        }
    }

    public void cleanup() throws CIMException {
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, op);
        try {
            SolarisPatchInfo patchInfo;
            int status;
            SolarisPatchObj patchObj = new SolarisPatchObj();
            CIMProperty cp = ci.getProperty(NAME);
            CIMValue cv = cp.getValue();
            String patchName = "";
            if (cv != null) {
                patchName = (String)cv.getValue();
            }
            if (patchName != null && patchName.trim().length() > 0) {
                patchObj.setPatchName(patchName);
            }
            cp = ci.getProperty(PATCH_DIR_NAME);
            cv = cp.getValue();
            String patchDirName = "";
            if (cv != null) {
                patchDirName = (String)cv.getValue();
            }
            if (patchDirName != null && patchDirName.trim().length() > 0) {
                patchObj.setPatchDirName(patchDirName);
            }
            cp = ci.getProperty(PATCH_BACKOUT_DIR);
            cv = cp.getValue();
            String patchBackOutDir = "";
            if (cv != null) {
                patchBackOutDir = (String)cv.getValue();
            }
            if (patchBackOutDir != null && patchBackOutDir.trim().length() > 0) {
                patchObj.setBackoutDir(patchBackOutDir);
            }
            if ((status = (patchInfo = new SolarisPatchInfo(this.provUtil)).addPatch(patchObj)) == 0 && (this.flag & 1) != 0) {
                CIMInstance indication = new CIMInstance();
                indication.setClassName(INSTANCEADDITION);
                cp = new CIMProperty();
                cp.setName("SourceInstance");
                cp.setValue(new CIMValue((Object)ci));
                Vector<CIMProperty> v = new Vector<CIMProperty>();
                v.addElement(cp);
                indication.setProperties(v);
                this.cimomhandle.deliverEvent(op.getNameSpace(), indication);
            }
        }
        catch (PatchException pe) {
            this.provUtil.writeLog(2, (Exception)((Object)pe));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)pe.getLocalizedMessage());
        }
        return null;
    }

    public synchronized void deleteInstance(CIMObjectPath op) throws CIMException {
        block7: {
            this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, op);
            try {
                CIMProperty cp;
                String pName = null;
                Enumeration e = op.getKeys().elements();
                while (e.hasMoreElements()) {
                    cp = (CIMProperty)e.nextElement();
                    if (!cp.getName().equalsIgnoreCase(NAME)) continue;
                    pName = (String)cp.getValue().getValue();
                }
                if (pName == null) {
                    throw new CIMProviderException("CIM_ERR_INVALID_PARAMETER", (Object)NAME);
                }
                SolarisPatchInfo patchInfo = new SolarisPatchInfo(this.provUtil);
                SolarisPatchObj patchObj = patchInfo.getPatchData(pName);
                if (patchObj != null) {
                    CIMClass cc = this.cimomhandle.getClass(op, false, true, true, null);
                    CIMInstance ci = this.getInstance(op, false, true, true, null, cc);
                    int status = patchInfo.removePatch(patchObj.getPatchName());
                    if (status == 0 && (this.flag & 2) != 0) {
                        CIMInstance indication = new CIMInstance();
                        indication.setClassName(INSTANCEDELETION);
                        cp = new CIMProperty();
                        cp.setName("SourceInstance");
                        cp.setValue(new CIMValue((Object)ci));
                        Vector<CIMProperty> v = new Vector<CIMProperty>();
                        v.addElement(cp);
                        indication.setProperties(v);
                        this.cimomhandle.deliverEvent(op.getNameSpace(), indication);
                    }
                    break block7;
                }
                throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)pName);
            }
            catch (PatchException pe) {
                this.provUtil.writeLog(2, (Exception)((Object)pe));
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)pe.getLocalizedMessage());
            }
            catch (CIMException e) {
                throw e;
            }
        }
    }

    public synchronized CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(PATCHMGR_READ_RIGHT, op);
        try {
            SolarisPatchInfo patchInfo = new SolarisPatchInfo(this.provUtil);
            Vector<CIMObjectPath> allRecs = new Vector<CIMObjectPath>();
            Vector patchList = patchInfo.getPatchListData();
            for (int i = 0; patchList != null && i < patchList.size(); ++i) {
                SolarisPatchObj patchObj = (SolarisPatchObj)patchList.elementAt(i);
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                cop.addKey(NAME, new CIMValue((Object)patchObj.getPatchName()));
                allRecs.addElement(cop);
            }
            CIMObjectPath[] copArray = new CIMObjectPath[allRecs.size()];
            allRecs.toArray(copArray);
            return copArray;
        }
        catch (PatchException pe) {
            this.provUtil.writeLog(2, (Exception)((Object)pe));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)pe.getLocalizedMessage());
        }
    }

    public synchronized CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(PATCHMGR_READ_RIGHT, op);
        try {
            SolarisPatchInfo patchInfo = new SolarisPatchInfo(this.provUtil);
            Vector<CIMInstance> allRecs = new Vector<CIMInstance>();
            Vector patchList = patchInfo.getPatchListData();
            for (int i = 0; patchList != null && i < patchList.size(); ++i) {
                SolarisPatchObj patchObj = (SolarisPatchObj)patchList.elementAt(i);
                if (patchObj == null) continue;
                CIMInstance ci = this.createNewInstance(patchObj, cc);
                if (localOnly) {
                    ci = ci.localElements();
                }
                allRecs.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
            }
            CIMInstance[] ciArray = new CIMInstance[allRecs.size()];
            allRecs.toArray(ciArray);
            return ciArray;
        }
        catch (PatchException pe) {
            this.provUtil.writeLog(2, (Exception)((Object)pe));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)pe.getLocalizedMessage());
        }
    }

    public synchronized CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(PATCHMGR_READ_RIGHT, op);
        try {
            String pName = null;
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase(NAME)) continue;
                pName = (String)cp.getValue().getValue();
            }
            if (pName == null) {
                throw new CIMProviderException("CIM_ERR_INVALID_PARAMETER", (Object)NAME);
            }
            SolarisPatchInfo patchInfo = new SolarisPatchInfo(this.provUtil);
            SolarisPatchObj patchObj = patchInfo.getPatchData(pName);
            if (patchObj != null) {
                CIMInstance ci = this.createNewInstance(patchObj, cc);
                if (localOnly) {
                    ci = ci.localElements();
                }
                return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
            }
            throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)pName);
        }
        catch (PatchException pe) {
            this.provUtil.writeLog(2, (Exception)((Object)pe));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)pe.getLocalizedMessage());
        }
        catch (CIMException cpe) {
            throw cpe;
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        try {
            if (methodName.equalsIgnoreCase(SPOOLED_PATCH_INFO)) {
                this.provUtil.checkRights(PATCHMGR_READ_RIGHT, op);
                String spooledPatchDir = (String)((CIMValue)inParams.elementAt(0)).getValue();
                SpooledPatchInfo spi = new SpooledPatchInfo(this.provUtil);
                Vector data = spooledPatchDir != null ? spi.getSpooledPatchInfo(spooledPatchDir) : new Vector(0);
                CIMValue ov = new CIMValue(data);
                outParams.addElement(ov);
                return new CIMValue((Object)new Integer(0));
            }
            if (methodName.equalsIgnoreCase(SPOOLED_PATCH_README)) {
                this.provUtil.checkRights(PATCHMGR_READ_RIGHT, op);
                String spooledPatchDir = (String)((CIMValue)inParams.elementAt(0)).getValue();
                String spooledPatchId = (String)((CIMValue)inParams.elementAt(1)).getValue();
                SpooledPatchInfo spi = new SpooledPatchInfo(this.provUtil);
                String readme = spooledPatchDir != null && spooledPatchId != null ? spi.getSpooledPatchReadme(spooledPatchDir, spooledPatchId) : new String("");
                CIMValue ov = new CIMValue((Object)readme);
                outParams.addElement(ov);
                return new CIMValue((Object)new Integer(0));
            }
            if (methodName.equalsIgnoreCase(DOWNLOAD_PATCHES)) {
                Vector patchesNotDownloaded;
                Vector requiredPatchList;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, op);
                Vector patchList = (Vector)((CIMValue)inParams.elementAt(0)).getValue();
                String downloadDir = (String)((CIMValue)inParams.elementAt(1)).getValue();
                DownloadPatches dp = new DownloadPatches(this.provUtil);
                try {
                    dp.initialize(patchList, downloadDir);
                    dp.patchDownloader(true);
                    requiredPatchList = dp.getAssessedOrAccumPatchList();
                    patchesNotDownloaded = dp.getPatchesNotDownloadedWithError();
                }
                finally {
                    dp.cleanup();
                }
                CIMValue ov = new CIMValue((Object)requiredPatchList);
                outParams.addElement(ov);
                ov = new CIMValue((Object)patchesNotDownloaded);
                outParams.addElement(ov);
                return new CIMValue((Object)new Integer(0));
            }
            if (methodName.equalsIgnoreCase(DOWNLOAD_PATCHES_IN_JAR_FORMAT)) {
                Vector patchesNotDownloaded;
                Vector requiredPatchList;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, op);
                Vector patchList = (Vector)((CIMValue)inParams.elementAt(0)).getValue();
                String downloadDir = (String)((CIMValue)inParams.elementAt(1)).getValue();
                DownloadPatches dp = new DownloadPatches(this.provUtil);
                try {
                    dp.initialize(patchList, downloadDir);
                    dp.patchDownloader(false);
                    requiredPatchList = dp.getAssessedOrAccumPatchList();
                    patchesNotDownloaded = dp.getPatchesNotDownloadedWithError();
                }
                finally {
                    dp.cleanup();
                }
                CIMValue ov = new CIMValue((Object)requiredPatchList);
                outParams.addElement(ov);
                ov = new CIMValue((Object)patchesNotDownloaded);
                outParams.addElement(ov);
                return new CIMValue((Object)new Integer(0));
            }
            if (methodName.equalsIgnoreCase(INSTALL_PATCHES)) {
                Vector installationStatus;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, op);
                Vector patchList = (Vector)((CIMValue)inParams.elementAt(0)).getValue();
                String spoolDir = (String)((CIMValue)inParams.elementAt(1)).getValue();
                InstallPatchesByPolicy ip = new InstallPatchesByPolicy(this.provUtil, this.logUtil);
                try {
                    ip.initialize(patchList, spoolDir);
                    installationStatus = ip.installPatches();
                }
                finally {
                    ip.cleanup();
                }
                CIMValue ov = new CIMValue((Object)installationStatus);
                outParams.addElement(ov);
                return new CIMValue((Object)new Integer(0));
            }
            if (methodName.equalsIgnoreCase(ASSESS_NEEDED_PATCHES)) {
                Vector synopsis;
                Vector patchList;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, op);
                AssessNeededPatches anp = new AssessNeededPatches(this.provUtil);
                try {
                    anp.initialize();
                    anp.getAssessedPatchesNeeded(AssessNeededPatches.IGNORE_CACHE);
                    patchList = anp.getPatchIds();
                    synopsis = anp.getSynopsis();
                }
                finally {
                    anp.cleanup();
                }
                CIMValue ov = new CIMValue((Object)patchList);
                outParams.addElement(ov);
                ov = new CIMValue((Object)synopsis);
                outParams.addElement(ov);
                return new CIMValue((Object)new Integer(0));
            }
            if (methodName.equalsIgnoreCase(ORDER_PATCHES)) {
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, op);
                Vector inputList = (Vector)((CIMValue)inParams.elementAt(0)).getValue();
                String spoolDir = (String)((CIMValue)inParams.elementAt(1)).getValue();
                OrderPatches ops = new OrderPatches(this.provUtil);
                ops.initialize();
                ops.orderPatches(inputList, spoolDir);
                Vector patchList = ops.getPatchIDs();
                CIMValue ov = new CIMValue((Object)patchList);
                outParams.addElement(ov);
                return new CIMValue((Object)new Integer(0));
            }
            if (methodName.equalsIgnoreCase(ANALYZE)) {
                Vector propertyList;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, op);
                Vector params = (Vector)((CIMValue)inParams.elementAt(0)).getValue();
                AssessNeededPatches anp = new AssessNeededPatches(this.provUtil, params);
                try {
                    anp.initialize();
                    anp.getAssessedPatchesNeeded(AssessNeededPatches.IGNORE_CACHE);
                    propertyList = anp.getProperties();
                }
                finally {
                    anp.cleanup();
                }
                CIMValue ov = new CIMValue((Object)propertyList);
                outParams.addElement(ov);
                return new CIMValue((Object)new Integer(0));
            }
            if (methodName.equalsIgnoreCase(RESOLVE)) {
                Vector propertyList;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, op);
                Vector inputList = (Vector)((CIMValue)inParams.elementAt(1)).getValue();
                ResolvePatchList rpl = new ResolvePatchList(this.provUtil);
                try {
                    rpl.initialize();
                    rpl.resolvePatchList(inputList);
                    propertyList = rpl.getProperties();
                }
                finally {
                    rpl.cleanup();
                }
                CIMValue ov = new CIMValue((Object)propertyList);
                outParams.addElement(ov);
                return new CIMValue((Object)new Integer(0));
            }
            if (methodName.equalsIgnoreCase(ANALYZE_AND_WRITE_CACHE)) {
                Vector propertyList;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, op);
                AssessNeededPatches anp = new AssessNeededPatches(this.provUtil);
                try {
                    anp.initialize();
                    anp.getAssessedPatchesNeeded(AssessNeededPatches.WRITE_CACHE);
                    propertyList = anp.getProperties();
                }
                finally {
                    anp.cleanup();
                }
                CIMValue ov = new CIMValue((Object)propertyList);
                outParams.addElement(ov);
                return new CIMValue((Object)new Integer(0));
            }
            if (methodName.equalsIgnoreCase(READ_CACHE)) {
                long lastModified;
                Vector propertyList;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, op);
                AssessNeededPatches anp = new AssessNeededPatches(this.provUtil);
                try {
                    anp.initialize();
                    anp.getAssessedPatchesNeeded(AssessNeededPatches.READ_CACHE);
                    propertyList = anp.getProperties();
                    lastModified = anp.getCacheLastModified();
                }
                finally {
                    anp.cleanup();
                }
                CIMValue ov = new CIMValue((Object)propertyList);
                outParams.addElement(ov);
                ov = lastModified != 0L ? new CIMValue((Object)new CIMDateTime(new Date(lastModified))) : new CIMValue(null);
                outParams.addElement(ov);
                return new CIMValue((Object)new Integer(0));
            }
            return null;
        }
        catch (PatchException pe) {
            Debug.trace1((String)"Solaris_Patch caught ", (Throwable)((Object)pe));
            this.provUtil.writeLog(2, (Exception)((Object)pe));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)pe.getLocalizedMessage());
        }
        catch (CIMSecurityException csex) {
            this.provUtil.writeLog(2, (Exception)((Object)csex));
            throw csex;
        }
        catch (CIMException e) {
            this.provUtil.writeLog(2, (Exception)((Object)e));
            throw e;
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] ciArray = this.enumerateInstances(op, true, false, false, null, cc);
            for (int i = 0; i < ciArray.length; ++i) {
                if (where != null && !where.apply((CIMElement)ciArray[i])) continue;
                result.addElement(attrs.apply((CIMElement)ciArray[i]));
            }
        }
        catch (CIMException e) {
            this.provUtil.writeLog(2, (Exception)((Object)e));
            throw e;
        }
        catch (ParseException e) {
            this.provUtil.writeLog(2, (Exception)((Object)e));
            throw new CIMException("CIM_ERR_FAILED", (Object)e.getLocalizedMessage());
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }

    private CIMInstance createNewInstance(SolarisPatchObj patchObj, CIMClass cc) {
        CIMInstance ci = cc.newInstance();
        ci.setProperty(NAME, new CIMValue((Object)patchObj.getPatchName()));
        ci.setProperty(OBSOLETES, new CIMValue((Object)patchObj.getObsoletes()));
        ci.setProperty(REQUIRES, new CIMValue((Object)patchObj.getRequires()));
        ci.setProperty(PACKAGES, new CIMValue((Object)patchObj.getPackages()));
        ci.setProperty(INCOMPATIBLES, new CIMValue((Object)patchObj.getIncompatibles()));
        ci.setProperty(PATCH_BACKOUT_DIR, new CIMValue((Object)patchObj.getBackoutDir()));
        ci.setProperty(DESCRIPTION, new CIMValue((Object)patchObj.getDescription()));
        ci.setProperty(TARGET_OS, new CIMValue((Object)new Integer(patchObj.getTargetOS())));
        ci.setProperty(INSTALL_DATE, new CIMValue((Object)patchObj.getInstallDate()));
        if (patchObj.getReleaseDate() != null) {
            ci.setProperty(RELEASE_DATE, new CIMValue((Object)patchObj.getReleaseDate()));
        }
        if (patchObj.getArchitecture() != null) {
            ci.setProperty(ARCH, new CIMValue((Object)patchObj.getArchitecture()));
        }
        ci.setProperty(PATCH_SOLARIS_REL, new CIMValue((Object)patchObj.getSolRelease()));
        ci.setProperty(PATCH_SUNOS_REL, new CIMValue((Object)patchObj.getSunOSRelease()));
        ci.setProperty(BACK_UP_FILES, new CIMValue((Object)new Boolean(patchObj.getBackUpFiles())));
        PatchPropertiesConfig ppc = patchObj.getPatchPropertiesConfig();
        if (ppc != null) {
            ci.setProperty(SUM_REC, new CIMValue((Object)new Boolean(ppc.getSumRecommended())));
            ci.setProperty(SUM_REQ, new CIMValue((Object)new Boolean(ppc.getSumRequired())));
            ci.setProperty(REB_AFT, new CIMValue((Object)new Boolean(ppc.getRebootAfter())));
            ci.setProperty(REB_IMM, new CIMValue((Object)new Boolean(ppc.getRebootImmediate())));
            ci.setProperty(REC_AFT, new CIMValue((Object)new Boolean(ppc.getReconfigAfter())));
            ci.setProperty(REC_IMM, new CIMValue((Object)new Boolean(ppc.getReconfigImmediate())));
        }
        return ci;
    }

    public void authorizeFilter(SelectExp filter, String eventType, CIMObjectPath classPath, String owner) throws CIMException {
    }

    public boolean mustPoll(SelectExp filter, String eventType, CIMObjectPath classPath) throws CIMException {
        return false;
    }

    public void activateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean firstActivation) throws CIMException {
        if (firstActivation) {
            this.activateEvent(eventType);
        }
    }

    public void deActivateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean lastActivation) throws CIMException {
        if (lastActivation) {
            this.deActivateEvent(eventType);
        }
    }

    void activateEvent(String eventType) {
        this.flag |= Solaris_Patch.determineEventType(eventType);
    }

    void deActivateEvent(String eventType) {
        this.flag -= Solaris_Patch.determineEventType(eventType);
    }

    static int determineEventType(String eventTypeString) {
        if (eventTypeString.equals(INSTANCEMODIFICATION)) {
            return 4;
        }
        if (eventTypeString.equals(INSTANCEDELETION)) {
            return 2;
        }
        if (eventTypeString.equals(INSTANCEADDITION)) {
            return 1;
        }
        return -1;
    }
}

