/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PProUtil;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.PatchPkgInfo;
import com.sun.wbem.solarisprovider.patch.PatchPropertiesConfig;
import com.sun.wbem.solarisprovider.patch.SolarisPatchObj;
import com.sun.wbem.solarisprovider.patch.SolarisPatchUtil;
import com.sun.wbem.solarisprovider.patch.SpooledPatchData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class SpooledPatchInfo {
    public static final String PKGINFO = "pkginfo";
    private static final String PKG = "PKG";
    private static final String DIPATCH_FILE = ".diPatch";
    private static final String cpCmd = "/usr/bin/cp";
    private static final String rmCmd = "/usr/bin/rm";
    private static final String rmOption = "-rf";
    private static final String PID_DELIM = "-";
    private static final int MAX_PID_TOKENS = 2;
    private static final int PATCH_BASE_LENGTH = 6;
    private static final int PATCH_REV_LENGTH = 2;
    private static final String TMP = "/var/tmp";
    private static final String TMP_DIR_SUFFIX = ".Solaris_Patch.tmp";
    private static final String JAR_EXT = ".jar";
    private static final String lineSeparator = System.getProperty("line.separator", "\n");
    private ProviderUtility provUtil;

    public SpooledPatchInfo(ProviderUtility provUtil) {
        this.provUtil = provUtil;
    }

    public Vector getSpooledPatchInfo(String spooledPatchDir) throws PatchException {
        SolarisPatchUtil spu;
        String tmpDir;
        block15: {
            Vector<String> vector;
            block16: {
                String[] cmd;
                File patchDirFile = new File(spooledPatchDir);
                Vector<String> data = new Vector<String>();
                String spDir = null;
                tmpDir = null;
                spu = new SolarisPatchUtil(this.provUtil);
                if (!patchDirFile.exists() || !patchDirFile.isDirectory() || !patchDirFile.canRead()) break block15;
                File[] fileList = patchDirFile.listFiles();
                SpooledPatchData spoolPatchData = new SpooledPatchData();
                Vector readmeInfo = new Vector();
                Vector pkgs = new Vector();
                StringBuffer chkp = new StringBuffer(50);
                StringBuffer diPatch = new StringBuffer(50);
                for (int i = 0; i < fileList.length; ++i) {
                    String patchName;
                    spDir = spooledPatchDir;
                    tmpDir = null;
                    if (!fileList[i].isDirectory() && (!fileList[i].isFile() || !fileList[i].getName().endsWith(JAR_EXT))) continue;
                    if (fileList[i].isFile()) {
                        int index;
                        String fileName = fileList[i].getName();
                        String pid = fileName.substring(0, index = fileName.lastIndexOf(JAR_EXT));
                        File pidFile = new File(spDir, pid);
                        if (pidFile.exists()) continue;
                        tmpDir = TMP + File.separator + fileList[i].getName() + TMP_DIR_SUFFIX;
                        File tmpDirFile = new File(tmpDir);
                        if (!tmpDirFile.exists() && !tmpDirFile.mkdir()) {
                            throw new PatchException("EXM_TMP_DIR_CREATE", tmpDir, pid);
                        }
                        PProUtil.extractPatchInfoFiles(spDir, tmpDir, pid);
                        patchName = pid;
                        spDir = tmpDir;
                    } else {
                        patchName = fileList[i].getName();
                    }
                    diPatch.setLength(0);
                    diPatch.append(spDir);
                    diPatch.append("/");
                    diPatch.append(patchName);
                    diPatch.append("/");
                    diPatch.append(DIPATCH_FILE);
                    File diPatchFile = new File(diPatch.toString());
                    if (!diPatchFile.exists()) continue;
                    chkp.setLength(0);
                    chkp.append(spDir);
                    chkp.append("/");
                    chkp.append(patchName);
                    chkp.append("/");
                    chkp.append("README");
                    chkp.append(".");
                    chkp.append(patchName);
                    File verify = new File(chkp.toString());
                    if (verify.exists() && verify.canRead() && verify.length() > 0L) {
                        readmeInfo = spu.contentsOfReadmeFile(chkp.toString());
                        spoolPatchData.setPatchId(patchName);
                        String arch = PatchPkgInfo.getInfoValue(readmeInfo, "Relevant Architectures");
                        spoolPatchData.setArchitecture(arch);
                        String sunOsRel = PatchPkgInfo.getInfoValue(readmeInfo, "SunOS Release");
                        if (sunOsRel.equals("")) {
                            sunOsRel = PatchPkgInfo.getInfoValue(readmeInfo, "SunOS release");
                            spoolPatchData.setSunOsRelease(sunOsRel);
                        } else {
                            spoolPatchData.setSunOsRelease(sunOsRel);
                        }
                        String req = PatchPkgInfo.getInfoValue(readmeInfo, "Patches required with this patch");
                        req = this.patchIdFilter(req);
                        spoolPatchData.setRequires(req);
                        String conf = PatchPkgInfo.getInfoValue(readmeInfo, "Patches which conflict with this patch");
                        conf = this.patchIdFilter(conf);
                        spoolPatchData.setConflicting(conf);
                        String obso = PatchPkgInfo.getInfoValue(readmeInfo, "Patches accumulated and obsoleted by this patch");
                        obso = this.patchIdFilter(obso);
                        spoolPatchData.setObsoletes(obso);
                        pkgs = this.getPackagesToBePatched(spDir, patchName);
                        String pkgStr = new String();
                        for (int ii = 0; ii < pkgs.size(); ++ii) {
                            pkgStr = pkgStr + (String)pkgs.elementAt(ii) + " ";
                        }
                        pkgStr = pkgStr.trim();
                        spoolPatchData.setPackages(pkgStr);
                        PatchPropertiesConfig ppc = PatchPkgInfo.getPatchPropConfig(pkgs, spDir + File.separatorChar + patchName);
                        spoolPatchData.setPatchPropertiesConfig(ppc);
                        data.addElement(spoolPatchData.formatString());
                    }
                    if (tmpDir == null) continue;
                    cmd = new String[]{rmCmd, rmOption, tmpDir};
                    spu.execScript(cmd);
                    tmpDir = null;
                }
                vector = data;
                if (tmpDir == null) break block16;
                cmd = new String[]{rmCmd, rmOption, tmpDir};
                spu.execScript(cmd);
            }
            return vector;
        }
        try {
            try {
                this.provUtil.writeLog(2, "LM_8820", "LM_8824", spooledPatchDir, null, null, null, null);
                throw new PatchException("EXM_SPOOL_PATCH_DIR_ACCESS", spooledPatchDir);
            }
            catch (PatchException pe) {
                throw pe;
            }
            catch (Exception e) {
                this.provUtil.writeLog(2, e);
                throw new PatchException("EXM_SPOOL_PATCH_DIR_ERR", spooledPatchDir);
            }
        }
        catch (Throwable throwable) {
            if (tmpDir != null) {
                String[] cmd = new String[]{rmCmd, rmOption, tmpDir};
                spu.execScript(cmd);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSpooledPatchReadme(String spooledPatchDir, String spooledPatchId) throws PatchException {
        String readmePath;
        InputStreamReader fr;
        BufferedReader in;
        boolean isSignedPatch;
        block22: {
            isSignedPatch = false;
            in = null;
            fr = null;
            File patchFile = new File(spooledPatchDir, spooledPatchId);
            if (!patchFile.exists()) {
                patchFile = new File(spooledPatchDir, spooledPatchId + JAR_EXT);
                if (patchFile.exists() && patchFile.isFile()) {
                    this.extractReadMe(spooledPatchDir, spooledPatchId);
                    readmePath = "/var/tmp/README." + spooledPatchId;
                    isSignedPatch = true;
                    break block22;
                } else {
                    this.provUtil.writeLog(2, "LM_8820", "LM_8825", spooledPatchDir + "/" + spooledPatchId + "/" + "README" + "." + spooledPatchId, null, null, null, null);
                    throw new PatchException("EXM_SPOOL_PATCH_README_ACCESS", spooledPatchId);
                }
            }
            readmePath = spooledPatchDir + "/" + spooledPatchId + "/" + "README" + "." + spooledPatchId;
        }
        try {
            File readmeFile = new File(readmePath);
            if (readmeFile.exists() && readmeFile.canRead()) {
                fr = new FileReader(readmeFile);
                in = new BufferedReader(fr);
                String line = in.readLine();
                StringBuffer newString = new StringBuffer();
                while (line != null) {
                    newString.append(line).append(lineSeparator);
                    line = in.readLine();
                }
                if (isSignedPatch) {
                    readmeFile.delete();
                }
                String string = newString.toString();
                return string;
            }
            this.provUtil.writeLog(2, "LM_8820", "LM_8825", readmePath, null, null, null, null);
            throw new PatchException("EXM_SPOOL_PATCH_README_ACCESS", readmePath);
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            throw new PatchException("EXM_SPOOL_PATCH_README_ERR");
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void extractReadMe(String spooledPatchDir, String patchID) throws PatchException {
        InputStreamReader ir = null;
        OutputStreamWriter or = null;
        try {
            int i;
            JarFile jf = new JarFile(spooledPatchDir + File.separator + patchID + JAR_EXT);
            ZipEntry ze = jf.getEntry(patchID + File.separator + "README" + "." + patchID);
            ir = new InputStreamReader(jf.getInputStream(ze));
            or = new OutputStreamWriter(new FileOutputStream(TMP + File.separator + "README" + "." + patchID));
            while ((i = ir.read()) != -1) {
                or.write(i);
            }
        }
        catch (IOException e) {
            throw new PatchException("EXM_SPOOL_PATCH_README_EXTRACT", patchID);
        }
        finally {
            try {
                if (ir != null) {
                    ir.close();
                }
                if (or != null) {
                    or.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private Vector getPackagesToBePatched(String spooledPatchDir, String spooledPatchId) throws PatchException {
        Vector<String> packageList = new Vector<String>();
        try {
            String patchIdDir = spooledPatchDir + "/" + spooledPatchId;
            Hashtable<String, String> pkgMap = new Hashtable<String, String>();
            File spooledPatchDirFile = new File(patchIdDir);
            if (spooledPatchDirFile.exists() && spooledPatchDirFile.isDirectory() && spooledPatchDirFile.canRead()) {
                File[] fileList = spooledPatchDirFile.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    String pkgName;
                    boolean pkgBol;
                    if (!fileList[i].isDirectory()) continue;
                    String packageDir = fileList[i].getName();
                    String pkgInfo = patchIdDir + "/" + packageDir + "/" + PKGINFO;
                    File verify = new File(pkgInfo);
                    if (!verify.exists() || (pkgBol = pkgMap.containsKey(pkgName = this.getPackageName(pkgInfo)))) continue;
                    pkgMap.put(pkgName, pkgName);
                }
                Enumeration e = pkgMap.elements();
                while (e.hasMoreElements()) {
                    packageList.addElement((String)e.nextElement());
                }
                return packageList;
            }
            this.provUtil.writeLog(2, "LM_8820", "LM_8824", spooledPatchDir, null, null, null, null);
            throw new PatchException("EXM_SPOOL_PATCH_DIR_ACCESS", spooledPatchDir);
        }
        catch (PatchException pe) {
            throw pe;
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            throw new PatchException("EXM_SPOOL_PKGINFO_ERR");
        }
    }

    private String getPackageName(String pkgInfo) {
        Vector pkgInfoVec = PatchPkgInfo.contentsOfPkginfoFile(pkgInfo);
        String pkgName = PatchPkgInfo.getInfoValue(pkgInfoVec, PKG);
        return pkgName;
    }

    private String patchIdFilter(String inStr) {
        StringTokenizer st = new StringTokenizer(inStr);
        StringBuffer outStr = new StringBuffer(50);
        while (st.hasMoreTokens()) {
            String tmpStr = st.nextToken();
            if (!SpooledPatchInfo.isValidPatchID(tmpStr)) continue;
            outStr.append(tmpStr);
            outStr.append(' ');
        }
        return outStr.toString().trim();
    }

    private static boolean isValidPatchID(String patchID) {
        StringTokenizer st = new StringTokenizer(patchID, PID_DELIM);
        int numTokens = st.countTokens();
        if (numTokens != 2) {
            return false;
        }
        try {
            String tmp = st.nextToken();
            if (tmp.length() != 6) {
                return false;
            }
            Integer.parseInt(tmp);
            tmp = st.nextToken();
            if (tmp.length() != 2) {
                return false;
            }
            Integer.parseInt(tmp);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    boolean isReconfigNeeded(SolarisPatchObj patchObj) throws PatchException {
        String patchID = patchObj.getPatchName();
        String patchDirName = patchObj.getPatchDirName();
        Vector pkgs = this.getPackagesToBePatched(patchDirName, patchID);
        PatchPropertiesConfig ppc = PatchPkgInfo.getPatchPropConfig(pkgs, patchDirName + File.separator + patchID);
        return ppc.getReconfigAfter() || ppc.getReconfigImmediate();
    }
}

