/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.printer;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.printer.PrtBuff;
import com.sun.wbem.solarisprovider.printer.Solaris_PrtNative;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_OwningPrintQueue
implements InstanceProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private String prtList = null;
    private String pos = null;
    private String Q_name = null;
    private String prt_buff = null;
    LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "Solaris_OwningPrintQueue";
    PrtBuff prtbuff = new PrtBuff();
    public static final String PRINTER_MODIFY_RIGHT = "solaris.admin.printer.modify";
    public static final String PRINTER_DELETE_RIGHT = "solaris.admin.printer.delete";
    public static final String PRINTER_READ_RIGHT = "solaris.admin.printer.read";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.prov_util.checkRights(PRINTER_MODIFY_RIGHT, op);
        try {
            String[] msg = new String[]{"createInstance for OwningPrintQueue"};
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9406", "LM_9407", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)"Create Printer Queue Failed.");
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)e);
        }
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        this.prov_util.checkRights(PRINTER_DELETE_RIGHT, op);
        try {
            String[] msg = new String[]{"deleteInstance for OwningPrintQueue"};
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9410", "LM_9411", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)"Delete Queue Failed");
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)e);
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.prov_util.checkRights(PRINTER_MODIFY_RIGHT, op);
        try {
            String[] msg = new String[]{"set Instance for Owning PrintQueue"};
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9420", "LM_9420", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)"Set Instance Failed");
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        CIMObjectPath prt_queue = null;
        CIMObjectPath prt_job = null;
        String[] msg = new String[]{"getInstance for OwningPrintQueue"};
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (cp.getName().equalsIgnoreCase("Antecedent")) {
                    prt_queue = (CIMObjectPath)cp.getValue().getValue();
                }
                if (!cp.getName().equalsIgnoreCase("Dependent")) continue;
                prt_job = (CIMObjectPath)cp.getValue().getValue();
            }
            this.prt_buff = prt_job.toString();
            this.pos = Solaris_OwningPrintQueue.parseJob_OBJ(this.prt_buff, "QueuePosition=");
            CIMInstance ci = cc.newInstance();
            ci.setProperty("Antecedent", new CIMValue((Object)prt_queue));
            ci.setProperty("Dependent", new CIMValue((Object)prt_job));
            ci.setProperty("QueuePosition", new CIMValue((Object)new UnsignedInt32((long)Integer.parseInt(this.pos))));
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9425", "LM_9425", msg, "Success", false, 0, 0);
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9427", "LM_9428", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> printSvcQ = new Vector<CIMInstance>();
        String[] msg = new String[]{"Enumeriating Print queue owners"};
        try {
            this.prtbuff.createPrtFile();
            this.prtbuff.createJobFile();
            int num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                CIMInstance ci = cc.newInstance();
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                CIMObjectPath prt_job = new CIMObjectPath("Solaris_PrintJob");
                CIMObjectPath prt_queue = new CIMObjectPath("Solaris_PrintQueue");
                CIMObjectPath prt_queue_cop = new CIMObjectPath(prt_queue.getObjectName(), prt_queue.getNameSpace());
                CIMObjectPath p_job_cop = new CIMObjectPath(prt_job.getObjectName(), prt_job.getNameSpace());
                this.prtList = this.prtbuff.getJob("ID", lines);
                int idx = this.prtList.indexOf(45, 0);
                this.Q_name = this.prtList.substring(0, idx);
                this.pos = Solaris_PrtNative.getPos(this.Q_name, this.prtList);
                if (this.pos.equalsIgnoreCase("no jobs")) continue;
                p_job_cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    p_job_cop.addKey("JobID", new CIMValue((Object)this.prtList));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                try {
                    p_job_cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                p_job_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_PrintJob"));
                prt_queue_cop.addKey("QueueName", new CIMValue((Object)this.Q_name));
                ci.setProperty("Antecedent", new CIMValue((Object)prt_queue_cop));
                ci.setProperty("Dependent", new CIMValue((Object)p_job_cop));
                if (localOnly) {
                    ci = ci.localElements();
                }
                printSvcQ.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
            }
            CIMInstance[] ciArray = new CIMInstance[printSvcQ.size()];
            printSvcQ.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9427", "LM_9428", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"Enumerating Print Queue Owners"};
        Vector<CIMObjectPath> printSvcQ = new Vector<CIMObjectPath>();
        try {
            this.prtbuff.createPrtFile();
            this.prtbuff.createJobFile();
            int num_lines = this.prtbuff.getNumJobs();
            for (int lines = 0; lines < num_lines; ++lines) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                CIMObjectPath p_job = new CIMObjectPath("Solaris_PrintJob");
                CIMObjectPath prt_queue = new CIMObjectPath("Solaris_PrintQueue");
                CIMObjectPath p_job_cop = new CIMObjectPath(p_job.getObjectName(), p_job.getNameSpace());
                CIMObjectPath prt_queue_cop = new CIMObjectPath(prt_queue.getObjectName(), prt_queue.getNameSpace());
                CIMInstance ci = cc.newInstance();
                this.prtList = this.prtbuff.getJob("ID", lines);
                int idx = this.prtList.indexOf(45, 0);
                this.Q_name = this.prtList.substring(0, idx);
                this.pos = Solaris_PrtNative.getPos(this.Q_name, this.prtList);
                if (this.pos.equalsIgnoreCase("no jobs")) continue;
                p_job_cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                p_job_cop.addKey("QueuePosition", new CIMValue((Object)new UnsignedInt32((long)Integer.parseInt(this.pos))));
                try {
                    p_job_cop.addKey("JobID", new CIMValue((Object)this.prtList));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                try {
                    p_job_cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                p_job_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_PrintJob"));
                prt_queue_cop.addKey("QueueName", new CIMValue((Object)this.Q_name));
                cop.addKey("Antecedent", new CIMValue((Object)prt_queue_cop));
                cop.addKey("Dependent", new CIMValue((Object)p_job_cop));
                cop.addKey("QueuePosition", new CIMValue((Object)new UnsignedInt32((long)Integer.parseInt(this.pos))));
                printSvcQ.addElement(cop);
            }
            CIMObjectPath[] copArray = new CIMObjectPath[printSvcQ.size()];
            printSvcQ.toArray(copArray);
            return copArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9427", "LM_9428", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) {
        return null;
    }

    public static String parseJob_OBJ(String prtBuff, String value) {
        int Q_idx = prtBuff.indexOf(value, 0);
        int len = value.length();
        String pos = "";
        pos = prtBuff.substring(Q_idx + len, Q_idx + len + 6);
        Q_idx = pos.indexOf(":");
        pos = pos.substring(0, Q_idx);
        return pos;
    }
}

