/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.printer;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.printer.PrtBuff;
import com.sun.wbem.solarisprovider.printer.Solaris_PrtNative;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_PrintJob
implements InstanceProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private String prtList = null;
    private String owner = null;
    private String size = null;
    private String start = null;
    private String origination = null;
    private String Q_name = null;
    LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "Solaris_PrintJob";
    PrtBuff prtbuff = new PrtBuff();
    public static final String PRINTER_MODIFY_RIGHT = "solaris.admin.printer.modify";
    public static final String PRINTER_DELETE_RIGHT = "solaris.admin.printer.delete";
    public static final String PRINTER_READ_RIGHT = "solaris.admin.printer.read";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"getInstance for PrintJob"};
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (cp.getName().equalsIgnoreCase("JobID")) {
                    this.prtList = (String)cp.getValue().getValue();
                }
                if (!cp.getName().equalsIgnoreCase("QueueName")) continue;
                this.Q_name = (String)cp.getValue().getValue();
            }
            this.size = Solaris_PrtNative.getQ("size", this.prtList);
            this.owner = Solaris_PrtNative.getQ("owner", this.prtList);
            this.origination = Solaris_PrtNative.getQ("origination", this.prtList);
            CIMInstance ci = cc.newInstance();
            ci.setProperty("JobSize", new CIMValue((Object)new UnsignedInt32((long)Integer.parseInt(this.size))));
            ci.setProperty("JobOrigination", new CIMValue((Object)this.origination));
            ci.setProperty("Owner", new CIMValue((Object)this.owner));
            ci.setProperty("QueueName", new CIMValue((Object)this.Q_name));
            ci.setProperty("JobID", new CIMValue((Object)this.prtList));
            String stat = Solaris_PrtNative.getPrtStat(this.Q_name, "Description");
            if (stat == null) {
                stat = "2";
            }
            ci.setProperty("PrintJobStatus", new CIMValue((Object)new UnsignedInt16(stat)));
            ci.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.Q_name, "Description")));
            ci.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.Q_name, "Status")));
            ci.setProperty("JobStatus", new CIMValue((Object)Solaris_PrtNative.getInfo(this.Q_name, "Status")));
            ci.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.Q_name, "Caption")));
            ci.setProperty("Name", new CIMValue((Object)this.prtList));
            ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            ci.setProperty("QueueCreationClassName", new CIMValue((Object)"Solaris_PrintJob"));
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9429", "LM_9430", msg, "Success", false, 0, 0);
            return ci;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9431", "LM_9432", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"Enumerating Print Jobs"};
        try {
            Vector<CIMInstance> printInstances = new Vector<CIMInstance>();
            this.prtbuff.createJobFile();
            int num_lines = this.prtbuff.getNumJobs();
            for (int lines = 0; lines < num_lines; ++lines) {
                if (num_lines == 0) continue;
                CIMInstance ci = cc.newInstance();
                this.prtList = this.prtbuff.getJob("ID", lines);
                int idx = this.prtList.indexOf(45, 0);
                this.Q_name = this.prtList.substring(0, idx);
                this.size = Solaris_PrtNative.getQ("size", this.prtList);
                this.owner = Solaris_PrtNative.getQ("owner", this.prtList);
                this.origination = Solaris_PrtNative.getQ("origination", this.prtList);
                ci.setProperty("JobSize", new CIMValue((Object)new UnsignedInt32((long)Integer.parseInt(this.size))));
                ci.setProperty("JobOrigination", new CIMValue((Object)this.origination));
                ci.setProperty("Owner", new CIMValue((Object)this.owner));
                ci.setProperty("QueueName", new CIMValue((Object)this.Q_name));
                ci.setProperty("JobID", new CIMValue((Object)this.prtList));
                String stat = Solaris_PrtNative.getPrtStat(this.Q_name, "Description");
                if (stat == null) {
                    stat = "2";
                }
                ci.setProperty("PrintJobStatus", new CIMValue((Object)new UnsignedInt16(stat)));
                ci.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.Q_name, "Description")));
                ci.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.Q_name, "Status")));
                ci.setProperty("JobStatus", new CIMValue((Object)Solaris_PrtNative.getInfo(this.Q_name, "Status")));
                ci.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.Q_name, "Caption")));
                ci.setProperty("Name", new CIMValue((Object)this.prtList));
                ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                ci.setProperty("QueueCreationClassName", new CIMValue((Object)"Solaris_PrintJob"));
                if (localOnly) {
                    ci = ci.localElements();
                }
                printInstances.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
            }
            CIMInstance[] ciArray = new CIMInstance[printInstances.size()];
            printInstances.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9431", "LM_9432", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"Enumerating Print Jobs"};
        try {
            Vector<CIMObjectPath> printInstances = new Vector<CIMObjectPath>();
            this.prtbuff.createJobFile();
            int num_lines = this.prtbuff.getNumJobs();
            for (int lines = 0; lines < num_lines; ++lines) {
                if (num_lines == 0) continue;
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                try {
                    this.prtList = this.prtbuff.getJob("ID", lines);
                    int idx = this.prtList.indexOf(45, 0);
                    this.Q_name = this.prtList.substring(0, idx);
                    cop.addKey("JobID", new CIMValue((Object)this.prtList));
                    cop.addKey("QueueName", new CIMValue((Object)this.Q_name));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                cop.addKey("QueueCreationClassName", new CIMValue((Object)"Solaris_PrintJob"));
                printInstances.addElement(cop);
            }
            CIMObjectPath[] copArray = new CIMObjectPath[printInstances.size()];
            printInstances.toArray(copArray);
            return copArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9431", "LM_9432", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    private int convertMonth(String month) {
        if ((month = month.trim()).equalsIgnoreCase("Jan")) {
            return 0;
        }
        if (month.equalsIgnoreCase("Feb")) {
            return 1;
        }
        if (month.equalsIgnoreCase("Mar")) {
            return 2;
        }
        if (month.equalsIgnoreCase("Apr")) {
            return 3;
        }
        if (month.equalsIgnoreCase("May")) {
            return 4;
        }
        if (month.equalsIgnoreCase("Jun")) {
            return 5;
        }
        if (month.equalsIgnoreCase("Jul")) {
            return 6;
        }
        if (month.equalsIgnoreCase("Aug")) {
            return 7;
        }
        if (month.equalsIgnoreCase("Sep")) {
            return 8;
        }
        if (month.equalsIgnoreCase("Oct")) {
            return 9;
        }
        if (month.equalsIgnoreCase("Nov")) {
            return 10;
        }
        if (month.equalsIgnoreCase("Dec")) {
            return 11;
        }
        return 1;
    }

    private Calendar convertDate(String startDate) {
        Calendar cal = Calendar.getInstance();
        StringTokenizer st = new StringTokenizer(startDate, " ");
        String[] date = new String[]{"Jan", "01", "00", "00"};
        int count = 0;
        int current_yr = cal.get(1);
        try {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (count < 1) {
                    date[count] = token;
                    ++count;
                    continue;
                }
                StringTokenizer stc = new StringTokenizer(token, ":");
                while (stc.hasMoreTokens()) {
                    date[count] = stc.nextToken();
                    ++count;
                }
            }
            if (count == 4) {
                cal.set(current_yr, this.convertMonth(date[0]), Integer.parseInt(date[1]), Integer.parseInt(date[3]), Integer.parseInt(date[4]));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return cal;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) {
        return null;
    }
}

