/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.printer;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.printer.PrtBuff;
import com.sun.wbem.solarisprovider.printer.Solaris_PrtNative;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_PrintQueue
implements InstanceProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private String prtList = null;
    private String dummy = null;
    LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "Solaris_PrintQueue";
    PrtBuff prtbuff = new PrtBuff();
    public static final String PRINTER_MODIFY_RIGHT = "solaris.admin.printer.modify";
    public static final String PRINTER_DELETE_RIGHT = "solaris.admin.printer.delete";
    public static final String PRINTER_READ_RIGHT = "solaris.admin.printer.read";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cop, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cop) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"getInstance for PrintQueue"};
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase("Name")) continue;
                this.prtList = (String)cp.getValue().getValue();
            }
            CIMInstance ci = cc.newInstance();
            ci.setProperty("Name", new CIMValue((Object)this.prtList));
            ci.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Description")));
            ci.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Status")));
            ci.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Caption")));
            boolean Q = false;
            Q = Solaris_PrintQueue.Q_Info(this.prtList, "Status");
            ci.setProperty("QueueEnabled", new CIMValue((Object)new Boolean(Q)));
            Q = Solaris_PrintQueue.Q_Info(this.prtList, "Description");
            ci.setProperty("QueueAccepting", new CIMValue((Object)new Boolean(Q)));
            ci.setProperty("NumberOnQueue", new CIMValue((Object)new UnsignedInt32("2")));
            ci.setProperty("QueueStatus", new CIMValue((Object)new UnsignedInt16("2")));
            ci.setProperty("QueueStatusInfo", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Status")));
            ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception ex) {
                // empty catch block
            }
            ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_PrintQueue"));
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9421", "LM_9422", msg, "Success", false, 0, 0);
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_943", "LM_9424", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"enumerating Instances for PrintQueue"};
        try {
            Vector<CIMInstance> printInstances = new Vector<CIMInstance>();
            this.prtbuff.createPrtFile();
            int num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                this.prtList = this.prtbuff.getPrinter(lines);
                CIMInstance ci = cc.newInstance();
                ci.setProperty("Name", new CIMValue((Object)this.prtList));
                ci.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Description")));
                ci.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Status")));
                ci.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Caption")));
                boolean Q = false;
                Q = Solaris_PrintQueue.Q_Info(this.prtList, "Status");
                ci.setProperty("QueueEnabled", new CIMValue((Object)new Boolean(Q)));
                Q = Solaris_PrintQueue.Q_Info(this.prtList, "Description");
                ci.setProperty("QueueAccepting", new CIMValue((Object)new Boolean(Q)));
                ci.setProperty("NumberOnQueue", new CIMValue((Object)new UnsignedInt32("2")));
                ci.setProperty("QueueStatus", new CIMValue((Object)new UnsignedInt16("2")));
                ci.setProperty("QueueStatusInfo", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Status")));
                ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_PrintQueue"));
                if (localOnly) {
                    ci = ci.localElements();
                }
                printInstances.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
            }
            CIMInstance[] ciArray = new CIMInstance[printInstances.size()];
            printInstances.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9427", "LM_9428", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> printInstances = new Vector<CIMObjectPath>();
        String[] msg = new String[]{"Enumerate Instances for PrintQueue"};
        try {
            this.prtbuff.createPrtFile();
            int num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                try {
                    this.prtList = this.prtbuff.getPrinter(lines);
                    cop.addKey("Name", new CIMValue((Object)this.prtList));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_PrintQueue"));
                printInstances.addElement(cop);
            }
            CIMObjectPath[] copArray = new CIMObjectPath[printInstances.size()];
            printInstances.toArray(copArray);
            return copArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9427", "LM_9428", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public static boolean Q_Info(String Q_name, String Option) {
        String buff = null;
        buff = Solaris_PrtNative.getInfo(Q_name, Option);
        if (Option.equalsIgnoreCase("Status")) {
            return buff.indexOf("enabled", 0) > 0;
        }
        if (Option.equalsIgnoreCase("Description")) {
            return buff.indexOf("accepting", 0) > 0;
        }
        return false;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) {
        return null;
    }
}

