/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.printer;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.printer.PrtBuff;
import com.sun.wbem.solarisprovider.printer.Solaris_PrtNative;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_PrintService
implements InstanceProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    public String prtName = null;
    LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "Solaris_PrintService";
    PrtBuff prtbuff = new PrtBuff();
    public static final String PRINTER_MODIFY_RIGHT = "solaris.admin.printer.modify";
    public static final String PRINTER_DELETE_RIGHT = "solaris.admin.printer.delete";
    public static final String PRINTER_READ_RIGHT = "solaris.admin.printer.read";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"getInstace for Print Service"};
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase("Name")) continue;
                this.prtName = (String)cp.getValue().getValue();
            }
            CIMInstance ci = cc.newInstance();
            ci.setProperty("Name", new CIMValue((Object)this.prtName));
            ci.setProperty("Started", new CIMValue((Object)new Boolean("true")));
            ci.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtName, "Description")));
            ci.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtName, "Status")));
            ci.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtName, "Caption")));
            ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception ex) {
                // empty catch block
            }
            ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_PrintService"));
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9437", "LM_9438", msg, "Success", false, 0, 0);
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9439", "LM_9440", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"enumerting instances for PrintService"};
        try {
            int num_lines = 0;
            Vector<CIMInstance> jobInstances = new Vector<CIMInstance>();
            this.prtbuff.createPrtFile();
            num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                this.prtName = this.prtbuff.getPrinter(lines);
                CIMInstance ci = cc.newInstance();
                ci.setProperty("Name", new CIMValue((Object)this.prtName));
                ci.setProperty("Started", new CIMValue((Object)new Boolean("true")));
                ci.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtName, "Description")));
                ci.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtName, "Status")));
                ci.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtName, "Caption")));
                ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_PrintService"));
                if (localOnly) {
                    ci = ci.localElements();
                }
                jobInstances.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
            }
            CIMInstance[] ciArray = new CIMInstance[jobInstances.size()];
            jobInstances.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9439", "LM_9440", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"enumerating instances for PrintService"};
        try {
            int num_lines = 0;
            Vector<CIMObjectPath> jobInstances = new Vector<CIMObjectPath>();
            this.prtbuff.createPrtFile();
            num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                try {
                    this.prtName = this.prtbuff.getPrinter(lines);
                    cop.addKey("Name", new CIMValue((Object)this.prtName));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_PrintService"));
                jobInstances.addElement(cop);
            }
            CIMObjectPath[] copArray = new CIMObjectPath[jobInstances.size()];
            jobInstances.toArray(copArray);
            return copArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9439", "LM_9440", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) {
        return null;
    }
}

