/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.printer;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.printer.PrtBuff;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_PrinterServicingQueue
implements InstanceProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private String prtList = null;
    private String dummy = null;
    LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "Solaris_PrinterServicingQueue";
    PrtBuff prtbuff = new PrtBuff();
    public static final String PRINTER_MODIFY_RIGHT = "solaris.admin.printer.modify";
    public static final String PRINTER_DELETE_RIGHT = "solaris.admin.printer.delete";
    public static final String PRINTER_READ_RIGHT = "solaris.admin.printer.read";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        CIMObjectPath printer = null;
        CIMObjectPath prt_queue = null;
        String[] msg = new String[]{"getInstance for PrinterServicingQueue"};
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (cp.getName().equalsIgnoreCase("Antecedent")) {
                    printer = (CIMObjectPath)cp.getValue().getValue();
                }
                if (!cp.getName().equalsIgnoreCase("Dependent")) continue;
                prt_queue = (CIMObjectPath)cp.getValue().getValue();
            }
            CIMInstance ci = cc.newInstance();
            ci.setProperty("Antecedent", new CIMValue(printer));
            ci.setProperty("Dependent", new CIMValue(prt_queue));
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9437", "LM_9438", msg, "Success", false, 0, 0);
            return ci;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9439", "LM_9440", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> printSvcQ = new Vector<CIMInstance>();
        String[] msg = new String[]{"enumeriating instances for PritnerServicingQueue"};
        try {
            this.prtbuff.createPrtFile();
            int num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                CIMInstance ci = cc.newInstance();
                CIMObjectPath printer = new CIMObjectPath("Solaris_Printer");
                CIMObjectPath prt_queue = new CIMObjectPath("Solaris_PrintQueue");
                CIMObjectPath printer_cop = new CIMObjectPath(printer.getObjectName(), printer.getNameSpace());
                CIMObjectPath prt_queue_cop = new CIMObjectPath(prt_queue.getObjectName(), prt_queue.getNameSpace());
                this.prtList = this.prtbuff.getPrinter(lines);
                printer_cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    printer_cop.addKey("DeviceID", new CIMValue((Object)this.prtList));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                try {
                    printer_cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                printer_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_Printer"));
                prt_queue_cop.addKey("Name", new CIMValue((Object)this.prtList));
                ci.setProperty("Antecedent", new CIMValue((Object)printer_cop));
                ci.setProperty("Dependent", new CIMValue((Object)prt_queue_cop));
                printSvcQ.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
            }
            CIMInstance[] ciArray = new CIMInstance[printSvcQ.size()];
            printSvcQ.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9439", "LM_9440", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> printSvcQ = new Vector<CIMObjectPath>();
        String[] msg = new String[]{"enumerating instances for PrinterServicingQueue"};
        try {
            this.prtbuff.createPrtFile();
            int num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                CIMObjectPath printer = new CIMObjectPath("Solaris_Printer");
                CIMObjectPath prt_queue = new CIMObjectPath("Solaris_PrintQueue");
                CIMObjectPath printer_cop = new CIMObjectPath(printer.getObjectName(), printer.getNameSpace());
                CIMObjectPath prt_queue_cop = new CIMObjectPath(prt_queue.getObjectName(), prt_queue.getNameSpace());
                this.prtList = this.prtbuff.getPrinter(lines);
                printer_cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    printer_cop.addKey("DeviceID", new CIMValue((Object)this.prtList));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                try {
                    printer_cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                printer_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_Printer"));
                prt_queue_cop.addKey("Name", new CIMValue((Object)this.prtList));
                cop.addKey("Antecedent", new CIMValue((Object)printer_cop));
                cop.addKey("Dependent", new CIMValue((Object)prt_queue_cop));
                printSvcQ.addElement(cop);
            }
            CIMObjectPath[] copArray = new CIMObjectPath[printSvcQ.size()];
            printSvcQ.toArray(copArray);
            return copArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9439", "LM_9440", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) {
        return null;
    }
}

