/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.project;

import com.sun.wbem.solarisprovider.project.ProjectException;
import com.sun.wbem.solarisprovider.project.ProjectObj;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisProjectTable {
    private String table = new String("project");
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String nameCol = "name";
    private String idCol = "id";
    private String commentCol = "comment";
    private String userCol = "user";
    private String groupCol = "group";
    private String attributeCol = "keyvalue";
    private String scope;
    public static final String DEFAULT_PROJECT_NAME = "default";
    public static final String STAFF_PROJECT_NAME = "group.staff";
    public static final String USER_DEF_PROJ_PREFIX = "user.";
    public static final String GROUP_DEF_PROJ_PREFIX = "group.";

    public SolarisProjectTable(String scope) {
        this.scope = scope;
    }

    public static String[] parseMembersIntoArray(String members, String delimeters) {
        StringTokenizer tk = new StringTokenizer(members, delimeters);
        String[] myStr = new String[tk.countTokens()];
        int i = 0;
        while (tk.hasMoreTokens()) {
            myStr[i++] = tk.nextToken();
        }
        return myStr;
    }

    public static String formatMembersIntoString(String[] members) {
        if (members.length == 0) {
            return "";
        }
        StringBuffer myBuffer = new StringBuffer(members[0]);
        for (int i = 1; i < members.length; ++i) {
            myBuffer.append(",");
            myBuffer.append(members[i]);
        }
        return myBuffer.toString();
    }

    public static String formatAttributesIntoString(String[] attributes) {
        if (attributes.length == 0) {
            return "";
        }
        StringBuffer myBuffer = new StringBuffer(attributes[0]);
        for (int i = 1; i < attributes.length; ++i) {
            myBuffer.append(";");
            myBuffer.append(attributes[i]);
        }
        return myBuffer.toString();
    }

    private boolean isProjectMember(String name, String members) {
        if (members == null) {
            return false;
        }
        if (members == "") {
            return false;
        }
        String[] myList = SolarisProjectTable.parseMembersIntoArray(members, ",");
        for (int i = 0; i < myList.length; ++i) {
            if (name.compareTo(myList[i]) != 0) continue;
            return true;
        }
        return false;
    }

    private DirectoryTable openProjectTable() throws DirectoryTableException {
        try {
            DirectoryTable projectTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            projectTable.open(this.table);
            return projectTable;
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableDoesNotExistException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectObj getProjectRow(ProjectObj projObj) throws DirectoryTableException, ProjectException {
        DirectoryTable etcTable = null;
        etcTable = this.openProjectTable();
        try {
            TableDefinitions tabledefs = etcTable.getCurrentTableDefinitions();
            DirectoryRow projEntry = new DirectoryRow(tabledefs.getNumberOfColumns());
            projEntry.putColumn(tabledefs.getColumnNumber(this.nameCol), projObj.getProjectName());
            projEntry = etcTable.getFirstRow((SearchTemplate)projEntry);
            if (projEntry == null) {
                throw new ProjectException("EXM_PRJ20", projObj.getProjectName());
            }
            projObj.setProjectUsers(SolarisProjectTable.parseMembersIntoArray(projEntry.getColumn(tabledefs.getColumnNumber(this.userCol)), ","));
            projObj.setProjectGroups(SolarisProjectTable.parseMembersIntoArray(projEntry.getColumn(tabledefs.getColumnNumber(this.groupCol)), ","));
            projObj.setProjectAttributes(SolarisProjectTable.parseMembersIntoArray(projEntry.getColumn(tabledefs.getColumnNumber(this.attributeCol)), ";"));
            projObj.setProjectID(projEntry.getColumn(tabledefs.getColumnNumber(this.idCol)));
            projObj.setProjectDescription(projEntry.getColumn(tabledefs.getColumnNumber(this.commentCol)));
        }
        catch (DirectoryTableInvalidParameterException ex) {
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (ProjectException ex) {
            throw ex;
        }
        catch (Exception exception) {
        }
        finally {
            if (etcTable != null) {
                etcTable.close();
            }
        }
        return projObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectRow(ProjectObj projObj) throws DirectoryTableException, ProjectException {
        DirectoryTable etcTable = null;
        etcTable = this.openProjectTable();
        try {
            TableDefinitions tabledefs = etcTable.getCurrentTableDefinitions();
            DirectoryRow projEntry = new DirectoryRow(tabledefs.getNumberOfColumns());
            if (projObj.getProjectName() != null) {
                projEntry.putColumn(tabledefs.getColumnNumber(this.nameCol), projObj.getProjectName());
                projEntry = etcTable.getFirstRow((SearchTemplate)projEntry);
            }
            if (projEntry != null) {
                throw new ProjectException("EXM_PRJ21", projObj.getProjectName());
            }
            projEntry = new DirectoryRow(tabledefs.getNumberOfColumns());
            if (projObj.getProjectID() != null) {
                this.validateAddProject(projObj);
                projEntry.putColumn(tabledefs.getColumnNumber(this.idCol), projObj.getProjectID());
                projEntry = etcTable.getFirstRow((SearchTemplate)projEntry);
            }
            if (projObj.getProjectName() != null) {
                projEntry.putColumn(tabledefs.getColumnNumber(this.nameCol), projObj.getProjectName());
            }
            if (projObj.getProjectID() != null) {
                projEntry.putColumn(tabledefs.getColumnNumber(this.idCol), projObj.getProjectID());
            }
            if (projObj.getProjectDescription() != null) {
                projEntry.putColumn(tabledefs.getColumnNumber(this.commentCol), projObj.getProjectDescription());
            }
            if (projObj.getProjectAttributes() != null) {
                projEntry.putColumn(tabledefs.getColumnNumber(this.attributeCol), SolarisProjectTable.formatAttributesIntoString(projObj.getProjectAttributes()));
            }
            if (projObj.getProjectUsers() != null) {
                projEntry.putColumn(tabledefs.getColumnNumber(this.userCol), SolarisProjectTable.formatMembersIntoString(projObj.getProjectUsers()));
            }
            if (projObj.getProjectGroups() != null) {
                projEntry.putColumn(tabledefs.getColumnNumber(this.groupCol), SolarisProjectTable.formatMembersIntoString(projObj.getProjectGroups()));
            }
            etcTable.addRow(projEntry);
        }
        catch (ProjectException ex) {
            throw ex;
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception exception) {
        }
        finally {
            if (etcTable != null) {
                etcTable.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyProjectRow(ProjectObj ProjectObj2) throws DirectoryTableException, ProjectException {
        block30: {
            DirectoryRow projEntry;
            TableDefinitions tabledefs;
            DirectoryTable etcTable;
            block28: {
                block29: {
                    etcTable = null;
                    etcTable = this.openProjectTable();
                    try {
                        tabledefs = etcTable.getCurrentTableDefinitions();
                        projEntry = new DirectoryRow(tabledefs.getNumberOfColumns());
                        if (ProjectObj2.getProjectName() != null) {
                            projEntry.putColumn(tabledefs.getColumnNumber(this.nameCol), ProjectObj2.getProjectName());
                            projEntry = etcTable.getFirstRow((SearchTemplate)projEntry);
                            if (projEntry == null) {
                                this.addProjectRow(ProjectObj2);
                                return;
                            }
                        }
                        if (!ProjectObj2.getProjectName().equals(DEFAULT_PROJECT_NAME)) break block28;
                        if (ProjectObj2.getProjectID().equals("3")) break block29;
                    }
                    catch (ProjectException ex) {
                        throw ex;
                    }
                    catch (DirectoryTableInvalidParameterException ex) {
                        throw ex;
                    }
                    catch (DirectoryTableAccessException ex) {
                        throw ex;
                    }
                    catch (DirectoryTableConnectionException ex) {
                        throw ex;
                    }
                    catch (DirectoryTableException ex) {
                        throw ex;
                    }
                    catch (Exception exception) {
                        break block30;
                    }
                    finally {
                        if (etcTable != null) {
                            etcTable.close();
                        }
                    }
                    throw new ProjectException("EXM_PRJ26");
                }
                if (ProjectObj2.getProjectUsers() != null || ProjectObj2.getProjectGroups() != null || ProjectObj2.getProjectDescription() != null || ProjectObj2.getProjectAttributes() != null) {
                    throw new ProjectException("EXM_PRJ27");
                }
            }
            DirectoryRow newEntry = new DirectoryRow(tabledefs.getNumberOfColumns());
            String tmpName = projEntry.getColumn(tabledefs.getColumnNumber(this.nameCol));
            if (!tmpName.equals(ProjectObj2.getProjectName()) && ProjectObj2.getProjectName() != null) {
                newEntry.putColumn(tabledefs.getColumnNumber(this.nameCol), ProjectObj2.getProjectName());
                newEntry = etcTable.getFirstRow((SearchTemplate)newEntry);
                if (newEntry != null) {
                    throw new ProjectException("EXM_PRJ20", ProjectObj2.getProjectName());
                }
                newEntry = new DirectoryRow(tabledefs.getNumberOfColumns());
            }
            if (ProjectObj2.getProjectID() != null) {
                projEntry.putColumn(tabledefs.getColumnNumber(this.idCol), ProjectObj2.getProjectID());
            }
            if (ProjectObj2.getProjectUsers() != null) {
                newEntry.putColumn(tabledefs.getColumnNumber(this.userCol), SolarisProjectTable.formatMembersIntoString(ProjectObj2.getProjectUsers()));
            }
            if (ProjectObj2.getProjectGroups() != null) {
                newEntry.putColumn(tabledefs.getColumnNumber(this.groupCol), SolarisProjectTable.formatMembersIntoString(ProjectObj2.getProjectGroups()));
            }
            if (ProjectObj2.getProjectName() != null) {
                newEntry.putColumn(tabledefs.getColumnNumber(this.nameCol), ProjectObj2.getProjectName());
            }
            if (ProjectObj2.getProjectDescription() != null) {
                newEntry.putColumn(tabledefs.getColumnNumber(this.commentCol), ProjectObj2.getProjectDescription());
            }
            if (ProjectObj2.getProjectID() != null) {
                newEntry.putColumn(tabledefs.getColumnNumber(this.idCol), ProjectObj2.getProjectID());
            }
            if (ProjectObj2.getProjectAttributes() != null) {
                newEntry.putColumn(tabledefs.getColumnNumber(this.attributeCol), SolarisProjectTable.formatAttributesIntoString(ProjectObj2.getProjectAttributes()));
            }
            etcTable.modifyRow(projEntry, newEntry);
        }
    }

    public void deleteProjectRow(ProjectObj projObj) throws DirectoryTableException, Exception {
        DirectoryTable etcTable = null;
        etcTable = this.openProjectTable();
        try {
            TableDefinitions tabledefs = etcTable.getCurrentTableDefinitions();
            DirectoryRow projEntry = new DirectoryRow(tabledefs.getNumberOfColumns());
            projEntry.putColumn(tabledefs.getColumnNumber(this.nameCol), projObj.getProjectName());
            projEntry = etcTable.getFirstRow((SearchTemplate)projEntry);
            if (projEntry == null) {
                return;
            }
            etcTable.deleteRow(projEntry);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                etcTable.close();
            }
        }
    }

    public Vector getAllProjectRows() throws DirectoryTableException {
        Vector<ProjectObj> projects = new Vector<ProjectObj>();
        DirectoryTable etcTable = null;
        etcTable = this.openProjectTable();
        try {
            TableDefinitions tabledefs = etcTable.getCurrentTableDefinitions();
            DirectoryRow projectEntry = etcTable.getAll();
            if (projectEntry == null) {
                Vector<ProjectObj> vector = projects;
                return vector;
            }
            for (int i = 1; i <= projectEntry.getNumberOfRows(); ++i) {
                ProjectObj solarisProject = new ProjectObj(projectEntry.getColumn(tabledefs.getColumnNumber(this.nameCol), i));
                solarisProject.setProjectName(projectEntry.getColumn(tabledefs.getColumnNumber(this.nameCol), i));
                solarisProject.setProjectID(projectEntry.getColumn(tabledefs.getColumnNumber(this.idCol), i));
                solarisProject.setProjectDescription(projectEntry.getColumn(tabledefs.getColumnNumber(this.commentCol), i));
                solarisProject.setProjectUsers(SolarisProjectTable.parseMembersIntoArray(projectEntry.getColumn(tabledefs.getColumnNumber(this.userCol), i), ","));
                solarisProject.setProjectGroups(SolarisProjectTable.parseMembersIntoArray(projectEntry.getColumn(tabledefs.getColumnNumber(this.groupCol), i), ","));
                solarisProject.setProjectAttributes(SolarisProjectTable.parseMembersIntoArray(projectEntry.getColumn(tabledefs.getColumnNumber(this.attributeCol), i), ";"));
                projects.addElement(solarisProject);
            }
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                etcTable.close();
            }
        }
        return projects;
    }

    private boolean isDuplicateID(String id) {
        boolean found = false;
        try {
            Vector rows = this.getAllProjectRows();
            Enumeration e = rows.elements();
            while (e.hasMoreElements()) {
                if (!id.equalsIgnoreCase(((ProjectObj)e.nextElement()).getProjectID())) continue;
                return true;
            }
        }
        catch (DirectoryTableInvalidParameterException ex) {
            return false;
        }
        catch (DirectoryTableAccessException ex) {
            return false;
        }
        catch (DirectoryTableConnectionException ex) {
            return false;
        }
        catch (DirectoryTableException ex) {
            return false;
        }
        return found;
    }

    private boolean isDefaultProjectName(String name) {
        try {
            return this.isUserGroupProjectName(name) || name.equals(DEFAULT_PROJECT_NAME);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isUserGroupProjectName(String name) {
        try {
            return name.startsWith(USER_DEF_PROJ_PREFIX) || name.startsWith(GROUP_DEF_PROJ_PREFIX);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isValidID(String id) {
        boolean valid = false;
        int max = Integer.MAX_VALUE;
        int min = 100;
        try {
            Integer ID = new Integer(id);
            if (ID >= min && ID <= max) {
                return true;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return valid;
    }

    private void validateAddProject(ProjectObj p) throws ProjectException {
        try {
            String id = p.getProjectID();
            String name = p.getProjectName();
            boolean isUserGroup = this.isUserGroupProjectName(name);
            if (isUserGroup) {
                return;
            }
            if (name.equals(DEFAULT_PROJECT_NAME)) {
                if (!id.equals("3")) {
                    throw new ProjectException("EXM_PRJ26");
                }
                if (p.getProjectUsers() != null || p.getProjectGroups() != null || p.getProjectDescription() != null || p.getProjectAttributes() != null) {
                    throw new ProjectException("EXM_PRJ27");
                }
            }
            Vector rows = this.getAllProjectRows();
            ProjectObj tempObj = null;
            boolean nonDefDupProjExists = false;
            boolean isDupID = false;
            Enumeration e = rows.elements();
            while (e.hasMoreElements()) {
                tempObj = (ProjectObj)e.nextElement();
                if (tempObj != null && id.equalsIgnoreCase(tempObj.getProjectID())) {
                    if (!this.isDefaultProjectName(tempObj.getProjectName())) {
                        nonDefDupProjExists = true;
                    }
                    isDupID = true;
                }
                if (!nonDefDupProjExists) continue;
            }
            if (!this.isValidID(id)) {
                throw new ProjectException("EXM_PRJ23", id);
            }
            if (nonDefDupProjExists) {
                throw new ProjectException("EXM_PRJ22", id);
            }
        }
        catch (DirectoryTableInvalidParameterException ex) {
            return;
        }
        catch (DirectoryTableAccessException ex) {
            return;
        }
        catch (DirectoryTableConnectionException ex) {
            return;
        }
        catch (DirectoryTableException ex) {
            return;
        }
    }
}

