/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.project;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.project.ProjCommon;
import com.sun.wbem.solarisprovider.project.ProjectException;
import com.sun.wbem.solarisprovider.project.ProjectObj;
import com.sun.wbem.solarisprovider.project.SolarisProjectTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowSizeException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;

public class Solaris_Project
implements Authorizable,
MethodProvider,
InstanceProvider {
    private static final String PROJECT_NAME = "ProjectName";
    private static final String PROJECT_ID = "ProjectID";
    private static final String PROJECT_DESCRIPTION = "Description";
    private static final String PROJECT_USERS = "Users";
    private static final String PROJECT_GROUPS = "Groups";
    private static final String PROJECT_ATTRIBUTES = "ProjectAttributes";
    private static final String PROJECT_CLASS = "Solaris_Project";
    private static final String PROJECT_USER_CLASS = "Solaris_ProjectUser";
    private static final String PROJECT_GROUP_CLASS = "Solaris_ProjectGroup";
    private static final String SYSTEM_CCN = "SystemCreationClassName";
    private static final String SYSTEM_NAME = "SystemName";
    private static final String USER_PREFIX = "user.";
    private static final String GROUP_PREFIX = "group.";
    public static final int MAX_PROJ_INTEGER_VALUE = Integer.MAX_VALUE;
    public static final String PROJECT_WRITE_RIGHT = "solaris.project.write";
    public static final String PROJECT_READ_RIGHT = "solaris.project.read";
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    public static final String PROVIDERNAME = "Project Provider";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.provUtil = new ProviderUtility(cimomhandle, PROVIDERNAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(PROJECT_READ_RIGHT, op);
        Object spt = null;
        String scope = null;
        String msg = null;
        scope = this.provUtil.getMgmtScope(op);
        String name = null;
        Object id = null;
        Object systemCCN = null;
        Object systemName = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(PROJECT_NAME)) continue;
            if (cp.getValue() != null) {
                name = (String)cp.getValue().getValue();
                continue;
            }
            msg = this.provUtil.writeLog(1, "LM_12001", "LM_12010", null, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)msg);
        }
        ProjectObj newObj = null;
        ProjectObj tempObj = new ProjectObj(name);
        if (name != null) {
            tempObj.setProjectName(name);
        }
        try {
            SolarisProjectTable pt = new SolarisProjectTable(scope);
            newObj = pt.getProjectRow(tempObj);
        }
        catch (DirectoryTableException ex) {
            this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        catch (ProjectException ex) {
            this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        if (newObj == null) {
            msg = this.provUtil.writeLog(1, "LM_12000", "LM_12010", name, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)msg);
        }
        try {
            CIMInstance ci = ProjCommon.projectToCim(newObj, cc, this.provUtil.getScopeClassType(scope), this.provUtil.getScopeDomainName(scope));
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }
        catch (CIMException cex) {
            msg = this.provUtil.writeLog(1, "LM_12020", "LM_12020", null, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)msg);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(PROJECT_READ_RIGHT, op);
        Vector<CIMInstance> projectInstances = new Vector<CIMInstance>();
        Vector allProjects = new Vector();
        SolarisProjectTable spt = null;
        String scope = null;
        scope = this.provUtil.getMgmtScope(op);
        try {
            spt = new SolarisProjectTable(scope);
            allProjects = spt.getAllProjectRows();
            ProjectObj projObj = null;
            String name = null;
            Enumeration e = allProjects.elements();
            while (e.hasMoreElements()) {
                projObj = (ProjectObj)e.nextElement();
                name = projObj.getProjectName();
                CIMInstance ci = ProjCommon.projectToCim(projObj, cc, this.provUtil.getScopeClassType(scope), this.provUtil.getScopeDomainName(scope));
                if (localOnly) {
                    ci = ci.localElements();
                }
                projectInstances.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
            }
        }
        catch (DirectoryTableException ex) {
            this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        CIMInstance[] ciArray = new CIMInstance[projectInstances.size()];
        projectInstances.toArray(ciArray);
        return ciArray;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(PROJECT_READ_RIGHT, op);
        Vector<CIMObjectPath> projectOPs = new Vector<CIMObjectPath>();
        Vector allProjects = new Vector();
        SolarisProjectTable spt = null;
        String scope = null;
        scope = this.provUtil.getMgmtScope(op);
        try {
            spt = new SolarisProjectTable(scope);
            allProjects = spt.getAllProjectRows();
            Enumeration e = allProjects.elements();
            while (e.hasMoreElements()) {
                projectOPs.addElement(ProjCommon.projectToCOP((ProjectObj)e.nextElement(), op, this.provUtil.getScopeClassType(scope), this.provUtil.getScopeDomainName(scope)));
            }
        }
        catch (DirectoryTableException ex) {
            this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        CIMObjectPath[] copArray = new CIMObjectPath[projectOPs.size()];
        projectOPs.toArray(copArray);
        return copArray;
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        SolarisProjectTable spt = null;
        String scope = null;
        ProjectObj projObj = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, op);
        try {
            scope = this.provUtil.getMgmtScope(op);
            spt = new SolarisProjectTable(scope);
            projObj = ProjCommon.cimToProject(ci, scope);
            spt.addProjectRow(projObj);
            this.provUtil.writeLog(0, "LM_12043", "LM_12026", projObj.getProjectName(), null, null, null);
        }
        catch (DirectoryTableRowSizeException drsx) {
            this.provUtil.writeLog(2, "LM_12052", "LM_12053", projObj.getProjectName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)drsx.getMessage());
        }
        catch (DirectoryTableException dex) {
            this.provUtil.writeLog(2, (Exception)((Object)dex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)dex.getMessage());
        }
        catch (ProjectException sse) {
            this.provUtil.writeLog(2, (Exception)((Object)sse));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)sse.getMessage());
        }
        catch (CIMException cex) {
            String msg = this.provUtil.writeLog(2, "LM_12009", "LM_12019", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        return op;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        SolarisProjectTable spt = null;
        ProjectObj projObj = null;
        String scope = null;
        String name = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, op);
        try {
            scope = this.provUtil.getMgmtScope(op);
            spt = new SolarisProjectTable(scope);
            projObj = ProjCommon.cimToProject(ci, scope);
            name = projObj.getProjectName();
            spt.modifyProjectRow(projObj);
            this.provUtil.writeLog(0, "LM_12044", "LM_12028", name, null, null, null);
        }
        catch (DirectoryTableRowSizeException drsx) {
            this.provUtil.writeLog(2, "LM_12052", "LM_12053", projObj.getProjectName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)drsx.getMessage());
        }
        catch (DirectoryTableException ex) {
            this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        catch (ProjectException sse) {
            this.provUtil.writeLog(2, (Exception)((Object)sse));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)sse.getMessage());
        }
        catch (CIMException cex) {
            String msg = this.provUtil.writeLog(2, "LM_12021", "LM_12022", name, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        SolarisProjectTable spt = null;
        String scope = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, op);
        try {
            scope = this.provUtil.getMgmtScope(op);
            spt = new SolarisProjectTable(scope);
            ProjectObj projObj = ProjCommon.opToProject(op, scope);
            spt.deleteProjectRow(projObj);
            this.provUtil.writeLog(0, "LM_12045", "LM_12030", projObj.getProjectName(), null, null, null);
        }
        catch (DirectoryTableException ex) {
            this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        catch (ProjectException sse) {
            this.provUtil.writeLog(2, (Exception)((Object)sse));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)sse.getMessage());
        }
        catch (Exception ex) {
            String msg = this.provUtil.writeLog(2, "LM_12024", "LM_12024", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        try {
            if (methodName.equalsIgnoreCase("getResourceControls")) {
                return this.getrctls(op);
            }
            if (methodName.equalsIgnoreCase("getNextProjectID")) {
                return this.getNextID(op);
            }
            if (methodName.equalsIgnoreCase("getProjectUsers")) {
                return this.getMembers(op, PROJECT_USER_CLASS);
            }
            if (methodName.equalsIgnoreCase("getProjectGroups")) {
                return this.getMembers(op, PROJECT_GROUP_CLASS);
            }
            if (methodName.equalsIgnoreCase("setProjectUsers")) {
                return this.setMembers(op, PROJECT_USER_CLASS, inParams);
            }
            if (methodName.equalsIgnoreCase("setProjectGroups")) {
                return this.setMembers(op, PROJECT_GROUP_CLASS, inParams);
            }
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)e.getMessage());
        }
        String msg = this.provUtil.writeLog(1, "LM_12003", "LM_12013", methodName, null, null, null);
        throw new CIMException("GENERAL_EXCEPTION", (Object)msg);
    }

    public Vector myExecQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMValue getrctls(CIMObjectPath op) throws CIMException {
        this.provUtil.checkRights(PROJECT_READ_RIGHT, op);
        ProjCommon projcmn = new ProjCommon();
        String[] strl = null;
        try {
            strl = projcmn.rctls();
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_FAILED", (Object)ex);
        }
        if (strl == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        Vector attribs = ProjCommon.buildVector(strl);
        return new CIMValue((Object)attribs);
    }

    private CIMValue getNextID(CIMObjectPath op) throws CIMException {
        this.provUtil.checkRights(PROJECT_READ_RIGHT, op);
        Vector allProjects = new Vector();
        SolarisProjectTable spt = null;
        int baseID = 100;
        int id = -1;
        String scope = null;
        ProjectObj projectObj = null;
        boolean found = false;
        CIMValue nextID = null;
        scope = this.provUtil.getMgmtScope(op);
        try {
            spt = new SolarisProjectTable(scope);
            allProjects = spt.getAllProjectRows();
            Enumeration e = allProjects.elements();
            int[] projIDs = new int[allProjects.size()];
            int index = 0;
            while (e.hasMoreElements()) {
                projectObj = (ProjectObj)e.nextElement();
                if (projectObj == null) continue;
                projIDs[index] = Integer.parseInt(projectObj.getProjectID());
                ++index;
            }
            Arrays.sort(projIDs);
            index = 0;
            while (!found && index < allProjects.size() && baseID <= Integer.MAX_VALUE) {
                if (projIDs[index] < 100) {
                    ++index;
                    continue;
                }
                if (baseID == projIDs[index]) {
                    ++baseID;
                    ++index;
                    continue;
                }
                if (baseID < projIDs[index]) {
                    id = baseID;
                    found = true;
                    continue;
                }
                if (baseID <= projIDs[index]) continue;
                ++index;
            }
        }
        catch (DirectoryTableException ex) {
            this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        if (baseID <= Integer.MAX_VALUE) {
            id = baseID;
        }
        if (id <= 0) {
            this.provUtil.writeLog(1, "LM_12002", "LM_12012", null, null, null, null);
            return null;
        }
        nextID = new CIMValue((Object)new UnsignedInt32((long)id));
        return nextID;
    }

    private CIMValue getMembers(CIMObjectPath op, String type) throws CIMException {
        this.provUtil.checkRights(PROJECT_READ_RIGHT, op);
        String scope = null;
        String name = null;
        scope = this.provUtil.getMgmtScope(op);
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(PROJECT_NAME) || cp.getValue() == null) continue;
            name = (String)cp.getValue().getValue();
        }
        try {
            ProjectObj projObj = new ProjectObj(name);
            SolarisProjectTable pt = new SolarisProjectTable(scope);
            projObj = pt.getProjectRow(projObj);
            if (type.equals(PROJECT_USER_CLASS)) {
                return new CIMValue((Object)SolarisProjectTable.formatMembersIntoString(projObj.getProjectUsers()));
            }
            if (type.equals(PROJECT_GROUP_CLASS)) {
                return new CIMValue((Object)SolarisProjectTable.formatMembersIntoString(projObj.getProjectGroups()));
            }
        }
        catch (DirectoryTableException ex) {
            this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        catch (ProjectException sse) {
            this.provUtil.writeLog(2, (Exception)((Object)sse));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)sse.getMessage());
        }
        return null;
    }

    private CIMValue setMembers(CIMObjectPath op, String type, Vector members) throws CIMException {
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, op);
        String scope = null;
        String name = null;
        scope = this.provUtil.getMgmtScope(op);
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(PROJECT_NAME) || cp.getValue() == null) continue;
            name = (String)cp.getValue().getValue();
        }
        try {
            if (members == null || members.isEmpty()) {
                if (type.equals(PROJECT_USER_CLASS)) {
                    this.provUtil.writeLog(2, "LM_12004", "LM_12014", name, null, null, null);
                    throw new CIMProviderException("GENERAL_EXCEPTION", (Object)"EXM_PRJ24");
                }
                this.provUtil.writeLog(2, "LM_12007", "LM_12017", name, null, null, null);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)"EXM_PRJ25");
            }
            ProjectObj projObj = new ProjectObj(name);
            SolarisProjectTable pt = new SolarisProjectTable(scope);
            projObj = pt.getProjectRow(projObj);
            CIMValue cv = (CIMValue)members.elementAt(0);
            String newMembers = (String)cv.getValue();
            String[] allMembers = null;
            allMembers = newMembers == null ? new String[]{""} : ProjCommon.stringToArray(newMembers);
            String typeMsg = "";
            if (type.equals(PROJECT_USER_CLASS)) {
                projObj.setProjectUsers(allMembers);
                typeMsg = "users";
            } else if (type.equals(PROJECT_GROUP_CLASS)) {
                projObj.setProjectGroups(allMembers);
                typeMsg = "groups";
            }
            pt.modifyProjectRow(projObj);
            this.provUtil.writeLog(0, "LM_12044", "LM_12054", projObj.getProjectName(), typeMsg, null, null);
            return new CIMValue((Object)SolarisProjectTable.formatMembersIntoString(allMembers));
        }
        catch (DirectoryTableException ex) {
            this.provUtil.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        catch (ProjectException sse) {
            this.provUtil.writeLog(2, (Exception)((Object)sse));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)sse.getMessage());
        }
    }
}

