/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.project;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.project.ProjCommon;
import com.sun.wbem.solarisprovider.project.ProjectException;
import com.sun.wbem.solarisprovider.project.ProjectObj;
import com.sun.wbem.solarisprovider.project.SolarisProjectTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowSizeException;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.AssociatorProvider;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;

public class Solaris_ProjectGroup
implements Authorizable,
MethodProvider,
InstanceProvider,
AssociatorProvider {
    private static final String PROJECT_NAME = "ProjectName";
    private static final String PROJECT_ID = "ProjectID";
    private static final String PROJECT_DESCRIPTION = "Description";
    private static final String PROJECT_USERS = "Users";
    private static final String PROJECT_GROUPS = "Groups";
    private static final String PROJECT_ATTRIBUTES = "ProjectAttributes";
    private static final String PROJECT_USER_CLASS = "Solaris_ProjectGroup";
    private static final String SYSTEM_CCN = "SystemCreationClassName";
    private static final String SYSTEM_NAME = "SystemName";
    private static final String NAME_SPACE = "root/cimv2";
    private static final String PROJECT_CLASS = "Solaris_Project";
    private static final String USER_GROUP_CLASS = "Solaris_UserGroup";
    private static final String GROUP_NAME = "GroupName";
    private static final String PROJECT_REF = "Project";
    private static final String GROUP_REF = "Group";
    public static final String PROJECT_WRITE_RIGHT = "solaris.project.write";
    public static final String PROJECT_READ_RIGHT = "solaris.project.read";
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    public static final String PROVIDERNAME = "Project Group Provider";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.provUtil = new ProviderUtility(cimomhandle, PROVIDERNAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(PROJECT_READ_RIGHT, op);
        Object spt = null;
        String scope = null;
        String SystemCCN = null;
        String SystemName = null;
        String msg = null;
        scope = this.provUtil.getMgmtScope(op);
        CIMObjectPath solarisProject = null;
        CIMObjectPath solarisUserGroup = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(PROJECT_REF)) {
                solarisProject = (CIMObjectPath)cp.getValue().getValue();
            }
            if (cp.getName().equalsIgnoreCase(GROUP_REF)) {
                solarisUserGroup = (CIMObjectPath)cp.getValue().getValue();
            }
            if (cp.getName().equalsIgnoreCase(SYSTEM_CCN)) {
                if (cp.getValue() != null) {
                    SystemCCN = (String)cp.getValue().getValue();
                } else {
                    msg = this.provUtil.writeLog(1, "LM_12006", "LM_12041", null, null, null, null);
                    throw new CIMException("GENERAL_EXCEPTION", (Object)msg);
                }
            }
            if (!cp.getName().equalsIgnoreCase(SYSTEM_NAME)) continue;
            if (cp.getValue() != null) {
                SystemName = (String)cp.getValue().getValue();
                continue;
            }
            msg = this.provUtil.writeLog(1, "LM_12006", "LM_12041", null, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (solarisProject == null || solarisUserGroup == null) {
            msg = this.provUtil.writeLog(1, "LM_12006", "LM_12016", null, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)msg);
        }
        CIMInstance ci = cc.newInstance();
        ci.setProperty(PROJECT_REF, new CIMValue(solarisProject));
        ci.setProperty(GROUP_REF, new CIMValue((Object)solarisUserGroup));
        ci.setProperty(SYSTEM_CCN, new CIMValue((Object)SystemCCN));
        ci.setProperty(SYSTEM_NAME, new CIMValue((Object)SystemName));
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(PROJECT_READ_RIGHT, op);
        Vector<CIMInstance> projectGroupInstances = new Vector<CIMInstance>();
        String scope = null;
        scope = this.provUtil.getMgmtScope(op);
        CIMObjectPath projectCOP = this.buildCOP(PROJECT_CLASS, op);
        CIMObjectPath userGroupCOP = new CIMObjectPath(USER_GROUP_CLASS);
        CIMObjectPath tmpGroupCOP = null;
        try {
            projectCOP.setNameSpace(NAME_SPACE);
            userGroupCOP.setNameSpace(NAME_SPACE);
            Enumeration projectEnum = this.cimomhandle.enumerateInstanceNames(projectCOP);
            while (projectEnum.hasMoreElements()) {
                projectCOP = (CIMObjectPath)projectEnum.nextElement();
                Enumeration userGroupEnum = this.cimomhandle.enumerateInstanceNames(userGroupCOP);
                while (userGroupEnum.hasMoreElements()) {
                    tmpGroupCOP = (CIMObjectPath)userGroupEnum.nextElement();
                    if (!this.projectContainsGroup(projectCOP, tmpGroupCOP, scope)) continue;
                    CIMInstance ci = cc.newInstance();
                    ci.setProperty(PROJECT_REF, new CIMValue((Object)projectCOP));
                    ci.setProperty(GROUP_REF, new CIMValue((Object)tmpGroupCOP));
                    ci.setProperty(SYSTEM_CCN, new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
                    ci.setProperty(SYSTEM_NAME, new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
                    if (localOnly) {
                        ci = ci.localElements();
                    }
                    projectGroupInstances.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
                }
            }
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)e.getMessage());
        }
        CIMInstance[] ciArray = new CIMInstance[projectGroupInstances.size()];
        projectGroupInstances.toArray(ciArray);
        return ciArray;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(PROJECT_READ_RIGHT, op);
        Vector<CIMObjectPath> projectGroupOPs = new Vector<CIMObjectPath>();
        String scope = null;
        scope = this.provUtil.getMgmtScope(op);
        CIMObjectPath projectCOP = this.buildCOP(PROJECT_CLASS, op);
        CIMObjectPath userGroupCOP = new CIMObjectPath(USER_GROUP_CLASS);
        CIMObjectPath tmpGroupCOP = null;
        try {
            projectCOP.setNameSpace(NAME_SPACE);
            Enumeration projectEnum = this.cimomhandle.enumerateInstanceNames(projectCOP);
            while (projectEnum.hasMoreElements()) {
                projectCOP = (CIMObjectPath)projectEnum.nextElement();
                userGroupCOP.setNameSpace(NAME_SPACE);
                Enumeration userGroupEnum = this.cimomhandle.enumerateInstanceNames(userGroupCOP);
                while (userGroupEnum.hasMoreElements()) {
                    tmpGroupCOP = (CIMObjectPath)userGroupEnum.nextElement();
                    if (!this.projectContainsGroup(projectCOP, tmpGroupCOP, scope)) continue;
                    CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                    cop.addKey(PROJECT_REF, new CIMValue((Object)projectCOP));
                    cop.addKey(GROUP_REF, new CIMValue((Object)tmpGroupCOP));
                    cop.addKey(SYSTEM_CCN, new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
                    cop.addKey(SYSTEM_NAME, new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
                    projectGroupOPs.addElement(cop);
                }
            }
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)e.getMessage());
        }
        CIMObjectPath[] copArray = new CIMObjectPath[projectGroupOPs.size()];
        projectGroupOPs.toArray(copArray);
        return copArray;
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        SolarisProjectTable spt = null;
        String scope = null;
        ProjectObj existObj = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, op);
        try {
            scope = this.provUtil.getMgmtScope(op);
            spt = new SolarisProjectTable(scope);
            existObj = this.getExistingProject(op, spt);
            if (existObj != null) {
                String groupName = this.getGroupName(op);
                spt.modifyProjectRow(this.concatGroup(groupName, existObj));
                this.provUtil.writeLog(0, "LM_12049", "LM_12032", groupName, existObj.getProjectName(), null, null);
            }
        }
        catch (DirectoryTableRowSizeException drsx) {
            this.provUtil.writeLog(2, "LM_12052", "LM_12053", existObj.getProjectName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)drsx.getMessage());
        }
        catch (DirectoryTableException dex) {
            this.provUtil.writeLog(2, (Exception)((Object)dex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)dex.getMessage());
        }
        catch (ProjectException sse) {
            this.provUtil.writeLog(2, (Exception)((Object)sse));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)sse.getMessage());
        }
        catch (CIMException cex) {
            this.provUtil.writeLog(2, (Exception)((Object)cex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cex.getMessage());
        }
        return op;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        SolarisProjectTable spt = null;
        String scope = null;
        ProjectObj existObj = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, op);
        try {
            scope = this.provUtil.getMgmtScope(op);
            spt = new SolarisProjectTable(scope);
            existObj = this.getExistingProject(op, spt);
            if (existObj != null) {
                String groupName = this.getGroupName(op);
                spt.modifyProjectRow(this.concatGroup(groupName, existObj));
                this.provUtil.writeLog(0, "LM_12034", "LM_12032", groupName, existObj.getProjectName(), null, null);
            }
        }
        catch (DirectoryTableRowSizeException drsx) {
            this.provUtil.writeLog(2, "LM_12052", "LM_12053", existObj.getProjectName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)drsx.getMessage());
        }
        catch (DirectoryTableException dex) {
            this.provUtil.writeLog(2, (Exception)((Object)dex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)dex.getMessage());
        }
        catch (ProjectException sse) {
            this.provUtil.writeLog(2, (Exception)((Object)sse));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)sse.getMessage());
        }
        catch (CIMException cex) {
            this.provUtil.writeLog(2, (Exception)((Object)cex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cex.getMessage());
        }
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        SolarisProjectTable spt = null;
        String scope = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, op);
        try {
            scope = this.provUtil.getMgmtScope(op);
            spt = new SolarisProjectTable(scope);
            ProjectObj existObj = this.getExistingProject(op, spt);
            if (existObj != null) {
                String groupName = this.getGroupName(op);
                spt.modifyProjectRow(this.delGroup(groupName, existObj));
                this.provUtil.writeLog(0, "LM_12051", "LM_12036", groupName, existObj.getProjectName(), null, null);
            }
        }
        catch (DirectoryTableException dex) {
            this.provUtil.writeLog(2, (Exception)((Object)dex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)dex.getMessage());
        }
        catch (ProjectException sse) {
            this.provUtil.writeLog(2, (Exception)((Object)sse));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)sse.getMessage());
        }
        catch (CIMException cex) {
            this.provUtil.writeLog(2, (Exception)((Object)cex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cex.getMessage());
        }
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector myExecQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector associators(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Vector<CIMInstance> projCIs = new Vector<CIMInstance>();
        if (objectName.getObjectName().equalsIgnoreCase(USER_GROUP_CLASS)) {
            if (role != null && !role.equalsIgnoreCase(GROUP_REF)) {
                return projCIs;
            }
            String scope = this.provUtil.getMgmtScope(objectName);
            CIMObjectPath tempOP = new CIMObjectPath(PROJECT_CLASS);
            tempOP.setNameSpace(assocName.getNameSpace());
            CIMClass projCC = this.cimomhandle.getClass(tempOP, false, includeQualifiers, includeClassOrigin, propertyList);
            try {
                Enumeration e = this.cimomhandle.enumerateInstanceNames(tempOP);
                while (e.hasMoreElements()) {
                    tempOP = (CIMObjectPath)e.nextElement();
                    if (!this.projectContainsGroup(tempOP, objectName, scope)) continue;
                    CIMInstance projCI = this.cimomhandle.getInstance(tempOP, false, includeQualifiers, includeClassOrigin, propertyList);
                    projCIs.addElement(projCI);
                }
            }
            catch (Exception ex) {
                this.provUtil.writeLog(2, ex);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
        } else {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)objectName);
        }
        return projCIs;
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole) throws CIMException {
        Vector<CIMObjectPath> projOPs;
        if (objectName.getObjectName().equalsIgnoreCase(USER_GROUP_CLASS)) {
            if (role != null && !role.equalsIgnoreCase(GROUP_REF)) {
                return new CIMObjectPath[0];
            }
            String scope = this.provUtil.getMgmtScope(objectName);
            projOPs = new Vector<CIMObjectPath>();
            CIMObjectPath tempOP = new CIMObjectPath(PROJECT_CLASS);
            tempOP.setNameSpace(assocName.getNameSpace());
            try {
                Enumeration e = this.cimomhandle.enumerateInstanceNames(tempOP);
                while (e.hasMoreElements()) {
                    tempOP = (CIMObjectPath)e.nextElement();
                    if (!this.projectContainsGroup(tempOP, objectName, scope)) continue;
                    projOPs.addElement(tempOP);
                }
            }
            catch (Exception ex) {
                this.provUtil.writeLog(2, ex);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
        } else {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)objectName);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[projOPs.size()];
        projOPs.toArray(copArray);
        return copArray;
    }

    public Vector references(CIMObjectPath assocName, CIMObjectPath objectName, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath assocName, CIMObjectPath objectName, String role) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private boolean projectContainsGroup(CIMObjectPath pcop, CIMObjectPath ucop, String scope) throws CIMException {
        try {
            ProjectObj projObj = ProjCommon.opToProject(pcop, scope);
            SolarisProjectTable spt = new SolarisProjectTable(scope);
            ProjectObj fullObj = spt.getProjectRow(projObj);
            String groupName = null;
            Enumeration e = ucop.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase(GROUP_NAME) || cp.getValue() == null) continue;
                groupName = (String)cp.getValue().getValue();
            }
            String[] projGroups = fullObj.getProjectGroups();
            if (projGroups == null || groupName == null) {
                return false;
            }
            for (int i = 0; i < projGroups.length; ++i) {
                if (!projGroups[i].equalsIgnoreCase(groupName)) continue;
                return true;
            }
        }
        catch (DirectoryTableException dex) {
            this.provUtil.writeLog(2, (Exception)((Object)dex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)dex.getMessage());
        }
        catch (ProjectException sse) {
            this.provUtil.writeLog(2, (Exception)((Object)sse));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)sse.getMessage());
        }
        return false;
    }

    private CIMObjectPath buildCOP(String className, CIMObjectPath op) {
        CIMObjectPath cop = new CIMObjectPath(className);
        Vector keys = null;
        if (op != null) {
            keys = op.getKeys();
        }
        if (keys != null) {
            for (int i = 0; i < keys.size(); ++i) {
                CIMValue cv;
                CIMProperty cp = (CIMProperty)keys.elementAt(i);
                if (cp.getName().equalsIgnoreCase(SYSTEM_NAME) && (cv = cp.getValue()) != null) {
                    cop.addKey(SYSTEM_NAME, cv);
                }
                if (!cp.getName().equalsIgnoreCase(SYSTEM_CCN) || (cv = cp.getValue()) == null) continue;
                cop.addKey(SYSTEM_CCN, cv);
            }
        }
        return cop;
    }

    private ProjectObj getExistingProject(CIMObjectPath op, SolarisProjectTable spt) throws CIMException {
        CIMProperty cp;
        ProjectObj projObj = new ProjectObj();
        CIMObjectPath projCOP = null;
        String name = null;
        String ID = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(PROJECT_REF) || cp.getValue() == null) continue;
            projCOP = (CIMObjectPath)cp.getValue().getValue();
        }
        projCOP.setNameSpace(op.getNameSpace());
        e = projCOP.getKeys().elements();
        while (e.hasMoreElements()) {
            cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(PROJECT_NAME) && cp.getValue() != null) {
                name = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(PROJECT_ID) || cp.getValue() == null) continue;
            ID = (String)cp.getValue().getValue();
        }
        projObj.setProjectName(name);
        projObj.setProjectID(ID);
        try {
            projObj = spt.getProjectRow(projObj);
        }
        catch (DirectoryTableException dex) {
            this.provUtil.writeLog(2, (Exception)((Object)dex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)dex.getMessage());
        }
        catch (ProjectException sse) {
            this.provUtil.writeLog(2, (Exception)((Object)sse));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)sse.getMessage());
        }
        return projObj;
    }

    private String getGroupName(CIMObjectPath op) {
        CIMProperty cp;
        CIMObjectPath groupCOP = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(GROUP_REF) || cp.getValue() == null) continue;
            groupCOP = (CIMObjectPath)cp.getValue().getValue();
        }
        e = groupCOP.getKeys().elements();
        while (e.hasMoreElements()) {
            cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(GROUP_NAME) || cp.getValue() == null) continue;
            String name = (String)cp.getValue().getValue();
            return name;
        }
        return null;
    }

    private ProjectObj concatGroup(String newGroup, ProjectObj existProj) throws CIMException {
        try {
            Vector existingGroups = ProjCommon.buildVector(existProj.getProjectGroups());
            if (existingGroups == null) {
                String[] groupList = new String[]{newGroup};
                existProj.setProjectGroups(groupList);
                return existProj;
            }
            if (newGroup == null || existingGroups.contains(newGroup)) {
                return existProj;
            }
            existingGroups.addElement(newGroup);
            existingGroups.trimToSize();
            String[] groupList = new String[existingGroups.size()];
            int i = 0;
            Object tmpGroup = null;
            Enumeration e = existingGroups.elements();
            while (e.hasMoreElements()) {
                groupList[i] = (String)e.nextElement();
                ++i;
            }
            existProj.setProjectGroups(groupList);
        }
        catch (Exception e) {
            String msg = this.provUtil.writeLog(1, "LM_12007", "LM_12017", newGroup, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)msg);
        }
        return existProj;
    }

    private ProjectObj delGroup(String delGroup, ProjectObj existProj) throws CIMException {
        try {
            Vector existingGroups = ProjCommon.buildVector(existProj.getProjectGroups());
            if (existingGroups == null || delGroup == null) {
                return existProj;
            }
            if (existingGroups.contains(delGroup)) {
                existingGroups.removeElement(delGroup);
                existingGroups.trimToSize();
                String[] groupList = new String[existingGroups.size()];
                int i = 0;
                Enumeration e = existingGroups.elements();
                while (e.hasMoreElements()) {
                    groupList[i] = (String)e.nextElement();
                    ++i;
                }
                existProj.setProjectGroups(groupList);
            }
        }
        catch (Exception e) {
            String msg = this.provUtil.writeLog(1, "LM_12005", "LM_12015", delGroup, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)msg);
        }
        return existProj;
    }
}

