/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.solarisprovider.scheduledjob.ScheduledJobProvider;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import javax.wbem.cim.CIMException;

public class CronConfiguration {
    public static String PROPERTY_CRONLOG = "CRONLOG";
    public static String PROPERTY_PATH = "PATH";
    public static String PROPERTY_SUPATH = "SUPATH";
    public static String DEFAULT_LOGGING_ON = "NO";
    public static String DEFAULT_USER_PATH = "/usr/bin";
    public static String DEFAULT_ROOT_PATH = "/usr/sbin:/usr/bin";
    private static String CRON_PROPERTIES_FILE = "/etc/default/cron";
    private static int CRON_PROPERTIES_FILE_USER = 2;
    private static int CRON_PROPERTIES_FILE_GROUP = 2;
    private static int CRON_PROPERTIES_FILE_ACCESS = 273;
    DirectoryTable cronProperties = null;
    TableDefinitions cronPropTableDefs = null;
    boolean dataLoaded = false;
    String loggingOn = DEFAULT_LOGGING_ON;
    boolean loggingOnChanged = false;
    String userPath = DEFAULT_USER_PATH;
    boolean userPathChanged = false;
    String rootPath = DEFAULT_ROOT_PATH;
    boolean rootPathChanged = false;
    ScheduledJobProvider provHandle = null;

    public CronConfiguration(ScheduledJobProvider handle) {
        this.provHandle = handle;
    }

    public void loadCronConfiguration() throws CIMException {
        try {
            this.cronProperties = DirectoryTableFactory.getDirectoryTableInstance((String)"File", (String)"", (String)"");
            this.cronPropTableDefs = this.cronProperties.getTableDefinitionsInstance();
            this.cronPropTableDefs.loadTableDefinitions("pkginfo");
            this.cronPropTableDefs.setMappedTableName(CRON_PROPERTIES_FILE);
            this.cronPropTableDefs.setUser(CRON_PROPERTIES_FILE_USER);
            this.cronPropTableDefs.setGroup(CRON_PROPERTIES_FILE_GROUP);
            this.cronPropTableDefs.setAccess(CRON_PROPERTIES_FILE_ACCESS);
        }
        catch (DirectoryTableException e) {
            this.cronProperties = null;
            this.provHandle.logErrorAndThrow("LM_7902", "LM_7903");
        }
        try {
            this.cronProperties.open(this.cronPropTableDefs);
            DirectoryRow allRows = this.cronProperties.getAll();
            DirectoryRow searchRow = this.cronProperties.getRowInstance();
            int foundRow = 0;
            int valCol = this.cronPropTableDefs.getColumnNumber("value");
            int keyCol = this.cronPropTableDefs.getColumnNumber("key");
            searchRow.putColumn(keyCol, PROPERTY_CRONLOG);
            try {
                foundRow = allRows.getFirstRow((SearchTemplate)searchRow, this.cronPropTableDefs);
                this.loggingOn = allRows.getColumn(valCol, foundRow);
            }
            catch (DirectoryTableException e1) {
                this.loggingOn = DEFAULT_LOGGING_ON;
            }
            searchRow.putColumn(keyCol, PROPERTY_PATH);
            try {
                foundRow = allRows.getFirstRow((SearchTemplate)searchRow, this.cronPropTableDefs);
                this.userPath = allRows.getColumn(valCol, foundRow);
            }
            catch (DirectoryTableException e2) {
                this.userPath = DEFAULT_USER_PATH;
            }
            searchRow.putColumn(keyCol, PROPERTY_SUPATH);
            try {
                foundRow = allRows.getFirstRow((SearchTemplate)searchRow, this.cronPropTableDefs);
                this.rootPath = allRows.getColumn(valCol, foundRow);
            }
            catch (DirectoryTableException e3) {
                this.rootPath = DEFAULT_ROOT_PATH;
            }
            this.cronProperties.close();
        }
        catch (DirectoryTableException e) {
            this.loggingOn = DEFAULT_LOGGING_ON;
            this.userPath = DEFAULT_USER_PATH;
            this.rootPath = DEFAULT_ROOT_PATH;
            this.provHandle.logWarning("LM_7666", "LM_7668");
        }
        this.dataLoaded = true;
    }

    public void saveCronConfiguration() throws CIMException {
        block16: {
            if (!this.dataLoaded) {
                this.provHandle.logErrorAndThrow("LM_7669", "LM_7670");
            }
            if (!(this.loggingOnChanged || this.userPathChanged || this.rootPathChanged)) {
                return;
            }
            try {
                this.cronProperties.open(this.cronPropTableDefs);
            }
            catch (DirectoryTableException e) {
                try {
                    this.cronProperties.create(this.cronPropTableDefs);
                    this.provHandle.logWarning("LM_7904", "LM_7905");
                }
                catch (DirectoryTableException e2) {
                    this.provHandle.logErrorAndThrow("LM_7669", "LM_7671");
                }
            }
            try {
                DirectoryRow newRow = this.cronProperties.getRowInstance();
                DirectoryRow searchRow = this.cronProperties.getRowInstance();
                int valCol = this.cronPropTableDefs.getColumnNumber("value");
                int keyCol = this.cronPropTableDefs.getColumnNumber("key");
                if (this.loggingOnChanged) {
                    searchRow.putColumn(keyCol, PROPERTY_CRONLOG);
                    try {
                        this.cronProperties.deleteRow(searchRow);
                    }
                    catch (DirectoryTableRowNotFoundException e1) {
                        this.provHandle.logWarning("LM_7906", "LM_7907", PROPERTY_CRONLOG);
                    }
                    newRow.putColumn(keyCol, PROPERTY_CRONLOG);
                    newRow.putColumn(valCol, this.loggingOn);
                    this.cronProperties.addRow(newRow);
                }
                if (this.rootPathChanged) {
                    searchRow.putColumn(keyCol, PROPERTY_SUPATH);
                    try {
                        this.cronProperties.deleteRow(searchRow);
                    }
                    catch (DirectoryTableRowNotFoundException e2) {
                        this.provHandle.logWarning("LM_7906", "LM_7907", PROPERTY_SUPATH);
                    }
                    newRow.putColumn(keyCol, PROPERTY_SUPATH);
                    newRow.putColumn(valCol, this.rootPath);
                    this.cronProperties.addRow(newRow);
                }
                if (!this.userPathChanged) break block16;
                searchRow.putColumn(keyCol, PROPERTY_PATH);
                try {
                    this.cronProperties.deleteRow(searchRow);
                }
                catch (DirectoryTableRowNotFoundException e3) {
                    this.provHandle.logWarning("LM_7906", "LM_7907", PROPERTY_PATH);
                }
                newRow.putColumn(keyCol, PROPERTY_PATH);
                newRow.putColumn(valCol, this.userPath);
                this.cronProperties.addRow(newRow);
            }
            catch (DirectoryTableException e) {
                this.cronProperties.close();
                this.provHandle.logErrorAndThrow("LM_7669", "LM_7674");
            }
        }
        this.cronProperties.close();
        this.loggingOnChanged = false;
        this.userPathChanged = false;
        this.rootPathChanged = false;
    }

    public boolean getLoggingOn() throws CIMException {
        return this.loggingOn.compareTo("NO") != 0;
    }

    public void setLoggingOn(boolean loggingOn) throws CIMException {
        if (!this.dataLoaded) {
            this.provHandle.logErrorAndThrow("LM_7677", "LM_7678", PROPERTY_CRONLOG);
        }
        this.loggingOn = loggingOn ? "YES" : "NO";
        this.loggingOnChanged = true;
    }

    public String getUserPath() throws CIMException {
        return this.userPath;
    }

    public void setUserPath(String userPath) throws CIMException {
        if (!this.dataLoaded) {
            this.provHandle.logErrorAndThrow("LM_7677", "LM_7678", PROPERTY_PATH);
        }
        this.userPath = userPath;
        this.userPathChanged = true;
    }

    public String getRootPath() throws CIMException {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) throws CIMException {
        if (!this.dataLoaded) {
            this.provHandle.logErrorAndThrow("LM_7677", "LM_7678", PROPERTY_SUPATH);
        }
        this.rootPath = rootPath;
        this.rootPathChanged = true;
    }
}

