/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.solarisprovider.scheduledjob.ScheduledJobProvider;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.wbem.cim.CIMException;

public class CronLog {
    private static String CRON_LOG_FILE = "/var/cron/log";
    private static String CRON_LOG_COMMAND_PREFIX = ">  CMD: ";
    private static String CRON_LOG_ENDJOB_PREFIX = "<  ";
    private static String CRON_LOG_RETURNCODE_PREFIX = "rc=";
    private static int MAX_LOG_LINES = 250;
    private static String JOB_EVENTS_REGEXP = "^[><].*";
    private String inDateFormatString = null;
    private DateFormat df = DateFormat.getDateTimeInstance(3, 3);
    private String jobStateUnknown = null;
    private String jobStateFinished1 = null;
    private String jobStateFinished2 = null;
    private String jobStateStarted1 = null;
    private String jobStateStarted2 = null;
    private ScheduledJobProvider provHandle = null;
    private DirectoryTable cronLog = null;
    private DirectoryRow logRows = null;
    private TableDefinitions cronLogTableDefs = null;
    private int lineCol = 0;
    private Hashtable jobEvents = null;
    private boolean dataLoaded = false;
    private SimpleDateFormat inDateFormat = null;

    public CronLog(ScheduledJobProvider handle) {
        this.provHandle = handle;
        this.inDateFormatString = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_IN_DATE_FORMAT");
        this.jobStateUnknown = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_STATE_UNKNOWN");
        this.jobStateFinished1 = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_STATE_FINISHED1");
        this.jobStateFinished2 = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_STATE_FINISHED2");
        this.jobStateStarted1 = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_STATE_STARTED1");
        this.jobStateStarted2 = this.provHandle.getMessage("LM_LABEL_SCHEDULEDJOB_STATE_STARTED2");
        this.inDateFormat = new SimpleDateFormat(this.inDateFormatString);
    }

    public void initialize() throws CIMException {
        try {
            this.cronLog = DirectoryTableFactory.getDirectoryTableInstance((String)"File", (String)"", (String)"");
            this.cronLogTableDefs = this.cronLog.getTableDefinitionsInstance();
            this.cronLogTableDefs.loadTableDefinitions("text");
            this.cronLogTableDefs.setMappedTableName(CRON_LOG_FILE);
            this.lineCol = this.cronLogTableDefs.getColumnNumber("line");
        }
        catch (DirectoryTableException e) {
            this.cronLog = null;
            this.provHandle.logWarning("LM_7908", "LM_7909");
        }
    }

    public void loadCronLog() throws CIMException {
        if (this.cronLog == null) {
            return;
        }
        try {
            this.cronLog.open(this.cronLogTableDefs);
            DirectoryFilter filt = new DirectoryFilter(1);
            filt.add(this.lineCol, 1, 9, JOB_EVENTS_REGEXP);
            this.logRows = this.cronLog.getAll((SearchTemplate)filt);
            if (this.logRows == null) {
                this.dataLoaded = true;
                this.jobEvents = null;
                return;
            }
            this.jobEvents = new Hashtable(101);
            this.parseLogEntries();
            this.cronLog.close();
            this.logRows = null;
        }
        catch (DirectoryTableException e) {
            this.logRows = null;
            this.jobEvents = null;
        }
        this.dataLoaded = true;
    }

    public void unloadCronLog() {
        if (this.dataLoaded) {
            this.logRows = null;
            this.jobEvents = null;
            this.dataLoaded = false;
        }
    }

    public String getCronLogJobStatus(String owner, String command) throws CIMException {
        if (!this.dataLoaded) {
            this.provHandle.logErrorAndThrow("LM_7681", "LM_7682");
        }
        if (this.jobEvents == null) {
            return null;
        }
        return (String)this.jobEvents.get(owner.trim() + ":" + command.trim());
    }

    private void parseLogEntries() {
        int numRows = this.logRows.getNumberOfRows();
        String line = null;
        String command = null;
        String owner = null;
        String pid = null;
        String startTime = null;
        String endTime = null;
        String returnCode = null;
        String jobStatus = "";
        if (numRows > MAX_LOG_LINES) {
            numRows = MAX_LOG_LINES;
        }
        for (int i = numRows - 1; i >= 0; --i) {
            try {
                int k;
                line = this.logRows.getColumn(this.lineCol, i);
                if (!line.startsWith(CRON_LOG_COMMAND_PREFIX)) continue;
                int endToken = line.indexOf(35);
                command = endToken != -1 ? line.substring(CRON_LOG_COMMAND_PREFIX.length(), endToken).trim() : line.substring(CRON_LOG_COMMAND_PREFIX.length()).trim();
                startTime = null;
                endTime = null;
                returnCode = null;
                pid = null;
                line = this.logRows.getColumn(this.lineCol, i + 1);
                int startToken = 3;
                endToken = line.indexOf(32, 3);
                for (int j = 0; endToken != -1 && j < 4; ++j) {
                    switch (j) {
                        case 0: {
                            owner = line.substring(startToken, endToken).trim();
                            break;
                        }
                        case 1: {
                            pid = line.substring(startToken, endToken).trim();
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            startTime = line.substring(startToken).trim();
                            break;
                        }
                    }
                    startToken = endToken + 1;
                    endToken = line.indexOf(32, startToken);
                }
                if (this.jobEvents.containsKey(owner + ":" + command)) continue;
                for (k = i + 2; k <= numRows && !(line = this.logRows.getColumn(this.lineCol, k)).startsWith(CRON_LOG_ENDJOB_PREFIX + owner + " " + pid); ++k) {
                }
                if (k <= numRows) {
                    endToken = line.indexOf(CRON_LOG_RETURNCODE_PREFIX);
                    startToken = CRON_LOG_ENDJOB_PREFIX.length() + owner.length() + pid.length() + 4;
                    if (endToken == -1) {
                        endTime = line.substring(startToken);
                    } else {
                        returnCode = line.substring(endToken + CRON_LOG_RETURNCODE_PREFIX.length());
                        endTime = line.substring(startToken, endToken - 1);
                    }
                }
                jobStatus = this.deriveJobStatus(pid, startTime, endTime, returnCode);
                this.jobEvents.put(owner + ":" + command, jobStatus);
                continue;
            }
            catch (DirectoryTableException e) {
                // empty catch block
            }
        }
    }

    private String deriveJobStatus(String pid, String startTime, String endTime, String returnCode) {
        String status = this.jobStateUnknown;
        Date dt = null;
        if (startTime == null || pid == null) {
            return status;
        }
        if (endTime == null) {
            try {
                dt = this.inDateFormat.parse(startTime);
                status = this.jobStateStarted1 + " " + this.df.format(dt) + " " + this.jobStateStarted2 + " " + pid;
            }
            catch (Exception e) {
                status = this.jobStateStarted1 + " " + this.jobStateStarted2 + " " + pid;
            }
        } else {
            try {
                dt = this.inDateFormat.parse(endTime);
                status = this.jobStateFinished1 + " " + this.df.format(dt);
            }
            catch (Exception e) {
                status = this.jobStateFinished1;
            }
            if (returnCode != null) {
                status = status + " " + this.jobStateFinished2 + " " + returnCode;
            }
        }
        return status;
    }
}

