/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.solarisprovider.scheduledjob.CronUtility;
import com.sun.wbem.solarisprovider.scheduledjob.NameFilter;
import com.sun.wbem.utility.common.QuickVector;
import java.util.Vector;

public class CrontabEntries {
    private static int OWNER_COLUMN = 0;
    private static int NAME_COLUMN = 1;
    private static int COMMAND_COLUMN = 2;
    private static int HOURS_COLUMN = 3;
    private static int MINUTES_COLUMN = 4;
    private static int DAYS_OF_THE_WEEK_COLUMN = 5;
    private static int DAYS_OF_THE_MONTH_COLUMN = 6;
    private static int MONTHS_COLUMN = 7;
    private static int JOB_STATUS_COLUMN = 8;
    private static int NUMBER_OF_COLUMNS = 9;
    private QuickVector entries = null;
    private int numberOfEntries = 0;

    public CrontabEntries() {
        this(1);
    }

    public CrontabEntries(int numberOfEntries) {
        String[] entry = null;
        this.entries = new QuickVector(numberOfEntries);
        this.entries.setSize(numberOfEntries);
        for (int i = 0; i < numberOfEntries; ++i) {
            entry = new String[NUMBER_OF_COLUMNS];
            for (int j = 0; j < NUMBER_OF_COLUMNS; ++j) {
                entry[j] = "";
            }
            this.entries.quickSetElementAt((Object)entry, i);
        }
        this.numberOfEntries = numberOfEntries;
    }

    public void addEntries(CrontabEntries entriesToAdd) {
        Object entry = null;
        int numberOfEntriesToAdd = entriesToAdd.numberOfEntries;
        this.entries.setSize(this.numberOfEntries + numberOfEntriesToAdd);
        for (int i = this.numberOfEntries; i < this.numberOfEntries + numberOfEntriesToAdd; ++i) {
            this.entries.quickSetElementAt(entriesToAdd.entries.quickElementAt(i - this.numberOfEntries), i);
        }
        this.numberOfEntries += numberOfEntriesToAdd;
    }

    public void setEntry(int entryNumber, String owner, String name, String command, String hours, String minutes, String daysOfTheWeek, String daysOfTheMonth, String months, String jobStatus) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.OWNER_COLUMN] = owner;
            entry[CrontabEntries.NAME_COLUMN] = name;
            entry[CrontabEntries.COMMAND_COLUMN] = command;
            entry[CrontabEntries.HOURS_COLUMN] = hours;
            entry[CrontabEntries.MINUTES_COLUMN] = minutes;
            entry[CrontabEntries.DAYS_OF_THE_WEEK_COLUMN] = daysOfTheWeek;
            entry[CrontabEntries.DAYS_OF_THE_MONTH_COLUMN] = daysOfTheMonth;
            entry[CrontabEntries.MONTHS_COLUMN] = months;
            entry[CrontabEntries.JOB_STATUS_COLUMN] = jobStatus;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public void setEntry(int entryNumber, String owner, String name, String command, Vector hours, Vector minutes, Vector daysOfTheWeek, Vector daysOfTheMonth, Vector months) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.OWNER_COLUMN] = owner;
            entry[CrontabEntries.NAME_COLUMN] = name;
            entry[CrontabEntries.COMMAND_COLUMN] = command;
            entry[CrontabEntries.HOURS_COLUMN] = CronUtility.getStringFromVectorOfUnsignedInt16(hours, 0, 23);
            entry[CrontabEntries.MINUTES_COLUMN] = CronUtility.getStringFromVectorOfUnsignedInt16(minutes, 0, 59);
            entry[CrontabEntries.DAYS_OF_THE_WEEK_COLUMN] = CronUtility.getStringFromVectorOfUnsignedInt16(daysOfTheWeek, 0, 6);
            entry[CrontabEntries.DAYS_OF_THE_MONTH_COLUMN] = CronUtility.getStringFromVectorOfUnsignedInt16(daysOfTheMonth, 1, 31);
            entry[CrontabEntries.MONTHS_COLUMN] = CronUtility.getStringFromVectorOfUnsignedInt16(months, 1, 12);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public void addBlankEntries(int numberOfEntriesToAdd) {
        String[] entry = null;
        this.entries.setSize(this.numberOfEntries + numberOfEntriesToAdd);
        for (int i = this.numberOfEntries; i < this.numberOfEntries + numberOfEntriesToAdd; ++i) {
            entry = new String[NUMBER_OF_COLUMNS];
            for (int j = 0; j < NUMBER_OF_COLUMNS; ++j) {
                entry[j] = "";
            }
            this.entries.quickSetElementAt((Object)entry, i);
        }
        this.numberOfEntries += numberOfEntriesToAdd;
    }

    public void deleteEntry(int entryToDelete) {
        this.entries.removeElementAt(entryToDelete - 1);
        --this.numberOfEntries;
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public String getOwner(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[OWNER_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setOwner(int entryNumber, String owner) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.OWNER_COLUMN] = owner;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getName(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            if (entry[NAME_COLUMN].equals("")) {
                return NameFilter.generateUniqueName(this, entryNumber);
            }
            return entry[NAME_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setName(int entryNumber, String name) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.NAME_COLUMN] = name;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getCommand(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[COMMAND_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setCommand(int entryNumber, String command) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.COMMAND_COLUMN] = command;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getHours(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[HOURS_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public Vector getHoursAsVector(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return CronUtility.getVectorOfUnsignedInt16FromString(entry[HOURS_COLUMN], 0, 23);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setHours(int entryNumber, String hours) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.HOURS_COLUMN] = hours;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public void setHours(int entryNumber, Vector hours) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.HOURS_COLUMN] = CronUtility.getStringFromVectorOfUnsignedInt16(hours, 0, 23);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getMinutes(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[MINUTES_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public Vector getMinutesAsVector(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return CronUtility.getVectorOfUnsignedInt16FromString(entry[MINUTES_COLUMN], 0, 59);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setMinutes(int entryNumber, String minutes) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.MINUTES_COLUMN] = minutes;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public void setMinutes(int entryNumber, Vector minutes) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.MINUTES_COLUMN] = CronUtility.getStringFromVectorOfUnsignedInt16(minutes, 0, 59);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getDaysOfTheWeek(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[DAYS_OF_THE_WEEK_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public Vector getDaysOfTheWeekAsVector(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return CronUtility.getVectorOfUnsignedInt16FromString(entry[DAYS_OF_THE_WEEK_COLUMN], 0, 6);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setDaysOfTheWeek(int entryNumber, String daysOfTheWeek) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.DAYS_OF_THE_WEEK_COLUMN] = daysOfTheWeek;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public void setDaysOfTheWeek(int entryNumber, Vector daysOfTheWeek) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.DAYS_OF_THE_WEEK_COLUMN] = CronUtility.getStringFromVectorOfUnsignedInt16(daysOfTheWeek, 0, 6);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getDaysOfTheMonth(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[DAYS_OF_THE_MONTH_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public Vector getDaysOfTheMonthAsVector(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return CronUtility.getVectorOfUnsignedInt16FromString(entry[DAYS_OF_THE_MONTH_COLUMN], 1, 31);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setDaysOfTheMonth(int entryNumber, String daysOfTheMonth) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.DAYS_OF_THE_MONTH_COLUMN] = daysOfTheMonth;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public void setDaysOfTheMonth(int entryNumber, Vector daysOfTheMonth) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.DAYS_OF_THE_MONTH_COLUMN] = CronUtility.getStringFromVectorOfUnsignedInt16(daysOfTheMonth, 1, 31);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getMonths(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[MONTHS_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public Vector getMonthsAsVector(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return CronUtility.getVectorOfUnsignedInt16FromString(entry[MONTHS_COLUMN], 1, 12);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setMonths(int entryNumber, String months) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.MONTHS_COLUMN] = months;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public void setMonths(int entryNumber, Vector months) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.MONTHS_COLUMN] = CronUtility.getStringFromVectorOfUnsignedInt16(months, 1, 12);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getJobStatus(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[JOB_STATUS_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setJobStatus(int entryNumber, String jobStatus) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CrontabEntries.JOB_STATUS_COLUMN] = jobStatus;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }
}

