/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.solarisprovider.scheduledjob.CrontabEntries;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.zip.Adler32;

public class NameFilter
implements SearchTemplate {
    private static String GENERATED_NAME_PREFIX = "job_";
    private static int CONVERT_RADIX = 16;
    long checksumToMatch = 0L;
    String name = null;
    boolean useChecksum = false;

    public NameFilter(String name) {
        if (NameFilter.isGeneratedName(name)) {
            this.checksumToMatch = Long.parseLong(NameFilter.stripPrefix(name), CONVERT_RADIX);
            this.useChecksum = true;
        } else {
            this.name = name;
            this.useChecksum = false;
        }
    }

    public boolean matchRow(DirectoryRow row, TableDefinitions tableDefs) throws DirectoryTableException {
        return this.matchRow(row, 1, tableDefs);
    }

    public boolean matchRow(DirectoryRow row, int rowNum, TableDefinitions tableDefs) throws DirectoryTableException {
        int nameCol = tableDefs.getColumnNumber("comment");
        if (this.useChecksum) {
            int numberOfCols = row.getNumberOfColumns();
            Adler32 checksum = new Adler32();
            for (int i = 1; i <= numberOfCols; ++i) {
                if (i == nameCol) continue;
                byte[] colAsBytes = row.getColumn(i, rowNum).getBytes();
                checksum.update(colAsBytes);
            }
            return checksum.getValue() == this.checksumToMatch;
        }
        return row.getColumn(nameCol, rowNum).equals(this.name);
    }

    public DirectoryRow getTemplateAsRow(TableDefinitions tableDefs) throws DirectoryTableException {
        return null;
    }

    public static String generateUniqueName(CrontabEntries entries, int entryNum) {
        long crcOfRow = 0L;
        Adler32 checksum = new Adler32();
        byte[] dataAsBytes = null;
        dataAsBytes = entries.getMinutes(entryNum).getBytes();
        checksum.update(dataAsBytes);
        dataAsBytes = entries.getHours(entryNum).getBytes();
        checksum.update(dataAsBytes);
        dataAsBytes = entries.getDaysOfTheMonth(entryNum).getBytes();
        checksum.update(dataAsBytes);
        dataAsBytes = entries.getMonths(entryNum).getBytes();
        checksum.update(dataAsBytes);
        dataAsBytes = entries.getDaysOfTheWeek(entryNum).getBytes();
        checksum.update(dataAsBytes);
        dataAsBytes = entries.getCommand(entryNum).getBytes();
        checksum.update(dataAsBytes);
        return GENERATED_NAME_PREFIX + Long.toString(checksum.getValue(), CONVERT_RADIX);
    }

    protected static boolean isGeneratedName(String name) {
        return name.startsWith(GENERATED_NAME_PREFIX);
    }

    protected static String stripPrefix(String name) {
        return name.substring(GENERATED_NAME_PREFIX.length());
    }
}

