/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.scheduledjob.CronUtility;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import com.sun.wbem.utility.log.LogUtil;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.InstanceProvider;

public abstract class ScheduledJobProvider
implements InstanceProvider {
    private static final String MGMT_DOMAIN = "mgmtDomain";
    private static final String DFLT_DOMAIN_TYPE = "file";
    private static final String ROLE_TYPE = "role";
    public static final String SCHEDULED_JOBS_ADMIN_RIGHT = "solaris.jobs.admin";
    public static final String SCHEDULED_JOBS_USER_RIGHT = "solaris.jobs.user";
    private static final int AUTH_NONE = 0;
    private static final int AUTH_READ_SELF = 1;
    private static final int AUTH_READ_OTHER = 2;
    private static final int AUTH_READ_ANY = 3;
    private static final int AUTH_WRITE_SELF = 4;
    private static final int AUTH_WRITE_OTHER = 8;
    private static final int AUTH_WRITE_ANY = 12;
    private static final int AUTH_ALL = 15;
    protected ProviderCIMOMHandle cimomhandle = null;
    protected LogUtil logUtil = null;
    protected ProviderUtility provUtil = null;
    protected String providerName = "ScheduledJobProvider";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.provUtil = new ProviderUtility(cimomhandle, this.providerName);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualififers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass c) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    protected UnsignedInt32 convertIntToCIMUnsignedInt(int intValue) {
        try {
            return new UnsignedInt32(Integer.toString(intValue));
        }
        catch (Exception e) {
            return new UnsignedInt32("0");
        }
    }

    protected UnsignedInt16 convertShortToCIMUnsignedInt16(short shortValue) {
        try {
            return new UnsignedInt16(Short.toString(shortValue));
        }
        catch (Exception e) {
            return new UnsignedInt16("0");
        }
    }

    protected String getMgmtScope(CIMObjectPath op) throws CIMException {
        return this.provUtil.getMgmtScope(op);
    }

    protected String getScopeType(String scope) {
        if (scope == null || scope.trim().length() == 0) {
            return DFLT_DOMAIN_TYPE;
        }
        int i = scope.indexOf(58);
        if (i < 1) {
            return DFLT_DOMAIN_TYPE;
        }
        return scope.substring(0, i);
    }

    protected String getDefaultScope() {
        return this.provUtil.getDefaultScope();
    }

    protected void checkAdminModifyRights(CIMObjectPath op) throws CIMException {
        this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, op);
    }

    protected void checkAdminViewRights(CIMObjectPath op) throws CIMException {
        try {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, op);
            return;
        }
        catch (CIMSecurityException e) {
            this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, op);
            return;
        }
    }

    protected String checkJobViewRights(CIMObjectPath op) throws CIMException {
        String owner = null;
        int ret = -1;
        owner = this.provUtil.getClientUserName();
        try {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, op);
            return null;
        }
        catch (CIMSecurityException se) {
            ret = CronUtility.withinFile(this, owner, CronUtility.ALLOW_FILENAME);
            if (ret == CronUtility.UNKNOWN_ERROR) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            if (ret != CronUtility.FILE_DOES_NOT_EXIST) {
                if (ret == CronUtility.USER_NOT_IN_FILE) {
                    this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, op);
                }
            } else {
                ret = CronUtility.withinFile(this, owner, CronUtility.DENY_FILENAME);
                if (ret == CronUtility.UNKNOWN_ERROR) {
                    throw new CIMException("CIM_ERR_FAILED");
                }
                if (ret != CronUtility.FILE_DOES_NOT_EXIST) {
                    if (ret == CronUtility.USER_IN_FILE) {
                        this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, op);
                    }
                } else {
                    this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, op);
                }
            }
            return owner;
        }
    }

    protected String checkJobModifyRights(String owner, CIMObjectPath op) throws CIMException {
        StringBuffer requiredAuth = null;
        String permittedOwner = null;
        int ret = -1;
        permittedOwner = this.provUtil.getClientUserName();
        if (permittedOwner == null) {
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
        if (owner.compareTo(permittedOwner) != 0) {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, op);
            requiredAuth = this.provUtil.assembleRequiredAuth(requiredAuth, SCHEDULED_JOBS_ADMIN_RIGHT);
        }
        if ((ret = CronUtility.withinFile(this, owner, CronUtility.ALLOW_FILENAME)) == CronUtility.UNKNOWN_ERROR) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        if (ret != CronUtility.FILE_DOES_NOT_EXIST) {
            if (ret == CronUtility.USER_NOT_IN_FILE) {
                this.checkUserRights(owner, SCHEDULED_JOBS_USER_RIGHT, op);
                requiredAuth = this.provUtil.assembleRequiredAuth(requiredAuth, SCHEDULED_JOBS_USER_RIGHT);
            }
        } else {
            ret = CronUtility.withinFile(this, owner, CronUtility.DENY_FILENAME);
            if (ret == CronUtility.UNKNOWN_ERROR) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            if (ret != CronUtility.FILE_DOES_NOT_EXIST) {
                if (ret == CronUtility.USER_IN_FILE) {
                    this.checkUserRights(owner, SCHEDULED_JOBS_USER_RIGHT, op);
                    requiredAuth = this.provUtil.assembleRequiredAuth(requiredAuth, SCHEDULED_JOBS_USER_RIGHT);
                }
            } else {
                this.checkUserRights(owner, SCHEDULED_JOBS_USER_RIGHT, op);
                requiredAuth = this.provUtil.assembleRequiredAuth(requiredAuth, SCHEDULED_JOBS_USER_RIGHT);
            }
        }
        return requiredAuth != null ? requiredAuth.toString() : null;
    }

    public int getScheduledJobsAuthorization(CIMObjectPath op) throws CIMException {
        String owner = null;
        int ret = -1;
        owner = this.provUtil.getClientUserName();
        try {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, op);
            return 15;
        }
        catch (CIMSecurityException se1) {
            ret = CronUtility.withinFile(this, owner, CronUtility.ALLOW_FILENAME);
            if (ret == CronUtility.UNKNOWN_ERROR) {
                return 0;
            }
            if (ret != CronUtility.FILE_DOES_NOT_EXIST) {
                if (ret == CronUtility.USER_NOT_IN_FILE) {
                    try {
                        this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, op);
                    }
                    catch (CIMSecurityException se2) {
                        return 0;
                    }
                }
            } else {
                ret = CronUtility.withinFile(this, owner, CronUtility.DENY_FILENAME);
                if (ret == CronUtility.UNKNOWN_ERROR) {
                    return 0;
                }
                if (ret != CronUtility.FILE_DOES_NOT_EXIST) {
                    if (ret == CronUtility.USER_IN_FILE) {
                        try {
                            this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, op);
                        }
                        catch (CIMSecurityException se3) {
                            return 0;
                        }
                    }
                } else {
                    try {
                        this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, op);
                    }
                    catch (CIMSecurityException se4) {
                        return 0;
                    }
                }
            }
            return 5;
        }
    }

    protected void checkUserRights(String user_name, String permission, CIMObjectPath op) throws CIMException {
        if (!AuthorizationUtility.checkAuthName((String)user_name, (String)permission)) {
            String[] args = new String[]{user_name};
            this.logUtil.writeLog(this.providerName, "LM_1001", "LM_1012", args, "", false, 1, 1);
            this.provUtil.unAuthorizedAudit(op, permission);
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
    }

    protected String getMessage(String msgId) {
        return this.logUtil.getMessage(msgId);
    }

    protected void writeLog(int severity, Exception pex) {
        this.provUtil.writeLog(severity, pex);
    }

    protected String writeLog(int severity, String msgId, String detailMsgId, String arg1, String arg2, String arg3, String arg4) {
        return this.provUtil.writeLog(severity, msgId, detailMsgId, arg1, arg2, arg2, arg4);
    }

    protected String logSuccess(String msgId) {
        return this.provUtil.writeLog(0, msgId, msgId, null, null, null, null);
    }

    protected String logSuccess(String msgId, String detailMsgId) {
        return this.provUtil.writeLog(0, msgId, detailMsgId, null, null, null, null);
    }

    protected String logSuccess(String msgId, String detailMsgId, String arg1) {
        return this.provUtil.writeLog(0, msgId, detailMsgId, arg1, null, null, null);
    }

    protected String logSuccess(String msgId, String detailMsgId, String arg1, String arg2) {
        return this.provUtil.writeLog(0, msgId, detailMsgId, arg1, arg2, null, null);
    }

    protected String logWarning(String msgId) {
        return this.provUtil.writeLog(1, msgId, msgId, null, null, null, null);
    }

    protected String logWarning(String msgId, String detailMsgId) {
        return this.provUtil.writeLog(1, msgId, detailMsgId, null, null, null, null);
    }

    protected String logWarning(String msgId, String detailMsgId, String arg1) {
        return this.provUtil.writeLog(1, msgId, detailMsgId, arg1, null, null, null);
    }

    protected String logWarning(String msgId, String detailMsgId, String arg1, String arg2) {
        return this.provUtil.writeLog(1, msgId, detailMsgId, arg1, arg2, null, null);
    }

    protected String logError(String msgId, String detailMsgId, String arg1, String arg2, String arg3) {
        return this.provUtil.writeLog(2, msgId, detailMsgId, arg1, arg2, arg3, null);
    }

    protected String logError(String msgId, String detailMsgId, String arg1, String arg2) {
        return this.provUtil.writeLog(2, msgId, detailMsgId, arg1, arg2, null, null);
    }

    protected String logError(String msgId, String detailMsgId, String arg1) {
        return this.provUtil.writeLog(2, msgId, detailMsgId, arg1, null, null, null);
    }

    protected String logError(String msgId, String detailMsgId) {
        return this.provUtil.writeLog(2, msgId, detailMsgId, null, null, null, null);
    }

    protected void logErrorAndThrow(String msgId, String detailMsgId, String arg1, String arg2, String arg3) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, msgId, detailMsgId, arg1, arg2, arg3, null));
    }

    protected void logErrorAndThrow(String msgId, String detailMsgId, String arg1, String arg2) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, msgId, detailMsgId, arg1, arg2, null, null));
    }

    protected void logErrorAndThrow(String msgId, String detailMsgId, String arg1) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, msgId, detailMsgId, arg1, null, null, null));
    }

    protected void logErrorAndThrow(String msgId, String detailMsgId) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, msgId, detailMsgId, null, null, null, null));
    }
}

