/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.audit.AuditEvent_scheduledjob_add;
import com.sun.audit.AuditEvent_scheduledjob_delete;
import com.sun.audit.AuditEvent_scheduledjob_modify;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.solarisprovider.scheduledjob.Crontab;
import com.sun.wbem.solarisprovider.scheduledjob.CrontabEntries;
import com.sun.wbem.solarisprovider.scheduledjob.ScheduledJobProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_ScheduledJob_Cron
extends ScheduledJobProvider
implements Authorizable {
    private static String CRON_JOB_SCHEDULER_NAME = "Cron";
    private static String CRON_JOB_TYPE = "Cron";
    private static String FIELDNAME_JOB_STATUS = "JobStatus";
    private static String FIELDNAME_TIME_SUBMITTED = "TimeSubmitted";
    private static String FIELDNAME_ELAPSED_TIME = "ElapsedTime";
    private static String FIELDNAME_UNTIL_TIME = "UntilTime";
    private static String FIELDNAME_NOTIFY = "Notify";
    private static String FIELDNAME_OWNER = "Owner";
    private static String FIELDNAME_PRIORITY = "Priority";
    private static String FIELDNAME_OWNING_JOB_SCHEDULER_NAME = "OwningJobSchedulerName";
    private static String FIELDNAME_JOB_TYPE = "JobType";
    private static String FIELDNAME_NAME = "Name";
    private static String FIELDNAME_COMMAND = "Command";
    private static String FIELDNAME_HOURS = "Hours";
    private static String FIELDNAME_MINUTES = "Minutes";
    private static String FIELDNAME_DAYS_OF_THE_WEEK = "DaysOfTheWeek";
    private static String FIELDNAME_DAYS_OF_THE_MONTH = "DaysOfTheMonth";
    private static String FIELDNAME_MONTHS = "Months";
    protected String providerName = "Solaris_ScheduledJob_Cron";

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        String requiredAuth = null;
        String owner = (String)ci.getProperty(FIELDNAME_OWNER).getValue().getValue();
        if (owner == null) {
            this.logErrorAndThrow("LM_7650", "LM_7651");
        }
        requiredAuth = this.checkJobModifyRights(owner, op);
        Crontab crontab = new Crontab(this);
        CrontabEntries entry = this.cimToCrontabEntry(owner, ci);
        crontab.initialize();
        crontab.addEntry(entry);
        CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
        cop.addKey(FIELDNAME_OWNER, new CIMValue((Object)entry.getOwner(1)));
        cop.addKey(FIELDNAME_NAME, new CIMValue((Object)entry.getName(1)));
        this.logSuccess("LM_7500", "LM_7501", entry.getName(1), entry.getOwner(1));
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace3((String)"Solaris_ScheduledJob_Cron createInstance() : null WbemAuditSession.");
                return cop;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"Solaris_ScheduledJob_Cron createInstance() : null platform AuditSession.");
                return cop;
            }
            AuditEvent_scheduledjob_add cronAddEvent = new AuditEvent_scheduledjob_add(auditSession);
            if (cronAddEvent == null) {
                Debug.trace3((String)"Solaris_ScheduledJob_Cron createInstance() : null AuditEvent_scheduledjob_add.");
                return cop;
            }
            String propertyToken = this.provUtil.formatAuditToken(ci);
            String scope = this.provUtil.getMgmtScope(op);
            cronAddEvent.object_name(op.getObjectName());
            cronAddEvent.domain(this.provUtil.getDomainToken(scope));
            cronAddEvent.name_service(this.provUtil.getNameServiceToken(scope));
            cronAddEvent.auth_used(requiredAuth);
            cronAddEvent.initial_values(propertyToken);
            cronAddEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace3((String)"Solaris_ScheduledJob_Cron createInstance() : Auditing threw exception", (Throwable)ex);
            return cop;
        }
        return cop;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        String requiredAuth = null;
        String name = null;
        String owner = null;
        CrontabEntries modEntry = null;
        Crontab crontab = new Crontab(this);
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(FIELDNAME_OWNER)) {
                owner = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(FIELDNAME_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (name == null) {
            this.logErrorAndThrow("LM_7652", "LM_7654");
        }
        if (owner == null) {
            this.logErrorAndThrow("LM_7652", "LM_7653");
        }
        requiredAuth = this.checkJobModifyRights(owner, op);
        String modOwner = (String)ci.getProperty(FIELDNAME_OWNER).getValue().getValue();
        if (modOwner == null) {
            modOwner = owner;
        }
        if (modOwner.compareTo(owner) != 0) {
            this.logErrorAndThrow("LM_7652", "LM_7655", owner, modOwner);
        }
        modEntry = this.cimToCrontabEntry(modOwner, ci);
        crontab.initialize();
        crontab.modifyEntry(owner, name, modEntry);
        this.logSuccess("LM_7504", "LM_7505", name, owner);
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace3((String)"Solaris_ScheduledJob_Cron setInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"Solaris_ScheduledJob_Cron setInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_scheduledjob_modify cronModEvent = new AuditEvent_scheduledjob_modify(auditSession);
            if (cronModEvent == null) {
                Debug.trace3((String)"Solaris_ScheduledJob_Cron setInstance() : null AuditEvent_scheduledjob_modify.");
                return;
            }
            String propertyToken = this.provUtil.formatAuditToken(ci);
            String scope = this.provUtil.getMgmtScope(op);
            cronModEvent.object_name(op.getObjectName());
            cronModEvent.domain(this.provUtil.getDomainToken(scope));
            cronModEvent.name_service(this.provUtil.getNameServiceToken(scope));
            cronModEvent.auth_used(requiredAuth);
            cronModEvent.changed_values(propertyToken);
            cronModEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace3((String)"Solaris_ScheduledJob_Cron setInstance() : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        String requiredAuth = null;
        String name = null;
        String owner = null;
        Crontab crontab = new Crontab(this);
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(FIELDNAME_OWNER)) {
                owner = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(FIELDNAME_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (name == null) {
            this.logErrorAndThrow("LM_7656", "LM_7657");
        }
        if (owner == null) {
            this.logErrorAndThrow("LM_7656", "LM_7658");
        }
        requiredAuth = this.checkJobModifyRights(owner, op);
        crontab.initialize();
        crontab.deleteEntry(owner, name);
        this.logSuccess("LM_7502", "LM_7503", name, owner);
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace3((String)"Solaris_ScheduledJob_Cron deleteInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"Solaris_ScheduledJob_Cron deleteInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_scheduledjob_delete cronDelEvent = new AuditEvent_scheduledjob_delete(auditSession);
            if (cronDelEvent == null) {
                Debug.trace3((String)"Solaris_ScheduledJob_Cron deleteInstance() : null AuditEvent_scheduledjob_delete.");
                return;
            }
            String scope = this.provUtil.getMgmtScope(op);
            cronDelEvent.object_name(op.getObjectName());
            cronDelEvent.domain(this.provUtil.getDomainToken(scope));
            cronDelEvent.name_service(this.provUtil.getNameServiceToken(scope));
            cronDelEvent.auth_used(requiredAuth);
            String delValue = "job=" + name + ";owner=" + owner;
            cronDelEvent.delete_values(delValue);
            cronDelEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace3((String)"Solaris_ScheduledJob_Cron deleteInstance() : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        String owner = this.checkJobViewRights(op);
        Object name = null;
        Crontab crontab = new Crontab(this);
        CrontabEntries entries = null;
        Vector<CIMObjectPath> allEntryInstances = new Vector<CIMObjectPath>();
        crontab.initialize();
        entries = owner == null ? crontab.getAllEntries(true) : crontab.getEntriesByOwner(owner, true, false);
        if (entries == null) {
            return null;
        }
        for (int i = 1; i <= entries.getNumberOfEntries(); ++i) {
            CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            cop.addKey(FIELDNAME_OWNING_JOB_SCHEDULER_NAME, new CIMValue((Object)CRON_JOB_SCHEDULER_NAME));
            cop.addKey(FIELDNAME_JOB_TYPE, new CIMValue((Object)CRON_JOB_TYPE));
            cop.addKey(FIELDNAME_OWNER, new CIMValue((Object)entries.getOwner(i)));
            cop.addKey(FIELDNAME_NAME, new CIMValue((Object)entries.getName(i)));
            allEntryInstances.addElement(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[allEntryInstances.size()];
        allEntryInstances.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String owner = this.checkJobViewRights(op);
        Object name = null;
        Crontab crontab = new Crontab(this);
        CrontabEntries entries = null;
        Vector<CIMInstance> allEntryInstances = new Vector<CIMInstance>();
        crontab.initialize();
        entries = owner == null ? crontab.getAllEntries(false) : crontab.getEntriesByOwner(owner, false, false);
        if (entries == null) {
            return null;
        }
        for (int i = 1; i <= entries.getNumberOfEntries(); ++i) {
            CIMInstance ci = this.crontabEntryToCim(entries, i, cc, localOnly);
            allEntryInstances.addElement(ci);
        }
        CIMInstance[] ciArray = new CIMInstance[allEntryInstances.size()];
        allEntryInstances.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String name = null;
        String getOwner = null;
        Crontab crontab = new Crontab(this);
        CrontabEntries entry = null;
        String permittedOwner = this.checkJobViewRights(op);
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(FIELDNAME_OWNER)) {
                getOwner = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(FIELDNAME_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (name == null) {
            this.logErrorAndThrow("LM_7661", "LM_7662");
        }
        if (getOwner == null) {
            this.logErrorAndThrow("LM_7661", "LM_7663");
        }
        if (permittedOwner != null && getOwner.compareTo(permittedOwner) != 0) {
            this.logErrorAndThrow("LM_7661", "LM_7664", getOwner);
        }
        crontab.initialize();
        entry = crontab.getEntryByName(getOwner, name);
        if (entry == null) {
            this.logErrorAndThrow("LM_7661", "LM_7665", name, getOwner);
        }
        CIMInstance ci = this.crontabEntryToCim(entry, 1, cc, localOnly);
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        try {
            this.provUtil.checkAuthenticated();
        }
        catch (CIMException e) {
            this.logErrorAndThrow("LM_10600", "LM_10613");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] ciArray = this.enumerateInstances(op, true, false, false, null, cc);
            for (int i = 0; i < ciArray.length; ++i) {
                if (where != null && !where.apply((CIMElement)ciArray[i])) continue;
                result.addElement(attrs.apply((CIMElement)ciArray[i]));
            }
        }
        catch (CIMException e) {
            this.logErrorAndThrow("LM_10600", "LM_10640");
        }
        catch (Exception e) {
            this.logErrorAndThrow("LM_10600", "LM_10640");
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }

    private CrontabEntries cimToCrontabEntry(String owner, CIMInstance ci) throws CIMException {
        CrontabEntries entry = new CrontabEntries(1);
        entry.setEntry(1, owner, (String)ci.getProperty(FIELDNAME_NAME).getValue().getValue(), (String)ci.getProperty(FIELDNAME_COMMAND).getValue().getValue(), (Vector)ci.getProperty(FIELDNAME_HOURS).getValue().getValue(), (Vector)ci.getProperty(FIELDNAME_MINUTES).getValue().getValue(), (Vector)ci.getProperty(FIELDNAME_DAYS_OF_THE_WEEK).getValue().getValue(), (Vector)ci.getProperty(FIELDNAME_DAYS_OF_THE_MONTH).getValue().getValue(), (Vector)ci.getProperty(FIELDNAME_MONTHS).getValue().getValue());
        return entry;
    }

    private CIMInstance crontabEntryToCim(CrontabEntries entry, int entryNum, CIMClass cc, boolean localOnly) throws CIMException {
        CIMInstance ci = null;
        ci = cc.newInstance();
        ci.setProperty(FIELDNAME_OWNING_JOB_SCHEDULER_NAME, new CIMValue((Object)CRON_JOB_SCHEDULER_NAME));
        ci.setProperty(FIELDNAME_JOB_TYPE, new CIMValue((Object)CRON_JOB_TYPE));
        ci.setProperty(FIELDNAME_OWNER, new CIMValue((Object)entry.getOwner(entryNum)));
        ci.setProperty(FIELDNAME_COMMAND, new CIMValue((Object)entry.getCommand(entryNum)));
        ci.setProperty(FIELDNAME_NAME, new CIMValue((Object)entry.getName(entryNum)));
        ci.setProperty(FIELDNAME_JOB_STATUS, new CIMValue((Object)entry.getJobStatus(entryNum)));
        ci.setProperty(FIELDNAME_HOURS, new CIMValue((Object)entry.getHoursAsVector(entryNum)));
        ci.setProperty(FIELDNAME_MINUTES, new CIMValue((Object)entry.getMinutesAsVector(entryNum)));
        ci.setProperty(FIELDNAME_DAYS_OF_THE_WEEK, new CIMValue((Object)entry.getDaysOfTheWeekAsVector(entryNum)));
        ci.setProperty(FIELDNAME_DAYS_OF_THE_MONTH, new CIMValue((Object)entry.getDaysOfTheMonthAsVector(entryNum)));
        ci.setProperty(FIELDNAME_MONTHS, new CIMValue((Object)entry.getMonthsAsVector(entryNum)));
        return ci;
    }
}

