/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.wbem.solarisprovider.serialport.SerialPortException;
import java.io.Serializable;

public class SerialPortData
implements Serializable,
Cloneable {
    public static final int NUM_FIELDS = 20;
    String portName = "";
    String portMonTag = "";
    String portMonType = "";
    String serviceTag = "";
    String portFlags = "";
    String identity = "";
    String reserve_1 = "";
    String reserve_2 = "";
    String reserve_3 = "";
    String deviceName = "";
    String ttyFlags = "";
    String countVal = "";
    String serviceCmdLine = "";
    String timeoutVal = "";
    String ttyLabel = "";
    String modules = "";
    String prompt = "";
    String disable = "";
    String terminalType = "";
    String softwareCarrier = "y";
    String comment = "";
    boolean noService = false;
    boolean enable = false;
    boolean deleted = false;
    String oldPortMonTag = "";
    String oldServiceTag = "";

    public SerialPortData(String portName) {
        this.portName = portName;
    }

    public void setDefaults(String portName) {
        this.setEnable(false);
        this.ttyLabel = "9600";
        this.terminalType = "tvi925";
        this.setTTYFlags(false, true, false);
        this.setSoftwareCarrier(false);
        this.prompt = "tty" + portName + " login:";
        this.comment = "";
        this.setPortFlags(true);
        this.setDisableFlag();
        this.setServiceTag("tty" + portName);
        this.setPortMonTag("zsmon");
        this.portMonType = "ttymon";
        this.setModules("ldterm,ttcompat");
        this.setDeviceName("/dev/term/" + portName);
        this.setServiceCmdLine("/usr/bin/login");
        this.setTimeoutVal("30");
    }

    public void fillData(String[] values) {
        this.oldPortMonTag = this.portMonTag = values[0];
        this.portMonType = values[1];
        this.oldServiceTag = this.serviceTag = values[2];
        this.portFlags = values[3];
        this.identity = values[4];
        this.reserve_1 = values[5];
        this.reserve_2 = values[6];
        this.reserve_3 = values[7];
        this.deviceName = values[8];
        this.ttyFlags = values[9];
        this.countVal = values[10];
        this.serviceCmdLine = values[11];
        this.timeoutVal = values[12];
        this.ttyLabel = values[13];
        this.modules = values[14];
        this.prompt = values[15];
        this.disable = values[16];
        this.terminalType = values[17];
        this.softwareCarrier = values[18];
        this.comment = values[19];
        if (this.comment.compareTo("#") == 0) {
            this.comment = "";
        }
        if (this.portFlags.indexOf("x") >= 0) {
            this.setNoService();
        } else {
            this.setService();
            this.setEnable(true);
        }
    }

    public String getPortMonTag() {
        return this.portMonTag;
    }

    public String getOldPortMonTag() {
        return this.oldPortMonTag;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        if (portName != null) {
            this.portName = portName;
        }
    }

    public String getServiceTag() {
        return this.serviceTag;
    }

    public String getOldServiceTag() {
        return this.oldServiceTag;
    }

    public void setOldServiceTag(String serviceTag) {
        if (serviceTag != null) {
            this.oldServiceTag = serviceTag;
        }
    }

    public void setOldPortMonTag(String portMonTag) {
        if (portMonTag != null) {
            this.oldPortMonTag = portMonTag;
        }
    }

    public void setPortMonTag(String portMonTag) {
        if (portMonTag != null) {
            this.oldPortMonTag = this.portMonTag;
            this.portMonTag = portMonTag;
        }
    }

    public void setServiceTag(String serviceTag) {
        if (serviceTag != null) {
            this.oldServiceTag = this.serviceTag;
            this.serviceTag = serviceTag;
        }
    }

    public void setEnable(boolean val) {
        this.enable = val;
    }

    public boolean isEnableSet() {
        return this.enable;
    }

    public void setDeleted() {
        this.deleted = true;
    }

    public void setNotDeleted() {
        this.deleted = false;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        if (deviceName != null) {
            this.deviceName = deviceName;
        }
    }

    public String getTTYLabel() {
        return this.ttyLabel;
    }

    public void setTTYLabel(String label) {
        if (label != null) {
            this.ttyLabel = label;
        }
    }

    public String getServiceCmdLine() {
        return this.serviceCmdLine;
    }

    public void setServiceCmdLine(String serviceCmdLine) {
        if (serviceCmdLine != null) {
            String actualCmdLine;
            String svc = serviceCmdLine.trim();
            this.serviceCmdLine = svc.indexOf(" ") > 0 && svc.indexOf(" ") < svc.length() ? (actualCmdLine = "\"" + svc + "\"") : svc;
        }
    }

    public String getTTYFlags() {
        return this.ttyFlags;
    }

    public void setTTYFlags(boolean initialize, boolean bidirectional, boolean connectOnCarrier) {
        this.ttyFlags = "";
        if (initialize) {
            this.ttyFlags = this.ttyFlags + "I";
        }
        if (bidirectional) {
            this.ttyFlags = this.ttyFlags + "b";
        }
        if (connectOnCarrier) {
            this.ttyFlags = this.ttyFlags + "c";
        }
    }

    public boolean isInitializeSet() {
        return this.ttyFlags.indexOf(73) >= 0;
    }

    public void setInitialize(boolean initialize) {
        if (initialize) {
            if (this.isInitializeSet()) {
                return;
            }
            this.ttyFlags = this.ttyFlags + "I";
        } else {
            if (!this.isInitializeSet()) {
                return;
            }
            int index = this.ttyFlags.indexOf(73);
            String s = this.ttyFlags.substring(0, index);
            if (index < this.ttyFlags.length() - 1) {
                s = s + this.ttyFlags.substring(index + 1);
            }
            this.ttyFlags = s;
        }
    }

    public boolean isBidirectionalSet() {
        return this.ttyFlags.indexOf(98) >= 0;
    }

    public void setBidirectional(boolean bidirectional) {
        if (bidirectional) {
            if (this.isBidirectionalSet()) {
                return;
            }
            this.ttyFlags = this.ttyFlags + "b";
        } else {
            if (!this.isBidirectionalSet()) {
                return;
            }
            int index = this.ttyFlags.indexOf(98);
            String s = this.ttyFlags.substring(0, index);
            if (index < this.ttyFlags.length() - 1) {
                s = s + this.ttyFlags.substring(index + 1);
            }
            this.ttyFlags = s;
        }
    }

    public boolean isConnectOnCarrierSet() {
        return this.ttyFlags.indexOf(99) >= 0;
    }

    public void setConnectOnCarrier(boolean connectOnCarrier) {
        if (connectOnCarrier) {
            if (this.isConnectOnCarrierSet()) {
                return;
            }
            this.ttyFlags = this.ttyFlags + "c";
        } else {
            if (!this.isConnectOnCarrierSet()) {
                return;
            }
            int index = this.ttyFlags.indexOf(99);
            String s = this.ttyFlags.substring(0, index);
            if (index < this.ttyFlags.length() - 1) {
                s = s + this.ttyFlags.substring(index + 1);
            }
            this.ttyFlags = s;
        }
    }

    public String getModules() {
        return this.modules;
    }

    public void setModules(String modules) {
        if (modules != null) {
            this.modules = modules;
        }
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        if (prompt != null) {
            this.prompt = prompt;
        }
    }

    public String getTimeoutVal() {
        return this.timeoutVal;
    }

    public void setTimeoutVal(String timeoutVal) {
        if (timeoutVal == null) {
            return;
        }
        if (timeoutVal.equalsIgnoreCase("never")) {
            timeoutVal = "";
        } else {
            this.timeoutVal = timeoutVal;
        }
    }

    public String getSoftwareCarrier() {
        return this.softwareCarrier;
    }

    public boolean isSoftwareCarrier() {
        return this.softwareCarrier.equalsIgnoreCase("y");
    }

    public void setSoftwareCarrier(boolean carrier) {
        this.softwareCarrier = carrier ? "y" : "n";
    }

    public String getTerminalType() {
        return this.terminalType;
    }

    public void setTerminalType(String terminalType) {
        if (terminalType != null) {
            this.terminalType = terminalType;
        }
    }

    public String getIdentity() {
        if (this.identity == null || this.identity.length() == 0) {
            return "root";
        }
        return this.identity;
    }

    public void setIdentity(String identity) {
        if (identity != null) {
            this.identity = identity;
        }
    }

    public String getPortFlags() {
        return this.portFlags;
    }

    public void setPortFlags(boolean portFlag) {
        if (portFlag && this.portFlags.indexOf("u") < 0) {
            this.portFlags = this.portFlags + "u";
        }
    }

    public boolean isUTMPSet() {
        return this.portFlags.indexOf("u") < 0;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (comment != null) {
            this.comment = comment;
        }
    }

    public boolean isEqualTo(SerialPortData data) {
        return this.portName.equalsIgnoreCase(data.getPortName()) && this.portMonTag.equalsIgnoreCase(data.getPortMonTag()) && this.serviceTag.equalsIgnoreCase(data.getServiceTag()) && this.portFlags.equalsIgnoreCase(data.getPortFlags()) && this.ttyFlags.equalsIgnoreCase(data.getTTYFlags()) && this.serviceCmdLine.equalsIgnoreCase(data.getServiceCmdLine()) && this.timeoutVal.equalsIgnoreCase(data.getTimeoutVal()) && this.ttyLabel.equalsIgnoreCase(data.getTTYLabel()) && this.modules.equalsIgnoreCase(data.getModules()) && this.prompt.equalsIgnoreCase(data.getPrompt()) && this.terminalType.equalsIgnoreCase(data.getTerminalType()) && this.softwareCarrier.equalsIgnoreCase(data.getSoftwareCarrier()) && this.comment.equalsIgnoreCase(data.getComment());
    }

    public void validateModules() throws SerialPortException {
        String mods;
        if (this.modules != null && (mods = this.modules.trim()).indexOf(" ") > 0) {
            throw new SerialPortException("EXM_DAT_MOD");
        }
    }

    public void validateTerminalType() throws SerialPortException {
    }

    public void validateComment() throws SerialPortException {
    }

    public void validateTTYLabel() throws SerialPortException {
    }

    public void validatePrompt() throws SerialPortException {
    }

    public void validatePortMonitorTag() throws SerialPortException {
        this.portMonTag.trim();
        if (this.portMonTag.length() == 0) {
            throw new SerialPortException("EXM_DAT_PMTAG");
        }
    }

    public void validateTimeout() throws SerialPortException {
    }

    public void validateServiceCmdLine() throws SerialPortException {
        this.serviceCmdLine.trim();
        if (this.serviceCmdLine.length() == 0) {
            throw new SerialPortException("EXM_DAT_SVCCMDLINE");
        }
    }

    public void tweakPortFlags() {
        int i = this.portFlags.indexOf("x");
        if (i < 0) {
            return;
        }
        this.portFlags = i == 0 ? (this.portFlags.length() > 1 ? "u" : "") : "u";
    }

    public void setDisableFlag() {
        if (this.portFlags.indexOf("x") < 0) {
            this.portFlags = this.portFlags + "x";
        }
    }

    public void setNoService() {
        this.noService = true;
    }

    public void setService() {
        this.noService = false;
    }

    public boolean isThereNoService() {
        return this.noService;
    }

    public String toString() {
        String retStr = "\n\t";
        retStr = retStr + "Port Name: " + this.portName + "\n\t";
        retStr = retStr + "Port Monitor Tag: " + this.portMonTag + "\n\t";
        retStr = retStr + "Port Monitor Type: " + this.portMonType + "\n\t";
        retStr = retStr + "Service Tag: " + this.serviceTag + "\n\t";
        retStr = retStr + "Port Flags: " + this.portFlags + "\n\t";
        retStr = retStr + "Identity: " + this.identity + "\n\t";
        retStr = retStr + "Reserved Field 1: " + this.reserve_1 + "\n\t";
        retStr = retStr + "Reserve Field 2: " + this.reserve_2 + "\n\t";
        retStr = retStr + "Reserve Field 3: " + this.reserve_3 + "\n\t";
        retStr = retStr + "Device Name: " + this.deviceName + "\n\t";
        retStr = retStr + "tty Flags : " + this.ttyFlags + "\n\t";
        retStr = retStr + "Count Value : " + this.countVal + "\n\t";
        retStr = retStr + "Service Command Line : " + this.serviceCmdLine + "\n\t";
        retStr = retStr + "Timeout Value : " + this.timeoutVal + "\n\t";
        retStr = retStr + "tty label : " + this.ttyLabel + "\n\t";
        retStr = retStr + "Modules : " + this.modules + "\n\t";
        retStr = retStr + "Prompt : " + this.prompt + "\n\t";
        retStr = retStr + "Disable : " + this.disable + "\n\t";
        retStr = retStr + "Terminal type : " + this.terminalType + "\n\t";
        retStr = retStr + "Software Carrier : " + this.softwareCarrier + "\n\t";
        retStr = retStr + "Comment: " + this.comment + "\n";
        return retStr;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

