/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.wbem.solarisprovider.serialport.SerialPortData;
import com.sun.wbem.solarisprovider.serialport.SerialPortException;
import com.sun.wbem.solarisprovider.serialport.Solaris_SerialNative;
import com.sun.wbem.solarisprovider.serialport.TokenString;
import com.sun.wbem.utility.log.LogUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class SerialPortInfo {
    public static final String DEFAULT_PMADM_PATH = "/usr/sbin/pmadm";
    public static final String DEFAULT_SACADM_PATH = "/usr/sbin/sacadm";
    public static final String DEFAULT_TTYADM_PATH = "/usr/sbin/ttyadm";
    public static final String DEFAULT_DEVTERM_DIR = "/dev/term";
    public static final String DEFAULT_ARCHITECTURE = "sparc";
    public static final String DEFAULT_TTYDEFS_FILE = "/etc/ttydefs";
    public static final String PROVIDER_NAME = "SerialPort";
    private static final int PM_NOTEXIST = 0;
    private static final int PM_ENABLED = 1;
    private static final int PM_DISABLED = 2;
    private static final int PM_STARTING = 3;
    private static final int PM_FAILED = 4;
    private String pmadm_path = "/usr/sbin/pmadm";
    private String sacadm_path = "/usr/sbin/sacadm";
    private String ttyadm_path = "/usr/sbin/ttyadm";
    private String devterm_dir = "/dev/term";
    private String alternate_device_dirs = null;
    private String architecture = "sparc";
    private String ttydefs_file = "/etc/ttydefs";
    Hashtable allPortData = new Hashtable();
    Vector dataObjectVector = new Vector();
    LogUtil logUtil = null;

    public SerialPortInfo(LogUtil util) {
        this.logUtil = util;
    }

    private void fillData(Vector portData) {
        for (int i = 0; i < portData.size(); ++i) {
            this.allPortData.put(((SerialPortData)portData.elementAt(i)).getPortName(), (SerialPortData)portData.elementAt(i));
        }
    }

    public String getPortName(int i) {
        if (this.dataObjectVector.size() > 0) {
            SerialPortData dat = (SerialPortData)this.dataObjectVector.elementAt(i);
            return dat.getPortName();
        }
        return null;
    }

    public String getPortMonTag(String portName) {
        SerialPortData dat = (SerialPortData)this.allPortData.get(portName);
        return dat.getPortMonTag();
    }

    public String getServiceTag(String portName) {
        SerialPortData dat = (SerialPortData)this.allPortData.get(portName);
        return dat.getServiceTag();
    }

    public String getDescription(String portName) {
        SerialPortData dat = (SerialPortData)this.allPortData.get(portName);
        return dat.getComment();
    }

    public int getnumPorts() {
        return this.dataObjectVector.size();
    }

    public int initData() throws SerialPortException {
        Vector devterm_files = null;
        Vector pmadm_strings = null;
        if (this.dataObjectVector.size() > 0) {
            this.dataObjectVector.removeAllElements();
        }
        if (!this.allPortData.isEmpty()) {
            this.allPortData.clear();
        }
        if ((devterm_files = this.readDirs()) == null) {
            try {
                String label = this.logUtil.getMessage("LM_LABEL_SERIAL_DEV_DIR");
                String logdata = label + ": " + this.devterm_dir + "\n" + this.logUtil.getMessage("LM_LABEL_SERIAL_ALT_DEV_DIR") + ": " + this.alternate_device_dirs;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5002", "LM_5003", null, logdata, false, 0, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SerialPortException("EXM_NODEV_SRV");
        }
        pmadm_strings = this.listSerialDevices();
        this.constructData(devterm_files, pmadm_strings);
        return this.dataObjectVector.size();
    }

    private Vector readDirs() throws SerialPortException {
        int device_count = 0;
        Vector alt_dirs = this.parseDirString(this.alternate_device_dirs);
        Vector<String> devices = new Vector<String>();
        boolean exception_occured = false;
        File dev_dir = null;
        try {
            dev_dir = new File(this.devterm_dir);
        }
        catch (SecurityException e) {
            try {
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5012", null, "", false, 0, 1);
            }
            catch (Exception ex) {
                // empty catch block
            }
            exception_occured = true;
        }
        try {
            String[] entries;
            if (dev_dir.exists() && dev_dir.isDirectory() && (entries = dev_dir.list()) != null && entries.length > 0) {
                for (int i = 0; i < entries.length; ++i) {
                    String entry = this.devterm_dir + File.separator + entries[i];
                    devices.addElement(entry);
                    ++device_count;
                }
            }
        }
        catch (SecurityException e) {
            try {
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5012", null, "", false, 0, 1);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String[] args = new String[]{this.devterm_dir};
            exception_occured = true;
        }
        if (alt_dirs != null && alt_dirs.size() > 0) {
            for (int i = 0; i < alt_dirs.size(); ++i) {
                try {
                    String[] entries;
                    String alt_dir_name = (String)alt_dirs.elementAt(i);
                    File alt_dev_dir = new File(alt_dir_name);
                    if (!alt_dev_dir.exists() || !alt_dev_dir.isDirectory() || (entries = alt_dev_dir.list()) == null || entries.length <= 0) continue;
                    for (int j = 0; j < entries.length; ++j) {
                        String entry = alt_dir_name + File.separator + entries[i];
                        devices.addElement(entry);
                        ++device_count;
                    }
                    continue;
                }
                catch (SecurityException e) {
                    try {
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5012", null, "", false, 0, 1);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    exception_occured = true;
                }
            }
        }
        if (device_count == 0 && exception_occured) {
            throw new SerialPortException("EXM_SEC_SRV");
        }
        if (device_count == 0) {
            return null;
        }
        return devices;
    }

    private Vector parseDirString(String alternate_dirs) {
        Vector<String> alt_dirs = new Vector<String>();
        String temp_dir = null;
        int dir_count = 0;
        if (alternate_dirs == null || alternate_dirs.length() == 0) {
            return null;
        }
        temp_dir = TokenString.getToken(alternate_dirs, ":");
        while (temp_dir != null) {
            alt_dirs.addElement(temp_dir);
            ++dir_count;
            temp_dir = TokenString.getToken(null, ":");
        }
        if (dir_count == 0) {
            return null;
        }
        return alt_dirs;
    }

    private Vector listSerialDevices() throws SerialPortException {
        String line;
        String command_str = this.pmadm_path + " -L -t ttymon";
        Vector<String> portInfoStrings = new Vector<String>();
        Process p = null;
        Runtime runtime = null;
        InputStream is = null;
        runtime = Runtime.getRuntime();
        try {
            p = runtime.exec(command_str);
        }
        catch (IOException e) {
            try {
                String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String logdata = label + ": " + command_str;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5023", "LM_5024", null, logdata, true, 0, 2);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new SerialPortException("EXM_IO_SRV");
        }
        catch (SecurityException e) {
            try {
                String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String logdata = label + ": " + command_str;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5007", null, logdata, true, 0, 2);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new SerialPortException("EXM_SEC_SRV");
        }
        int b = 0;
        int num = 0;
        StringBuffer sb = new StringBuffer();
        try {
            is = p.getInputStream();
            while ((b = is.read()) > 0) {
                sb.append((char)b);
                ++num;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (num == 0) {
            InputStream err = null;
            StringBuffer err_buf = new StringBuffer();
            try {
                err = p.getErrorStream();
                while ((b = is.read()) > 0) {
                    err_buf.append((char)b);
                    ++num;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (num == 0) {
                try {
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5008", "LM_5009", null, "", false, 0, 2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return null;
            }
            String error_str = new String(err_buf);
            return null;
        }
        String output = new String(sb);
        num = output.indexOf("\n");
        int fromIndex = 0;
        int toIndex = 0;
        while (num != -1) {
            toIndex = num;
            line = output.substring(fromIndex, toIndex);
            if (line.length() > 0) {
                portInfoStrings.addElement(line);
            }
            if ((fromIndex = toIndex + 1) >= output.length()) break;
            num = output.indexOf("\n", fromIndex);
        }
        if (fromIndex < output.length() && (line = output.substring(fromIndex)).length() > 0) {
            portInfoStrings.addElement(line);
        }
        return portInfoStrings;
    }

    private void constructData(Vector files, Vector ports) {
        String portName = null;
        File check_file = null;
        for (int i = 0; i < files.size(); ++i) {
            int found = 0;
            String fileStr = (String)files.elementAt(i);
            if (fileStr == null || fileStr.length() <= 0) continue;
            for (int j = 0; ports != null && j < ports.size(); ++j) {
                String portStr;
                block12: {
                    String[] args;
                    portStr = (String)ports.elementAt(j);
                    if (portStr == null || portStr.length() <= 0) continue;
                    try {
                        check_file = new File(fileStr);
                    }
                    catch (Exception e) {
                        try {
                            args = new String[]{fileStr};
                            this.logUtil.writeLog(PROVIDER_NAME, "LM_5004", "LM_5005", args, "", false, 0, 1);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        found = -1;
                        break;
                    }
                    try {
                        if (check_file != null && check_file.exists()) break block12;
                        try {
                            String[] args2 = new String[]{fileStr};
                            this.logUtil.writeLog(PROVIDER_NAME, "LM_5004", "LM_5005", args2, "", false, 0, 1);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        found = -1;
                    }
                    catch (Exception e) {
                        try {
                            args = new String[]{fileStr};
                            this.logUtil.writeLog(PROVIDER_NAME, "LM_5004", "LM_5005", args, "", false, 0, 1);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        found = -1;
                    }
                    break;
                }
                found = this.parseAdmString(fileStr, portStr);
                if (found > 0) break;
            }
            if (found == -1 || found != 0) continue;
            int slash_index = fileStr.lastIndexOf("/");
            portName = slash_index >= 0 ? fileStr.substring(slash_index + 1) : fileStr;
            SerialPortData ser_data = new SerialPortData(portName);
            ser_data.setDefaults(portName);
            ser_data.setDeleted();
            ser_data.setDeviceName(fileStr);
            this.dataObjectVector.addElement(ser_data);
            this.allPortData.put(portName, ser_data);
        }
    }

    private int parseAdmString(String fileStr, String portStr) {
        String temp_result;
        String portName;
        String[] result;
        block9: {
            if (portStr.indexOf(fileStr + ":") < 0) {
                return 0;
            }
            result = new String[20];
            for (int j = 0; j < 20; ++j) {
                result[j] = "";
            }
            int slash_index = fileStr.lastIndexOf("/");
            portName = slash_index >= 0 ? fileStr.substring(slash_index + 1) : fileStr;
            String temp_str = TokenString.getToken(portStr, ":");
            for (int i = 0; temp_str != null && i < 19; ++i) {
                int j;
                result[i] = temp_str;
                temp_str = TokenString.getToken(null, ":");
                if (temp_str == null || (j = result[i].lastIndexOf("\\")) <= 0 || j != result[i].length() - 1) continue;
                temp_result = result[i].substring(0, j);
                result[i] = temp_result = temp_result.concat(":");
                int n = i;
                result[n] = result[n] + temp_str;
                temp_str = TokenString.getToken(null, ":");
            }
            result[19] = temp_str;
            String rem_str = TokenString.getWhatRemains();
            if (rem_str != null) {
                result[19] = result[19] + ":" + rem_str;
            }
            if (result[8] != null && result[8].length() != 0) {
                try {
                    if (Solaris_SerialNative.doStat(result[8]) >= 0) break block9;
                    try {
                        String[] args = new String[]{result[8]};
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5013", "LM_5014", args, "", true, 0, 2);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    return 0;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        result[19] = result[19] != null && result[19].length() > 1 ? (temp_result = result[19].substring(1)) : "";
        SerialPortData ser_data = new SerialPortData(portName);
        ser_data.fillData(result);
        this.dataObjectVector.addElement(ser_data);
        this.allPortData.put(portName, ser_data);
        return 1;
    }

    public SerialPortData getPortData(String port_name) throws SerialPortException {
        SerialPortData ret_dat = null;
        ret_dat = (SerialPortData)this.allPortData.get(port_name);
        if (ret_dat == null) {
            throw new SerialPortException("Null data");
        }
        return ret_dat;
    }

    public SerialPortData getPortData(int i) throws SerialPortException {
        SerialPortData ret_dat = null;
        ret_dat = (SerialPortData)this.dataObjectVector.elementAt(i);
        if (ret_dat == null) {
            throw new SerialPortException("Null data");
        }
        return ret_dat;
    }

    public synchronized void synchronizedSetPortInfo(String portName, SerialPortData data, boolean diffFlag) throws SerialPortException {
        String[] args;
        String port;
        String failure_str;
        boolean sacadm_cmd_failed;
        block68: {
            if (data == null) {
                throw new SerialPortException("EXM_NULL_DATA_SRV");
            }
            sacadm_cmd_failed = false;
            failure_str = "";
            port = data.getDeviceName();
            try {
                if (Solaris_SerialNative.isConsole(port) <= 0) break block68;
                try {
                    String[] args2 = new String[]{port};
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5028", "LM_5029", args2, "", false, 0, 1);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_CONSOLE_SRV", port);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!data.isEnableSet() && !diffFlag) {
            String[] cmd_args = new String[6];
            String command_str = this.pmadm_path + " -d -p " + data.getPortMonTag() + "  -s " + data.getServiceTag();
            cmd_args[0] = this.pmadm_path;
            cmd_args[1] = "-d";
            cmd_args[2] = "-p";
            cmd_args[3] = data.getPortMonTag();
            cmd_args[4] = "-s";
            cmd_args[5] = data.getServiceTag();
            Vector result_vec = null;
            try {
                result_vec = this.runCommand(cmd_args);
            }
            catch (Exception e) {
                try {
                    String[] args3 = new String[]{data.getPortName()};
                    String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5056", "LM_5057", args3, label + ": " + command_str, true, 0, 2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_CMD_FAIL_SRV", command_str);
            }
            if (result_vec != null && result_vec.size() > 0) {
                String temp = (String)result_vec.elementAt(0);
                if (temp.compareTo("Error") == 0) {
                    try {
                        String[] args4 = new String[]{data.getPortName()};
                        String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                        String logdata = label + ": " + command_str;
                        for (int j = 1; j < result_vec.size(); ++j) {
                            logdata = logdata + " " + (String)result_vec.elementAt(j);
                        }
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5056", "LM_5057", args4, logdata, true, 0, 2);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", command_str);
                }
                try {
                    String[] args5 = new String[]{data.getPortName()};
                    String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String logdata = label + ": " + command_str;
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5058", "LM_5059", args5, logdata, false, 0, 0);
                }
                catch (Exception ex) {}
            } else {
                try {
                    String[] args6 = new String[]{data.getPortName()};
                    String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5056", "LM_5057", args6, label + ": " + command_str, true, 0, 2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_CMD_FAIL_SRV", command_str);
            }
            return;
        }
        try {
            switch (this.checkForPortmon(data.getPortMonTag())) {
                case -1: {
                    String version_str = "1";
                    try {
                        String temp_str;
                        String[] cmd_args = new String[]{this.ttyadm_path, "-V"};
                        Vector result_vec = this.runCommand(cmd_args);
                        if (result_vec != null && result_vec.size() > 0 && (temp_str = (String)result_vec.elementAt(0)).compareTo("Success") == 0) {
                            for (int i = 1; i < result_vec.size(); ++i) {
                                version_str = (String)result_vec.elementAt(i);
                            }
                        }
                    }
                    catch (SerialPortException x) {
                        // empty catch block
                    }
                    String cmd_str = this.sacadm_path + " -a -n 2 -p " + data.getPortMonTag() + "\t-t ttymon -c /usr/lib/saf/ttymon -v " + version_str + " -y \"Serial Ports\"";
                    try {
                        String[] cmd_args = new String[]{this.sacadm_path, "-a", "-n", "2", "-p", data.getPortMonTag(), "-t", "ttymon", "-c", "/usr/lib/saf/ttymon", "-v", version_str, "-y", "\"Serial Ports\""};
                        Vector result_vec = this.runCommand(cmd_args);
                        if (result_vec == null || result_vec.size() <= 0) break;
                        String temp = (String)result_vec.elementAt(0);
                        if (temp.compareTo("Error") == 0) {
                            String[] args7 = new String[]{portName};
                            try {
                                String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                String logdata = label + ": " + cmd_str;
                                for (int j = 1; j < result_vec.size(); ++j) {
                                    logdata = logdata + " " + (String)result_vec.elementAt(j);
                                }
                                this.logUtil.writeLog(PROVIDER_NAME, "LM_5030", "LM_5031", args7, logdata, true, 0, 2);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            sacadm_cmd_failed = true;
                            failure_str = cmd_str;
                            break;
                        }
                        String[] args8 = new String[]{portName};
                        try {
                            String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                            String logdata = label + ": " + cmd_str;
                            for (int j = 1; j < result_vec.size(); ++j) {
                                logdata = logdata + " " + (String)result_vec.elementAt(j);
                            }
                            this.logUtil.writeLog(PROVIDER_NAME, "LM_5032", "LM_5033", args8, logdata, false, 0, 0);
                        }
                        catch (Exception ex) {
                        }
                    }
                    catch (SerialPortException e) {
                        sacadm_cmd_failed = true;
                        failure_str = cmd_str;
                    }
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    String command_str = this.sacadm_path + " -e -p " + data.getPortMonTag();
                    try {
                        String[] cmd_args = new String[]{this.sacadm_path, "-e", "-p", data.getPortMonTag()};
                        Vector result_vec = this.runCommand(cmd_args);
                        if (result_vec == null || result_vec.size() <= 0) break;
                        String temp = (String)result_vec.elementAt(0);
                        if (temp.compareTo("Error") == 0) {
                            String[] args9 = new String[]{portName};
                            try {
                                String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                String logdata = label + ": " + command_str;
                                for (int j = 1; j < result_vec.size(); ++j) {
                                    logdata = logdata + " " + (String)result_vec.elementAt(j);
                                }
                                this.logUtil.writeLog(PROVIDER_NAME, "LM_5034", "LM_5035", args9, logdata, true, 0, 2);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            sacadm_cmd_failed = true;
                            break;
                        }
                        String[] args10 = new String[]{portName};
                        try {
                            String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                            String logdata = label + ": " + command_str;
                            for (int j = 1; j < result_vec.size(); ++j) {
                                logdata = logdata + " " + (String)result_vec.elementAt(j);
                            }
                            this.logUtil.writeLog(PROVIDER_NAME, "LM_5036", "LM_5037", args10, logdata, false, 0, 0);
                        }
                        catch (Exception ex) {
                        }
                    }
                    catch (SerialPortException e) {
                        sacadm_cmd_failed = true;
                        failure_str = command_str;
                    }
                    break;
                }
                case 4: {
                    String kick_start_str = this.sacadm_path + " -s -p " + data.getPortMonTag();
                    try {
                        String[] cmd_args = new String[]{this.sacadm_path, "-s", "-p", data.getPortMonTag()};
                        Vector result_vec = this.runCommand(cmd_args);
                        if (result_vec == null || result_vec.size() <= 0) break;
                        String temp = (String)result_vec.elementAt(0);
                        if (temp.compareTo("Error") == 0) {
                            String[] args11 = new String[]{portName};
                            try {
                                String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                String logdata = label + ": " + kick_start_str;
                                for (int j = 1; j < result_vec.size(); ++j) {
                                    logdata = logdata + " " + (String)result_vec.elementAt(j);
                                }
                                this.logUtil.writeLog(PROVIDER_NAME, "LM_5038", "LM_5039", args11, logdata, true, 0, 2);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            sacadm_cmd_failed = true;
                            break;
                        }
                        String[] args12 = new String[]{portName};
                        try {
                            String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                            String logdata = label + ": " + kick_start_str;
                            for (int j = 1; j < result_vec.size(); ++j) {
                                logdata = logdata + " " + (String)result_vec.elementAt(j);
                            }
                            this.logUtil.writeLog(PROVIDER_NAME, "LM_5040", "LM_5041", args12, logdata, false, 0, 0);
                        }
                        catch (Exception ex) {}
                        break;
                    }
                    catch (SerialPortException e) {
                        sacadm_cmd_failed = true;
                        failure_str = kick_start_str;
                    }
                }
            }
        }
        catch (SerialPortException e) {
            args = new String[]{portName};
            try {
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5042", "LM_5043", args, "", true, 0, 2);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (sacadm_cmd_failed) {
            throw new SerialPortException("EXM_SACADM_ERR_SRV", failure_str);
        }
        this.turn_on_port(data, diffFlag);
        int k = -1;
        k = Solaris_SerialNative.eepromSet(port);
        if (k < 0) {
            args = new String[]{data.getDeviceName()};
            try {
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5060", "LM_5061", args, "", true, 0, 2);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new SerialPortException("EXM_EEPROM_SRV");
        }
        args = new String[]{portName};
        try {
            String label = this.logUtil.getMessage("LM_LABEL_SERIAL_OLD_DATA");
            SerialPortData ser_data = (SerialPortData)this.allPortData.get(portName);
            this.logUtil.writeLog(PROVIDER_NAME, "LM_5062", "LM_5063", args, label + ": " + ser_data.toString(), false, 0, 0);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private Vector runCommand(String[] command_args) throws SerialPortException {
        String line;
        Vector<String> outputStrings = new Vector<String>();
        Process p = null;
        Runtime runtime = null;
        InputStream is = null;
        runtime = Runtime.getRuntime();
        try {
            p = runtime.exec(command_args);
        }
        catch (IOException e) {
            throw new SerialPortException("");
        }
        catch (SecurityException e) {
            throw new SerialPortException("EXM_SEC_SRV");
        }
        int b = 0;
        int num = 0;
        StringBuffer sb = new StringBuffer();
        try {
            is = p.getInputStream();
            while ((b = is.read()) > 0) {
                sb.append((char)b);
                ++num;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (num == 0) {
            String line2;
            InputStream err = null;
            StringBuffer err_buf = new StringBuffer();
            try {
                err = p.getErrorStream();
                while ((b = err.read()) > 0) {
                    err_buf.append((char)b);
                    ++num;
                }
            }
            catch (IOException e) {
                throw new SerialPortException("");
            }
            if (num == 0) {
                outputStrings.addElement("Success");
                return outputStrings;
            }
            String error_str = new String(err_buf);
            num = error_str.indexOf("\n");
            int fromIndex = 0;
            int toIndex = 0;
            outputStrings.addElement("Error");
            while (num != -1) {
                toIndex = num;
                line2 = error_str.substring(fromIndex, toIndex);
                if (line2.length() > 0) {
                    outputStrings.addElement(line2);
                }
                if ((fromIndex = toIndex + 1) >= error_str.length()) break;
                num = error_str.indexOf("\n", fromIndex);
            }
            if (fromIndex < error_str.length() && (line2 = error_str.substring(fromIndex)).length() > 0) {
                outputStrings.addElement(line2);
            }
            return outputStrings;
        }
        String output = new String(sb);
        outputStrings.addElement("Success");
        num = output.indexOf("\n");
        int fromIndex = 0;
        int toIndex = 0;
        while (num != -1) {
            toIndex = num;
            line = output.substring(fromIndex, toIndex);
            if (line.length() > 0) {
                outputStrings.addElement(line);
            }
            if ((fromIndex = toIndex + 1) >= output.length()) break;
            num = output.indexOf("\n", fromIndex);
        }
        if (fromIndex < output.length() && (line = output.substring(fromIndex)).length() > 0) {
            outputStrings.addElement(line);
        }
        return outputStrings;
    }

    private int checkForPortmon(String portmon_tag) throws SerialPortException {
        String command_str = this.sacadm_path + " -l -t ttymon";
        Vector result_vec = null;
        String[] cmd_args = new String[4];
        try {
            cmd_args[0] = this.sacadm_path;
            cmd_args[1] = "-l";
            cmd_args[2] = "-t";
            cmd_args[3] = "ttymon";
            result_vec = this.runCommand(cmd_args);
        }
        catch (Exception e) {
            try {
                String cmd = cmd_args[0] + " " + cmd_args[1] + " " + cmd_args[2] + " " + cmd_args[3];
                String[] args = new String[]{cmd, "ttymon"};
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5064", "LM_5065", args, "", false, 0, 2);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new SerialPortException("EXM_PORTMONERR_SRV");
        }
        if (result_vec == null || result_vec.size() == 0) {
            return -1;
        }
        String temp = (String)result_vec.elementAt(0);
        if (temp.compareTo("Error") == 0) {
            return -1;
        }
        for (int i = 1; i < result_vec.size(); ++i) {
            String output_str = (String)result_vec.elementAt(i);
            int index = output_str.indexOf(portmon_tag);
            if (index < 0) continue;
            index = output_str.indexOf("ENABLED");
            if (index > 0) {
                return 1;
            }
            index = output_str.indexOf("DISABLED");
            if (index > 0) {
                return 2;
            }
            index = output_str.indexOf("STARTING");
            if (index > 0) {
                return 3;
            }
            index = output_str.indexOf("FAILED");
            if (index > 0) {
                return 4;
            }
            return -1;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void turn_on_port(SerialPortData data, boolean diffFlag) throws SerialPortException {
        String label;
        String svctag;
        String temp_data_str;
        if (data.isEnableSet() && !diffFlag) {
            String cmd_str = this.pmadm_path + "  -e -p " + data.getPortMonTag() + " -s " + data.getServiceTag();
            Vector result_vec = null;
            try {
                String[] cmd_args = new String[]{this.pmadm_path, "-e", "-p", data.getPortMonTag(), "-s", data.getServiceTag()};
                result_vec = this.runCommand(cmd_args);
            }
            catch (Exception e) {
                try {
                    String label2 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] args = new String[]{data.getPortName()};
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5044", "LM_5045", args, label2 + ": " + cmd_str, true, 0, 2);
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", cmd_str);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_CMD_FAIL_SRV", cmd_str);
            }
            if (result_vec != null && result_vec.size() > 0) {
                String temp = (String)result_vec.elementAt(0);
                if (temp.compareTo("Error") != 0) return;
                try {
                    String label3 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] args = new String[]{data.getPortName()};
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5044", "LM_5045", args, label3 + ": " + cmd_str, true, 0, 2);
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", cmd_str);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_CMD_FAIL_SRV", cmd_str);
            }
            try {
                String label4 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String[] args = new String[]{data.getPortName()};
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5044", "LM_5045", args, label4 + ": " + cmd_str, true, 0, 2);
                throw new SerialPortException("EXM_CMD_FAIL_SRV", cmd_str);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new SerialPortException("EXM_CMD_FAIL_SRV", cmd_str);
        }
        if (data.isEnableSet() && diffFlag) {
            data.tweakPortFlags();
        }
        if (!data.isEnableSet() && diffFlag) {
            data.setDisableFlag();
        }
        int line_no = -1;
        line_no = Solaris_SerialNative.checkTTYLabel(data.getTTYLabel(), this.ttydefs_file);
        if (line_no < 0) {
            try {
                String[] args = new String[]{data.getPortName(), data.getTTYLabel(), this.ttydefs_file};
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5050", "LM_5051", args, "", true, 0, 1);
                throw new SerialPortException("EXM_NO_TTYLABEL_SRV", (Object)this.ttydefs_file, data.getTTYLabel());
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new SerialPortException("EXM_NO_TTYLABEL_SRV", (Object)this.ttydefs_file, data.getTTYLabel());
        }
        String ttyadm_command = this.ttyadm_path + " -d " + data.getDeviceName() + " -l " + data.getTTYLabel() + " -s " + data.getServiceCmdLine();
        Vector<String> args_vec = new Vector<String>();
        args_vec.addElement(this.ttyadm_path);
        args_vec.addElement("-d");
        args_vec.addElement(data.getDeviceName());
        args_vec.addElement("-l");
        args_vec.addElement(data.getTTYLabel());
        args_vec.addElement("-s");
        args_vec.addElement(data.getServiceCmdLine());
        String ttyflags = data.getTTYFlags();
        if (ttyflags != null && ttyflags.length() > 0) {
            if (ttyflags.indexOf("b") >= 0) {
                ttyadm_command = ttyadm_command + " -b ";
                args_vec.addElement("-b");
            }
            if (ttyflags.indexOf("c") >= 0) {
                ttyadm_command = ttyadm_command + " -c ";
                args_vec.addElement("-c");
            }
            if (ttyflags.indexOf("I") >= 0) {
                ttyadm_command = ttyadm_command + " -I ";
                args_vec.addElement("-I");
            }
        }
        if ((temp_data_str = data.getModules()) != null && temp_data_str.length() > 0) {
            ttyadm_command = ttyadm_command + " -m " + temp_data_str;
            args_vec.addElement("-m");
            args_vec.addElement(temp_data_str);
        }
        if ((temp_data_str = data.getPrompt()) != null && temp_data_str.length() > 0) {
            ttyadm_command = ttyadm_command + " -p " + temp_data_str;
            args_vec.addElement("-p");
            args_vec.addElement(temp_data_str);
        }
        if ((temp_data_str = data.getTimeoutVal()) != null && temp_data_str.length() > 0) {
            ttyadm_command = ttyadm_command + " -t " + temp_data_str;
            args_vec.addElement("-t");
            args_vec.addElement(temp_data_str);
        }
        if ((temp_data_str = data.getSoftwareCarrier()) != null && temp_data_str.length() > 0) {
            ttyadm_command = ttyadm_command + " -S " + temp_data_str;
            args_vec.addElement("-S");
            args_vec.addElement(temp_data_str);
        }
        if ((temp_data_str = data.getTerminalType()) != null && temp_data_str.length() > 0) {
            ttyadm_command = ttyadm_command + " -T " + temp_data_str;
            args_vec.addElement("-T");
            args_vec.addElement(temp_data_str);
        }
        Object[] cmd_args = new String[args_vec.size()];
        args_vec.copyInto(cmd_args);
        Vector result_vec = null;
        String ttyadm_cmd_result = "";
        try {
            result_vec = this.runCommand((String[])cmd_args);
        }
        catch (SerialPortException ex) {
            try {
                String label5 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String[] args = new String[]{data.getPortName()};
                String logdata = label5 + ": " + ttyadm_command;
                for (int j = 1; j < result_vec.size(); ++j) {
                    logdata = logdata + " " + (String)result_vec.elementAt(j);
                }
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5052", "LM_5053", args, logdata, true, 0, 2);
                throw new SerialPortException("EXM_SACADM_ERR_SRV", ttyadm_command);
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new SerialPortException("EXM_SACADM_ERR_SRV", ttyadm_command);
        }
        if (result_vec != null && result_vec.size() > 0) {
            String temp_str = (String)result_vec.elementAt(0);
            if (temp_str.compareTo("Error") == 0) {
                try {
                    String label6 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] args = new String[]{data.getPortName()};
                    String logdata = label6 + ": " + ttyadm_command;
                    for (int j = 1; j < result_vec.size(); ++j) {
                        logdata = logdata + " " + (String)result_vec.elementAt(j);
                    }
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5052", "LM_5053", args, logdata, true, 0, 2);
                    throw new SerialPortException("EXM_SACADM_ERR_SRV", ttyadm_command);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_SACADM_ERR_SRV", ttyadm_command);
            }
            if (result_vec.size() > 1) {
                ttyadm_cmd_result = (String)result_vec.elementAt(1);
            }
        } else {
            try {
                String label7 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String[] args = new String[]{data.getPortName()};
                String logdata = label7 + ": " + ttyadm_command;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5052", "LM_5053", args, logdata, true, 0, 2);
                throw new SerialPortException("EXM_SACADM_ERR_SRV", ttyadm_command);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new SerialPortException("EXM_SACADM_ERR_SRV", ttyadm_command);
        }
        temp_data_str = data.getOldPortMonTag();
        if (temp_data_str != null && temp_data_str.length() > 0 && (svctag = data.getOldServiceTag()) != null && svctag.length() > 0) {
            String[] command_args = new String[]{this.pmadm_path, "-r", "-p", temp_data_str, "-s", svctag};
            this.runCommand(command_args);
        }
        String pmadm_command = this.pmadm_path + " -a " + " -p " + data.getPortMonTag() + " -s " + data.getServiceTag() + " -i " + data.getIdentity();
        args_vec = new Vector();
        args_vec.addElement(this.pmadm_path);
        args_vec.addElement("-a");
        args_vec.addElement("-p");
        args_vec.addElement(data.getPortMonTag());
        args_vec.addElement("-s");
        args_vec.addElement(data.getServiceTag());
        args_vec.addElement("-i");
        args_vec.addElement(data.getIdentity());
        String version_str = "1";
        try {
            String temp_str;
            String[] command_args = new String[]{this.ttyadm_path, "-V"};
            result_vec = this.runCommand(command_args);
            if (result_vec != null && result_vec.size() > 0 && (temp_str = (String)result_vec.elementAt(0)).compareTo("Success") == 0) {
                for (int i = 1; i < result_vec.size(); ++i) {
                    version_str = (String)result_vec.elementAt(i);
                }
            }
        }
        catch (SerialPortException x) {
            // empty catch block
        }
        pmadm_command = pmadm_command + " -v " + version_str;
        args_vec.addElement("-v");
        args_vec.addElement(version_str);
        temp_data_str = data.getPortFlags();
        if (temp_data_str != null && temp_data_str.length() > 0) {
            pmadm_command = pmadm_command + " -f " + temp_data_str;
            args_vec.addElement("-f");
            args_vec.addElement(temp_data_str);
        }
        pmadm_command = pmadm_command + " -m \"" + ttyadm_cmd_result + "\"";
        args_vec.addElement("-m");
        args_vec.addElement(ttyadm_cmd_result);
        temp_data_str = data.getComment();
        if (temp_data_str != null && temp_data_str.length() > 0) {
            pmadm_command = pmadm_command + " -y " + temp_data_str;
            args_vec.addElement("-y");
            args_vec.addElement(temp_data_str);
        }
        cmd_args = new String[args_vec.size()];
        args_vec.copyInto(cmd_args);
        try {
            result_vec = this.runCommand((String[])cmd_args);
        }
        catch (SerialPortException x) {
            try {
                label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String[] args = new String[]{data.getPortName()};
                String logdata = label + ": " + pmadm_command;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5054", "LM_5055", args, logdata, true, 0, 2);
                throw new SerialPortException("EXM_SACADM_ERR_SRV", pmadm_command);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new SerialPortException("EXM_SACADM_ERR_SRV", pmadm_command);
        }
        if (result_vec != null && result_vec.size() > 0) {
            String temp_str = (String)result_vec.elementAt(0);
            if (temp_str.compareTo("Error") != 0) return;
            try {
                label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String[] args = new String[]{data.getPortName()};
                String logdata = label + ": " + pmadm_command;
                for (int j = 1; j < result_vec.size(); ++j) {
                    logdata = logdata + " " + (String)result_vec.elementAt(j);
                }
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5054", "LM_5055", args, logdata, true, 0, 2);
                throw new SerialPortException("EXM_SACADM_ERR_SRV", pmadm_command);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new SerialPortException("EXM_SACADM_ERR_SRV", pmadm_command);
        }
        try {
            String label8 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
            String[] args = new String[]{data.getPortName()};
            String logdata = label8 + ": " + pmadm_command;
            this.logUtil.writeLog(PROVIDER_NAME, "LM_5054", "LM_5055", args, logdata, true, 0, 2);
            throw new SerialPortException("EXM_SACADM_ERR_SRV", pmadm_command);
        }
        catch (Exception ex) {
            // empty catch block
        }
        throw new SerialPortException("EXM_SACADM_ERR_SRV", pmadm_command);
    }

    public synchronized Vector synchronizedDeletePort(String portName) throws SerialPortException {
        SerialPortData dat = (SerialPortData)this.allPortData.get(portName);
        String portMonTag = dat.getPortMonTag();
        String serviceTag = dat.getServiceTag();
        Vector result = null;
        if (portMonTag != null && serviceTag != null) {
            String command_str = this.pmadm_path + " -r -p " + portMonTag + " -s " + serviceTag;
            try {
                String[] cmd_args = new String[]{this.pmadm_path, "-r", "-p", portMonTag, "-s", serviceTag};
                result = this.runCommand(cmd_args);
            }
            catch (Exception e) {
                try {
                    String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] args = new String[]{portName};
                    String logdata = label + ": " + command_str;
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5015", "LM_5016", args, logdata, false, 0, 2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_DEL_SRV", portName);
            }
            if (result != null && result.size() > 1) {
                try {
                    String label = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] args = new String[]{portName, (String)result.elementAt(1)};
                    String logdata = label + ": " + command_str;
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5015", "LM_5017", args, logdata, false, 0, 2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_DEL_SRV", portName);
            }
            dat.setDefaults(portName);
            for (int k = 0; k < this.dataObjectVector.size(); ++k) {
                String port_name = null;
                SerialPortData data_elem = (SerialPortData)this.dataObjectVector.elementAt(k);
                port_name = data_elem.getPortName();
                if (port_name == null || port_name.compareTo(portName) != 0) continue;
                data_elem.setDefaults(portName);
                data_elem.setDeviceName(dat.getDeviceName());
                data_elem.setNoService();
                data_elem.setDeleted();
                this.dataObjectVector.setElementAt(data_elem, k);
                this.allPortData.put(portName, data_elem);
                break;
            }
            try {
                String label = this.logUtil.getMessage("LM_LABEL_SERIAL_PORTMONTAG");
                String[] args = new String[]{portName};
                String logdata = label + ": " + portMonTag + "\n" + this.logUtil.getMessage("LM_LABEL_SERIAL_SERVICETAG") + ": " + serviceTag;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5019", "LM_5020", args, logdata, false, 0, 0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            return this.dataObjectVector;
        }
        try {
            String[] args = new String[]{portName};
            this.logUtil.writeLog(PROVIDER_NAME, "LM_5015", "LM_5018", args, "", false, 0, 2);
        }
        catch (Exception ex) {
            // empty catch block
        }
        throw new SerialPortException("EXM_DELNODATA_SRV", portName);
    }

    public String toString(int i) {
        SerialPortData port_data = (SerialPortData)this.dataObjectVector.elementAt(i);
        return port_data.toString();
    }
}

