/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.serialport.SerialPortData;
import com.sun.wbem.solarisprovider.serialport.SerialPortException;
import com.sun.wbem.solarisprovider.serialport.SerialPortInfo;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_SerialPort
implements InstanceProvider,
MethodProvider,
Authorizable {
    public static final String SERIAL_MODIFY_RIGHT = "solaris.admin.serialmgr.modify";
    public static final String SERIAL_DELETE_RIGHT = "solaris.admin.serialmgr.delete";
    public static final String SERIAL_READ_RIGHT = "solaris.admin.serialmgr.read";
    public static final String PROVIDER_NAME = "SerialPort";
    SerialPortInfo dat = null;
    LogUtil util = null;
    int num_ports;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.util = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        String app_name = this.util.getMessage("LM_SERIAL_APP_NAME");
        this.provUtil = new ProviderUtility(cimomhandle, app_name);
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(SERIAL_READ_RIGHT, op);
        String portName = "";
        SerialPortData portData = null;
        this.dat = this.initData();
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase("DeviceID")) continue;
            portName = (String)cp.getValue().getValue();
        }
        try {
            portData = this.dat.getPortData(portName);
        }
        catch (SerialPortException spex) {
            String msg = spex.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            String msg = this.provUtil.writeLog(2, ex);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        CIMInstance ci = cc.newInstance();
        ci.setProperty("DeviceID", new CIMValue((Object)portName));
        ci.setProperty("PortMonitor", new CIMValue((Object)portData.getPortMonTag()));
        ci.setProperty("ServiceTag", new CIMValue((Object)portData.getServiceTag()));
        ci.setProperty("Comment", new CIMValue((Object)portData.getComment()));
        ci.setProperty("ServiceEnabled", new CIMValue((Object)new Boolean(portData.isEnableSet())));
        if (localOnly) {
            ci = ci.localElements();
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }
        ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        try {
            ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        }
        catch (Exception ex) {
            // empty catch block
        }
        ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_SerialPort"));
        return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(SERIAL_READ_RIGHT, op);
        Vector<CIMInstance> ports = new Vector<CIMInstance>();
        SerialPortData portData = null;
        CIMInstance ci = null;
        this.dat = this.initData();
        for (int i = 0; i < this.num_ports; ++i) {
            ci = cc.newInstance();
            try {
                portData = this.dat.getPortData(this.dat.getPortName(i));
                ci.setProperty("DeviceID", new CIMValue((Object)this.dat.getPortName(i)));
            }
            catch (SerialPortException spex) {
                String msg = spex.getLocalizedMessage();
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
            }
            catch (Exception e) {
                String msg = this.provUtil.writeLog(2, e);
                throw new CIMException("CIM_ERR_FAILED", (Object)msg);
            }
            ci.setProperty("PortMonitor", new CIMValue((Object)portData.getPortMonTag()));
            ci.setProperty("ServiceTag", new CIMValue((Object)portData.getServiceTag()));
            ci.setProperty("Comment", new CIMValue((Object)portData.getComment()));
            ci.setProperty("ServiceEnabled", new CIMValue((Object)new Boolean(portData.isEnableSet())));
            ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception e) {
                // empty catch block
            }
            ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_SerialPort"));
            if (localOnly) {
                ci = ci.localElements();
            }
            ports.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
        }
        CIMInstance[] ciArray = new CIMInstance[ports.size()];
        ports.toArray(ciArray);
        return ciArray;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(SERIAL_READ_RIGHT, op);
        Vector<CIMObjectPath> ports = new Vector<CIMObjectPath>();
        this.dat = this.initData();
        for (int i = 0; i < this.num_ports; ++i) {
            CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            try {
                cop.addKey("DeviceID", new CIMValue((Object)this.dat.getPortName(i)));
            }
            catch (Exception e) {
                String msg = this.provUtil.writeLog(2, e);
                throw new CIMException("CIM_ERR_FAILED", (Object)msg);
            }
            cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception e) {
                // empty catch block
            }
            cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_SerialPort"));
            ports.addElement(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[ports.size()];
        ports.toArray(copArray);
        return copArray;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        if (methodName.equalsIgnoreCase("disableportservice")) {
            this.provUtil.checkRights(SERIAL_DELETE_RIGHT, op);
            return new CIMValue((Object)this.DisablePortService(op));
        }
        return null;
    }

    public Boolean DisablePortService(CIMObjectPath op) throws CIMException {
        this.dat = this.initData();
        String portName = "";
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase("DeviceID")) continue;
            portName = (String)cp.getValue().getValue();
        }
        try {
            this.dat.synchronizedDeletePort(portName);
        }
        catch (SerialPortException spex) {
            String msg = spex.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            String msg = this.provUtil.writeLog(2, ex);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        return new Boolean(true);
    }

    private SerialPortInfo initData() throws CIMException {
        try {
            SerialPortInfo priv_data = new SerialPortInfo(this.util);
            this.num_ports = priv_data.initData();
            return priv_data;
        }
        catch (SerialPortException spex) {
            String msg = spex.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception e) {
            String msg = this.provUtil.writeLog(2, e);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] ciArray = this.enumerateInstances(op, true, false, false, null, cc);
            for (int i = 0; i < ciArray.length; ++i) {
                if (where != null && !where.apply((CIMElement)ciArray[i])) continue;
                result.addElement(attrs.apply((CIMElement)ciArray[i]));
            }
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e.toString());
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }
}

