/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.serialport.SerialPortException;
import com.sun.wbem.solarisprovider.serialport.SerialPortInfo;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_SerialPortSetting
implements InstanceProvider {
    SerialPortInfo dat = null;
    int num_ports;
    private CIMOMHandle cimomhandle = null;
    private LogUtil util = null;
    private ProviderUtility provUtil = null;

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.util = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        String app_name = this.util.getMessage("LM_SERIAL_APP_NAME");
        this.provUtil = new ProviderUtility(cimomhandle, app_name);
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        CIMObjectPath config = null;
        CIMObjectPath port = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase("Element")) {
                port = (CIMObjectPath)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase("Setting")) continue;
            config = (CIMObjectPath)cp.getValue().getValue();
        }
        CIMInstance ci = cc.newInstance();
        ci.setProperty("Element", new CIMValue(port));
        ci.setProperty("Setting", new CIMValue(config));
        return ci;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> port_settings = new Vector<CIMInstance>();
        this.dat = this.initData();
        for (int i = 0; i < this.num_ports; ++i) {
            CIMInstance ci = cc.newInstance();
            CIMObjectPath c_port = new CIMObjectPath("Solaris_SerialPort");
            c_port.setNameSpace("root/cimv2");
            CIMObjectPath c_config = new CIMObjectPath("Solaris_SerialPortConfiguration");
            c_config.setNameSpace("root/cimv2");
            CIMObjectPath c_port_cop = new CIMObjectPath(c_port.getObjectName(), c_port.getNameSpace());
            CIMObjectPath c_config_cop = new CIMObjectPath(c_config.getObjectName(), c_config.getNameSpace());
            c_port_cop.addKey("DeviceID", new CIMValue((Object)this.dat.getPortName(i)));
            if (!localOnly) {
                c_port_cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    c_port_cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                c_port_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_SerialPort"));
            }
            c_config_cop.addKey("PortName", new CIMValue((Object)this.dat.getPortName(i)));
            c_config_cop.addKey("ServiceTag", new CIMValue((Object)this.dat.getServiceTag(this.dat.getPortName(i))));
            ci.setProperty("Element", new CIMValue((Object)c_port_cop));
            ci.setProperty("Setting", new CIMValue((Object)c_config_cop));
            if (localOnly) {
                ci = ci.localElements();
            }
            port_settings.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
        }
        CIMInstance[] ciArray = new CIMInstance[port_settings.size()];
        port_settings.toArray(ciArray);
        return ciArray;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> port_settings = new Vector<CIMObjectPath>();
        this.dat = this.initData();
        for (int i = 0; i < this.num_ports; ++i) {
            CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            CIMObjectPath c_port = new CIMObjectPath("Solaris_SerialPort");
            c_port.setNameSpace("root/cimv2");
            CIMObjectPath c_config = new CIMObjectPath("Solaris_SerialPortConfiguration");
            c_config.setNameSpace("root/cimv2");
            CIMObjectPath c_port_cop = new CIMObjectPath(c_port.getObjectName(), c_port.getNameSpace());
            CIMObjectPath c_config_cop = new CIMObjectPath(c_config.getObjectName(), c_config.getNameSpace());
            c_port_cop.addKey("DeviceID", new CIMValue((Object)this.dat.getPortName(i)));
            c_port_cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                c_port_cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception e) {
                // empty catch block
            }
            c_port_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_SerialPort"));
            c_config_cop.addKey("PortName", new CIMValue((Object)this.dat.getPortName(i)));
            c_config_cop.addKey("ServiceTag", new CIMValue((Object)this.dat.getServiceTag(this.dat.getPortName(i))));
            cop.addKey("Element", new CIMValue((Object)c_port_cop));
            cop.addKey("Setting", new CIMValue((Object)c_config_cop));
            port_settings.addElement(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[port_settings.size()];
        port_settings.toArray(copArray);
        return copArray;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private SerialPortInfo initData() throws CIMException {
        try {
            SerialPortInfo priv_data = new SerialPortInfo(this.util);
            this.num_ports = priv_data.initData();
            return priv_data;
        }
        catch (SerialPortException spex) {
            String msg = spex.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception e) {
            String msg = this.provUtil.writeLog(2, e);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] ciArray = this.enumerateInstances(op, true, false, false, null, cc);
            for (int i = 0; i < ciArray.length; ++i) {
                if (where != null && !where.apply((CIMElement)ciArray[i])) continue;
                result.addElement(attrs.apply((CIMElement)ciArray[i]));
            }
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e.toString());
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }
}

