/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.tz;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_TimeZone
implements InstanceProvider {
    private static final String BACKPAD = "00.000000:000";
    private static final int INTERVAL_SIZE = 2;
    private static final CIMDataType SINT32 = CIMDataType.getPredefinedType((int)5);
    private static final CIMDataType SINT8 = CIMDataType.getPredefinedType((int)1);
    private static final CIMDataType UINT32 = CIMDataType.getPredefinedType((int)4);
    private static final CIMDataType UINT16 = CIMDataType.getPredefinedType((int)2);
    private static final CIMDataType UINT8 = CIMDataType.getPredefinedType((int)0);
    private static final CIMDataType DATETIME = CIMDataType.getPredefinedType((int)12);
    private CIMOMHandle cimomhandle = null;
    private LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "TimeZone";
    private String tzkey = "TZ";
    private TimeZone tz = TimeZone.getDefault();
    private Calendar cal = Calendar.getInstance();
    private String tzBuff = this.cal.toString();
    private String[] msg = new String[]{this.PROVIDER_NAME};

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8600", "LM_8601", this.msg, "FAILURE", false, 0, 2);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8602", "LM_8603", this.msg, "FAILURE", false, 0, 2);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8608", "LM_8609", this.msg, "FAILURE", false, 0, 2);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        try {
            CIMDateTime dt;
            String StdName = null;
            String creationClassName = null;
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (cp == null) continue;
                if (cp.getName().equalsIgnoreCase("StandardName")) {
                    StdName = (String)cp.getValue().getValue();
                }
                if (!cp.getName().equalsIgnoreCase("CreationClassName")) continue;
                creationClassName = (String)cp.getValue().getValue();
            }
            if (StdName == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", StdName);
            }
            if (creationClassName == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", creationClassName);
            }
            TimeZone tz = TimeZone.getTimeZone(StdName);
            this.cal = Calendar.getInstance(tz);
            this.tzBuff = this.cal.toString();
            CIMInstance ci = cc.newInstance();
            ci.setProperty("StandardName", new CIMValue((Object)StdName));
            ci.setProperty("CreationClassName", new CIMValue((Object)creationClassName));
            CIMValue cv = null;
            cv = new CIMValue((Object)new Integer(tz.getRawOffset() / 60000), SINT32);
            ci.setProperty("Offset", cv);
            ci.setProperty("DaylightName", new CIMValue((Object)tz.getDisplayName(true, 1)));
            ci.setProperty("DaylightCaption", new CIMValue((Object)tz.getDisplayName(true, 0)));
            if (tz.useDaylightTime()) {
                cv = new CIMValue((Object)new UnsignedInt16(1900), UINT16);
                ci.setProperty("DaylightStartYear", cv);
            } else {
                cv = new CIMValue((Object)new UnsignedInt16(0), UINT16);
                ci.setProperty("DaylightStartYear", cv);
            }
            if (tz.useDaylightTime()) {
                cv = new CIMValue((Object)new UnsignedInt8(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "startMonth=")), UINT8);
                ci.setProperty("DaylightMonth", cv);
            }
            if (tz.useDaylightTime()) {
                cv = new CIMValue((Object)new Byte(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "startDay=")), SINT8);
                ci.setProperty("DaylightDay", cv);
            }
            if (tz.useDaylightTime()) {
                cv = new CIMValue((Object)new Byte(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "startDayOfWeek=")), SINT8);
                ci.setProperty("DaylightDayOfWeek", cv);
            }
            if (tz.useDaylightTime()) {
                dt = this.getStartTimeInterval();
                cv = new CIMValue((Object)dt, DATETIME);
                ci.setProperty("DaylightStartInterval", cv);
            }
            if (tz.useDaylightTime()) {
                cv = new CIMValue((Object)new UnsignedInt8(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "endMonth=")), UINT8);
                ci.setProperty("StandardMonth", cv);
            }
            if (tz.useDaylightTime()) {
                cv = new CIMValue((Object)new Byte(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "endDay=")), SINT8);
                ci.setProperty("StandardDay", cv);
            }
            if (tz.useDaylightTime()) {
                cv = new CIMValue((Object)new Byte(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "endDayOfWeek=")), SINT8);
                ci.setProperty("StandardDayOfWeek", cv);
            }
            if (tz.useDaylightTime()) {
                dt = this.getEndTimeInterval();
                cv = new CIMValue((Object)dt, DATETIME);
                ci.setProperty("StandardStartInterval", cv);
            }
            ci.setProperty("SettingID", new CIMValue((Object)tz.getDisplayName(tz.useDaylightTime(), 1)));
            ci.setProperty("Caption", new CIMValue((Object)tz.getDisplayName(false, 0)));
            ci.setProperty("Description", new CIMValue((Object)tz.getID()));
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8606", "LM_8607", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance of TimeZone Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> tzInstances = new Vector<CIMInstance>();
        try {
            String[] ids = TimeZone.getAvailableIDs();
            for (int i = 0; i < ids.length; ++i) {
                CIMDateTime dt;
                TimeZone tz = TimeZone.getTimeZone(ids[i]);
                Calendar cal = Calendar.getInstance(tz);
                this.tzBuff = cal.toString();
                String StdName = tz.getID();
                CIMInstance ci = cc.newInstance();
                ci.setProperty("StandardName", new CIMValue((Object)StdName));
                ci.setProperty("CreationClassName", new CIMValue((Object)cc.getName()));
                CIMValue cv = null;
                cv = new CIMValue((Object)new Integer(tz.getRawOffset() / 60000), SINT32);
                ci.setProperty("Offset", cv);
                ci.setProperty("DaylightName", new CIMValue((Object)tz.getDisplayName(true, 1)));
                ci.setProperty("DaylightCaption", new CIMValue((Object)tz.getDisplayName(true, 0)));
                if (tz.useDaylightTime()) {
                    cv = new CIMValue((Object)new UnsignedInt16(1900), UINT16);
                    ci.setProperty("DaylightStartYear", cv);
                } else {
                    cv = new CIMValue((Object)new UnsignedInt16(0), UINT16);
                    ci.setProperty("DaylightStartYear", cv);
                }
                if (tz.useDaylightTime()) {
                    cv = new CIMValue((Object)new UnsignedInt8(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "startMonth=")), UINT8);
                    ci.setProperty("DaylightMonth", cv);
                }
                if (tz.useDaylightTime()) {
                    cv = new CIMValue((Object)new Byte(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "startDay=")), SINT8);
                    ci.setProperty("DaylightDay", cv);
                }
                if (tz.useDaylightTime()) {
                    cv = new CIMValue((Object)new Byte(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "startDayOfWeek=")), SINT8);
                    ci.setProperty("DaylightDayOfWeek", cv);
                }
                if (tz.useDaylightTime()) {
                    dt = this.getStartTimeInterval();
                    cv = new CIMValue((Object)dt, DATETIME);
                    ci.setProperty("DaylightStartInterval", cv);
                }
                if (tz.useDaylightTime()) {
                    cv = new CIMValue((Object)new UnsignedInt8(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "endMonth=")), UINT8);
                    ci.setProperty("StandardMonth", cv);
                }
                if (tz.useDaylightTime()) {
                    cv = new CIMValue((Object)new Byte(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "endDay=")), SINT8);
                    ci.setProperty("StandardDay", cv);
                }
                if (tz.useDaylightTime()) {
                    cv = new CIMValue((Object)new Byte(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "endDayOfWeek=")), SINT8);
                    ci.setProperty("StandardDayOfWeek", cv);
                }
                if (tz.useDaylightTime()) {
                    dt = this.getEndTimeInterval();
                    cv = new CIMValue((Object)dt, DATETIME);
                    ci.setProperty("StandardStartInterval", cv);
                }
                ci.setProperty("SettingID", new CIMValue((Object)tz.getDisplayName(tz.useDaylightTime(), 1)));
                ci.setProperty("Caption", new CIMValue((Object)tz.getDisplayName(false, 0)));
                ci.setProperty("Description", new CIMValue((Object)tz.getID()));
                tzInstances.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
            }
            CIMInstance[] ciArray = new CIMInstance[tzInstances.size()];
            tzInstances.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8606", "LM_8607", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"enumInstance of TimeZone Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> tzInstances = new Vector<CIMObjectPath>();
        try {
            String[] ids = TimeZone.getAvailableIDs();
            for (int i = 0; i < ids.length; ++i) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                cop.addKey("CreationClassName", new CIMValue((Object)cc.getName()));
                String StdName = ids[i];
                cop.addKey("StandardName", new CIMValue((Object)new String(StdName)));
                tzInstances.addElement(cop);
            }
            CIMObjectPath[] copArray = new CIMObjectPath[tzInstances.size()];
            tzInstances.toArray(copArray);
            return copArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8606", "LM_8607", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"enumInstance of TimeZone Failed");
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] ciArray = this.enumerateInstances(op, true, false, false, null, cc);
            for (int i = 0; i < ciArray.length; ++i) {
                if (where != null && !where.apply((CIMElement)ciArray[i])) continue;
                result.addElement(attrs.apply((CIMElement)ciArray[i]));
            }
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e.toString());
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }

    public static String parseTZ_OBJ(String tzBuff, String value) {
        String delim1 = ",";
        String delim2 = ":";
        String delim3 = "]";
        String retvalue = null;
        String token = null;
        String token2 = null;
        String token3 = null;
        String pars2token = null;
        int field_val_idx = 0;
        StringTokenizer parser = new StringTokenizer(tzBuff, delim1);
        try {
            while (parser.hasMoreTokens()) {
                token = parser.nextToken();
                StringTokenizer parser2 = new StringTokenizer(token, delim2);
                token2 = parser2.nextToken();
                if (!token2.startsWith(value)) continue;
                if (token2.endsWith("]")) {
                    StringTokenizer parser3 = new StringTokenizer(token2, delim3);
                    pars2token = token3 = parser3.nextToken();
                    field_val_idx = value.length();
                    retvalue = pars2token.substring(field_val_idx);
                    continue;
                }
                pars2token = token2;
                field_val_idx = value.length();
                retvalue = pars2token.substring(field_val_idx);
            }
        }
        catch (NoSuchElementException e) {
            System.out.println(e);
        }
        return retvalue;
    }

    private String padLeadingZeros(int number, int numSize) {
        return this.padLeadingZeros(String.valueOf(number), numSize);
    }

    private String padLeadingZeros(String number, int numSize) {
        StringBuffer buf = new StringBuffer(number);
        for (int i = number.length(); i < numSize; ++i) {
            buf.insert(0, 0);
        }
        return buf.toString();
    }

    private CIMDateTime getStartTimeInterval() {
        CIMDateTime dt = new CIMDateTime();
        String testStartTime = Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "startTime=");
        Integer startTimeInteger = new Integer(Integer.parseInt(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "startTime=")));
        int startTimeInt = startTimeInteger;
        int intervalMinutes = startTimeInt / 60000;
        if (intervalMinutes < 60) {
            String frontPad = "0000000000";
            int intervalHours = intervalMinutes / 60;
            StringBuffer buf = new StringBuffer();
            buf.append(frontPad);
            buf.append(this.padLeadingZeros(intervalHours, 2));
            buf.append(BACKPAD);
            String dateString = buf.toString();
            dt = new CIMDateTime(dateString);
        } else {
            String frontPad = "00000000";
            int intervalMinRemainder = intervalMinutes % 60;
            int intervalHours = intervalMinutes / 60;
            StringBuffer buf = new StringBuffer();
            buf.append(frontPad);
            buf.append(this.padLeadingZeros(intervalHours, 2));
            buf.append(this.padLeadingZeros(intervalMinRemainder, 2));
            buf.append(BACKPAD);
            String dateString = buf.toString();
            dt = new CIMDateTime(dateString);
        }
        return dt;
    }

    private CIMDateTime getEndTimeInterval() {
        CIMDateTime dt = new CIMDateTime();
        Integer endTimeInteger = new Integer(Integer.parseInt(Solaris_TimeZone.parseTZ_OBJ(this.tzBuff, "endTime=")));
        int endTimeInt = endTimeInteger;
        int intervalMinutes = endTimeInt / 60000;
        if (intervalMinutes > 59) {
            int intervalMinRemainder = intervalMinutes % 60;
            int intervalHours = intervalMinutes / 60;
            StringBuffer buf = new StringBuffer();
            String frontPad = "00000000";
            buf.append(frontPad);
            buf.append(this.padLeadingZeros(intervalHours, 2));
            buf.append(this.padLeadingZeros(intervalMinRemainder, 2));
            buf.append(BACKPAD);
            String dateString = buf.toString();
            dt = new CIMDateTime(dateString);
        } else {
            String frontPad = "0000000000";
            int intervalHours = intervalMinutes / 60;
            StringBuffer buf = new StringBuffer();
            buf.append(frontPad);
            buf.append(this.padLeadingZeros(intervalHours, 2));
            buf.append(BACKPAD);
            String dateString = buf.toString();
            dt = new CIMDateTime(dateString);
        }
        return dt;
    }
}

