/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.aliases;

import com.sun.audit.AuditEvent_usermgr_add;
import com.sun.audit.AuditEvent_usermgr_delete;
import com.sun.audit.AuditEvent_usermgr_modify;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.solarisprovider.common.ProviderFilter;
import com.sun.wbem.solarisprovider.usermgr.aliases.AliasProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.aliases.EmailAliasObj;
import com.sun.wbem.solarisprovider.usermgr.aliases.UMgrWrapper;
import com.sun.wbem.solarisprovider.usermgr.common.UMgrProvider;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethodException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.MethodProvider;

public class Solaris_EmailAlias
extends UMgrProvider
implements MethodProvider,
Authorizable {
    private static final String ALIAS_NAME = "aliasName";
    private static final String ALIAS_COMMENT = "aliasComment";
    private static final String ALIAS_MEMBERS = "aliasMembers";
    private static final String ALIAS_CLASS = "Solaris_EmailAlias";

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.checkRights("solaris.admin.usermgr.manage", op);
        String scope = this.provUtil.getMgmtScope(op);
        try {
            String aliasName = null;
            String strMembers = "";
            if (ci.getProperty(ALIAS_NAME) != null && ci.getProperty(ALIAS_NAME).getValue() != null) {
                aliasName = (String)ci.getProperty(ALIAS_NAME).getValue().getValue();
            }
            if (aliasName == null || aliasName.trim().equals("")) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            if (ci.getProperty(ALIAS_MEMBERS) != null && ci.getProperty(ALIAS_MEMBERS).getValue() != null) {
                strMembers = (String)ci.getProperty(ALIAS_MEMBERS).getValue().getValue();
            }
            UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
            EmailAliasObj aliasObj = new EmailAliasObj(aliasName);
            aliasObj.setAliasExpansion(strMembers);
            uMgrWrapper.addEmailAlias(aliasObj);
        }
        catch (CIMProviderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_EmailAlias createInstance() : null WbemAuditSession.");
                return null;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_EmailAlias createInstance() : null platform AuditSession.");
                return null;
            }
            AuditEvent_usermgr_add aliasAddEvent = new AuditEvent_usermgr_add(auditSession);
            if (aliasAddEvent == null) {
                Debug.trace1((String)"Solaris_EmailAlias createInstance() : null AuditEvent_usermgr_add");
                return null;
            }
            String propertyToken = this.provUtil.formatAuditToken(ci);
            aliasAddEvent.object_name(op.getObjectName());
            aliasAddEvent.domain(this.provUtil.getDomainToken(scope));
            aliasAddEvent.name_service(this.provUtil.getNameServiceToken(scope));
            aliasAddEvent.auth_used("solaris.admin.usermgr.manage");
            aliasAddEvent.initial_values(propertyToken);
            aliasAddEvent.putEvent(0, 0);
        }
        catch (Exception e) {
            Debug.trace1((String)"Solaris_EmailAlias createInstance() : Auditing threw exception", (Throwable)e);
            return null;
        }
        return null;
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        this.checkRights("solaris.admin.usermgr.manage", op);
        String scope = this.provUtil.getMgmtScope(op);
        String aliasName = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(ALIAS_NAME) || cp.getValue() == null) continue;
            aliasName = (String)cp.getValue().getValue();
        }
        if (aliasName == null) {
            return;
        }
        try {
            UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
            EmailAliasObj aliasObj = new EmailAliasObj(aliasName);
            uMgrWrapper.deleteEmailAlias(aliasObj);
        }
        catch (CIMProviderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_EmailAlias deleteInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_EmailAlias deleteInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_usermgr_delete aliasDelEvent = new AuditEvent_usermgr_delete(auditSession);
            if (aliasDelEvent == null) {
                Debug.trace1((String)"Solaris_EmailAlias deleteInstance() : null AuditEvent_usermgr_delete");
                return;
            }
            aliasDelEvent.object_name(op.getObjectName());
            aliasDelEvent.domain(this.provUtil.getDomainToken(scope));
            aliasDelEvent.name_service(this.provUtil.getNameServiceToken(scope));
            aliasDelEvent.auth_used("solaris.admin.usermgr.manage");
            aliasDelEvent.delete_values(aliasName);
            aliasDelEvent.putEvent(0, 0);
        }
        catch (Exception e2) {
            Debug.trace1((String)"Solaris_EmailAlias deleteInstance() : Auditing threw exception", (Throwable)e2);
            return;
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        this.checkRights("solaris.admin.usermgr.read", op);
        String scope = this.provUtil.getMgmtScope(op);
        Vector<CIMObjectPath> vKeyPaths = new Vector<CIMObjectPath>();
        Vector vAliasObjs = new Vector();
        try {
            UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
            vAliasObjs = uMgrWrapper.getAllEmailAliases();
        }
        catch (CIMProviderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        for (int i = 0; vAliasObjs != null && i < vAliasObjs.size(); ++i) {
            EmailAliasObj aliasObj = (EmailAliasObj)vAliasObjs.elementAt(i);
            CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            cop.addKey("SystemCreationClassName", new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
            cop.addKey("SystemName", new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
            cop.addKey(ALIAS_NAME, new CIMValue((Object)aliasObj.getAliasName()));
            vKeyPaths.addElement(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[vKeyPaths.size()];
        vKeyPaths.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.checkRights("solaris.admin.usermgr.read", op);
        String scope = null;
        scope = this.provUtil.getMgmtScope(op);
        UMgrWrapper uMgrWrapper = null;
        Vector<CIMInstance> vInstances = new Vector<CIMInstance>();
        Vector vAliasObjs = null;
        CIMInstance ci = null;
        try {
            uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
            vAliasObjs = uMgrWrapper.getAllEmailAliases();
        }
        catch (CIMProviderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        for (int i = 0; vAliasObjs != null && i < vAliasObjs.size(); ++i) {
            EmailAliasObj aliasObj = (EmailAliasObj)vAliasObjs.elementAt(i);
            ci = cc.newInstance();
            ci.setProperty("SystemCreationClassName", new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
            ci.setProperty("SystemName", new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
            ci.setProperty(ALIAS_NAME, new CIMValue((Object)aliasObj.getAliasName()));
            ci.setProperty(ALIAS_MEMBERS, new CIMValue((Object)aliasObj.getAliasExpansion()));
            if (localOnly) {
                ci = ci.localElements();
            }
            vInstances.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
        }
        CIMInstance[] ciArray = new CIMInstance[vInstances.size()];
        vInstances.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.checkRights("solaris.admin.usermgr.read", op);
        String scope = null;
        scope = this.provUtil.getMgmtScope(op);
        UMgrWrapper uMgrWrapper = null;
        EmailAliasObj newAliasObj = null;
        String aliasName = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(ALIAS_NAME) || cp.getValue() == null) continue;
            aliasName = (String)cp.getValue().getValue();
        }
        if (aliasName == null) {
            return null;
        }
        EmailAliasObj aliasObj = new EmailAliasObj(aliasName);
        try {
            uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
            newAliasObj = uMgrWrapper.getEmailAliasAttributes(aliasObj);
        }
        catch (CIMProviderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        CIMInstance ci = cc.newInstance();
        ci.setProperty("SystemCreationClassName", new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
        ci.setProperty("SystemName", new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
        ci.setProperty(ALIAS_NAME, new CIMValue((Object)newAliasObj.getAliasName()));
        ci.setProperty(ALIAS_MEMBERS, new CIMValue((Object)newAliasObj.getAliasExpansion()));
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        String aliasname = null;
        String aliasExpansion = null;
        UMgrWrapper uMgrWrapper = null;
        this.checkRights("solaris.admin.usermgr.manage", op);
        String scope = this.provUtil.getMgmtScope(op);
        if (ci.getProperty(ALIAS_NAME) != null && ci.getProperty(ALIAS_NAME).getValue() != null) {
            aliasname = (String)ci.getProperty(ALIAS_NAME).getValue().getValue();
        }
        if (ci.getProperty(ALIAS_MEMBERS) != null && ci.getProperty(ALIAS_MEMBERS).getValue() != null) {
            aliasExpansion = (String)ci.getProperty(ALIAS_MEMBERS).getValue().getValue();
        }
        if (aliasname == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        EmailAliasObj newObj = new EmailAliasObj(aliasname);
        if (aliasExpansion != null) {
            newObj.setAliasExpansion(aliasExpansion);
        }
        EmailAliasObj oldObj = new EmailAliasObj(aliasname);
        try {
            uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
            oldObj = uMgrWrapper.getEmailAliasAttributes(oldObj);
        }
        catch (CIMProviderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        try {
            uMgrWrapper.modifyEmailAlias(newObj, oldObj);
        }
        catch (CIMProviderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_EmailAlias setInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_EmailAlias setInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_usermgr_modify aliasModEvent = new AuditEvent_usermgr_modify(auditSession);
            if (aliasModEvent == null) {
                Debug.trace1((String)"Solaris_EmailAlias createInstance() : null AuditEvent_usermgr_modify");
                return;
            }
            String propertyToken = null;
            propertyToken = this.provUtil.formatAuditToken(ci);
            aliasModEvent.object_name(op.getObjectName());
            aliasModEvent.domain(this.provUtil.getDomainToken(scope));
            aliasModEvent.name_service(this.provUtil.getNameServiceToken(scope));
            aliasModEvent.auth_used("solaris.admin.usermgr.manage");
            aliasModEvent.changed_values(propertyToken);
            aliasModEvent.putEvent(0, 0);
        }
        catch (Exception e) {
            Debug.trace1((String)"Solaris_EmailAlias setInstance() : Auditing threw exception", (Throwable)e);
            return;
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        Vector results = new Vector(0);
        CIMInstance ci = null;
        Vector vAliases = null;
        Vector<CIMInstance> vInstances = new Vector<CIMInstance>();
        this.checkRights("solaris.admin.usermgr.read", op);
        String scope = this.provUtil.getMgmtScope(op);
        ProviderFilter pf = null;
        AliasProviderDirectoryFilter pdf = null;
        try {
            pf = new ProviderFilter(cc, query);
            pdf = new AliasProviderDirectoryFilter(pf);
        }
        catch (CIMException cex) {
            this.writeLog(2, "LM_2098", "LM_2114", cex.getLocalizedMessage(), null, null, null);
            throw cex;
        }
        catch (Exception ex) {
            this.writeLog(2, "LM_2098", "LM_2114", ex.getLocalizedMessage(), null, null, null);
            throw new CIMException("CIM_ERR_INVALID_QUERY");
        }
        if (cc.getName().equals(ALIAS_CLASS)) {
            try {
                UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
                vAliases = uMgrWrapper.getAllEmailAliases(pdf);
            }
            catch (CIMProviderException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
            }
        } else {
            throw new CIMProviderException("GENERAL_EXCEPTION");
        }
        for (int i = 0; vAliases != null && i < vAliases.size(); ++i) {
            EmailAliasObj aliasObj = (EmailAliasObj)vAliases.elementAt(i);
            ci = cc.newInstance();
            ci.setProperty("SystemCreationClassName", new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
            ci.setProperty("SystemName", new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
            ci.setProperty(ALIAS_NAME, new CIMValue((Object)aliasObj.getAliasName()));
            ci.setProperty(ALIAS_MEMBERS, new CIMValue((Object)aliasObj.getAliasExpansion()));
            vInstances.addElement(ci);
        }
        CIMInstance[] ciArray = new CIMInstance[vInstances.size()];
        vInstances.toArray(ciArray);
        return ciArray;
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        CIMValue results = null;
        String scope = null;
        String name = null;
        CIMObjectPath cop = new CIMObjectPath(ALIAS_CLASS, "root\\cimv2");
        CIMClass cc = this.cimomhandle.getClass(cop, false, true, true, null);
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            scope = this.getDefaultScope();
        }
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(ALIAS_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (!methodName.equals("bulkData")) {
            this.writeLog(2, "LM_2098", "LM_2109", null, null, null, null);
            throw new CIMMethodException("NO_SUCH_METHOD", (Object)methodName, (Object)op.getObjectName());
        }
        results = this.bulkData(cc, scope, inParams, outParams);
        return results;
    }

    private CIMValue bulkData(CIMClass cc, String scope, Vector inParams, Vector outParams) throws CIMException {
        ProviderFilter pf = null;
        AliasProviderDirectoryFilter pdf = null;
        Vector list = null;
        EmailAliasObj eao = null;
        this.provUtil.checkRights("solaris.admin.usermgr.read", (CIMObjectPath)null);
        CIMValue rv = new CIMValue((Object)new Integer(0));
        CIMValue iv = null;
        String filter = null;
        iv = null;
        if (inParams != null && inParams.size() > 0) {
            try {
                iv = (CIMValue)inParams.elementAt(0);
                filter = (String)iv.getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        pdf = null;
        if (filter != null) {
            try {
                pf = new ProviderFilter(cc, filter);
                pdf = new AliasProviderDirectoryFilter(pf);
            }
            catch (Exception ex) {
                this.writeLog(2, "LM_2098", "LM_2116", ex.getLocalizedMessage(), null, null, null);
                throw new CIMException("CIM_ERR_INVALID_QUERY");
            }
        }
        try {
            UMgrWrapper uMgrWrapper = new UMgrWrapper(this.provUtil, scope);
            list = uMgrWrapper.getAllEmailAliases(pdf);
        }
        catch (CIMProviderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getMessage());
        }
        if (list == null) {
            list = new Vector(0);
        }
        Vector<String> vOutParam = new Vector<String>();
        boolean i = false;
        Enumeration en = list.elements();
        while (en.hasMoreElements()) {
            eao = (EmailAliasObj)en.nextElement();
            vOutParam.addElement(eao.getAliasName());
            vOutParam.addElement(eao.getAliasExpansion());
        }
        CIMDataType dtype = new CIMDataType(22);
        CIMValue outVal = new CIMValue(vOutParam, dtype);
        outParams.addElement(outVal);
        return rv;
    }
}

