/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.auths;

import com.sun.wbem.solarisprovider.common.ProviderFilter;
import com.sun.wbem.solarisprovider.usermgr.auths.AuthAttrObj;
import com.sun.wbem.solarisprovider.usermgr.auths.AuthProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.auths.SolarisAuthAttrTable;
import com.sun.wbem.solarisprovider.usermgr.common.UMgrProvider;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethodException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.MethodProvider;

public class Solaris_AuthorizationAttribute
extends UMgrProvider
implements MethodProvider,
Authorizable {
    private static final String SYS_CREATE = "SystemCreationClassName";
    private static final String SYS_NAME = "SystemName";
    private static final String AUTH_NAME = "authName";
    private static final String SHORT_DESC = "shortDesc";
    private static final String LONG_DESC = "longDesc";
    private static final String KEY_VALUE = "SolarisAttrKeyValue";
    private static final int M_SYS_CREATE = 1;
    private static final int M_SYS_NAME = 2;
    private static final int M_AUTH_NAME = 4;
    private static final int M_SHORT_DESC = 8;
    private static final int M_LONG_DESC = 16;
    private static final int M_KEY_VALUE = 32;
    private static final String[] PROP_NAME_TABLE = new String[]{"SystemCreationClassName", "SystemName", "authName", "shortDesc", "longDesc", "SolarisAttrKeyValue"};
    private static final int[] PROP_MASK_TABLE = new int[]{1, 2, 4, 8, 16, 32};

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        ArrayList<CIMObjectPath> allRecs = new ArrayList<CIMObjectPath>();
        SolarisAuthAttrTable aat = null;
        AuthAttrObj[] list = null;
        String scope = null;
        String msg = null;
        this.provUtil.checkAuthenticated();
        scope = this.provUtil.getMgmtScope(op);
        try {
            aat = new SolarisAuthAttrTable(scope);
            list = aat.listAuthAttributes();
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2400", "LM_2401", scope, ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            cop.addKey(SYS_CREATE, new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
            cop.addKey(SYS_NAME, new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
            cop.addKey(AUTH_NAME, new CIMValue((Object)list[i].getAuthName()));
            allRecs.add(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[allRecs.size()];
        allRecs.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        Object ci = null;
        CIMInstance[] aci = null;
        SolarisAuthAttrTable aat = null;
        AuthAttrObj[] list = null;
        String scope = null;
        String msg = null;
        this.provUtil.checkAuthenticated();
        scope = this.provUtil.getMgmtScope(op);
        try {
            aat = new SolarisAuthAttrTable(scope);
            list = aat.listAuthAttributes();
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2400", "LM_2401", scope, ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (list != null) {
            CIMClass fc = cc.localElements();
            fc = fc.filterProperties(propList, includeQualifiers, includeClassOrigin);
            int pMask = this.getPropertiesMask(propList);
            aci = new CIMInstance[list.length];
            CIMValue cvtype = new CIMValue((Object)this.provUtil.getScopeClassType(scope));
            CIMValue cvname = new CIMValue((Object)this.provUtil.getScopeDomainName(scope));
            for (int i = 0; i < list.length; ++i) {
                AuthAttrObj aa = list[i];
                aci[i] = this.buildInstance(fc, pMask, aa, cvtype, cvname);
            }
        }
        return aci;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        CIMInstance ci = null;
        SolarisAuthAttrTable aat = null;
        AuthAttrObj aa = null;
        String scope = null;
        String name = null;
        String msg = null;
        this.provUtil.checkAuthenticated();
        scope = this.provUtil.getMgmtScope(op);
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(AUTH_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (name == null) {
            msg = this.provUtil.writeLog(2, "LM_2400", "LM_2402", scope, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        try {
            aat = new SolarisAuthAttrTable(scope);
            aa = aat.readAuthAttrObj(name);
        }
        catch (DirectoryTableRowNotFoundException dex) {
            throw new CIMException("CIM_ERR_NOT_FOUND", name);
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2400", "LM_2415", name, scope, ex.getLocalizedMessage(), null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (aa == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)name);
        }
        CIMClass fc = cc.localElements();
        fc = fc.filterProperties(propList, includeQualifiers, includeClassOrigin);
        CIMValue cvtype = new CIMValue((Object)this.provUtil.getScopeClassType(scope));
        CIMValue cvname = new CIMValue((Object)this.provUtil.getScopeDomainName(scope));
        int pMask = this.getPropertiesMask(propList);
        ci = this.buildInstance(cc, pMask, aa, cvtype, cvname);
        return ci;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        ArrayList<CIMInstance> results = new ArrayList<CIMInstance>();
        CIMInstance ci = null;
        SolarisAuthAttrTable aat = null;
        AuthAttrObj[] list = null;
        String scope = null;
        String msg = null;
        this.provUtil.checkAuthenticated();
        scope = this.provUtil.getMgmtScope(op);
        ProviderFilter pf = null;
        try {
            pf = new ProviderFilter(cc, query);
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2400", "LM_2403", scope, query, null, null);
            throw new CIMException("CIM_ERR_INVALID_QUERY");
        }
        AuthProviderDirectoryFilter pdf = null;
        try {
            pdf = new AuthProviderDirectoryFilter(pf);
        }
        catch (Exception ex) {
            pdf = null;
        }
        try {
            aat = new SolarisAuthAttrTable(scope);
            list = aat.listAuthAttributes(pdf);
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2400", "LM_2401", scope, ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (list != null) {
            String[] propList = pf.getPropertiesList();
            CIMClass fc = cc.filterProperties(propList, false, false);
            int pMask = this.getPropertiesMask(propList);
            CIMValue cvtype = new CIMValue((Object)this.provUtil.getScopeClassType(scope));
            CIMValue cvname = new CIMValue((Object)this.provUtil.getScopeDomainName(scope));
            for (int i = 0; i < list.length; ++i) {
                AuthAttrObj aa = list[i];
                ci = this.buildInstance(fc, pMask, aa, cvtype, cvname);
                if (pdf == null && !pf.apply(ci)) continue;
                results.add(pf.project(ci));
            }
        }
        CIMInstance[] ciArray = new CIMInstance[results.size()];
        results.toArray(ciArray);
        return ciArray;
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        CIMValue results = null;
        String scope = null;
        String name = null;
        this.provUtil.checkAuthenticated();
        scope = this.getDefaultScope();
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(AUTH_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (methodName == null) {
            this.provUtil.writeLog(2, "LM_2400", "LM_2405", "(null)", null, null, null);
            throw new CIMMethodException("NO_SUCH_METHOD", (Object)"(null)", (Object)op.getObjectName());
        }
        if (!methodName.equals("getUserAuths")) {
            this.provUtil.writeLog(2, "LM_2400", "LM_2405", methodName, null, null, null);
            throw new CIMMethodException("NO_SUCH_METHOD", (Object)methodName, (Object)op.getObjectName());
        }
        results = this.getUserAuths(inParams, outParams);
        return results;
    }

    private CIMValue getUserAuths(Vector inParams, Vector outParams) throws CIMException {
        CIMValue rv = new CIMValue((Object)new Integer(0));
        String user_name = null;
        CIMValue iv = null;
        if (inParams != null && inParams.size() > 0) {
            try {
                iv = (CIMValue)inParams.elementAt(0);
                user_name = (String)iv.getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (user_name == null || user_name.trim().length() == 0) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)"(null)");
        }
        String[] list = null;
        try {
            list = AuthorizationUtility.getUserAuths((String)user_name);
        }
        catch (Exception ex) {
            this.provUtil.writeLog(2, "LM_2400", "LM_2406", user_name, ex.getLocalizedMessage(), null, null);
            list = null;
        }
        if (list == null) {
            list = new String[]{};
        }
        Vector<String> vlist = new Vector<String>(list.length);
        for (int i = 0; i < list.length; ++i) {
            vlist.addElement(list[i]);
        }
        CIMValue ov = new CIMValue(vlist);
        outParams.addElement(ov);
        return rv;
    }

    private int getPropertiesMask(String[] propList) throws CIMException {
        if (propList == null || propList.length == 0) {
            return -1;
        }
        int mask = 0;
        int tsize = PROP_NAME_TABLE.length;
        for (int i = 0; i < propList.length; ++i) {
            String str = propList[i];
            if (str == null) continue;
            int tmask = 0;
            for (int j = 0; j < tsize; ++j) {
                if (!str.equals(PROP_NAME_TABLE[j])) continue;
                tmask = PROP_MASK_TABLE[j];
                break;
            }
            if (tmask > 0) {
                mask += tmask;
                continue;
            }
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertiesList");
        }
        if (mask == 0) {
            mask = -1;
        }
        return mask;
    }

    private CIMInstance buildInstance(CIMClass bc, int pMask, AuthAttrObj aa, CIMValue cvtype, CIMValue cvname) throws CIMException {
        CIMInstance ci = bc.newInstance();
        if (pMask == -1) {
            ci.setProperty(SYS_CREATE, cvtype);
            ci.setProperty(SYS_NAME, cvname);
            ci.setProperty(AUTH_NAME, new CIMValue((Object)aa.getAuthName()));
            ci.setProperty(SHORT_DESC, new CIMValue((Object)aa.getShortDesc()));
            ci.setProperty(LONG_DESC, new CIMValue((Object)aa.getLongDesc()));
            ci.setProperty(KEY_VALUE, new CIMValue((Object)aa.getAttributeString()));
        } else {
            if ((pMask & 1) != 0) {
                ci.setProperty(SYS_CREATE, cvtype);
            }
            if ((pMask & 2) != 0) {
                ci.setProperty(SYS_NAME, cvname);
            }
            if ((pMask & 4) != 0) {
                ci.setProperty(AUTH_NAME, new CIMValue((Object)aa.getAuthName()));
            }
            if ((pMask & 8) != 0) {
                ci.setProperty(SHORT_DESC, new CIMValue((Object)aa.getShortDesc()));
            }
            if ((pMask & 0x10) != 0) {
                ci.setProperty(LONG_DESC, new CIMValue((Object)aa.getLongDesc()));
            }
            if ((pMask & 0x20) != 0) {
                ci.setProperty(KEY_VALUE, new CIMValue((Object)aa.getAttributeString()));
            }
        }
        return ci;
    }
}

