/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.common;

import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import java.io.Serializable;

public class FilterItem
implements Serializable {
    public static final int ATTR_CONTAINS = 1;
    public static final int ATTR_DOES_NOT_CONTAIN = 2;
    public static final int ATTR_STARTS_WITH = 3;
    public static final int ATTR_ENDS_WITH = 4;
    public static final int ATTR_EQUALS = 5;
    public static final int ATTR_DOES_NOT_EQUAL = 6;
    public static final int ATTR_LESS_THAN = 7;
    public static final int ATTR_GREATER_THAN = 8;
    public static final int ATTR_MAXIMUM = 8;
    public static final int BOOLEAN_NULL = 1;
    public static final int BOOLEAN_AND = 2;
    public static final int BOOLEAN_OR = 3;
    public static final int MAX_BOOLEAN_METHOD = 3;
    private static final String[] OP_LABEL = new String[]{"contains", "doesn't contain", "starts with", "ends with", "equals", "does not equal", "is less than", "is greater than"};
    private static final String[] BOOL_LABEL = new String[]{"NONE", "AND", "OR"};
    private String attribute = "";
    private int operator = 5;
    private String value = "";
    private int booleanOperator = 1;

    public FilterItem() throws UserException {
    }

    public FilterItem(String attribute, int operator, String value, int bool) throws UserException {
        this.setAttribute(attribute);
        this.setOperator(operator);
        this.setValue(value);
        this.setBooleanOperator(bool);
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) throws UserException {
        if (attribute == null || attribute.length() == 0) {
            throw new UserException("Invalid value for attribute");
        }
        this.attribute = attribute;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) throws UserException {
        block3: {
            block2: {
                if (operator < 1) break block2;
                if (operator <= 8) break block3;
            }
            throw new UserException("Invalid operator");
        }
        this.operator = operator;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws UserException {
        if (value == null) {
            throw new UserException("Invalid value");
        }
        this.value = value;
    }

    public int getBooleanOperator() {
        return this.booleanOperator;
    }

    public void setBooleanOperator(int bool) throws UserException {
        block3: {
            block2: {
                if (bool < 1) break block2;
                if (bool <= 3) break block3;
            }
            throw new UserException("Invalid operator");
        }
        this.booleanOperator = bool;
    }

    public void print() {
        System.out.println("Filter attribute is " + this.attribute);
        System.out.println("Filter operation is " + OP_LABEL[this.operator - 1]);
        System.out.println("Filter value is\t" + this.value);
        System.out.println("Filter boolean is\t" + BOOL_LABEL[this.booleanOperator - 1]);
    }
}

