/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.execs;

import com.sun.wbem.solarisprovider.usermgr.common.ExtAttrObj;
import java.util.Vector;

public class ExecAttrObj
extends ExtAttrObj
implements Cloneable {
    private String profName = null;
    private String policy = null;
    private String type = null;
    private String id = null;
    public static final String SOLARIS_EUID = "euid";
    public static final String SOLARIS_UID = "uid";
    public static final String SOLARIS_EGID = "egid";
    public static final String SOLARIS_GID = "gid";
    public static final String SOLARIS_INHERITED_PRIVILEGE = "privs";
    public static final String SOLARIS_LIMIT_PRIVILEGE = "limitprivs";
    public static final String DELIM = "@^#@";

    public ExecAttrObj() {
        this.policy = "";
        this.type = "";
        this.id = "";
    }

    public ExecAttrObj(String profName) {
        this.profName = profName;
        this.policy = "";
        this.type = "";
        this.id = "";
    }

    public Object clone() {
        ExecAttrObj newobj = new ExecAttrObj(this.profName);
        newobj.setPolicy(this.policy);
        newobj.setType(this.type);
        newobj.setId(this.id);
        super.clone(newobj);
        return newobj;
    }

    public String getProfName() {
        return this.profName;
    }

    public void setProfName(String newProfName) {
        this.profName = newProfName;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String newPolicy) {
        this.policy = newPolicy;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public String getEuid() {
        Vector v = this.getAttribute(SOLARIS_EUID);
        if (v != null && v.size() > 0) {
            return (String)v.elementAt(0);
        }
        return null;
    }

    public String[] getEuids() {
        return this.getAttributeArray(SOLARIS_EUID);
    }

    public void setEuid(String newEuid) {
        this.setAttribute(SOLARIS_EUID, newEuid);
    }

    public void setEuid(String[] newEuid) {
        this.setAttribute(SOLARIS_EUID, newEuid);
    }

    public String getUid() {
        Vector v = this.getAttribute(SOLARIS_UID);
        if (v != null && v.size() > 0) {
            return (String)v.elementAt(0);
        }
        return null;
    }

    public String[] getUids() {
        return this.getAttributeArray(SOLARIS_UID);
    }

    public void setUid(String newUid) {
        this.setAttribute(SOLARIS_UID, newUid);
    }

    public void setUid(String[] newUid) {
        this.setAttribute(SOLARIS_UID, newUid);
    }

    public String getEgid() {
        Vector v = this.getAttribute(SOLARIS_EGID);
        if (v != null && v.size() > 0) {
            return (String)v.elementAt(0);
        }
        return null;
    }

    public String[] getEgids() {
        return this.getAttributeArray(SOLARIS_EGID);
    }

    public void setEgid(String newEgid) {
        this.setAttribute(SOLARIS_EGID, newEgid);
    }

    public void setEgid(String[] newEgid) {
        this.setAttribute(SOLARIS_EGID, newEgid);
    }

    public String getGid() {
        Vector v = this.getAttribute(SOLARIS_GID);
        if (v != null && v.size() > 0) {
            return (String)v.elementAt(0);
        }
        return null;
    }

    public String[] getGids() {
        return this.getAttributeArray(SOLARIS_GID);
    }

    public void setGid(String newGid) {
        this.setAttribute(SOLARIS_GID, newGid);
    }

    public void setGid(String[] newGid) {
        this.setAttribute(SOLARIS_GID, newGid);
    }

    public String toString() {
        String retStr = "";
        retStr = retStr + this.profName + DELIM;
        retStr = retStr + this.policy + DELIM;
        retStr = retStr + this.type + DELIM;
        retStr = retStr + this.id + DELIM;
        retStr = retStr + this.getAttributeString() + DELIM;
        return retStr;
    }

    public ExecAttrObj toExecAttrObj(String exec_attr) {
        String attr_str;
        String id_str;
        String type_str;
        if (exec_attr == null) {
            return null;
        }
        int beg_index = 0;
        int end_index = exec_attr.indexOf(DELIM);
        String prof_str = exec_attr.substring(beg_index, end_index);
        if (prof_str == null) {
            return null;
        }
        this.setProfName(prof_str);
        beg_index = end_index + DELIM.length();
        end_index = exec_attr.indexOf(DELIM, beg_index);
        String policy_str = exec_attr.substring(beg_index, end_index);
        if (policy_str != null) {
            this.setPolicy(policy_str);
        }
        if ((type_str = exec_attr.substring(beg_index = end_index + DELIM.length(), end_index = exec_attr.indexOf(DELIM, beg_index))) != null) {
            this.setType(type_str);
        }
        if ((id_str = exec_attr.substring(beg_index = end_index + DELIM.length(), end_index = exec_attr.indexOf(DELIM, beg_index))) != null) {
            this.setId(id_str);
        }
        if ((attr_str = exec_attr.substring(beg_index = end_index + DELIM.length(), end_index = exec_attr.indexOf(DELIM, beg_index))) != null) {
            this.putAttributeString(attr_str);
        }
        return this;
    }

    static {
        ExtAttrObj.addAuthAttrMap(ExecAttrObj.class, "solaris.admin.privilege.write", new String[]{SOLARIS_INHERITED_PRIVILEGE, SOLARIS_LIMIT_PRIVILEGE});
    }
}

