/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.execs;

import com.sun.audit.AuditEvent_usermgr_add;
import com.sun.audit.AuditEvent_usermgr_delete;
import com.sun.audit.AuditEvent_usermgr_modify;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.solarisprovider.usermgr.common.UMgrProvider;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.common.UserRightsUtil;
import com.sun.wbem.solarisprovider.usermgr.execs.ExecAttrObj;
import com.sun.wbem.solarisprovider.usermgr.execs.SolarisExecAttrTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethodException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.MethodProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_ExecutionProfile
extends UMgrProvider
implements MethodProvider,
Authorizable {
    private static final String DOMAIN_TYPE = "SystemCreationClassName";
    private static final String DOMAIN_NAME = "SystemName";
    private static final String PROF_NAME = "ProfileName";
    private static final String POLICY_NAME = "PolicyName";
    private static final String EXEC_TYPE = "Type";
    private static final String EXEC_ID = "ExecID";
    private static final String KEY_VALUE = "SolarisAttrKeyValue";
    private static final String EXEC_CLASS = "Solaris_ExecutionProfile";
    public static final String PROFMGR_WRITE_RIGHT = "solaris.profmgr.write";
    public static final String PROFMGR_READ_RIGHT = "solaris.profmgr.read";

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> allRecs = new Vector<CIMObjectPath>();
        SolarisExecAttrTable pat = null;
        ExecAttrObj[] list = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_7000", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        try {
            pat = new SolarisExecAttrTable(scope);
            list = pat.listExecAttributes();
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            cop.addKey(PROF_NAME, new CIMValue((Object)list[i].getProfName()));
            cop.addKey(DOMAIN_TYPE, new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
            cop.addKey(DOMAIN_NAME, new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
            cop.addKey(EXEC_TYPE, new CIMValue((Object)list[i].getType()));
            cop.addKey(EXEC_ID, new CIMValue((Object)list[i].getId()));
            cop.addKey(POLICY_NAME, new CIMValue((Object)list[i].getPolicy()));
            allRecs.addElement(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[allRecs.size()];
        allRecs.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> allInstances = new Vector<CIMInstance>();
        CIMInstance ci = null;
        SolarisExecAttrTable pat = null;
        ExecAttrObj[] list = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_7000", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        try {
            pat = new SolarisExecAttrTable(scope);
            list = pat.listExecAttributes();
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            ExecAttrObj pa = list[i];
            ci = this.execToCim(pa, cc, scope);
            if (localOnly) {
                ci = ci.localElements();
            }
            allInstances.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
        }
        CIMInstance[] ciArray = new CIMInstance[allInstances.size()];
        allInstances.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        CIMInstance ci = null;
        SolarisExecAttrTable pat = null;
        ExecAttrObj pa = null;
        String name = null;
        String id = null;
        String type = null;
        String policy = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7005", "LM_7000", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(PROF_NAME)) {
                name = (String)cp.getValue().getValue();
            }
            if (cp.getName().equalsIgnoreCase(EXEC_TYPE)) {
                type = (String)cp.getValue().getValue();
            }
            if (cp.getName().equalsIgnoreCase(EXEC_ID)) {
                id = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(POLICY_NAME)) continue;
            policy = (String)cp.getValue().getValue();
        }
        if (name == null || type == null || id == null || policy == null) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "name, type, id and policy";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7005", "LM_7000", args, op.toString(), true, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        try {
            pat = new SolarisExecAttrTable(scope);
            pa = pat.readExecAttr(name, type, id, policy);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (pat == null || pa == null) {
            String msg = this.writeLog(1, "LM_7005", "LM_7002", name, type, id, policy);
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)msg);
        }
        ci = this.execToCim(pa, cc, scope);
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.provUtil.checkRights(PROFMGR_WRITE_RIGHT, op);
        SolarisExecAttrTable pat = null;
        ExecAttrObj pa = null;
        String name = null;
        String type = null;
        String id = null;
        String policy = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7001", "LM_7000", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(PROF_NAME)) {
                name = (String)cp.getValue().getValue();
            }
            if (cp.getName().equalsIgnoreCase(EXEC_TYPE)) {
                type = (String)cp.getValue().getValue();
            }
            if (cp.getName().equalsIgnoreCase(EXEC_ID)) {
                id = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(POLICY_NAME)) continue;
            policy = (String)cp.getValue().getValue();
        }
        if (name == null || type == null || id == null || policy == null) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "name, type, id and policy";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7001", "LM_7000", args, op.toString(), true, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        try {
            pat = new SolarisExecAttrTable(scope);
            pa = pat.readExecAttr(name, type, id, policy);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (pa == null) {
            String msg = this.writeLog(1, "LM_7001", "LM_7002", name, type, id, policy);
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)msg);
        }
        ExecAttrObj newPa = this.cimToExec(ci);
        UserRightsUtil userRights = new UserRightsUtil(this.provUtil);
        try {
            userRights.checkAttrAssignRights(pa, newPa);
        }
        catch (UserException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        try {
            pat.writeExecAttr(newPa);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        this.writeLog(0, "LM_7003", "LM_7004", name, type, id, policy);
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_ExecutionProfile setInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_ExecutionProfile setInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_usermgr_modify execModEvent = new AuditEvent_usermgr_modify(auditSession);
            if (execModEvent == null) {
                Debug.trace1((String)"Solaris_ExecutionProfile setInstance() : null AuditEvent_usermgr_modify");
                return;
            }
            String propertyToken = null;
            propertyToken = this.provUtil.formatAuditToken(ci);
            execModEvent.object_name(op.getObjectName());
            execModEvent.domain(this.provUtil.getDomainToken(scope));
            execModEvent.name_service(this.provUtil.getNameServiceToken(scope));
            execModEvent.auth_used(PROFMGR_WRITE_RIGHT);
            execModEvent.changed_values(propertyToken);
            execModEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_ExecutionProfile setInstance() : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.provUtil.checkRights(PROFMGR_WRITE_RIGHT, op);
        SolarisExecAttrTable pat = null;
        ExecAttrObj pa = null;
        String name = null;
        String id = null;
        String type = null;
        String policy = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_7000", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(PROF_NAME)) {
                name = (String)cp.getValue().getValue();
            }
            if (cp.getName().equalsIgnoreCase(EXEC_TYPE)) {
                type = (String)cp.getValue().getValue();
            }
            if (cp.getName().equalsIgnoreCase(EXEC_ID)) {
                id = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(POLICY_NAME)) continue;
            policy = (String)cp.getValue().getValue();
        }
        if (name == null || type == null || id == null || policy == null) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "name, type, id and policy";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_7000", args, op.toString(), true, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        try {
            pat = new SolarisExecAttrTable(scope);
            pa = pat.readExecAttr(name, type, id, policy);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (pa != null) {
            String msg = this.writeLog(1, "LM_7018", "LM_7019", name, type, id, policy);
            throw new CIMException("CIM_ERR_ALREADY_EXISTS", (Object)msg);
        }
        ExecAttrObj newPa = this.cimToExec(ci);
        UserRightsUtil userRights = new UserRightsUtil(this.provUtil);
        try {
            userRights.checkAttrAssignRights(null, newPa);
        }
        catch (UserException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        try {
            pat.writeExecAttr(newPa);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
        cop.addKey(PROF_NAME, new CIMValue((Object)newPa.getProfName()));
        cop.addKey(DOMAIN_TYPE, new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
        cop.addKey(DOMAIN_NAME, new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
        cop.addKey(EXEC_TYPE, new CIMValue((Object)newPa.getType()));
        cop.addKey(EXEC_ID, new CIMValue((Object)newPa.getId()));
        cop.addKey(POLICY_NAME, new CIMValue((Object)newPa.getPolicy()));
        this.writeLog(0, "LM_7020", "LM_7021", name, type, id, policy);
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_ExecutionProfile createInstance() : null WbemAuditSession.");
                return cop;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_ExecutionProfile createInstance() : null platform AuditSession.");
                return cop;
            }
            AuditEvent_usermgr_add execAddEvent = new AuditEvent_usermgr_add(auditSession);
            if (execAddEvent == null) {
                Debug.trace1((String)"Solaris_ExecutionProfile createInstance() : null AuditEvent_usermgr_add.");
                return cop;
            }
            String propertyToken = null;
            propertyToken = this.provUtil.formatAuditToken(ci);
            execAddEvent.object_name(op.getObjectName());
            execAddEvent.domain(this.provUtil.getDomainToken(scope));
            execAddEvent.name_service(this.provUtil.getNameServiceToken(scope));
            execAddEvent.auth_used(PROFMGR_WRITE_RIGHT);
            execAddEvent.initial_values(propertyToken);
            execAddEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_ExecutionProfile createInstance() : Auditing threw exception.", (Throwable)ex);
            return cop;
        }
        return cop;
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        this.provUtil.checkRights(PROFMGR_WRITE_RIGHT, op);
        SolarisExecAttrTable pat = null;
        String name = null;
        String type = null;
        String id = null;
        String policy = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_7000", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        pat = new SolarisExecAttrTable(scope);
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase(PROF_NAME)) {
                name = (String)cp.getValue().getValue();
            }
            if (cp.getName().equalsIgnoreCase(EXEC_TYPE)) {
                type = (String)cp.getValue().getValue();
            }
            if (cp.getName().equalsIgnoreCase(EXEC_ID)) {
                id = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase(POLICY_NAME)) continue;
            policy = (String)cp.getValue().getValue();
        }
        if (name == null || type == null || id == null) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "name, type, id and policy";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_7000", args, op.toString(), true, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        ExecAttrObj exec = new ExecAttrObj(name);
        exec.setType(type);
        exec.setId(id);
        exec.setPolicy(policy);
        try {
            pat.removeExecAttr(exec);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, "LM_7008", ex.getMessage(), null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception solex) {
            String msg = this.writeLog(2, "LM_7008", solex.getMessage(), null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        this.writeLog(0, "LM_7006", "LM_7007", name, type, id, policy);
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_ExecutionProfile deleteInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_ExecutionProfile deleteInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_usermgr_delete execDelEvent = new AuditEvent_usermgr_delete(auditSession);
            if (execDelEvent == null) {
                Debug.trace1((String)"Solaris_ExecutionProfile deleteInstance() : null AuditEvent_usermgr_delete");
                return;
            }
            execDelEvent.object_name(op.getObjectName());
            execDelEvent.domain(this.provUtil.getDomainToken(scope));
            execDelEvent.name_service(this.provUtil.getNameServiceToken(scope));
            execDelEvent.auth_used(PROFMGR_WRITE_RIGHT);
            String delValue = "ProfileName=" + name + ";Type=" + type + ";PolicyName=" + policy + ";ExecID=" + id;
            execDelEvent.delete_values(delValue);
            execDelEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_ExecutionProfile deleteInstance() : Auditing threw exception.", (Throwable)ex);
            return;
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] ciArray = this.enumerateInstances(op, true, false, false, null, cc);
            for (int i = 0; i < ciArray.length; ++i) {
                if (where != null && !where.apply((CIMElement)ciArray[i])) continue;
                result.addElement(attrs.apply((CIMElement)ciArray[i]));
            }
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e.toString());
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        CIMValue results = null;
        CIMObjectPath cop = new CIMObjectPath(EXEC_CLASS, "root\\cimv2");
        CIMClass cc = this.cimomhandle.getClass(cop, false, true, true, null);
        String name = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_2310", "LM_7000", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(PROF_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (methodName == null) {
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
        if (!methodName.equalsIgnoreCase("bulkData")) {
            throw new CIMMethodException("NO_SUCH_METHOD", (Object)methodName, (Object)op.getObjectName());
        }
        results = this.bulkData(cc, scope, inParams, outParams);
        return results;
    }

    private CIMValue bulkData(CIMClass cc, String scope, Vector inParams, Vector outParams) throws CIMException {
        this.provUtil.checkRights(PROFMGR_READ_RIGHT, (CIMObjectPath)null);
        CIMValue rv = new CIMValue((Object)new Integer(0));
        CIMValue iv = null;
        String profName = null;
        String type = null;
        String policy = null;
        if (inParams != null && inParams.size() > 2) {
            try {
                iv = (CIMValue)inParams.elementAt(0);
                profName = (String)iv.getValue();
                iv = (CIMValue)inParams.elementAt(1);
                type = (String)iv.getValue();
                if (type.trim().length() == 0) {
                    type = null;
                }
                if ((policy = (String)(iv = (CIMValue)inParams.elementAt(2)).getValue()).trim().length() == 0) {
                    policy = null;
                }
            }
            catch (Exception ex) {
                this.writeLog(2, ex);
            }
        }
        SolarisExecAttrTable pat = null;
        ExecAttrObj[] list = null;
        try {
            pat = new SolarisExecAttrTable(scope);
            list = pat.readExecAttrs(profName, type, policy);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (list == null) {
            outParams.addElement(new CIMValue((Vector)null, new CIMDataType(22)));
            return rv;
        }
        Vector<String> vOutParam = new Vector<String>();
        for (int i = 0; i < list.length; ++i) {
            vOutParam.addElement(list[i].toString());
        }
        CIMDataType dtype = new CIMDataType(22);
        CIMValue outVal = new CIMValue(vOutParam, dtype);
        outParams.addElement(outVal);
        return rv;
    }

    private ExecAttrObj cimToExec(CIMInstance ci) throws CIMException {
        ExecAttrObj newPa = null;
        try {
            String key_val;
            String exec_id;
            String policy;
            String profName = (String)ci.getProperty(PROF_NAME).getValue().getValue();
            newPa = new ExecAttrObj(profName);
            String exec_type = (String)ci.getProperty(EXEC_TYPE).getValue().getValue();
            if (exec_type != null) {
                newPa.setType(exec_type);
            }
            if ((policy = (String)ci.getProperty(POLICY_NAME).getValue().getValue()) != null) {
                newPa.setPolicy(policy);
            }
            if ((exec_id = (String)ci.getProperty(EXEC_ID).getValue().getValue()) != null) {
                newPa.setId(exec_id);
            }
            if ((key_val = (String)ci.getProperty(KEY_VALUE).getValue().getValue()) != null) {
                newPa.putAttributeString(key_val);
            }
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        return newPa;
    }

    private CIMInstance execToCim(ExecAttrObj pa, CIMClass cc, String scope) throws CIMException {
        CIMInstance ci = null;
        ci = cc.newInstance();
        ci.setProperty(DOMAIN_TYPE, new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
        ci.setProperty(DOMAIN_NAME, new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
        ci.setProperty(PROF_NAME, new CIMValue((Object)pa.getProfName()));
        ci.setProperty(EXEC_TYPE, new CIMValue((Object)pa.getType()));
        ci.setProperty(EXEC_ID, new CIMValue((Object)pa.getId()));
        ci.setProperty(POLICY_NAME, new CIMValue((Object)pa.getPolicy()));
        ci.setProperty(KEY_VALUE, new CIMValue((Object)pa.getAttributeString()));
        return ci;
    }

    private String[] getKeys(CIMObjectPath op) {
        String[] keys = new String[op.getKeys().size() + 1];
        int i = 0;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            keys[i] = (String)cp.getValue().getValue();
            if (keys[i] == null) {
                keys[i] = " ";
            }
            ++i;
        }
        return keys;
    }
}

