/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.homedir;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.AdminCommonTools;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.homedir.HomeDirObj;
import java.io.File;
import java.text.StringCharacterIterator;

public class UMgrWrapper {
    ProviderUtility provUtil = null;
    private String mvCommand = "/usr/bin/mv";
    private String chownCommand = "/usr/bin/chown";
    private String chmodCommand = "/usr/bin/chmod";
    private String chgrpCommand = "/usr/bin/chgrp";
    private String cpCommand = "/usr/bin/cp";
    private String mkdirCommand = "/usr/bin/mkdir";
    private String rmdirCommand = "/usr/bin/rm -r ";
    private String DEFAULT_SOURCE_DIRECTORY = "/etc/skel";
    private String ROOT = "/";
    private String ETC = "/etc";
    private String USR = "/usr";
    private String HOM = "/home";
    private String VAR = "/var";
    private String OPT = "/opt";
    private String TMP = "/tmp";
    private String PRC = "/proc";

    public UMgrWrapper(ProviderUtility provUtil) throws UserException {
        this.provUtil = provUtil;
    }

    public synchronized HomeDirObj getPermissions(HomeDirObj homeObj) throws UserException {
        String pathname = homeObj.getPathname();
        int owner = 7;
        int group = 5;
        int world = 0;
        homeObj.setOwnerPerms(owner);
        homeObj.setGroupPerms(group);
        homeObj.setWorldPerms(world);
        File localFile = new File(pathname);
        try {
            if (!localFile.exists()) {
                homeObj.setModifyServer(true);
                homeObj.setForceModify(true);
                return homeObj;
            }
        }
        catch (Exception exp) {
            return homeObj;
        }
        String[] strEnv = new String[]{"LC_ALL=C", "LC_MESSAGES=C", "LANG=C"};
        String cmdInput = "/bin/ls -ld ";
        cmdInput = cmdInput.concat(pathname);
        String[] lsOutput = AdminCommonTools.CMN_exec(cmdInput, strEnv);
        if (lsOutput == null) {
            AdminCommonTools.CMN_HandleOutput("ls command failed!");
            return homeObj;
        }
        StringCharacterIterator it = new StringCharacterIterator(lsOutput[0]);
        owner = 0;
        char c = it.first();
        c = it.next();
        if (c == 'r') {
            owner = 5;
        }
        if ((c = it.next()) == 'w') {
            owner = 7;
        }
        group = 0;
        c = it.next();
        c = it.next();
        if (c == 'r') {
            group = 5;
        }
        if ((c = it.next()) == 'w') {
            group = 7;
        }
        world = 0;
        c = it.next();
        c = it.next();
        if (c == 'r') {
            world = 5;
        }
        if ((c = it.next()) == 'w') {
            world = 7;
        }
        homeObj.setOwnerPerms(owner);
        homeObj.setGroupPerms(group);
        homeObj.setWorldPerms(world);
        return homeObj;
    }

    public synchronized void deleteHomeDir(String pathName) throws UserException {
        String msg = null;
        String nPath = null;
        nPath = pathName.trim();
        boolean pathOK = this.isStringOK(nPath);
        if (!pathOK) {
            msg = this.provUtil.writeLog(2, "LM_2047", "LM_2307", nPath, null, null, null);
            throw new UserException(msg);
        }
        if (nPath.equals(this.ROOT) || nPath.equals(this.ETC) || nPath.equals(this.USR) || nPath.equals(this.HOM) || nPath.equals(this.VAR) || nPath.equals(this.OPT) || nPath.equals(this.TMP) || nPath.equals(this.PRC)) {
            msg = this.provUtil.writeLog(2, "LM_2047", "LM_2232", nPath, null, null, null);
            throw new UserException(msg);
        }
        String cmd = new String(this.rmdirCommand + nPath);
        Runtime rt = Runtime.getRuntime();
        try {
            Process proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
            proc.waitFor();
        }
        catch (Exception exp) {
            msg = this.provUtil.writeLog(2, "LM_2047", "LM_2307", nPath, null, null, null);
            throw new UserException(msg);
        }
        this.provUtil.writeLog(0, "LM_2044", "LM_2304", nPath, null, null, null);
    }

    public synchronized void createHomeDir(HomeDirObj homeObj) throws UserException {
        String pathname = "";
        String userName = homeObj.getUserName();
        if (homeObj != null) {
            pathname = homeObj.getPathname();
        }
        String msg = null;
        File homeDir = null;
        try {
            homeDir = new File(pathname);
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2043", "LM_2220", ex.getLocalizedMessage(), null, null, null);
            throw new UserException(msg);
        }
        if (homeDir.exists()) {
            msg = this.provUtil.writeLog(2, "LM_2043", "LM_2064", pathname, userName, homeObj.getServer(), null);
            throw new UserException(msg);
        }
        try {
            this.performCreateHomeDir(homeObj);
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2043", "LM_2308", pathname, null, null, null);
            throw new UserException(msg);
        }
        this.provUtil.writeLog(0, "LM_2045", "LM_2076", userName, pathname, null, null);
    }

    public void modifyHomeDir(HomeDirObj newHomeObj, String inPath) throws UserException {
        String msg = null;
        if (newHomeObj == null) {
            msg = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
            throw new UserException(msg);
        }
        String userName = newHomeObj.getUserName();
        String newPath = inPath;
        String oldPath = newHomeObj.getPathname();
        if (newPath == null) {
            newPath = "";
        }
        if (newPath.trim().length() == 0) {
            newPath = oldPath;
        }
        if (newPath.equals(oldPath)) {
            File oldDir = new File(oldPath);
            if (!oldDir.exists()) {
                try {
                    this.performCreateHomeDir(newHomeObj);
                    msg = this.provUtil.writeLog(0, "LM_2004", "LM_2076", userName, newPath, null, null);
                    return;
                }
                catch (Exception ex) {
                    msg = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
                    throw new UserException(msg);
                }
            }
        } else {
            Process proc;
            Runtime rt;
            String cmd;
            File newDir = new File(newPath);
            if (newDir.exists()) {
                msg = this.provUtil.writeLog(2, "LM_2005", "LM_2065", newPath, userName, newHomeObj.getServer(), null);
                throw new UserException(msg);
            }
            int index = newPath.lastIndexOf("/");
            String newString = null;
            if (index == -1) {
                msg = this.provUtil.writeLog(2, "LM_2005", "LM_2313", newPath, null, null, null);
                throw new UserException(msg);
            }
            newString = newPath.substring(0, index);
            File parentDir = new File(newString);
            if (!parentDir.exists()) {
                cmd = new String(this.mkdirCommand + " -m 750 -p " + newString);
                rt = Runtime.getRuntime();
                try {
                    proc = rt.exec(cmd);
                    proc.getInputStream().close();
                    proc.getErrorStream().close();
                    proc.waitFor();
                }
                catch (Exception exp) {
                    msg = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
                    throw new UserException(msg);
                }
            }
            cmd = new String(this.mvCommand + " " + oldPath + " " + newPath);
            rt = Runtime.getRuntime();
            try {
                proc = rt.exec(cmd);
                proc.getInputStream().close();
                proc.getErrorStream().close();
                proc.waitFor();
            }
            catch (Exception exp) {
                msg = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
                throw new UserException(msg);
            }
        }
        String perms = newHomeObj.getOwnerPerms() + newHomeObj.getGroupPerms() + newHomeObj.getWorldPerms();
        String cmd = new String(this.chmodCommand + " " + perms + " " + newPath);
        Runtime rt = Runtime.getRuntime();
        try {
            Process proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
            proc.waitFor();
        }
        catch (Exception exp) {
            msg = this.provUtil.writeLog(2, "LM_2005", "LM_2309", newPath, null, null, null);
            throw new UserException(msg);
        }
        this.provUtil.writeLog(0, "LM_2004", "LM_2080", userName, newPath, null, null);
    }

    private void performCreateHomeDir(HomeDirObj homeObj) throws SolServerException, UserException {
        Process proc;
        if (homeObj == null) {
            throw new SolServerException("?????");
        }
        String ownerUID = homeObj.getUID();
        String pathname = homeObj.getPathname();
        String perms = homeObj.getOwnerPerms() + homeObj.getGroupPerms() + homeObj.getWorldPerms();
        String primaryGroup = homeObj.getPrimaryGroup();
        String cmd = new String(this.mkdirCommand + " -m 750 -p " + pathname);
        Runtime rt = Runtime.getRuntime();
        try {
            Process proc2 = rt.exec(cmd);
            proc2.getInputStream().close();
            proc2.getErrorStream().close();
            proc2.waitFor();
        }
        catch (Exception exp) {
            AdminCommonTools.CMN_Trace1("Exec'ing mkdir failed");
            exp.printStackTrace();
            throw new SolServerException("?????");
        }
        String initialDir = null;
        initialDir = homeObj.getInitFilePath() != null && homeObj.getInitFilePath().trim().length() != 0 ? new String(homeObj.getInitFilePath()) : new String(this.DEFAULT_SOURCE_DIRECTORY);
        initialDir = initialDir.endsWith("/") ? initialDir.concat(".") : initialDir.concat("/.");
        cmd = new String(this.cpCommand + " -r -p " + initialDir + " " + pathname);
        try {
            String[] cpOutput = AdminCommonTools.CMN_exec(cmd);
            for (int i = 0; i < cpOutput.length; ++i) {
                if (cpOutput[i] == null) continue;
                AdminCommonTools.CMN_Trace1("cpOutput is " + cpOutput[i]);
            }
        }
        catch (Exception exp) {
            AdminCommonTools.CMN_Trace1("Exec'ing cp failed");
            throw new SolServerException("?????");
        }
        cmd = new String(this.mvCommand + " " + pathname + "/" + "local.login " + pathname + "/" + ".login");
        try {
            proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
            proc.waitFor();
        }
        catch (Exception exp) {
            throw new SolServerException("?????");
        }
        cmd = new String(this.mvCommand + " " + pathname + "/" + "local.profile " + pathname + "/" + ".profile");
        try {
            proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
            proc.waitFor();
        }
        catch (Exception exp) {
            throw new SolServerException("?????");
        }
        cmd = new String(this.mvCommand + " " + pathname + "/" + "local.cshrc " + pathname + "/" + ".cshrc");
        try {
            proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
        }
        catch (Exception exp) {
            throw new SolServerException("?????");
        }
        cmd = new String(this.chmodCommand + " " + perms + " " + pathname);
        try {
            proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
            proc.waitFor();
        }
        catch (Exception exp) {
            AdminCommonTools.CMN_Trace1("exec'ing chmod failed");
            throw new SolServerException("?????");
        }
        cmd = new String(this.chownCommand + " -fR " + ownerUID + " " + pathname);
        try {
            proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
            proc.waitFor();
        }
        catch (Exception exp) {
            AdminCommonTools.CMN_Trace1("exec'ing chown failed");
            throw new SolServerException("?????");
        }
        cmd = new String(this.chgrpCommand + " -fR " + primaryGroup + " " + pathname);
        try {
            proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
            proc.waitFor();
        }
        catch (Exception exp) {
            AdminCommonTools.CMN_Trace1("exec'ing chown failed");
            throw new SolServerException("?????");
        }
    }

    private boolean isStringOK(String path) {
        boolean b = true;
        int len = path.length();
        if (len < 1) {
            b = false;
        }
        for (int i = 0; i < len; ++i) {
            if (path.charAt(i) != ' ' && path.charAt(i) != '.' && path.charAt(i) != '*') continue;
            b = false;
            break;
        }
        return b;
    }
}

