/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.mbox;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.mbox.MBoxObj;
import com.sun.wbem.solarisprovider.usermgr.users.SolServicesAttr;
import java.io.File;

public class MboxWrapper {
    private static String DEFAULT_MAILBOX_DIRECTORY = "/var/mail/";
    private static String DEFAULT_MAILBOX_PERMISSIONS = "660";
    private static String DEFAULT_MAILBOX_GROUP = "mail";
    private static String NEW_USER_NAME = "newUserName";
    ProviderUtility provUtil = null;
    private String mvCommand = "/usr/bin/mv";
    private String lsCommand = "/usr/bin/ls";
    private String chownCommand = "/usr/bin/chown";
    private String chmodCommand = "/usr/bin/chmod";
    private String chgrpCommand = "/usr/bin/chgrp";
    private String cpCommand = "/usr/bin/cp";
    private String mkdirCommand = "/usr/bin/mkdir";
    private String touchCommand = "/usr/bin/touch";
    private String rmdirCommand = "/usr/bin/rm -r ";
    private static boolean library_loaded = false;

    public static native int nativeCreateMailbox(String var0, String var1);

    public MboxWrapper(ProviderUtility provUtil) {
        this.provUtil = provUtil;
    }

    public synchronized void createMailbox(MBoxObj mBoxObj) throws Exception {
        String pathname = new String("/var/mail/" + mBoxObj.getUserName());
        String msg = "";
        File mailbox = new File(pathname);
        if (mailbox.exists()) {
            msg = this.provUtil.writeLog(2, "LM_2043", "LM_2231", pathname, null, null, null);
            throw new UserException(msg);
        }
        try {
            this.performCreateMailbox(mBoxObj);
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2043", "LM_2230", ex.getLocalizedMessage(), null, null, null);
            throw new UserException(msg);
        }
        this.provUtil.writeLog(0, "LM_2045", "LM_2089", mBoxObj.getUserName(), null, null, null);
    }

    public synchronized void deleteMBox(String userName) throws Exception {
        String pathName = new String(DEFAULT_MAILBOX_DIRECTORY + userName);
        String msg = "";
        String cmd = new String(this.rmdirCommand + pathName);
        Runtime rt = Runtime.getRuntime();
        try {
            Process proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2068", "LM_2230", ex.getLocalizedMessage(), null, null, null);
            throw new UserException(msg);
        }
        this.provUtil.writeLog(0, "LM_2044", "LM_2301", pathName, null, null, null);
    }

    public synchronized void modifyMailBox(MBoxObj mBoxObj, String newName) throws Exception {
        String msg = "";
        String mailboxPath = new String(SolServicesAttr.DEFAULT_MAILBOX_DIRECTORY + mBoxObj.getUserName());
        File mailbox = new File(mailboxPath);
        if (!mailbox.exists()) {
            try {
                mBoxObj.setUserName(newName);
                this.performCreateMailbox(mBoxObj);
                String[] args = new String[]{mBoxObj.getUserName(), mailboxPath};
                this.provUtil.writeLog(0, "LM_2004", "LM_2087", mBoxObj.getUserName(), mBoxObj.getMailServer(), null, null);
                return;
            }
            catch (Exception ex) {
                msg = this.provUtil.writeLog(2, "LM_2005", "LM_2230", ex.getLocalizedMessage(), null, null, null);
                throw new UserException(msg);
            }
        }
        String newMailboxPath = new String(SolServicesAttr.DEFAULT_MAILBOX_DIRECTORY + newName);
        String cmd = new String(this.mvCommand + " " + mailboxPath + " " + newMailboxPath);
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
        }
        catch (Exception ex) {
            msg = this.provUtil.writeLog(2, "LM_2005", "LM_2230", ex.getLocalizedMessage(), null, null, null);
            throw new UserException(msg);
        }
        this.provUtil.writeLog(0, "LM_2004", "LM_2087", mBoxObj.getUserName(), mBoxObj.getMailServer(), null, null);
    }

    private void performCreateMailbox(MBoxObj mBoxObj) throws Exception {
        String userName = new String(mBoxObj.getUserName());
        String pathname = new String(DEFAULT_MAILBOX_DIRECTORY + userName);
        if (library_loaded) {
            if (MboxWrapper.nativeCreateMailbox(pathname, userName) < 0) {
                System.err.println("Error creating mailbox...");
            }
        } else {
            String cmd = new String(this.touchCommand + " " + pathname);
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
            cmd = new String(this.chmodCommand + " " + DEFAULT_MAILBOX_PERMISSIONS + " " + pathname);
            proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
            cmd = new String(this.chownCommand + " " + mBoxObj.getUserUID() + " " + pathname);
            proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
            cmd = new String(this.chgrpCommand + " " + DEFAULT_MAILBOX_GROUP + " " + pathname);
            proc = rt.exec(cmd);
            proc.getInputStream().close();
            proc.getErrorStream().close();
        }
    }

    static {
        try {
            System.loadLibrary("solprov");
            library_loaded = true;
        }
        catch (Exception ex) {
            System.err.println("Error while loading library libsolprov.so");
            ex.printStackTrace();
        }
    }
}

