/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.profs;

import com.sun.wbem.solarisprovider.usermgr.common.ExtAttrObj;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class ProfAttrObj
extends ExtAttrObj
implements Cloneable {
    private String profName = null;
    private String[] longDesc = null;
    public static final String SOLARIS_PREFIX = "solaris";
    public static final String SOLARIS_DOT = ".";
    public static final String SOLARIS_ALL = "*";
    public static final String SOLARIS_GRANT = "grant";
    public static final String SOLARIS_AUTHS = "auths";
    public static final String SOLARIS_PROFILES = "profiles";
    public static final String SOLARIS_PROF_HELP = "help";
    public static final String SOLARIS_PRIVILEGE = "privs";

    public ProfAttrObj() {
        this.longDesc = new String[1];
        this.longDesc[0] = null;
    }

    public ProfAttrObj(String profName) {
        this.profName = profName;
        this.longDesc = new String[1];
        this.longDesc[0] = null;
    }

    public String getProfName() {
        return this.profName;
    }

    public void setProfName(String newProfName) {
        this.profName = newProfName;
    }

    public Object clone() {
        ProfAttrObj newobj = new ProfAttrObj(this.profName);
        newobj.setLongDesc(this.longDesc);
        super.clone(newobj);
        return newobj;
    }

    public String getLongDesc() {
        if (this.longDesc == null) {
            return null;
        }
        return this.longDesc[0];
    }

    public String[] getLongDescs() {
        if (this.longDesc == null) {
            return null;
        }
        return this.longDesc;
    }

    public String getLongDesc(Locale locale) {
        if (this.longDesc == null) {
            return null;
        }
        return this.longDesc[0];
    }

    public void setLongDesc(String longDesc) {
        if (this.longDesc == null) {
            this.longDesc = new String[1];
        }
        this.longDesc[0] = longDesc;
    }

    public void setLongDesc(String[] longDesc) {
        this.longDesc = longDesc;
    }

    public String[] getAuthNames() {
        return this.getAttributeArray(SOLARIS_AUTHS);
    }

    public Vector getAuthNamesVector() {
        return this.getAttribute(SOLARIS_AUTHS);
    }

    public void setAuthNames(String[] authArray) {
        this.setAttribute(SOLARIS_AUTHS, authArray);
    }

    public void setAuthNamesVector(Vector names) {
        this.setAttribute(SOLARIS_AUTHS, names);
    }

    public void addAuthNames(String[] authArray) {
        this.addAttribute(SOLARIS_AUTHS, authArray);
    }

    public void addAuthNames(String authName) {
        this.setAttribute(SOLARIS_AUTHS, authName);
    }

    public void delAuthNames(String authname) {
        this.delAttribute(SOLARIS_AUTHS, authname);
    }

    public void delAuthNames(String[] authArray) {
        this.delAttribute(SOLARIS_AUTHS, authArray);
    }

    public String[] getProfNames() {
        return this.getAttributeArray(SOLARIS_PROFILES);
    }

    public Vector getProfNamesVector() {
        return this.getAttribute(SOLARIS_PROFILES);
    }

    public void setProfNames(String[] profArray) {
        this.setAttribute(SOLARIS_PROFILES, profArray);
    }

    public void setProfNamesVector(Vector names) {
        this.setAttribute(SOLARIS_PROFILES, names);
    }

    public void addProfNames(String[] profArray) {
        this.addAttribute(SOLARIS_PROFILES, profArray);
    }

    public void addProfNames(String profName) {
        this.addAttribute(SOLARIS_PROFILES, profName);
    }

    public void delProfNames(String profName) {
        this.delAttribute(SOLARIS_PROFILES, profName);
    }

    public void delProfNames(String[] profArray) {
        this.delAttribute(SOLARIS_PROFILES, profArray);
    }

    public String getLongDescId() {
        Vector v = this.getAttribute(SOLARIS_PROF_HELP);
        if (v != null && v.size() > 0) {
            return (String)v.elementAt(0);
        }
        return null;
    }

    public String[] getLongDescIds() {
        return this.getAttributeArray(SOLARIS_PROF_HELP);
    }

    public Vector getLongDescIdsVector() {
        return this.getAttribute(SOLARIS_PROF_HELP);
    }

    public void setLongDescId(String longDescHelp) {
        this.setAttribute(SOLARIS_PROF_HELP, longDescHelp);
    }

    public void setLongDescId(String[] longDescIdArray) {
        this.setAttribute(SOLARIS_PROF_HELP, longDescIdArray);
    }

    public void setLongDescIdVector(Vector names) {
        this.setAttribute(SOLARIS_PROF_HELP, names);
    }

    public boolean checkAuthName(String authname) {
        Vector authNames = this.getAttribute(SOLARIS_AUTHS);
        if (authNames == null) {
            return false;
        }
        if (authNames.contains(authname)) {
            return true;
        }
        StringTokenizer tk = new StringTokenizer(authname, SOLARIS_DOT);
        int tokCount = tk.countTokens() - 1;
        if (tokCount < 1) {
            return false;
        }
        String matchType = authname.endsWith(".grant") ? SOLARIS_GRANT : SOLARIS_ALL;
        String authPath = "";
        for (int i = 0; i < tokCount; ++i) {
            if (!authNames.contains((authPath = authPath.concat((String)tk.nextElement() + SOLARIS_DOT)).concat(matchType))) continue;
            return true;
        }
        return false;
    }

    public boolean checkAuthName(String[] authArray, boolean OrFlag) {
        if (OrFlag) {
            for (int i = 0; i < authArray.length; ++i) {
                if (!this.checkAuthName(authArray[i])) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < authArray.length; ++i) {
            if (this.checkAuthName(authArray[i])) continue;
            return false;
        }
        return true;
    }

    static {
        ExtAttrObj.addAuthAttrMap(ProfAttrObj.class, "solaris.admin.privilege.write", new String[]{SOLARIS_PRIVILEGE});
    }
}

