/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.profs;

import com.sun.wbem.solarisprovider.usermgr.common.KeyValue;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.profs.ProfAttrObj;
import com.sun.wbem.solarisprovider.usermgr.profs.ProfAttrTable;
import com.sun.wbem.utility.directorytable.DirectoryMask;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Vector;

public class SolarisProfAttrTable
implements ProfAttrTable {
    private static final String table = new String("prof_attr");
    private static final String emptyString = new String("");
    private static final String nameCol = "name";
    private static final String res1Col = "res1";
    private static final String res2Col = "res2";
    private static final String descCol = "long_descr";
    private static final String attrCol = "attr";
    private int nameColNum = 0;
    private int res1ColNum = 0;
    private int res2ColNum = 0;
    private int descColNum = 0;
    private int attrColNum = 0;
    private String scope;

    public SolarisProfAttrTable(String scopeUrl) {
        this.scope = scopeUrl;
        Class[] noArgs = new Class[]{};
        Class[] stringArray = new Class[]{String[].class};
        ProfAttrObj attrObj = new ProfAttrObj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfAttrObj readProfAttr(String profName) throws DirectoryTableException {
        ProfAttrObj attrObj = null;
        DirectoryTable etcTable = this.openProfAttrTable();
        try {
            DirectoryRow profAttrRow = etcTable.getRowInstance();
            profAttrRow.putColumn(this.nameColNum, profName);
            profAttrRow = etcTable.getFirstRow((SearchTemplate)profAttrRow);
            if (profAttrRow != null) {
                attrObj = new ProfAttrObj(profName);
                attrObj.setLongDesc(profAttrRow.getColumn(this.descColNum));
                String attrList = profAttrRow.getColumn(this.attrColNum);
                KeyValue.getAttributes(attrList, attrObj.attrSet);
            }
        }
        finally {
            this.closeProfAttrTable(etcTable);
        }
        return attrObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProfAttr(ProfAttrObj profAttr) throws DirectoryTableException {
        DirectoryTable etcTable = this.openProfAttrTable();
        try {
            DirectoryRow newAttrRow = etcTable.getRowInstance();
            newAttrRow.putColumn(this.nameColNum, profAttr.getProfName());
            DirectoryRow oldAttrRow = etcTable.getFirstRow((SearchTemplate)newAttrRow);
            String attrList = oldAttrRow != null ? oldAttrRow.getColumn(this.attrColNum) : null;
            String attrs = KeyValue.putAttributes(attrList, profAttr.attrSet, false);
            newAttrRow.putColumn(this.descColNum, profAttr.getLongDesc());
            newAttrRow.putColumn(this.attrColNum, attrs);
            if (oldAttrRow == null) {
                etcTable.addRow(newAttrRow);
            } else {
                etcTable.modifyRow(oldAttrRow, newAttrRow);
            }
        }
        finally {
            this.closeProfAttrTable(etcTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProfAttr(String profName) throws DirectoryTableException, SolServerException {
        DirectoryTable etcTable = this.openProfAttrTable();
        try {
            DirectoryRow profAttrRow = etcTable.getRowInstance();
            profAttrRow.putColumn(this.nameColNum, profName);
            profAttrRow = etcTable.getFirstRow((SearchTemplate)profAttrRow);
            if (profAttrRow == null) {
                throw new SolServerException("EXM_SUS78", profName);
            }
            etcTable.deleteRow(profAttrRow);
        }
        finally {
            this.closeProfAttrTable(etcTable);
        }
    }

    public void removeProfAttr(ProfAttrObj profAttr) throws DirectoryTableException, SolServerException {
        String profName = profAttr.getProfName();
        this.removeProfAttr(profName);
    }

    public void createProfAttrTable() throws DirectoryTableException {
        DirectoryTable profAttrTable = null;
        boolean exists = true;
        try {
            profAttrTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            profAttrTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            exists = false;
        }
        catch (DirectoryTableException ex) {
            this.closeProfAttrTable(profAttrTable);
            throw ex;
        }
        TableDefinitions tbldef = null;
        try {
            if (!exists) {
                tbldef = profAttrTable.getTableDefinitionsInstance();
                tbldef.loadTableDefinitions(table);
                profAttrTable.create(table);
            }
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        finally {
            this.closeProfAttrTable(profAttrTable);
        }
    }

    private DirectoryTable openProfAttrTable() throws DirectoryTableException {
        DirectoryTableFactory factory = new DirectoryTableFactory();
        DirectoryTable profAttrTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        try {
            profAttrTable.open(table);
            TableDefinitions tabledefs = profAttrTable.getCurrentTableDefinitions();
            this.nameColNum = tabledefs.getColumnNumber(nameCol);
            this.res1ColNum = tabledefs.getColumnNumber(res1Col);
            this.res2ColNum = tabledefs.getColumnNumber(res2Col);
            this.descColNum = tabledefs.getColumnNumber(descCol);
            this.attrColNum = tabledefs.getColumnNumber(attrCol);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
        }
        return profAttrTable;
    }

    private void closeProfAttrTable(DirectoryTable dirTable) {
        dirTable.close();
        this.nameColNum = 0;
        this.res1ColNum = 0;
        this.res2ColNum = 0;
        this.descColNum = 0;
        this.attrColNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector listProfAttributes() throws DirectoryTableException {
        Vector<ProfAttrObj> profs = null;
        int numRows = 0;
        DirectoryTable etcTable = this.openProfAttrTable();
        try {
            DirectoryMask mask = etcTable.getDirectoryMaskInstance();
            mask.setColumn(this.nameColNum);
            mask.setColumn(this.descColNum);
            mask.setColumn(this.attrColNum);
            DirectoryRow profRow = etcTable.getAll(mask);
            if (profRow == null) {
                throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
            }
            numRows = profRow.getNumberOfRows();
            profs = new Vector<ProfAttrObj>(numRows);
            profs.setSize(numRows);
            for (int i = 1; i <= numRows; ++i) {
                ProfAttrObj profAttr = new ProfAttrObj();
                profAttr.setProfName(profRow.getColumn(this.nameColNum, i));
                profAttr.setLongDesc(profRow.getColumn(this.descColNum, i));
                String attrList = profRow.getColumn(this.attrColNum, i);
                KeyValue.getAttributes(attrList, profAttr.attrSet);
                profs.setElementAt(profAttr, i - 1);
            }
        }
        finally {
            this.closeProfAttrTable(etcTable);
        }
        return profs;
    }

    public String[] getProfilesList() throws DirectoryTableException {
        String[] profArray = null;
        int numRows = 0;
        DirectoryTable etcTable = this.openProfAttrTable();
        DirectoryMask mask = etcTable.getDirectoryMaskInstance();
        mask.setColumn(this.nameColNum);
        DirectoryRow profRow = etcTable.getAll(mask);
        if (profRow == null) {
            throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
        }
        numRows = profRow.getNumberOfRows();
        profArray = new String[numRows];
        for (int i = 1; i <= numRows; ++i) {
            String profName;
            profArray[i - 1] = profName = profRow.getColumn(this.nameColNum, i);
        }
        this.closeProfAttrTable(etcTable);
        return profArray;
    }
}

