/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.profs;

import com.sun.audit.AuditEvent_usermgr_add;
import com.sun.audit.AuditEvent_usermgr_delete;
import com.sun.audit.AuditEvent_usermgr_modify;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.solarisprovider.usermgr.common.UMgrProvider;
import com.sun.wbem.solarisprovider.usermgr.common.UserAttrUtil;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.common.UserRightsUtil;
import com.sun.wbem.solarisprovider.usermgr.execs.SolarisExecAttrTable;
import com.sun.wbem.solarisprovider.usermgr.profs.ProfAttrObj;
import com.sun.wbem.solarisprovider.usermgr.profs.ProfMgrNative;
import com.sun.wbem.solarisprovider.usermgr.profs.SolarisProfAttrTable;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisPasswdTable;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisUserAttrTable;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrObj;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.MethodProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_ProfileAttribute
extends UMgrProvider
implements MethodProvider,
Authorizable {
    private static final String DOMAIN_TYPE = "SystemCreationClassName";
    private static final String DOMAIN_NAME = "SystemName";
    private static final String PROF_NAME = "ProfileName";
    private static final String LONG_DESC = "LongDescription";
    private static final String KEY_VALUE = "SolarisAttrKeyValue";
    public static final String PROFMGR_WRITE_RIGHT = "solaris.profmgr.write";
    public static final String PROFMGR_READ_RIGHT = "solaris.profmgr.read";

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> allRecs = new Vector<CIMObjectPath>();
        SolarisProfAttrTable pat = null;
        Vector attrObjs = null;
        Object[] list = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7014", "LM_7009", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        try {
            pat = new SolarisProfAttrTable(scope);
            attrObjs = pat.listProfAttributes();
            list = new ProfAttrObj[attrObjs.size()];
            try {
                attrObjs.copyInto(list);
            }
            catch (Exception e) {
                throw new CIMException(e.getMessage());
            }
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            cop.addKey(PROF_NAME, new CIMValue((Object)((ProfAttrObj)list[i]).getProfName()));
            cop.addKey(DOMAIN_TYPE, new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
            cop.addKey(DOMAIN_NAME, new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
            allRecs.addElement(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[allRecs.size()];
        allRecs.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> allInstances = new Vector<CIMInstance>();
        CIMInstance ci = null;
        SolarisProfAttrTable pat = null;
        Vector attrObjs = null;
        Object[] list = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7014", "LM_7009", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        try {
            pat = new SolarisProfAttrTable(scope);
            attrObjs = pat.listProfAttributes();
            list = new ProfAttrObj[attrObjs.size()];
            try {
                attrObjs.copyInto(list);
            }
            catch (Exception e) {
                throw new CIMException(e.getMessage());
            }
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            Object pa = list[i];
            ci = this.profToCim((ProfAttrObj)pa, cc, scope);
            if (localOnly) {
                ci = ci.localElements();
            }
            allInstances.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
        }
        CIMInstance[] ciArray = new CIMInstance[allInstances.size()];
        allInstances.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        CIMInstance ci = null;
        SolarisProfAttrTable pat = null;
        ProfAttrObj pa = null;
        String scope = null;
        String name = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7014", "LM_7009", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(PROF_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (name == null) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Name";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7014", "LM_7009", args, op.toString(), true, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        try {
            pat = new SolarisProfAttrTable(scope);
            pa = pat.readProfAttr(name);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (pa == null) {
            String msg = this.writeLog(1, "LM_7014", "LM_7011", name, null, null, null);
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)msg);
        }
        ci = this.profToCim(pa, cc, scope);
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.provUtil.checkRights(PROFMGR_WRITE_RIGHT, op);
        SolarisProfAttrTable pat = null;
        ProfAttrObj pa = null;
        String name = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7014", "LM_7009", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(PROF_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (name == null) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Name";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7014", "LM_7009", args, op.toString(), true, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        try {
            pat = new SolarisProfAttrTable(scope);
            pa = pat.readProfAttr(name);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (pa == null) {
            String msg = this.writeLog(1, "LM_7010", "LM_7011", name, null, null, null);
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)msg);
        }
        ProfAttrObj newPa = this.cimToProf(ci);
        try {
            UserAttrUtil uau = new UserAttrUtil(scope);
            uau.validateAuthNames(pa, newPa);
            uau.validateProfNames(pa, newPa);
        }
        catch (Exception ex) {
            String msg = this.writeLog(2, "LM_7010", "LM_7027", name, ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        UserRightsUtil userRights = new UserRightsUtil(this.provUtil);
        try {
            userRights.checkProfAssignRights(pa, newPa, op);
        }
        catch (UserException ex) {
            String msg = this.writeLog(2, "LM_7010", "LM_7027", name, ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        try {
            userRights.checkAuthAssignRights(pa, newPa);
        }
        catch (UserException ex) {
            String msg = this.writeLog(2, "LM_7010", "LM_7027", name, ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        try {
            userRights.checkAttrAssignRights(pa, newPa);
        }
        catch (UserException ex) {
            String msg = this.writeLog(2, "LM_7010", "LM_7027", name, ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        try {
            pat.writeProfAttr(newPa);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        this.writeLog(0, "LM_7012", "LM_7013", name, null, null, null);
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_ProfileAttribute setInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_ProfileAttribute setInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_usermgr_modify profModEvent = new AuditEvent_usermgr_modify(auditSession);
            if (profModEvent == null) {
                Debug.trace1((String)"Solaris_ProfileAttribute setInstance() : null AuditEvent_usermgr_modify.");
                return;
            }
            String propertyToken = null;
            propertyToken = this.provUtil.formatAuditToken(ci);
            profModEvent.object_name(op.getObjectName());
            profModEvent.domain(this.provUtil.getDomainToken(scope));
            profModEvent.name_service(this.provUtil.getNameServiceToken(scope));
            profModEvent.auth_used(PROFMGR_WRITE_RIGHT);
            profModEvent.changed_values(propertyToken);
            profModEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_ProfileAttribute setInstance() : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.provUtil.checkRights(PROFMGR_WRITE_RIGHT, op);
        SolarisProfAttrTable pat = null;
        ProfAttrObj pa = null;
        String name = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7014", "LM_7009", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(PROF_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (name == null) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Name";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7014", "LM_7009", args, op.toString(), true, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        try {
            pat = new SolarisProfAttrTable(scope);
            pa = pat.readProfAttr(name);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        if (pa != null) {
            String msg = this.writeLog(1, "LM_7022", "LM_7023", name, null, null, null);
            throw new CIMProviderException("CIM_ERR_ALREADY_EXISTS", (Object)msg);
        }
        ProfAttrObj newPa = this.cimToProf(ci);
        try {
            UserAttrUtil uau = new UserAttrUtil(scope);
            uau.validateAuthNames(null, newPa);
            uau.validateProfNames(null, newPa);
        }
        catch (Exception ex) {
            String msg = this.writeLog(2, "LM_7022", "LM_7026", name, ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        UserRightsUtil userRights = new UserRightsUtil(this.provUtil);
        try {
            userRights.checkProfAssignRights(null, newPa, op);
            userRights.checkAuthAssignRights(null, newPa);
            userRights.checkAttrAssignRights(null, newPa);
        }
        catch (UserException ex) {
            String msg = this.writeLog(2, "LM_7022", "LM_7026", name, ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        try {
            pat.writeProfAttr(newPa);
        }
        catch (DirectoryTableException ex) {
            String msg = this.writeLog(2, (Exception)((Object)ex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
        cop.addKey(PROF_NAME, new CIMValue((Object)newPa.getProfName()));
        cop.addKey(DOMAIN_TYPE, new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
        cop.addKey(DOMAIN_NAME, new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
        this.writeLog(0, "LM_7024", "LM_7025", name, null, null, null);
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_ProfileAttribute createInstance() : null WbemAuditSession.");
                return cop;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_ProfileAttribute createInstance() : null platform AuditSession.");
                return cop;
            }
            AuditEvent_usermgr_add profAddEvent = new AuditEvent_usermgr_add(auditSession);
            if (profAddEvent == null) {
                Debug.trace1((String)"Solaris_ProfileAttribute createInstance() : null AuditEvent_usermgr_add.");
                return cop;
            }
            String propertyToken = null;
            propertyToken = this.provUtil.formatAuditToken(ci);
            profAddEvent.object_name(op.getObjectName());
            profAddEvent.domain(this.provUtil.getDomainToken(scope));
            profAddEvent.name_service(this.provUtil.getNameServiceToken(scope));
            profAddEvent.auth_used(PROFMGR_WRITE_RIGHT);
            profAddEvent.initial_values(propertyToken);
            profAddEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_ProfileAttribute createInstance() : Auditing threw exception", (Throwable)ex);
            return cop;
        }
        return cop;
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        String msg;
        this.provUtil.checkRights(PROFMGR_WRITE_RIGHT, op);
        SolarisProfAttrTable pat = null;
        SolarisExecAttrTable eat = null;
        SolarisUserAttrTable uat = null;
        SolarisPasswdTable passwdAttr = null;
        String name = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg2 = this.logUtil.writeLog(this.providerName, "LM_7014", "LM_7009", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg2);
        }
        pat = new SolarisProfAttrTable(scope);
        eat = new SolarisExecAttrTable(scope);
        uat = new SolarisUserAttrTable(scope);
        passwdAttr = new SolarisPasswdTable(scope);
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(PROF_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (name == null) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Name";
            String msg3 = this.logUtil.writeLog(this.providerName, "LM_7014", "LM_7009", args, op.toString(), true, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg3);
        }
        try {
            pat.removeProfAttr(name);
            eat.removeExecAttr(name);
        }
        catch (DirectoryTableException ex) {
            String msg4 = this.writeLog(2, "LM_7017", ex.getMessage(), null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg4);
        }
        catch (Exception ex) {
            String msg5 = this.writeLog(2, "LM_7017", ex.getMessage(), null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg5);
        }
        try {
            Vector profObjs = pat.listProfAttributes();
            if (profObjs != null && profObjs.size() > 0) {
                Enumeration profEnum = profObjs.elements();
                block14: while (profEnum.hasMoreElements()) {
                    ProfAttrObj prf = (ProfAttrObj)profEnum.nextElement();
                    if (prf == null) continue;
                    String[] prfNames = prf.getProfNames();
                    for (int j = 0; prfNames != null && j < prfNames.length; ++j) {
                        if (!prfNames[j].equalsIgnoreCase(name)) continue;
                        prf.delProfNames(name);
                        pat.writeProfAttr(prf);
                        continue block14;
                    }
                }
            }
        }
        catch (DirectoryTableException dex) {
            String msg6 = this.writeLog(2, (Exception)((Object)dex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg6);
        }
        catch (Exception ex) {
            String msg7 = this.writeLog(2, ex);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg7);
        }
        try {
            UserAttrObj[] userObjs = uat.listUserAttrs();
            if (userObjs != null) {
                for (int i = 0; i < userObjs.length; ++i) {
                    String[] profs;
                    UserAttrObj uObj = userObjs[i];
                    if (uObj == null || (profs = uObj.getProfNames()) == null || profs.length <= 0) continue;
                    boolean flag = false;
                    for (int j = 0; j < profs.length; ++j) {
                        if (!profs[j].equalsIgnoreCase(name)) continue;
                        flag = true;
                        uObj.delProfNames(name);
                    }
                    if (!flag) continue;
                    uat.writeUserAttr(uObj);
                }
            }
        }
        catch (DirectoryTableException dex) {
            msg = this.writeLog(2, (Exception)((Object)dex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            msg = this.writeLog(2, ex);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        this.writeLog(0, "LM_7015", "LM_7016", name, null, null, null);
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_ProfileAttribute deleteInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_ProfileAttribute deleteInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_usermgr_delete profDelEvent = new AuditEvent_usermgr_delete(auditSession);
            if (profDelEvent == null) {
                Debug.trace1((String)"Solaris_ProfileAttribute deleteInstance() : null AuditEvent_usermgr_delete.");
                return;
            }
            profDelEvent.object_name(op.getObjectName());
            profDelEvent.domain(this.provUtil.getDomainToken(scope));
            profDelEvent.name_service(this.provUtil.getNameServiceToken(scope));
            profDelEvent.auth_used(PROFMGR_WRITE_RIGHT);
            profDelEvent.delete_values(name);
            profDelEvent.putEvent(0, 0);
        }
        catch (Exception ex) {
            Debug.trace1((String)"Solaris_ProfileAttribute deleteInstance() : Auditing threw exception", (Throwable)ex);
            return;
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] ciArray = this.enumerateInstances(op, true, false, false, null, cc);
            for (int i = 0; i < ciArray.length; ++i) {
                if (where != null && !where.apply((CIMElement)ciArray[i])) continue;
                result.addElement(attrs.apply((CIMElement)ciArray[i]));
            }
        }
        catch (Exception e) {
            String msg = this.writeLog(2, e);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        CIMValue results = null;
        CIMValue return_result = new CIMValue((Object)new Integer(0));
        String name = null;
        String scope = null;
        try {
            scope = this.provUtil.getMgmtScope(op);
        }
        catch (CIMException cex) {
            String[] args = this.getKeys(op);
            args[args.length - 1] = "Scope";
            String msg = this.logUtil.writeLog(this.providerName, "LM_7014", "LM_7009", args, op.toString(), true, 0, 2);
            throw new CIMException(cex.getID(), (Object)msg);
        }
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(PROF_NAME)) continue;
            name = (String)cp.getValue().getValue();
        }
        if (methodName == null) {
            throw new CIMProviderException("CIM_ERR_NOT_SUPPORTED");
        }
        if (methodName.equals("getUserProfs")) {
            String userName = null;
            boolean deep = false;
            CIMValue val = null;
            if (inParams != null && inParams.size() > 0) {
                try {
                    val = (CIMValue)inParams.elementAt(0);
                    userName = (String)val.getValue();
                }
                catch (Exception ex) {
                    throw new CIMProviderException("CIM_ERR_FAILED");
                }
            }
            if (userName == null || userName.trim().length() == 0) {
                throw new CIMProviderException("CIM_ERR_FAILED");
            }
            String[] profNames = AuthorizationUtility.getUserProfs((String)userName);
            Vector<String> allProfs = new Vector<String>();
            for (int i = 0; profNames != null && i < profNames.length; ++i) {
                allProfs.addElement(profNames[i]);
            }
            results = new CIMValue(allProfs);
            outParams.addElement(results);
        } else if (methodName.equals("getExecutables")) {
            String dirPath = null;
            CIMValue val = null;
            if (inParams != null && inParams.size() > 0) {
                try {
                    val = (CIMValue)inParams.elementAt(0);
                    dirPath = (String)val.getValue();
                }
                catch (Exception ex) {
                    throw new CIMProviderException("CIM_ERR_FAILED");
                }
            }
            if (dirPath == null) {
                throw new CIMProviderException("CIM_ERR_FAILED");
            }
            String[] execNames = ProfMgrNative.getExecutables(dirPath);
            Vector<String> allExecs = new Vector<String>();
            for (int i = 0; execNames != null && i < execNames.length; ++i) {
                allExecs.addElement(execNames[i]);
            }
            results = new CIMValue(allExecs);
            outParams.addElement(results);
        } else {
            throw new CIMProviderException("CIM_ERR_NOT_SUPPORTED");
        }
        return return_result;
    }

    private ProfAttrObj cimToProf(CIMInstance ci) throws CIMException {
        ProfAttrObj newPa = null;
        try {
            String profName = (String)ci.getProperty(PROF_NAME).getValue().getValue();
            newPa = new ProfAttrObj(profName);
            String longDesc = (String)ci.getProperty(LONG_DESC).getValue().getValue();
            if (longDesc != null) {
                newPa.setLongDesc(longDesc);
            } else {
                newPa.setLongDesc("");
            }
            String key_val = (String)ci.getProperty(KEY_VALUE).getValue().getValue();
            if (key_val != null) {
                newPa.putAttributeString(key_val);
            } else {
                newPa.putAttributeString("");
            }
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        return newPa;
    }

    private CIMInstance profToCim(ProfAttrObj pa, CIMClass cc, String scope) throws CIMException {
        CIMInstance ci = null;
        ci = cc.newInstance();
        ci.setProperty(DOMAIN_TYPE, new CIMValue((Object)this.provUtil.getScopeClassType(scope)));
        ci.setProperty(DOMAIN_NAME, new CIMValue((Object)this.provUtil.getScopeDomainName(scope)));
        ci.setProperty(PROF_NAME, new CIMValue((Object)pa.getProfName()));
        ci.setProperty(LONG_DESC, new CIMValue((Object)pa.getLongDesc()));
        ci.setProperty(KEY_VALUE, new CIMValue((Object)pa.getAttributeString()));
        return ci;
    }

    private String[] getKeys(CIMObjectPath op) {
        String[] keys = new String[op.getKeys().size() + 1];
        int i = 0;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            keys[i] = (String)cp.getValue().getValue();
            if (keys[i] == null) {
                keys[i] = " ";
            }
            ++i;
        }
        return keys;
    }
}

