/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import java.io.FileInputStream;
import java.util.Properties;

public class CheckSyntax {
    private static String errorString;
    private static final int MAX_PASSWD_LEN = 16;
    private static int passLen;
    private static int minAlpha;
    private static int minNonAlpha;
    private static int minUpper;
    private static int minLower;
    private static int minSpecial;
    private static int minDigit;
    private static String whiteSpace;

    public void CheckSyntax() {
        CheckSyntax.setErrorString(" ");
    }

    public static void setErrorString(String currentErrorString) {
        errorString = currentErrorString;
    }

    public static String getErrorString() {
        return errorString;
    }

    public static boolean isNameOK(String name) {
        String[] allowedChars = new String[]{"0", "_", "-", "."};
        if (name.length() < 2) {
            return false;
        }
        if (!Character.isLetter(name.charAt(0))) {
            return false;
        }
        if (name.length() > 32) {
            return false;
        }
        if (!CheckSyntax.isOneLowerCase(name)) {
            return false;
        }
        return CheckSyntax.isStringOK(name, allowedChars);
    }

    public static boolean isUIDOK(String uid) {
        long longUid = Long.parseLong(uid);
        if (longUid < 100L) {
            return false;
        }
        if (longUid > Integer.MAX_VALUE) {
            return false;
        }
        return longUid != 60001L && longUid != 60002L && longUid != 65534L;
    }

    public static boolean isDescLenOK(String desc) {
        return desc.length() <= 256;
    }

    public static boolean isPasswordConf(String passwd, String confPasswd) {
        if (!passwd.equals(confPasswd)) {
            return false;
        }
        return CheckSyntax.isPasswordLenOK(passwd);
    }

    public static boolean isPasswordLenOK(String passwd) {
        String[] specials = new String[]{"!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "+", "|", "~", "-", "=", "{", "}", "[", "]", ":", ";", "'", "`", "<", ">", "?", ",", ".", "/", "\\", "\""};
        int countAlphas = 0;
        int countNonAlpha = 0;
        int countUpper = 0;
        int countLower = 0;
        boolean countRepeats = false;
        int countSpecial = 0;
        int countDigit = 0;
        int countWhiteSpace = 0;
        boolean hasWhiteSpace = false;
        if (!passwd.equals("")) {
            CheckSyntax.checkPasswdParam();
            String[] passArg = new String[]{String.valueOf(passLen), String.valueOf(minAlpha), String.valueOf(minNonAlpha)};
            if (passLen == 0 || passwd.length() < passLen) {
                return false;
            }
            if (passwd.length() > 16) {
                return false;
            }
            String tmpPwd = null;
            tmpPwd = passwd.substring(0, passLen);
            for (int j = 0; j < passLen; ++j) {
                char tmpChar = tmpPwd.charAt(j);
                if (Character.isLetter(tmpChar)) {
                    ++countAlphas;
                    if (Character.isUpperCase(tmpChar)) {
                        ++countUpper;
                    } else {
                        ++countLower;
                    }
                } else if (Character.isDigit(tmpChar)) {
                    ++countDigit;
                    ++countNonAlpha;
                } else {
                    for (int k = 0; k < specials.length; ++k) {
                        if (String.valueOf(tmpChar).equals(specials[k])) {
                            ++countSpecial;
                            ++countNonAlpha;
                            continue;
                        }
                        if (!Character.isWhitespace(tmpChar)) continue;
                        ++countWhiteSpace;
                    }
                }
                if (whiteSpace.equalsIgnoreCase("yes") && countWhiteSpace > 0 || whiteSpace.equalsIgnoreCase("false")) {
                    hasWhiteSpace = true;
                }
                if (countAlphas < minAlpha || countNonAlpha < minNonAlpha || countSpecial < minSpecial || countUpper < minUpper || countLower < minLower || countDigit < minDigit || !hasWhiteSpace) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static void checkPasswdParam() {
        try {
            Properties config = CheckSyntax.readDefaultPasswdFile();
            passLen = config.getProperty("PASSLENGTH") == null ? 6 : Integer.parseInt(config.getProperty("PASSLENGTH").trim());
            minAlpha = config.getProperty("MINALPHA") == null ? 2 : Integer.parseInt(config.getProperty("MINALPHA").trim());
            minNonAlpha = config.getProperty("MINNONALPHA") == null ? 1 : Integer.parseInt(config.getProperty("MINNONALPHA").trim());
            minUpper = config.getProperty("MINUPPER") == null ? 0 : Integer.parseInt(config.getProperty("MINUPPER").trim());
            minLower = config.getProperty("MINLOWER") == null ? 0 : Integer.parseInt(config.getProperty("MINLOWER").trim());
            minSpecial = config.getProperty("MINSPECIAL") == null ? 0 : Integer.parseInt(config.getProperty("MINSPECIAL").trim());
            minDigit = config.getProperty("MINDIGIT") == null ? 0 : Integer.parseInt(config.getProperty("MINDIGIT").trim());
            whiteSpace = config.getProperty("WHITESPACE") == null ? "false" : config.getProperty("WHITESPACE").trim();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static boolean checkMinWeeks(String tmpValue) {
        int minWeeks = 0;
        try {
            Properties config = CheckSyntax.readDefaultPasswdFile();
            if (config.getProperty("MINWEEKS") != null) {
                minWeeks = Integer.parseInt(config.getProperty("MINWEEKS").trim()) * 7;
            }
            int tmpVal = 0;
            if (tmpValue != null && !tmpValue.trim().equals("")) {
                tmpVal = Integer.parseInt(tmpValue);
            }
            if (minWeeks != 0 && tmpVal < minWeeks) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean checkMaxWeeks(String tmpValue) {
        int maxWeeks = 0;
        try {
            Properties config = CheckSyntax.readDefaultPasswdFile();
            if (config.getProperty("MAXWEEKS") != null) {
                maxWeeks = Integer.parseInt(config.getProperty("MAXWEEKS").trim()) * 7;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int tmpVal = 0;
        if (tmpValue != null && !tmpValue.trim().equals("")) {
            tmpVal = Integer.parseInt(tmpValue);
        }
        return maxWeeks == 0 || tmpVal <= maxWeeks;
    }

    public static Properties readDefaultPasswdFile() {
        Properties config = null;
        try {
            FileInputStream fstream = new FileInputStream("/etc/default/passwd");
            config = new Properties();
            config.load(fstream);
            fstream.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        return config;
    }

    public static boolean isHomeDirServerOK(String homeDirServerName) {
        String[] allowedChars = new String[]{"0", "-"};
        if (homeDirServerName.equals("")) {
            return false;
        }
        if (homeDirServerName.length() > 255) {
            return false;
        }
        if (!Character.isLetterOrDigit(homeDirServerName.charAt(0))) {
            return false;
        }
        return CheckSyntax.isStringOK(homeDirServerName, allowedChars);
    }

    public static boolean isHomeDirPathnameOK(String homeDirPathName) {
        String[] allowedChars = new String[]{"0", "-", "/", ".", "_"};
        if (homeDirPathName.equals("")) {
            return false;
        }
        if (!String.valueOf(homeDirPathName.charAt(0)).equals("/")) {
            return false;
        }
        if (!CheckSyntax.isPathLenOK(homeDirPathName)) {
            return false;
        }
        return CheckSyntax.isStringOK(homeDirPathName, allowedChars);
    }

    private static boolean isPathLenOK(String testName) {
        int pos1 = 0;
        int pos2 = 0;
        for (int i = 0; i < testName.length(); ++i) {
            char tempChar = testName.charAt(i);
            if (!String.valueOf(tempChar).equals("/") || (pos2 = i) - pos1 <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean isOneLowerCase(String testName) {
        for (int i = 0; i < testName.length(); ++i) {
            char tempChar = testName.charAt(i);
            if (!Character.isLowerCase(tempChar)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStringOK(String testName, String[] allowableChars) {
        for (int i = 0; i < testName.length(); ++i) {
            char tempChar = testName.charAt(i);
            if (Character.isLetterOrDigit(tempChar)) continue;
            int len = allowableChars.length;
            boolean isAllowable = false;
            if (len == 1) {
                return false;
            }
            for (int j = 1; j < len; ++j) {
                if (!String.valueOf(tempChar).equals(allowableChars[j])) continue;
                isAllowable = true;
                break;
            }
            if (isAllowable) continue;
            return false;
        }
        return true;
    }
}

