/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.usermgr.common.AttrObj;
import com.sun.wbem.solarisprovider.usermgr.common.ExtAttrObj;
import java.util.StringTokenizer;
import java.util.Vector;

public class UserAttrObj
extends ExtAttrObj
implements Cloneable {
    private String userName = null;
    private String qualifier = null;
    public static final String SOLARIS_USER = "normal";
    public static final String SOLARIS_ROLE = "role";
    public static final String SOLARIS_PREFIX = "solaris";
    public static final String SOLARIS_DOT = ".";
    public static final String SOLARIS_ALL = "*";
    public static final String SOLARIS_GRANT = "grant";
    public static final int SOLARIS_CARDINALITY_INFINITY = 0;
    public static final String SOLARIS_AUTHS = "auths";
    public static final String SOLARIS_USERTYPE = "type";
    public static final String SOLARIS_ROLES = "roles";
    public static final String SOLARIS_MUTEX = "mutex";
    public static final String SOLARIS_CARDINALITY = "cardinality";
    public static final String SOLARIS_PROFILES = "profiles";
    public static final String SOLARIS_DEFAULT_PRIVILEGE = "defaultpriv";
    public static final String SOLARIS_LIMIT_PRIVILEGE = "limitpriv";
    public static final String SOLARIS_ROLE_MEMBERS = "members";
    public static final String SOLARIS_PRIMARY_PROJECT = "project";
    public static final String SOLARIS_DEFAULT_PROJECT = "default";

    public UserAttrObj(String userName, String userType) {
        this.userName = userName;
        this.qualifier = "";
        this.initAttrs(userType);
    }

    public UserAttrObj(String userName) {
        this.userName = userName;
        this.qualifier = "";
    }

    public UserAttrObj() {
        this.qualifier = "";
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String newUser) {
        this.userName = newUser;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String newQualifier) {
        this.qualifier = newQualifier;
    }

    public Object clone() {
        UserAttrObj newUserAttrObj = new UserAttrObj(this.userName);
        newUserAttrObj.setQualifier(this.qualifier);
        super.clone(newUserAttrObj);
        return newUserAttrObj;
    }

    public boolean equals(UserAttrObj userAttr) {
        if (!this.userName.equals(userAttr.getUserName())) {
            return false;
        }
        if (!this.qualifier.equals(userAttr.getQualifier())) {
            return false;
        }
        return super.equals(userAttr);
    }

    public void debugPrint() {
        System.out.println("Authorization attributes for " + this.userName);
        System.out.println("   qual:  " + this.qualifier);
        super.debugPrint();
    }

    public String[] getAuthNames() {
        return this.getAttributeArray(SOLARIS_AUTHS);
    }

    public Vector getAuthNamesVector() {
        return this.getAttribute(SOLARIS_AUTHS);
    }

    public void setAuthNames(String[] authArray) {
        this.setAttribute(SOLARIS_AUTHS, authArray);
    }

    public void setAuthNamesVector(Vector names) {
        this.setAttribute(SOLARIS_AUTHS, names);
    }

    public void addAuthNames(String[] authArray) {
        this.addAttribute(SOLARIS_AUTHS, authArray);
    }

    public void addAuthNames(String authName) {
        this.addAttribute(SOLARIS_AUTHS, authName);
    }

    public void delAuthNames(String authname) {
        this.delAttribute(SOLARIS_AUTHS, authname);
    }

    public void delAuthNames(String[] authArray) {
        this.delAttribute(SOLARIS_AUTHS, authArray);
    }

    public boolean checkAuthName(String authname) {
        Vector authNames = this.getAttribute(SOLARIS_AUTHS);
        if (authNames == null) {
            return false;
        }
        if (authNames.contains(authname)) {
            return true;
        }
        StringTokenizer tk = new StringTokenizer(authname, SOLARIS_DOT);
        int tokCount = tk.countTokens() - 1;
        if (tokCount < 1) {
            return false;
        }
        String matchType = authname.endsWith(".grant") ? SOLARIS_GRANT : SOLARIS_ALL;
        String authPath = "";
        for (int i = 0; i < tokCount; ++i) {
            if (!authNames.contains((authPath = authPath.concat((String)tk.nextElement() + SOLARIS_DOT)).concat(matchType))) continue;
            return true;
        }
        return false;
    }

    public boolean checkAuthName(String[] authArray, boolean OrFlag) {
        if (OrFlag) {
            for (int i = 0; i < authArray.length; ++i) {
                if (!this.checkAuthName(authArray[i])) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < authArray.length; ++i) {
            if (this.checkAuthName(authArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean checkAuthGrant(String authname) {
        boolean bool = false;
        if (authname != null) {
            int i = authname.lastIndexOf(46);
            String prefix = i > 0 ? authname.substring(0, i + 1) : authname.concat(SOLARIS_DOT);
            String grantname = prefix.concat(SOLARIS_GRANT);
            if (this.checkAuthName(authname) && this.checkAuthName(grantname)) {
                bool = true;
            }
        }
        return bool;
    }

    public String getUserType() {
        Vector v = this.getAttribute(SOLARIS_USERTYPE);
        if (v != null && v.size() > 0) {
            return (String)v.elementAt(0);
        }
        return SOLARIS_USER;
    }

    public void setUserType(String newUserType) {
        this.setAttribute(SOLARIS_USERTYPE, newUserType);
    }

    public String[] getRoleNames() {
        return this.getAttributeArray(SOLARIS_ROLES);
    }

    public Vector getRoleNamesVector() {
        return this.getAttribute(SOLARIS_ROLES);
    }

    public void setRoleNames(String[] roleArray) {
        this.setAttribute(SOLARIS_ROLES, roleArray);
    }

    public void setRoleNamesVector(Vector roles) {
        this.setAttribute(SOLARIS_ROLES, roles);
    }

    public void addRoleNames(String rolename) {
        this.addAttribute(SOLARIS_ROLES, rolename);
    }

    public void addRoleNames(String[] roleArray) {
        this.addAttribute(SOLARIS_ROLES, roleArray);
    }

    public void delRoleNames(String rolename) {
        this.delAttribute(SOLARIS_ROLES, rolename);
    }

    public void delRoleNames(String[] roleArray) {
        this.delAttribute(SOLARIS_ROLES, roleArray);
    }

    public String getPrimaryProject() {
        Vector v = this.getAttribute(SOLARIS_PRIMARY_PROJECT);
        if (v != null && v.size() > 0) {
            return (String)v.elementAt(0);
        }
        return null;
    }

    public void setPrimaryProject(String newPrimaryProject) {
        if (newPrimaryProject.equals(SOLARIS_DEFAULT_PROJECT)) {
            this.delAttribute(SOLARIS_PRIMARY_PROJECT, this.getPrimaryProject());
        } else {
            this.setAttribute(SOLARIS_PRIMARY_PROJECT, newPrimaryProject);
        }
    }

    public void delPrimaryProject(String[] primProjectArray) {
        this.delAttribute(SOLARIS_PRIMARY_PROJECT, primProjectArray);
    }

    public int getCardinality() {
        Vector v = this.getAttribute(SOLARIS_CARDINALITY);
        int icard = 0;
        if (v != null && v.size() > 0) {
            String card = (String)v.elementAt(0);
            try {
                icard = new Integer(card);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return icard;
    }

    public void setCardinality(int newCardinality) {
        this.setAttribute(SOLARIS_CARDINALITY, Integer.toString(newCardinality));
    }

    public String[] getProfNames() {
        return this.getAttributeArray(SOLARIS_PROFILES);
    }

    public Vector getProfNamesVector() {
        return this.getAttribute(SOLARIS_PROFILES);
    }

    public void setProfNames(String[] profArray) {
        this.setAttribute(SOLARIS_PROFILES, profArray);
    }

    public void setProfNamesVector(Vector names) {
        this.setAttribute(SOLARIS_PROFILES, names);
    }

    public void addProfNames(String[] profArray) {
        this.addAttribute(SOLARIS_PROFILES, profArray);
    }

    public void addProfNames(String profName) {
        this.addAttribute(SOLARIS_PROFILES, profName);
    }

    public void delProfNames(String profname) {
        this.delAttribute(SOLARIS_PROFILES, profname);
    }

    public void delProfNames(String[] profArray) {
        this.delAttribute(SOLARIS_PROFILES, profArray);
    }

    private void initAttrs(String user_type) {
        AttrObj ao = new AttrObj(SOLARIS_USERTYPE);
        ao.set(user_type);
        this.attrSet.put(SOLARIS_USERTYPE, ao);
    }

    static {
        ExtAttrObj.addAuthAttrMap(UserAttrObj.class, "solaris.admin.privilege.write", new String[]{SOLARIS_DEFAULT_PRIVILEGE, SOLARIS_LIMIT_PRIVILEGE});
    }
}

