/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.upgrade;

import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cimom.ReadersWriter;
import com.sun.wbem.client.PSImpl;
import com.sun.wbem.repository.PSRlogImpl;
import com.sun.wbem.upgrade.DagTraversor;
import com.sun.wbem.util.ConvertCIMComSunToJavax;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;

public class Convert {
    private static DataOutputStream succStream;
    private static DataOutputStream dupStream;
    private static DataOutputStream errorStream;
    private static DataOutputStream cycleStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processClasses(Enumeration e, PSImpl ps, PSRlogImpl psr, CIMObjectPath op, ReadersWriter rw) throws Exception {
        String name;
        com.sun.wbem.cim.CIMClass cc;
        String ns = op.getNameSpace();
        HashMap<String, com.sun.wbem.cim.CIMClass> cMap = new HashMap<String, com.sun.wbem.cim.CIMClass>();
        ArrayList<String> list = new ArrayList<String>();
        String[] listArray = null;
        if (ns.equals("\\root\\cimv2") || ns.equals("\\root\\system") || ns.equals("\\root\\security")) {
            while (e.hasMoreElements()) {
                cc = (com.sun.wbem.cim.CIMClass)e.nextElement();
                name = cc.getName().toLowerCase();
                if (name.startsWith("cim_") || name.startsWith("solaris_")) continue;
                cMap.put(name, cc);
                list.add(0, name);
                listArray = new String[list.size()];
                list.toArray(listArray);
            }
        } else {
            while (e.hasMoreElements()) {
                cc = (CIMClass)e.nextElement();
                name = cc.getName().toLowerCase();
                cMap.put(name, cc);
                list.add(0, name);
                listArray = new String[list.size()];
                list.toArray(listArray);
            }
        }
        DagCB dcb = new DagCB(cMap, ps, psr, op, rw);
        DagTraversor dag = new DagTraversor(listArray, new String[]{"s", "a"}, dcb);
        dag.start();
        for (String className : dcb.addedClassList) {
            Enumeration ei = ps.enumerateInstances(ns, className, false, false).elements();
            while (ei.hasMoreElements()) {
                rw.writeLock();
                boolean success = true;
                CIMInstance ci = (CIMInstance)ei.nextElement();
                try {
                    javax.wbem.cim.CIMInstance ci2 = ConvertCIMComSunToJavax.convertCIMInstance(ci);
                    psr.addCIMElement(ns, ci2);
                }
                catch (CIMException ex) {
                    success = false;
                    if (ex.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                        dupStream.writeBytes(ns + "\n");
                        dupStream.writeBytes(ci + "\n");
                    } else {
                        errorStream.writeBytes(ns + "\n");
                        errorStream.writeBytes(ci + "\n");
                        errorStream.writeBytes((Object)((Object)ex) + "\n");
                    }
                }
                catch (Exception ex) {
                    success = false;
                    errorStream.writeBytes(ns + "\n");
                    errorStream.writeBytes(ci + "\n");
                    errorStream.writeBytes(ex + "\n");
                }
                finally {
                    rw.writeUnlock();
                }
                if (!success) continue;
                succStream.writeBytes(ns + "\n");
                succStream.writeBytes(ci + "\n");
            }
        }
    }

    private static DataOutputStream getStream(String filepath) throws Exception {
        File f = new File(filepath);
        f.createNewFile();
        DataOutputStream fStream = new DataOutputStream(new FileOutputStream(filepath));
        return fStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        succStream = Convert.getStream(args[0]);
        dupStream = Convert.getStream(args[1]);
        errorStream = Convert.getStream(args[2]);
        cycleStream = Convert.getStream(args[3]);
        ReadersWriter rw = new ReadersWriter();
        PSImpl ps = new PSImpl("localhost");
        PSRlogImpl psr = new PSRlogImpl("localhost", rw);
        Vector v = ps.enumerateNameSpace("", true);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String ns = (String)e.nextElement();
            CIMObjectPath nsop = new CIMObjectPath();
            nsop.setNameSpace(ns);
            ns = nsop.getNameSpace();
            com.sun.wbem.cim.CIMObjectPath csnsop = new com.sun.wbem.cim.CIMObjectPath();
            csnsop.setNameSpace(ns);
            String csns = csnsop.getNameSpace();
            boolean success = true;
            rw.writeLock();
            try {
                psr.createNameSpace(ns);
            }
            catch (CIMException ex) {
                success = false;
                if (ex.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                    dupStream.writeBytes(ns + "\n");
                } else {
                    errorStream.writeBytes(ns + "\n");
                    errorStream.writeBytes((Object)((Object)ex) + "\n");
                }
            }
            catch (Exception ex) {
                success = false;
                errorStream.writeBytes(ns + "\n");
                errorStream.writeBytes(ex + "\n");
            }
            finally {
                rw.writeUnlock();
            }
            if (success) {
                succStream.writeBytes(ns + "\n");
            }
            Enumeration eq = ps.enumerateQualifierTypes(csnsop).elements();
            while (eq.hasMoreElements()) {
                com.sun.wbem.cim.CIMObjectPath qop = (com.sun.wbem.cim.CIMObjectPath)eq.nextElement();
                com.sun.wbem.cim.CIMQualifierType cqt = ps.getQualifierType(qop);
                success = true;
                rw.writeLock();
                try {
                    CIMQualifierType cqt2 = ConvertCIMComSunToJavax.convertCIMQualifierType(cqt);
                    psr.addCIMElement(ns, cqt2);
                }
                catch (CIMException ex) {
                    success = false;
                    if (ex.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                        dupStream.writeBytes(qop + "\n");
                    } else {
                        errorStream.writeBytes(qop + "\n");
                        errorStream.writeBytes((Object)((Object)ex) + "\n");
                    }
                }
                catch (Exception ex) {
                    success = false;
                    errorStream.writeBytes(qop + "\n");
                    errorStream.writeBytes(ex + "\n");
                }
                finally {
                    rw.writeUnlock();
                }
                if (!success) continue;
                succStream.writeBytes(qop + "\n");
            }
            eq = ps.enumerateClasses(csnsop, true, false).elements();
            Convert.processClasses(eq, ps, psr, nsop, rw);
        }
    }

    private static class DagCB
    implements DagTraversor.Callback {
        HashMap cMap = null;
        CIMObjectPath op;
        String ns;
        PSRlogImpl psr;
        PSImpl ps;
        List addedClassList;
        ReadersWriter rw;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noCycles(String nodeName) {
            com.sun.wbem.cim.CIMClass cc = (com.sun.wbem.cim.CIMClass)this.cMap.get(nodeName);
            boolean success = true;
            try {
                this.rw.writeLock();
                this.psr.addCIMElement(this.ns, ConvertCIMComSunToJavax.convertCIMClass(cc));
                this.addedClassList.add(0, nodeName);
            }
            catch (CIMException ex) {
                success = false;
                if (ex.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                    try {
                        dupStream.writeBytes(this.ns + "\n");
                        dupStream.writeBytes(cc + "\n");
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                    }
                } else {
                    try {
                        errorStream.writeBytes(this.ns + "\n");
                        errorStream.writeBytes(cc + "\n");
                        errorStream.writeBytes((Object)((Object)ex) + "\n");
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                    }
                }
            }
            catch (Exception ex) {
                success = false;
                try {
                    errorStream.writeBytes(this.ns + "\n");
                    errorStream.writeBytes(cc + "\n");
                    errorStream.writeBytes(ex + "\n");
                }
                catch (Exception e1) {
                    System.out.println(e1);
                }
            }
            finally {
                this.rw.writeUnlock();
            }
            if (success) {
                try {
                    succStream.writeBytes(this.ns + "\n");
                    succStream.writeBytes(cc + "\n");
                }
                catch (Exception e1) {
                    System.out.println(e1);
                }
            }
        }

        public String[] dependNodes(String nodeName, String dependency) {
            com.sun.wbem.cim.CIMClass cc = (com.sun.wbem.cim.CIMClass)this.cMap.get(nodeName);
            if (dependency.equals("s")) {
                String sc = cc.getSuperClass();
                if (sc == null || sc.length() == 0) {
                    return null;
                }
                String[] sArray = new String[]{sc.toLowerCase()};
                return sArray;
            }
            if (!cc.isAssociation()) {
                return null;
            }
            ArrayList<String> assocList = new ArrayList<String>();
            Enumeration ep = cc.getProperties().elements();
            while (ep.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)ep.nextElement();
                if (!cp.isReference()) continue;
                String refClassName = cp.getType().getRefClassName().toLowerCase();
                assocList.add(refClassName);
            }
            int size = assocList.size();
            if (size == 0) {
                return null;
            }
            String[] assocArray = new String[size];
            assocList.toArray(assocArray);
            return assocArray;
        }

        public void cycleDetected(String[] cycleInfo) {
            try {
                cycleStream.writeBytes(this.ns + "\n");
                for (int i = 0; i < cycleInfo.length; ++i) {
                    cycleStream.writeBytes(cycleInfo[i] + " ");
                }
                cycleStream.writeBytes("\n");
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }

        DagCB(HashMap cMap, PSImpl ps, PSRlogImpl psr, CIMObjectPath op, ReadersWriter rw) {
            this.cMap = cMap;
            this.ps = ps;
            this.psr = psr;
            this.op = op;
            this.ns = op.getNameSpace();
            this.addedClassList = new ArrayList();
            this.rw = rw;
        }
    }
}

