/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.util;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.security.SecurityToken;
import com.sun.wbem.util.OldXMLParser;
import com.sun.xml.tree.XmlDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.security.SecurityMessage;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConvertCIMJavaxToComSun {
    private static CIMXml xmlImpl = CIMXmlFactory.getCIMXmlImpl();

    public static Node makeNode(String pXml) throws CIMException {
        try {
            InputSource stream = new InputSource(new ByteArrayInputStream(pXml.getBytes()));
            XmlDocument doc = XmlDocument.createXmlDocument((InputSource)stream, (boolean)false);
            return doc.getDocumentElement();
        }
        catch (SAXException se) {
            throw new CIMException("CIM_ERR_INVALID_CLASS", (Object)se);
        }
        catch (IOException ioe) {
            throw new CIMException("CIM_ERR_FAILED", (Object)ioe);
        }
    }

    public static com.sun.wbem.cim.CIMQualifierType convertCIMQualifierType(CIMQualifierType pOld) throws CIMException {
        if (pOld == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String xmlString = xmlImpl.CIMQualifierTypeToXml(pOld, true);
        Node node = ConvertCIMJavaxToComSun.makeNode(xmlString);
        return OldXMLParser.getCIMQualifierType(node);
    }

    public static com.sun.wbem.cim.CIMClass convertCIMClass(CIMClass pOld) throws CIMException {
        if (pOld == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String xmlString = xmlImpl.CIMClassToXml(pOld, true, true, null, true);
        Node node = ConvertCIMJavaxToComSun.makeNode(xmlString);
        return OldXMLParser.getCIMClass(node);
    }

    public static CIMInstance convertCIMInstance(javax.wbem.cim.CIMInstance pOld) throws CIMException {
        if (pOld == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String xmlString = xmlImpl.ConvertCIMInstanceToXml(pOld, true, true, null, true);
        Node node = ConvertCIMJavaxToComSun.makeNode(xmlString);
        return OldXMLParser.getCIMInstance(node);
    }

    public static CIMNameSpace convertCIMNameSpace(javax.wbem.cim.CIMNameSpace pOld) throws CIMException {
        if (pOld == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return new CIMNameSpace(pOld.getHost(), pOld.getNameSpace());
    }

    public static CIMValue convertCIMValue(javax.wbem.cim.CIMValue pOld) throws CIMException {
        if (pOld == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String xmlString = xmlImpl.CIMValueToXml(pOld, true);
        Node node = ConvertCIMJavaxToComSun.makeNode(xmlString);
        CIMDataType dt = null;
        CIMDataType tmpType = pOld.getType();
        if (tmpType != null && tmpType.isArrayType()) {
            int arrayType = tmpType.getType();
            int simpleType = CIMDataType.findSimpleType((int)arrayType);
            dt = CIMDataType.getPredefinedType((int)simpleType);
        } else {
            dt = tmpType;
        }
        return OldXMLParser.getCIMValue(node, dt == null ? null : dt.toString());
    }

    public static com.sun.wbem.cim.CIMObjectPath convertCIMObjectPath(CIMObjectPath pOld) throws CIMException {
        if (pOld == null) {
            return null;
        }
        String xmlString = xmlImpl.ConvertCIMObjectPathToXml(pOld, true);
        Node node = ConvertCIMJavaxToComSun.makeNode(xmlString);
        return OldXMLParser.getCIMObjectPath(node);
    }

    public static com.sun.wbem.security.SecurityMessage convertSecurityMessage(SecurityMessage pOld) {
        com.sun.wbem.security.SecurityMessage newMsg = null;
        byte[] challenge = pOld.getChallenge();
        byte[] response = pOld.getResponse();
        byte[] checkSum = pOld.getChecksum();
        byte[] sessionId = pOld.getSessionId();
        PublicKey pk = pOld.getPublicKey();
        if (pOld.isHello()) {
            byte[] nameSpace = pOld.getNameSpace();
            byte[] userDigest = pOld.getUserDigest();
            byte[] labelSystem = pOld.getLabeledSystem();
            byte[] roleWSLogin = pOld.getRoleWSLogin();
            newMsg = com.sun.wbem.security.SecurityMessage.hello((byte[])challenge, (byte[])userDigest, (byte[])nameSpace, (byte[])labelSystem, (byte[])roleWSLogin, (byte[])checkSum);
        } else if (pOld.isResponse()) {
            newMsg = com.sun.wbem.security.SecurityMessage.response((byte[])response, (PublicKey)pk, (byte[])sessionId, (byte[])checkSum);
        } else if (pOld.isChallenge()) {
            byte[] salt = pOld.getSalt();
            newMsg = com.sun.wbem.security.SecurityMessage.challenge((byte[])challenge, (byte[])salt, (byte[])sessionId, (byte[])checkSum);
        } else if (pOld.isResult()) {
            newMsg = com.sun.wbem.security.SecurityMessage.result((byte[])sessionId, (PublicKey)pk, (byte[])response, (byte[])checkSum);
        } else if (pOld.isError()) {
            String msg = pOld.getMessage();
            newMsg = com.sun.wbem.security.SecurityMessage.error((String)msg);
        }
        return newMsg;
    }

    public static SecurityToken convertSecurityToken(javax.wbem.security.SecurityToken pOld) {
        SecurityToken newTok = new SecurityToken();
        byte[] checkSum = pOld.getChecksum();
        byte[] sig = pOld.getSignature();
        byte[] sessionId = pOld.getSessionId();
        newTok.setChecksum(checkSum);
        newTok.setSignature(sig);
        newTok.setSessionId(sessionId);
        return newTok;
    }
}

