/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.common;

import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.authorization.AuthorizationServiceFactory;
import com.sun.management.services.common.ConsoleException;
import com.sun.management.services.common.Debug;
import com.sun.management.services.registration.Help;
import com.sun.management.services.registration.ManagementApp;
import com.sun.management.services.registration.Masthead;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import com.sun.web.common.ConsoleLogout;
import java.io.InputStream;
import java.security.Principal;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConsoleUtil {
    static final String PRODNAME_FILE = "ProductName.properties";
    static final String UI_PRODNAME_PATH = "/com_sun_web_ui/images";
    static final String UI_PRODNAME_ATTR = "com.sun.web.ui.prodname";
    static final String WEBUI_PRODNAME_PATH = "/com_sun_webui_jsf/images";
    static final String WEBUI_PRODNAME_ATTR = "com.sun.webui.jsf.prodname";
    private static final String PROP_PRODNAME_PRIMARY = "primary.";
    private static final String PROP_PRODNAME_SECONDARY = "secondary.";
    private static final String PROP_PRODNAME_VERSION = "version.";
    private static final String PROP_PRODNAME_URI = "uri";
    private static final String PROP_PRODNAME_HEIGHT = "height";
    private static final String PROP_PRODNAME_WIDTH = "width";

    public static String getAppContext() {
        String string = null;
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            string = facesContext.getExternalContext().getRequestContextPath();
            if (string.startsWith("/")) {
                string = string.substring(1).trim();
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)"could not get app context", (Throwable)exception);
            string = null;
        }
        return string;
    }

    public static ManagementApp getManagementApp() {
        String string = MgmtAppRegistrationServiceFactory.getPluginName((String)ConsoleUtil.getAppContext());
        if (string != null) {
            String string2 = MgmtAppRegistrationServiceFactory.getRegisteredAppDir((String)string);
            ManagementApp managementApp = MgmtAppRegistrationServiceFactory.getRegistrationInfo((String)string).getManagementApp();
            return managementApp;
        }
        Debug.trace1((String)"ManagementApp registration object is null");
        return null;
    }

    public static Masthead getMastheadObject() {
        ManagementApp managementApp = ConsoleUtil.getManagementApp();
        if (managementApp != null) {
            return managementApp.getMasthead();
        }
        Debug.trace1((String)"Masthead registration object could not be found");
        return null;
    }

    public static Help getHelpObject() {
        ManagementApp managementApp = ConsoleUtil.getManagementApp();
        if (managementApp != null) {
            return managementApp.getHelp();
        }
        Debug.trace1((String)"Help registration object could not be found");
        return null;
    }

    public static String getAppVersion() {
        ManagementApp managementApp = ConsoleUtil.getManagementApp();
        if (managementApp != null) {
            return managementApp.getVersion();
        }
        Debug.trace1((String)"Management app version could not be found");
        return null;
    }

    public static Principal getPrincipal(HttpServletRequest httpServletRequest) {
        return AuthorizationServiceFactory.getPrincipal((HttpServletRequest)httpServletRequest, null);
    }

    public static String getUserName(HttpServletRequest httpServletRequest) {
        String string = null;
        Principal principal = ConsoleUtil.getPrincipal(httpServletRequest);
        if (principal == null) {
            return null;
        }
        try {
            UserRolePrincipal userRolePrincipal = (UserRolePrincipal)principal;
            string = userRolePrincipal.getUserName();
        }
        catch (Exception exception) {
            string = principal.getName();
        }
        return string;
    }

    public static String getRoleName(HttpServletRequest httpServletRequest) {
        String string = null;
        Principal principal = ConsoleUtil.getPrincipal(httpServletRequest);
        if (principal == null) {
            return null;
        }
        try {
            UserRolePrincipal userRolePrincipal = (UserRolePrincipal)principal;
            string = userRolePrincipal.getRoleName();
        }
        catch (Exception exception) {
            Debug.trace1((String)"Could not get role name, setting to null");
        }
        return string;
    }

    public static String getUserInfo() {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            HttpServletRequest httpServletRequest = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            String string = ConsoleUtil.getUserName(httpServletRequest);
            String string2 = ConsoleUtil.getRoleName(httpServletRequest);
            if (string != null && string2 != null) {
                return string2 + " (" + string + ")";
            }
            if (string != null) {
                return string;
            }
            return null;
        }
        catch (Exception exception) {
            Debug.trace1((String)"Cannot get user info...", (Throwable)exception);
            return "";
        }
    }

    public static String consoleClicked() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        try {
            externalContext.redirect(externalContext.encodeResourceURL("/console/faces/jsp/launch/Launch.jsp"));
        }
        catch (Exception exception) {
            Debug.trace1((String)"could not redirect to launch page", (Throwable)exception);
        }
        return "";
    }

    public static String logoutClicked() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletRequest httpServletRequest = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        try {
            ConsoleLogout consoleLogout = new ConsoleLogout();
            consoleLogout.logout(httpServletRequest, httpServletResponse);
            facesContext.responseComplete();
            return "";
        }
        catch (ConsoleException consoleException) {
            Debug.trace1((String)"logout failes", (Throwable)consoleException);
            return "";
        }
    }

    public static String getProductName(String string) {
        String string2 = null;
        ManagementApp managementApp = ConsoleUtil.getManagementApp();
        if (string.equalsIgnoreCase("secondary")) {
            string2 = managementApp.getSecondaryProductName();
        }
        if (string.equalsIgnoreCase("version")) {
            string2 = managementApp.getVersionProductName();
        }
        if (string2 == null) {
            string2 = managementApp.getPrimaryProductName();
        }
        return string2;
    }

    public static String[] getProductNameImage(String string) {
        return ConsoleUtil.getProductNameImage(string, UI_PRODNAME_ATTR, UI_PRODNAME_PATH);
    }

    public static String[] getProductNameImage(String string, String string2, String string3) {
        String[] stringArray;
        Object object;
        ServletContext servletContext = null;
        String string4 = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletRequest httpServletRequest = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        if (httpServletRequest != null) {
            string4 = httpServletRequest.getContextPath();
            servletContext = httpServletRequest.getSession().getServletContext();
        }
        if (servletContext == null) {
            return null;
        }
        Properties properties = new Properties();
        String string5 = string2 + "." + string4.substring(1);
        String string6 = string3 + "/" + PRODNAME_FILE;
        try {
            properties = (Properties)servletContext.getAttribute(string5);
            if (properties == null) {
                properties = new Properties();
                object = servletContext.getResourceAsStream(string6);
                if (object != null) {
                    properties.load((InputStream)object);
                    ((InputStream)object).close();
                }
                servletContext.setAttribute(string5, (Object)properties);
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)("Error reading product name properties: " + exception.getMessage()));
            properties = new Properties();
        }
        object = null;
        String string7 = null;
        String string8 = null;
        try {
            String string9;
            stringArray = null;
            if (string.equalsIgnoreCase("primary")) {
                stringArray = "primary.";
            } else if (string.equalsIgnoreCase("secondary")) {
                stringArray = PROP_PRODNAME_SECONDARY;
            } else if (string.equalsIgnoreCase("version")) {
                stringArray = PROP_PRODNAME_VERSION;
            }
            if (stringArray != null && (string9 = properties.getProperty((String)stringArray + PROP_PRODNAME_URI)) != null) {
                object = string9;
                string7 = properties.getProperty((String)stringArray + PROP_PRODNAME_HEIGHT);
                string8 = properties.getProperty((String)stringArray + PROP_PRODNAME_WIDTH);
            }
        }
        catch (Exception exception) {
            Debug.trace3((String)("Error obtaining buffered image: " + exception.getMessage()));
        }
        stringArray = new String[]{object, string7, string8};
        return stringArray;
    }

    public static String getBaseName() {
        String string = null;
        try {
            string = ConsoleUtil.getManagementApp().getBundle();
        }
        catch (Exception exception) {
            Debug.trace1((String)"could not get resource bundle", (Throwable)exception);
            string = null;
        }
        return string;
    }

    public static String getMessage(String string, String string2) {
        Object object;
        String string3 = null;
        Locale locale = null;
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = FacesContext.getCurrentInstance();
            if (object != null) {
                locale = object.getViewRoot().getLocale();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            object = ResourceBundle.getBundle(string, locale, classLoader);
            string3 = ((ResourceBundle)object).getString(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static String getDisplayAppName() {
        String string = "";
        ManagementApp managementApp = ConsoleUtil.getManagementApp();
        if (managementApp != null) {
            String string2 = managementApp.getName().getNameContent();
            string = managementApp.getName().isLocalizable() ? ConsoleUtil.getMessage(ConsoleUtil.getBaseName(), string2) : string2;
        }
        return string;
    }

    public static String getVersionTooltip() {
        Help help = ConsoleUtil.getHelpObject();
        if (help == null) {
            return null;
        }
        String string = help.getVersionTooltip();
        return ConsoleUtil.getMessage(ConsoleUtil.getBaseName(), string);
    }

    public static String getProductImageDescription() {
        Masthead masthead = ConsoleUtil.getMastheadObject();
        if (masthead != null) {
            return ConsoleUtil.getMessage(ConsoleUtil.getBaseName(), masthead.getLogoAltText());
        }
        return null;
    }

    public static String getProductImageURL() {
        Masthead masthead = ConsoleUtil.getMastheadObject();
        if (masthead != null) {
            return ConsoleUtil.getMessage(ConsoleUtil.getBaseName(), masthead.getLogo());
        }
        return "";
    }

    public static int getProductImageHeight() {
        Masthead masthead = ConsoleUtil.getMastheadObject();
        if (masthead != null) {
            return Integer.parseInt(masthead.getLogoHeight());
        }
        return 0;
    }

    public static int getProductImageWidth() {
        Masthead masthead = ConsoleUtil.getMastheadObject();
        if (masthead != null) {
            return Integer.parseInt(masthead.getLogoWidth());
        }
        return 0;
    }

    public static String getVersionProductImageURL() {
        Masthead masthead = ConsoleUtil.getMastheadObject();
        if (masthead != null) {
            return ConsoleUtil.getMessage(ConsoleUtil.getBaseName(), masthead.getVersionLogo());
        }
        return "";
    }

    public static int getVersionProductImageHeight() {
        Masthead masthead = ConsoleUtil.getMastheadObject();
        if (masthead != null) {
            return Integer.parseInt(masthead.getVersionLogoHeight());
        }
        return 0;
    }

    public static int getVersionProductImageWidth() {
        Masthead masthead = ConsoleUtil.getMastheadObject();
        if (masthead != null) {
            return Integer.parseInt(masthead.getVersionLogoWidth());
        }
        return 0;
    }

    public static String getHelpTooltip() {
        Help help = ConsoleUtil.getHelpObject();
        if (help == null) {
            return null;
        }
        String string = help.getHelpTooltip();
        return ConsoleUtil.getMessage(ConsoleUtil.getBaseName(), string);
    }

    public static boolean isCloseButton() {
        return true;
    }

    public static String getHelpFile() {
        Help help = ConsoleUtil.getHelpObject();
        if (help != null) {
            return help.getHelpFileName();
        }
        return null;
    }

    public static String getJspPathPrefix() {
        Help help = ConsoleUtil.getHelpObject();
        if (help != null) {
            return help.getPathPrefix();
        }
        return null;
    }

    public static String getMastheadDescription() {
        Help help = ConsoleUtil.getHelpObject();
        if (help != null) {
            return ConsoleUtil.getMessage(ConsoleUtil.getBaseName(), help.getMastheadTitle());
        }
        return null;
    }

    public static String getMastheadUrl() {
        Help help = ConsoleUtil.getHelpObject();
        if (help != null) {
            return ConsoleUtil.getMessage(ConsoleUtil.getBaseName(), help.getMastheadTitle());
        }
        return null;
    }

    public static String getWindowTitle() {
        Help help = ConsoleUtil.getHelpObject();
        if (help != null) {
            return ConsoleUtil.getMessage(ConsoleUtil.getBaseName(), help.getWindowTitle());
        }
        return null;
    }

    public static String getHelpWindoHeight() {
        Help help = ConsoleUtil.getHelpObject();
        if (help != null) {
            return help.getHeight();
        }
        return null;
    }

    public static String getHelpWindoWidth() {
        Help help = ConsoleUtil.getHelpObject();
        if (help != null) {
            return help.getWidth();
        }
        return null;
    }

    public static String getHelpLogoWidth() {
        Help help = ConsoleUtil.getHelpObject();
        if (help != null) {
            return help.getHelpLogoWidth();
        }
        return null;
    }

    public static String getHelpLogoHeight() {
        Help help = ConsoleUtil.getHelpObject();
        if (help != null) {
            return help.getHelpLogoHeight();
        }
        return null;
    }

    public static String getToolTip() {
        Help help = ConsoleUtil.getHelpObject();
        if (help != null) {
            return ConsoleUtil.getMessage(ConsoleUtil.getBaseName(), help.getHelpTooltip());
        }
        return null;
    }
}

